/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.model;

import android.text.TextUtils;
import com.ss.ttvideoengine.model.VideoModelPb;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoThumbInfo {
    public static final int VALUE_VIDEO_THUMB_INFO_IMG_NUM = 0;
    public static final int VALUE_VIDEO_THUMB_INFO_URI = 1;
    public static final int VALUE_VIDEO_THUMB_INFO_IMG_URL = 2;
    public static final int VALUE_VIDEO_THUMB_INFO_IMG_X_SIZE = 3;
    public static final int VALUE_VIDEO_THUMB_INFO_IMG_Y_SIZE = 4;
    public static final int VALUE_VIDEO_THUMB_INFO_IMG_X_LEN = 5;
    public static final int VALUE_VIDEO_THUMB_INFO_IMG_Y_LEN = 6;
    public static final int VALUE_VIDEO_THUMB_INFO_DURATION = 7;
    public static final int VALUE_VIDEO_THUMB_INFO_INTERVAL = 8;
    public static final int VALUE_VIDEO_THUMB_INFO_FEXT = 9;
    public static final int VALUE_VIDEO_THUMB_INFO_CAPTURE_NUM = 0;
    public static final int VALUE_VIDEO_THUMB_INFO_CELL_WIDTH = 3;
    public static final int VALUE_VIDEO_THUMB_INFO_CELL_HEIGHT = 4;
    public static final int VALUE_VIDEO_THUMB_INFO_FORMAT = 9;
    public static final String KEY_IMG_NUM = "img_num";
    public static final String KEY_URI = "uri";
    public static final String KEY_IMG_URI = "img_uri";
    public static final String KEY_IMG_URL = "img_url";
    public static final String KEY_IMG_URLS = "img_urls";
    public static final String KEY_IMG_X_SIZE = "img_x_size";
    public static final String KEY_IMG_Y_SIZE = "img_y_size";
    public static final String KEY_IMG_X_LEN = "img_x_len";
    public static final String KEY_IMG_Y_LEN = "img_y_len";
    public static final String KEY_DURATION = "duration";
    public static final String KEY_INTERVAL = "interval";
    public static final String KEY_FEXT = "fext";
    public int mImgNum;
    public String mUri;
    public String mImgUrl;
    public int mImgXsize;
    public int mImgYsize;
    public int mImgXlen;
    public int mImgYlen;
    public double mDuration;
    public double mInterval;
    public String mFext;
    public ArrayList<String> mImgUrlList;
    private static final String KEY_VER2_IMG_NUM = "ImgNum";
    private static final String KEY_VER2_URI = "Uri";
    private static final String KEY_VER2_IMG_URL = "ImgUrl";
    private static final String KEY_VER2_IMG_X_SIZE = "ImgXSize";
    private static final String KEY_VER2_IMG_Y_SIZE = "ImgYSize";
    private static final String KEY_VER2_IMG_X_LEN = "ImgXLen";
    private static final String KEY_VER2_IMG_Y_LEN = "ImgYLen";
    private static final String KEY_VER2_DURATION = "Duration";
    private static final String KEY_VER2_INTERVAL = "Interval";
    private static final String KEY_VER2_FEXT = "Fext";
    private int mImgNumVer2;
    private String mUriVer2;
    private String mImgUrlVer2;
    private int mImgXsizeVer2;
    private int mImgYsizeVer2;
    private int mImgXlenVer2;
    private int mImgYlenVer2;
    private double mDurationVer2;
    private double mIntervalVer2;
    private String mFextVer2;
    private static final String KEY_VER4_CAPTURE_NUM = "CaptureNum";
    private static final String KEY_VER4_STORE_URLS = "StoreUrls";
    private static final String KEY_VER4_CELL_WIDTH = "CellWidth";
    private static final String KEY_VER4_CELL_HEIGHT = "CellHeight";
    private static final String KEY_VER4_IMG_X_LEN = "ImgXLen";
    private static final String KEY_VER4_IMG_Y_LEN = "ImgYLen";
    private static final String KEY_VER4_INTERVAL = "Interval";
    private static final String KEY_VER4_FORMAT = "Format";
    private int mCaptureNumVer4;
    private ArrayList<String> mStoreUrlsVer4;
    private int mCellWidthVer4;
    private int mCellHeightVer4;
    private int mImgXLenVer4;
    private int mImgYLenVer4;
    private double mIntervalVer4;
    private String mFormatVer4;
    private int mVersion = 1;

    public void setVersion(int version) {
        this.mVersion = version;
    }

    public void parseFromPb(VideoModelPb.BigThumb pb) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void extractFields(JSONObject obj) {
        if (obj == null) {
            return;
        }
        if (obj.has(KEY_IMG_NUM)) {
            if (this.mVersion != 3) {
                this.mVersion = 1;
            }
        } else if (obj.has(KEY_VER2_IMG_URL)) {
            this.mVersion = 2;
        }
        if (this.mVersion == 1 || this.mVersion == 3) {
            try {
                this.mImgNum = obj.getInt(KEY_IMG_NUM);
                this.mUri = obj.optString(KEY_URI);
                if (TextUtils.isEmpty((CharSequence)this.mUri)) {
                    this.mUri = obj.optString(KEY_IMG_URI);
                }
                this.mImgUrl = obj.optString(KEY_IMG_URL);
                this.mImgXsize = obj.optInt(KEY_IMG_X_SIZE);
                this.mImgYsize = obj.optInt(KEY_IMG_Y_SIZE);
                this.mImgXlen = obj.optInt(KEY_IMG_X_LEN);
                this.mImgYlen = obj.optInt(KEY_IMG_Y_LEN);
                this.mDuration = obj.optDouble(KEY_DURATION);
                this.mInterval = obj.optDouble(KEY_INTERVAL);
                this.mFext = obj.optString(KEY_FEXT);
                JSONArray imgUrls = obj.optJSONArray(KEY_IMG_URLS);
                if (imgUrls == null || imgUrls.length() <= 0) return;
                this.mImgUrlList = new ArrayList();
                for (int i = 0; i < imgUrls.length(); ++i) {
                    this.mImgUrlList.add(imgUrls.optString(i));
                }
                return;
            }
            catch (JSONException e) {
                TTVideoEngineLog.d(e);
                return;
            }
        } else if (this.mVersion == 2) {
            try {
                this.mImgNumVer2 = obj.getInt(KEY_VER2_IMG_NUM);
                this.mUriVer2 = obj.optString(KEY_VER2_URI);
                this.mImgUrlVer2 = obj.optString(KEY_VER2_IMG_URL);
                this.mImgXsizeVer2 = obj.optInt(KEY_VER2_IMG_X_SIZE);
                this.mImgYsizeVer2 = obj.optInt(KEY_VER2_IMG_Y_SIZE);
                this.mImgXlenVer2 = obj.optInt("ImgXLen");
                this.mImgYlenVer2 = obj.optInt("ImgYLen");
                this.mDurationVer2 = obj.optDouble(KEY_VER2_DURATION);
                this.mIntervalVer2 = obj.optDouble("Interval");
                this.mFextVer2 = obj.optString(KEY_VER2_FEXT);
                return;
            }
            catch (JSONException e) {
                TTVideoEngineLog.d(e);
            }
            return;
        } else {
            if (this.mVersion != 4) return;
            this.mCaptureNumVer4 = obj.optInt(KEY_VER4_CAPTURE_NUM);
            JSONArray storeUrls = obj.optJSONArray(KEY_VER4_STORE_URLS);
            if (storeUrls != null && storeUrls.length() > 0) {
                this.mStoreUrlsVer4 = new ArrayList();
                for (int i = 0; i < storeUrls.length(); ++i) {
                    this.mStoreUrlsVer4.add(storeUrls.optString(i));
                }
            }
            this.mCellWidthVer4 = obj.optInt(KEY_VER4_CELL_WIDTH);
            this.mCellHeightVer4 = obj.optInt(KEY_VER4_CELL_HEIGHT);
            this.mImgXLenVer4 = obj.optInt("ImgXLen");
            this.mImgYLenVer4 = obj.optInt("ImgYLen");
            this.mIntervalVer4 = obj.optDouble("Interval");
            this.mFormatVer4 = obj.optString(KEY_VER4_FORMAT);
        }
    }

    public int getValueInt(int key) {
        if (this.mVersion == 2) {
            switch (key) {
                case 0: {
                    return this.mImgNumVer2;
                }
                case 3: {
                    return this.mImgXsizeVer2;
                }
                case 4: {
                    return this.mImgYsizeVer2;
                }
                case 5: {
                    return this.mImgXlenVer2;
                }
                case 6: {
                    return this.mImgYlenVer2;
                }
            }
            return -1;
        }
        if (this.mVersion == 4) {
            switch (key) {
                case 0: {
                    return this.mCaptureNumVer4;
                }
                case 3: {
                    return this.mCellWidthVer4;
                }
                case 4: {
                    return this.mCellHeightVer4;
                }
                case 5: {
                    return this.mImgXLenVer4;
                }
                case 6: {
                    return this.mImgYLenVer4;
                }
            }
            return -1;
        }
        switch (key) {
            case 0: {
                return this.mImgNum;
            }
            case 3: {
                return this.mImgXsize;
            }
            case 4: {
                return this.mImgYsize;
            }
            case 5: {
                return this.mImgXlen;
            }
            case 6: {
                return this.mImgYlen;
            }
        }
        return -1;
    }

    public String getValueStr(int key) {
        if (this.mVersion == 2) {
            switch (key) {
                case 1: {
                    return this.mUriVer2;
                }
                case 2: {
                    return this.mImgUrlVer2;
                }
                case 9: {
                    return this.mFextVer2;
                }
            }
            return "";
        }
        if (this.mVersion == 4) {
            switch (key) {
                case 9: {
                    return this.mFormatVer4;
                }
            }
            return "";
        }
        switch (key) {
            case 1: {
                return this.mUri;
            }
            case 2: {
                return this.mImgUrl;
            }
            case 9: {
                return this.mFext;
            }
        }
        return "";
    }

    public double getValueDouble(int key) {
        if (this.mVersion == 2) {
            switch (key) {
                case 7: {
                    return this.mDurationVer2;
                }
                case 8: {
                    return this.mIntervalVer2;
                }
            }
            return -1.0;
        }
        if (this.mVersion == 4) {
            switch (key) {
                case 8: {
                    return this.mIntervalVer4;
                }
            }
            return -1.0;
        }
        switch (key) {
            case 7: {
                return this.mDuration;
            }
            case 8: {
                return this.mInterval;
            }
        }
        return -1.0;
    }

    public List<String> getUrls() {
        if (this.mVersion == 4 && this.mStoreUrlsVer4 != null) {
            return new ArrayList<String>(this.mStoreUrlsVer4);
        }
        return null;
    }
}

