/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategrycenter;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bytedance.vcloud.strategy.IAppService;
import com.bytedance.vcloud.strategy.ILogCallback;
import com.bytedance.vcloud.strategy.StrategyCenter;
import com.ss.ttvideoengine.TTNetWorkListener;
import com.ss.ttvideoengine.TTNetworkStateCallback;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.database.KVDBManager;
import com.ss.ttvideoengine.log.VideoEventManager;
import com.ss.ttvideoengine.model.BareVideoModel;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.preload.PreloadScene;
import com.ss.ttvideoengine.selector.strategy.GearStrategyConfig;
import com.ss.ttvideoengine.selector.strategy.GearStrategyContext;
import com.ss.ttvideoengine.selector.strategy.IGearStrategyListener;
import com.ss.ttvideoengine.setting.SettingsHelper;
import com.ss.ttvideoengine.strategrycenter.IPortraitService;
import com.ss.ttvideoengine.strategrycenter.IStrategyEventListener;
import com.ss.ttvideoengine.strategrycenter.IStrategyStateSupplier;
import com.ss.ttvideoengine.strategrycenter.StrategyEvent;
import com.ss.ttvideoengine.strategrycenter.StrategyKeys;
import com.ss.ttvideoengine.strategrycenter.StrategyMediaParam;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONException;
import org.json.JSONObject;

public class StrategyHelper {
    static final String TAG = "VCStrategy";
    public static final String LOG_KEY_PRECISE_CACHE_CONTROL = "st_play_task_op";
    private StrategyCenter mCenter = null;
    private IStrategyStateSupplier mSupplier = null;
    private IPortraitService mPortraitService = null;
    private IStrategyEventListener mEventListener;
    private boolean mDidSetAppInfo = false;
    private long mIOManager = 0L;
    private long mIOManagerVersion = 0L;
    private Context mContext = null;
    private int mLogLevel = 5;
    private int mAppID = 0;
    private boolean mCheckPlayerVer = false;
    private boolean mPlayerIsMatch = false;
    private TTNetworkStateCallback mNetWorkChangeCb = null;
    private WeakReference<TTNetworkStateCallback> mNetWorkChangeCbr = null;
    private final ReentrantLock mLock = new ReentrantLock();
    private DBHelper mDBHelper = null;
    private Map<Integer, Integer> mModuleSwitchMap = new ConcurrentHashMap<Integer, Integer>(5);
    private StrategyEvent mInnerEvent = new StrategyEvent();
    private Map<Integer, Integer> mSettingMap = new ConcurrentHashMap<Integer, Integer>();
    private Map<Integer, String> mJsonStringMap = new ConcurrentHashMap<Integer, String>();

    public static StrategyHelper helper() {
        return StrategyHelperHolder.Instance;
    }

    public StrategyCenter getCenter() {
        if (this.mCenter == null) {
            this.mLock.lock();
            try {
                if (this.mCenter == null) {
                    this.mCenter = new StrategyCenter(new MyIStrategyEventListener(this));
                }
            }
            finally {
                this.mLock.unlock();
            }
        }
        return this.mCenter;
    }

    public boolean needCheckPlayerVersion() {
        return !this.mCheckPlayerVer;
    }

    public boolean playerIsMatch() {
        return this.mPlayerIsMatch;
    }

    public boolean checkPlayerVersion(int playerVersion) {
        if (playerVersion != -1 && this.getCenter().isLoadLibrarySucceed()) {
            this.mCheckPlayerVer = true;
            this.mPlayerIsMatch = this.getCenter().iPlayerVersion() == playerVersion;
        }
        return this.mPlayerIsMatch;
    }

    public int moduleSwitch(int key) {
        if (!this.mModuleSwitchMap.containsKey(key)) {
            if (this.getCenter().isRunning()) {
                int retVal = this.getCenter().getIntValue(key, 0);
                this.mModuleSwitchMap.put(key, retVal);
            } else {
                return 0;
            }
        }
        return this.mModuleSwitchMap.get(key);
    }

    @Nullable
    public Map<String, Object> getLogData(String videoId) {
        return this.mInnerEvent.getLogData(videoId);
    }

    @Nullable
    public Map<String, Object> getLogDataByTraceId(String traceId) {
        return this.mInnerEvent.getLogDataByTraceId(traceId);
    }

    @Nullable
    public Map<String, Object> getLogData(String videoId, String key) {
        return this.mInnerEvent.getLogData(videoId, key);
    }

    public void removeLogData(String videoId) {
        this.mInnerEvent.removeLogData(videoId);
    }

    public void removeLogDataByTraceId(String traceId) {
        this.mInnerEvent.removeLogDataByTraceId(traceId);
    }

    public void start(boolean needLoadLibrary) {
        this.getCenter();
        this.mLock.lock();
        try {
            this.internalStart(needLoadLibrary);
        }
        catch (Throwable e) {
            TTVideoEngineLog.i(TAG, e != null ? e.toString() : "");
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void internalStart(boolean needLoadLibrary) {
        JSONObject vodSettings;
        this.getCenter().create(this.mContext, needLoadLibrary);
        if (!this.getCenter().isLoadLibrarySucceed()) {
            return;
        }
        this._configParams();
        this._netStateListener();
        if (this.mJsonStringMap.get(31001) == null) {
            String algorithmJson = "{\"strategy_center_v1\":{\"engine_default\":{\"preload_strategy\":{\"name\":\"default\",\"tasks\":[{\"download_progress\":100,\"count\":5,\"offset\":0,\"size\":800}]}},\"video_range_request\":{\"enable_concurrent_download\":0,\"allowed_segment_download\":0,\"fixed_size\":3000,\"fixed_duration\":10}}}";
            if (this.mAppID == 32) {
                algorithmJson = "{\"strategy_center_v1\":{\"feed\":{\"preload_strategy\":{\"name\":\"adaptive\",\"low_buf\":5,\"high_buf\":20,\"tasks\":[{\"count\":5,\"size\":800,\"offset\":0}]}},\"fullscreen_immersive\":{\"preload_strategy\":{\"name\":\"adaptive\",\"low_buf\":5,\"high_buf\":20,\"tasks\":[{\"count\":5,\"size\":800,\"offset\":0}]}},\"story\":{\"preload_strategy\":{\"name\":\"adaptive\",\"low_buf\":5,\"high_buf\":20,\"tasks\":[{\"count\":5,\"size\":800,\"offset\":0}]}}}}";
            }
            this.setAlgorithmJson(31001, algorithmJson);
        }
        this.getCenter().setIOManager(this.mIOManager, this.mIOManagerVersion);
        if (!this.getCenter().isIOManagerVersionMatch()) {
            TTVideoEngineLog.i(TAG, "io manager interface not match, start fail.");
            return;
        }
        this.getCenter().setLogCallback(new MyALogCallBak());
        if (this.mPortraitService != null) {
            this.getCenter().setAppServer(new MyAppServer(this));
        }
        if ((vodSettings = SettingsHelper.helper().getJsonObject(SettingsHelper.MODULE_VOD)) != null) {
            this.getCenter().setSettingsInfo(SettingsHelper.MODULE_VOD, vodSettings.toString());
        }
        String sceneId = "engine_default";
        String briefSceneId = "engine_brief_default";
        PreloadScene scene = new PreloadScene(sceneId);
        scene.mSceneId = sceneId;
        scene.mBriefSceneId = briefSceneId;
        scene.mAutoPlay = 1;
        scene.mMute = 0;
        scene.mMaxVisibleCardCnt = 1;
        scene.setAlgorithmName(sceneId);
        StrategyHelper.helper().getCenter().createScene(scene.toJsonString());
        this.getCenter().setStateSupplier(new com.bytedance.vcloud.strategy.IStrategyStateSupplier(){

            @Override
            public String mediaInfoJsonString(String videoId) {
                if (StrategyHelper.this.mSupplier != null) {
                    Map<String, Object> map = StrategyHelper.this.mSupplier.mediaInfo(videoId);
                    String jsonString = null;
                    try {
                        if (map != null) {
                            jsonString = new JSONObject(map).toString();
                        }
                    }
                    catch (Throwable e) {
                        TTVideoEngineLog.d(e);
                    }
                    return jsonString;
                }
                return null;
            }

            @Override
            public String selectBitrateJsonString(String videoId, int type) {
                if (StrategyHelper.this.mSupplier != null) {
                    Map<String, Integer> map = StrategyHelper.this.mSupplier.selectBitrate(videoId, type);
                    String jsonString = null;
                    try {
                        if (map != null) {
                            jsonString = new JSONObject(map).toString();
                        }
                    }
                    catch (Throwable e) {
                        TTVideoEngineLog.d(e);
                    }
                    return jsonString;
                }
                return null;
            }

            @Override
            @Nullable
            public String selectBitrateJsonString(String videoId, String sceneId, int type) {
                if (StrategyHelper.this.mSupplier != null) {
                    Map<String, Integer> map = StrategyHelper.this.mSupplier.selectBitrate(new StrategyMediaParam(videoId, sceneId, type));
                    String jsonString = null;
                    try {
                        if (map != null) {
                            jsonString = new JSONObject(map).toString();
                        }
                    }
                    catch (Throwable e) {
                        TTVideoEngineLog.d(e);
                    }
                    return jsonString;
                }
                return null;
            }

            @Override
            public double getNetworkSpeed() {
                if (StrategyHelper.this.mSupplier != null) {
                    return StrategyHelper.this.mSupplier.getNetworkSpeed();
                }
                return 0.0;
            }

            @Override
            public int getNetworkType() {
                int accessType = TTNetWorkListener.getInstance().getCurrentAccessType();
                return StrategyHelper._netState(accessType);
            }

            @Override
            public String onBeforeSelect(String mediaInfo, String extraInfo, int type, Object context) {
                GearStrategyConfig gearStrategyConfig;
                TTVideoEngineLog.i(StrategyHelper.TAG, "[GearStrategy] StrategyHelper.onBeforeSelect type=" + type + " context=" + context);
                IVideoModel model = null;
                IGearStrategyListener listener = null;
                GearStrategyContext strategyContext = null;
                Object userData = null;
                WeakReference<TTVideoEngine> videoEngineRef = null;
                TTVideoEngine videoEngine = null;
                if (context instanceof GearStrategyContext) {
                    strategyContext = (GearStrategyContext)context;
                    listener = strategyContext.getGearStrategyListener();
                }
                if (listener == null && (gearStrategyConfig = TTVideoEngine.getGearStrategyConfig()) != null) {
                    listener = gearStrategyConfig.getGearStrategyListener();
                }
                if (listener == null) {
                    TTVideoEngineLog.i(StrategyHelper.TAG, "listener is null");
                    return extraInfo;
                }
                if (strategyContext != null) {
                    userData = strategyContext.getUserData();
                    model = strategyContext.getVideoModel();
                    videoEngineRef = strategyContext.getVideoEngineRef();
                    if (videoEngineRef != null) {
                        videoEngine = (TTVideoEngine)videoEngineRef.get();
                    }
                }
                if (model == null) {
                    model = new BareVideoModel.Builder().build();
                    model.fromMediaInfoJsonString(mediaInfo);
                }
                if (model == null) {
                    TTVideoEngineLog.i(StrategyHelper.TAG, "[GearStrategy] StrategyHelper.onBeforeSelect  model is null mediaInfo=" + mediaInfo);
                    return extraInfo;
                }
                HashMap<String, String> params = new HashMap<String, String>();
                StrategyHelper.this._stringToMap(extraInfo, params);
                if (listener != null) {
                    if (videoEngine != null) {
                        videoEngine.setLoggerLongOption(107, System.currentTimeMillis());
                    }
                    listener.onBeforeSelect(model, params, type, userData);
                    if (videoEngine != null) {
                        videoEngine.setLoggerLongOption(108, System.currentTimeMillis());
                    }
                }
                StrategyHelper.this.getCenter().updateMedia(model.getVideoRefStr(2), "", model.toMediaInfoJsonString());
                return StrategyHelper.this._mapToString(params);
            }

            @Override
            public String onAfterSelect(String mediaInfo, String extraInfo, int type, Object context) {
                GearStrategyConfig gearStrategyConfig;
                TTVideoEngineLog.i(StrategyHelper.TAG, "[GearStrategy] StrategyHelper.onAfterSelect type=" + type + " context=" + context);
                IVideoModel model = null;
                IGearStrategyListener listener = null;
                GearStrategyContext strategyContext = null;
                Object userData = null;
                WeakReference<TTVideoEngine> videoEngineRef = null;
                TTVideoEngine videoEngine = null;
                if (context instanceof GearStrategyContext) {
                    strategyContext = (GearStrategyContext)context;
                    listener = strategyContext.getGearStrategyListener();
                }
                if (listener == null && (gearStrategyConfig = TTVideoEngine.getGearStrategyConfig()) != null) {
                    listener = gearStrategyConfig.getGearStrategyListener();
                }
                if (listener == null) {
                    TTVideoEngineLog.i(StrategyHelper.TAG, "listener is null");
                    return extraInfo;
                }
                if (strategyContext != null) {
                    userData = strategyContext.getUserData();
                    model = strategyContext.getVideoModel();
                    videoEngineRef = strategyContext.getVideoEngineRef();
                    if (videoEngineRef != null) {
                        videoEngine = (TTVideoEngine)videoEngineRef.get();
                    }
                }
                if (model == null) {
                    model = new BareVideoModel.Builder().build();
                    model.fromMediaInfoJsonString(mediaInfo);
                }
                if (model == null) {
                    TTVideoEngineLog.i(StrategyHelper.TAG, "[GearStrategy] StrategyHelper.onAfterSelect  model is null mediaInfo=" + mediaInfo);
                    return extraInfo;
                }
                HashMap<String, String> result = new HashMap<String, String>();
                StrategyHelper.this._stringToMap(extraInfo, result);
                if (listener != null) {
                    if (videoEngine != null) {
                        videoEngine.setLoggerLongOption(109, System.currentTimeMillis());
                    }
                    listener.onAfterSelect(model, result, type, userData);
                    if (videoEngine != null) {
                        videoEngine.setLoggerLongOption(110, System.currentTimeMillis());
                        if (result.containsKey("video_bitrarte_user_selected")) {
                            try {
                                videoEngine.setLoggerLongOption(101, Long.parseLong((String)result.get("video_bitrarte_user_selected")));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            videoEngine.setLoggerIntOption(102, 9);
                        } else {
                            if (result.containsKey("video_bitrarte")) {
                                try {
                                    videoEngine.setLoggerLongOption(101, Long.parseLong((String)result.get("video_bitrarte")));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (result.containsKey("select_reason")) {
                                try {
                                    videoEngine.setLoggerIntOption(102, Integer.parseInt((String)result.get("select_reason")));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (result.containsKey("speed")) {
                                try {
                                    videoEngine.setLoggerLongOption(103, Long.parseLong((String)result.get("speed")));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (result.containsKey(104)) {
                                try {
                                    videoEngine.setLoggerIntOption(104, Integer.parseInt((String)result.get("error_code")));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                StrategyHelper.this.getCenter().updateMedia(model.getVideoRefStr(2), "", model.toMediaInfoJsonString());
                return StrategyHelper.this._mapToString(result);
            }
        });
        this.getCenter().start(this.mContext, needLoadLibrary);
        StrategyHelper.helper().getCenter().switchToScene(sceneId);
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIOManager(long ioManager, long version) {
        this.mLock.lock();
        try {
            this.mIOManager = ioManager;
            this.mIOManagerVersion = version;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void setEventListener(IStrategyEventListener eventListener) {
        this.mLock.lock();
        try {
            this.mEventListener = eventListener;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void setSupplier(IStrategyStateSupplier mSupplier) {
        this.mSupplier = mSupplier;
    }

    public void setPortraitService(IPortraitService service) {
        this.mLock.lock();
        try {
            if (null == this.mPortraitService && null != service) {
                this.getCenter().setAppServer(new MyAppServer(this));
            }
            this.mPortraitService = service;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void configAppInfo(String appInfo, Map infoMap) {
        if (!this.mDidSetAppInfo && this.getCenter().isLoadLibrarySucceed()) {
            this.getCenter().setAppInfo(appInfo);
            this.mDidSetAppInfo = true;
        }
        if (infoMap != null && infoMap.containsKey("appid")) {
            this.mAppID = TTHelper.parseInt(infoMap.get("appid"));
        }
    }

    public void setLogLevel(int level) {
        this.getCenter().setIntValue(10000, level);
        this.mLogLevel = level;
    }

    public boolean isRunning() {
        return this.getCenter().isRunning();
    }

    public int getLogLevel() {
        return this.mLogLevel;
    }

    public IStrategyStateSupplier getSupplier() {
        return this.mSupplier;
    }

    public void setAlgorithmJson(int key, String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            TTVideoEngineLog.i(TAG, "[preload] Algorithm json " + jsonString);
            return;
        }
        if (this.getCenter().isLoadLibrarySucceed()) {
            this.getCenter().setAlgorithmJson(key, jsonString);
        } else {
            this.mJsonStringMap.put(key, jsonString);
        }
    }

    public void setIntValue(int key, int value) {
        if (key <= 50000 || key >= 60000) {
            return;
        }
        if (this.getCenter().isLoadLibrarySucceed()) {
            this.getCenter().setIntValue(key, value);
        } else {
            this.mSettingMap.put(key, value);
        }
    }

    @Nullable
    public Map<String, Integer> selectResolution(IVideoModel videoModel, int type, @Nullable Map<String, String> param, GearStrategyContext context) {
        String retString = this.getCenter().selectBitrate(videoModel.toMediaInfoJsonString(), type, this._mapToString(param), context);
        if (TextUtils.isEmpty((CharSequence)retString)) {
            TTVideoEngineLog.d(TAG, "[GearStrategy]StrategyHelper.selectResolution result invalid retString=" + retString);
            return null;
        }
        return this._stringToIntValueMap(retString);
    }

    private void _configParams() {
        this.mDBHelper = new DBHelper(this.mContext, this);
        this.getCenter().setIntValue(10000, this.mLogLevel);
        this.getCenter().setIntValue(801, StrategyKeys.mInteractionBlockDurationPreloaded);
        this.getCenter().setIntValue(802, StrategyKeys.mInteractionBlockDurationNonPreloaded);
        for (Map.Entry<Integer, String> entry : this.mJsonStringMap.entrySet()) {
            this.getCenter().setAlgorithmJson(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : this.mSettingMap.entrySet()) {
            this.getCenter().setIntValue(entry.getKey(), (Integer)entry.getValue());
        }
    }

    private void _netStateListener() {
        if (this.mNetWorkChangeCb != null) {
            return;
        }
        this.mNetWorkChangeCb = new TTNetworkStateCallback(){

            @Override
            public void onAccessChanged(int what, int from, int to) {
                switch (what) {
                    case 0: {
                        StrategyHelper.this.getCenter().businessEvent(1202, StrategyHelper._netState(to));
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
            }
        };
        this.mNetWorkChangeCbr = new WeakReference<TTNetworkStateCallback>(this.mNetWorkChangeCb);
        TTNetWorkListener.getInstance().startListen(this.mNetWorkChangeCbr);
    }

    public static void buildMediaInfo(Map modelMap, String vid, String fileHash, String[] urls) {
        try {
            List infoMaps = null;
            infoMaps = modelMap.containsKey("infos") ? (List)modelMap.get("infos") : new ArrayList();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("urls", urls);
            infoMap.put("file_hash", fileHash);
            infoMaps.add(infoMap);
            modelMap.put("vid", TextUtils.isEmpty((CharSequence)vid) ? fileHash : vid);
            modelMap.put("infos", infoMaps);
        }
        catch (Throwable e) {
            TTVideoEngineLog.e(TAG, e.toString());
        }
    }

    public static void buildMaskInfo(Map modelMap, String maskUrl, String fileHash) {
        try {
            List infoMaps = null;
            infoMaps = modelMap.containsKey("infos") ? (List)modelMap.get("infos") : new ArrayList();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("file_hash", fileHash);
            if (!TextUtils.isEmpty((CharSequence)maskUrl)) {
                infoMap.put("urls", new String[]{maskUrl});
            }
            infoMap.put("media_type", "mask");
            infoMaps.add(infoMap);
            modelMap.put("infos", infoMaps);
        }
        catch (Throwable e) {
            TTVideoEngineLog.e(TAG, e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> _stringToIntValueMap(String str) {
        if (null == str || str.length() < 2) {
            return null;
        }
        HashMap<String, Integer> retMap = new HashMap<String, Integer>();
        String[] tems = str.split(",");
        try {
            for (int i = 0; i < tems.length; ++i) {
                String[] items = tems[i].split(":");
                if (items.length != 2) continue;
                retMap.put(items[0], Integer.parseInt(items[1]));
            }
        }
        catch (NumberFormatException e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            return retMap;
        }
    }

    private String _mapToString(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        try {
            JSONObject json = new JSONObject();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) continue;
                json.put(key, (Object)value);
            }
            return json.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    private Map<String, String> _stringToMap(String input, Map<String, String> map) {
        if (TextUtils.isEmpty((CharSequence)input) || map == null) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(input);
            Iterator it = json.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = json.getString(key);
                if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) continue;
                map.put(key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private static final int _netState(int accessType) {
        int ret = -1;
        if (accessType == -1) {
            ret = 0;
        } else if (accessType == 0) {
            ret = 20;
        } else if (accessType == 2 || accessType == 3 || accessType == 1 || accessType == 4) {
            ret = 10;
        }
        return ret;
    }

    private final class DBHelper {
        private static final String dataBaseName = "TTVideoEngine_vod_strategy_database_v01";
        private static final String dataIndex = "data_index";
        private final ArrayList<String> mIndexArray = new ArrayList();
        KVDBManager mDBManager = null;
        Context mContext = null;
        WeakReference<StrategyHelper> mSHelper = null;
        final int mMaxCacheNum = 2000;

        public DBHelper(Context context, StrategyHelper helper) {
            this.mContext = context;
            this.mSHelper = new WeakReference<StrategyHelper>(helper);
        }

        public void event(int operateKey, String cacheKey, String info) {
            switch (operateKey) {
                case 1: {
                    this.loadDB();
                    break;
                }
                case 2: {
                    this.saveData(cacheKey, info);
                    break;
                }
                case 3: {
                    this.removeData(cacheKey);
                    break;
                }
            }
        }

        public void loadDB() {
            try {
                this.mDBManager = new KVDBManager(this.mContext, dataBaseName);
                if (!this.mDBManager.isCreateDBSuccess()) {
                    TTVideoEngineLog.e(StrategyHelper.TAG, "create db fail.");
                    return;
                }
                this._loadData();
            }
            catch (Throwable e) {
                TTVideoEngineLog.d(e);
            }
        }

        private void _loadData() {
            StrategyHelper helper = (StrategyHelper)this.mSHelper.get();
            if (helper == null) {
                return;
            }
            String prIndexV2 = this.mDBManager.get(dataIndex);
            ArrayList<String> strArray = this.stringToStringArray(prIndexV2);
            if (strArray == null || strArray.isEmpty()) {
                return;
            }
            this.mIndexArray.addAll(strArray);
            String temValue = null;
            for (String cacheKey : strArray) {
                temValue = this.mDBManager.get(cacheKey);
                if (TextUtils.isEmpty((CharSequence)temValue)) continue;
                helper.getCenter().businessEvent(31210, temValue);
            }
        }

        public void saveData(String cacheKey, String valueString) {
            try {
                this.mIndexArray.add(cacheKey);
                if (this.mIndexArray.size() > 2000) {
                    String removeKey = this.mIndexArray.remove(0);
                    this.mDBManager.remove(removeKey);
                }
                this._saveDataIndexes();
                this.mDBManager.save(cacheKey, valueString);
            }
            catch (Throwable e) {
                TTVideoEngineLog.e(StrategyHelper.TAG, "save data fail. " + e.toString());
            }
        }

        public void removeData(String cacheKey) {
            try {
                this.mIndexArray.remove(cacheKey);
                this._saveDataIndexes();
                this.mDBManager.remove(cacheKey);
            }
            catch (Throwable e) {
                TTVideoEngineLog.e(StrategyHelper.TAG, "remove data fail. " + e.toString());
            }
        }

        private void _saveDataIndexes() {
            String string = this.indexToString(this.mIndexArray);
            this.mDBManager.save(dataIndex, string);
        }

        @Nullable
        private ArrayList<String> stringToStringArray(String str) {
            if (TextUtils.isEmpty((CharSequence)str)) {
                return null;
            }
            ArrayList<String> temIndex = null;
            try {
                String[] strs = str.split(",");
                if (strs != null && strs.length > 0) {
                    temIndex = new ArrayList<String>();
                    for (String indexStr : strs) {
                        if (TextUtils.isEmpty((CharSequence)indexStr)) continue;
                        temIndex.add(indexStr);
                    }
                }
            }
            catch (Throwable e) {
                TTVideoEngineLog.d(e);
            }
            return temIndex;
        }

        private String indexToString(ArrayList<String> strArray) {
            if (strArray != null) {
                StringBuilder sb = new StringBuilder(strArray.size());
                for (int i = 0; i < strArray.size(); ++i) {
                    sb.append(strArray.get(i));
                    if (i >= strArray.size() - 1) continue;
                    sb.append(",");
                }
                return sb.toString();
            }
            return null;
        }
    }

    class MyAppServer
    implements IAppService {
        private WeakReference<StrategyHelper> mHelper = null;

        MyAppServer(StrategyHelper helper) {
            this.mHelper = new WeakReference<StrategyHelper>(helper);
        }

        @Override
        @Nullable
        public String getAllPortraits() {
            StrategyHelper helper = (StrategyHelper)this.mHelper.get();
            if (helper == null || helper.mPortraitService == null) {
                return null;
            }
            JSONObject object = helper.mPortraitService.getPortraits();
            if (object != null) {
                return object.toString();
            }
            return null;
        }

        @Override
        @Nullable
        public String getPortrait(String key) {
            StrategyHelper helper = (StrategyHelper)this.mHelper.get();
            if (helper == null || helper.mPortraitService == null) {
                return null;
            }
            return helper.mPortraitService.getPortrait(key);
        }

        @Override
        @Nullable
        public String getPortraits(String group) {
            StrategyHelper helper = (StrategyHelper)this.mHelper.get();
            if (helper == null || helper.mPortraitService == null) {
                return null;
            }
            JSONObject object = helper.mPortraitService.getGroupPortraits(group);
            if (object != null) {
                return object.toString();
            }
            return null;
        }

        @Override
        @Nullable
        public String getServerPortraits() {
            StrategyHelper helper = (StrategyHelper)this.mHelper.get();
            if (helper == null || helper.mPortraitService == null) {
                return null;
            }
            JSONObject object = helper.mPortraitService.getServerPortraits();
            if (object != null) {
                return object.toString();
            }
            return null;
        }

        @Override
        public void updatePortrait(String key, String value) {
            StrategyHelper helper = (StrategyHelper)this.mHelper.get();
            if (helper == null || helper.mPortraitService == null) {
                return;
            }
            helper.mPortraitService.updatePortrait(key, value);
        }

        @Override
        public void updatePortraits(String portraitObj) {
            StrategyHelper helper = (StrategyHelper)this.mHelper.get();
            if (helper == null || helper.mPortraitService == null) {
                return;
            }
            try {
                helper.mPortraitService.updatePortraits(new JSONObject(portraitObj));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static class MyALogCallBak
    implements ILogCallback {
        MyALogCallBak() {
        }

        @Override
        public void log(String logInfo) {
            TTVideoEngineLog.i(StrategyHelper.TAG, logInfo);
        }
    }

    class MyIStrategyEventListener
    implements com.bytedance.vcloud.strategy.IStrategyEventListener {
        private WeakReference<StrategyHelper> mHelper = null;

        MyIStrategyEventListener(StrategyHelper helper) {
            this.mHelper = new WeakReference<StrategyHelper>(helper);
        }

        @Override
        public void onEvent(String videoId, int key, int value, String info) {
            TTVideoEngineLog.i(StrategyHelper.TAG, "videoID = " + videoId + ", key = " + key + ", value = " + value + ", info = " + info);
            if (key == 2019) {
                StrategyHelper helper = (StrategyHelper)this.mHelper.get();
                if (helper != null && helper.mDBHelper != null) {
                    helper.mDBHelper.event(value, videoId, info);
                }
                return;
            }
            StrategyHelper.this.mInnerEvent.event(videoId, key, value, info);
            StrategyHelper.this.mLock.lock();
            if (StrategyHelper.this.mEventListener != null) {
                StrategyHelper.this.mLock.unlock();
                if (key == 2012) {
                    StrategyHelper.this.mEventListener.onEvent(videoId, key, value, info);
                }
            } else {
                StrategyHelper.this.mLock.unlock();
            }
        }

        @Override
        public void onEventLog(String eventName, String logInfo) {
            TTVideoEngineLog.d(StrategyHelper.TAG, "eventName: " + eventName + ", logInfo: " + logInfo);
            if (!TextUtils.isEmpty((CharSequence)logInfo)) {
                try {
                    VideoEventManager.instance.addEventV2(true, new JSONObject(logInfo), eventName);
                }
                catch (JSONException e) {
                    TTVideoEngineLog.d(e);
                }
            }
        }
    }

    private static class StrategyHelperHolder {
        private static final StrategyHelper Instance = new StrategyHelper();

        private StrategyHelperHolder() {
        }
    }
}

