/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.superresolution;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.LruCache;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.superresolution.ISRStatusListener;
import com.ss.ttvideoengine.superresolution.ISRStrategyListener;
import com.ss.ttvideoengine.superresolution.SRStrategyConfig;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class SRStrategy {
    private static final String TAG = "TTVideoEngine.SRStrategy";
    public static final int SR_STRATEGY_MODE_AUTO = 0;
    public static final int SR_STRATEGY_MODE_USER = 1;
    public static final int SR_STATUS_NONE = -1;
    public static final int SR_STATUS_CLOSE = 0;
    public static final int SR_STATUS_OPEN_SUCCESS = 1;
    public static final int SR_STATUS_OPEN_FAIL = 2;
    public static final int VIDEO_FORMAT_TYPE_MP4 = 1;
    public static final int VIDEO_FORMAT_TYPE_DASH = 2;
    public static final int SCENE_NONE = 0;
    public static final int SCENE_LIST = 1;
    public static final int SCENE_DETAIL = 2;
    public static final int SCENE_FULLSCREEN = 4;
    public static final int SR_CHECK_TYPE_PRELOAD = 0;
    public static final int SR_CHECK_TYPE_PLAY = 1;
    public static final String KEY_ENABLE_SR_STRATEGY = "ess";
    public static final String KEY_ENABLE_ABR_SR = "eas";
    public static final String KEY_SR_STRATEGY_CONFIG = "sc";
    public static final String KEY_SR_STRATEGY_MODE = "sm";
    public static final String KEY_BITRATE_BEFORE_DOWNGRADE = "bbd";
    public static final String KEY_BITRATE_AFTER_DOWNGRADE = "bad";
    public static final String KEY_BITRATE_DOWNGRADE_TYPE = "bdt";
    public static final String KEY_SR_STATUS = "ss";
    public static final String KEY_SR_FAIL_REASON = "sfr";
    public static final String KEY_SR_SATISFIED = "srs";
    public static final String KEY_SR_USE_TEXTURE = "sut";
    public static final String KEY_SR_OPEN = "so";
    public static final String KEY_SR_MEDIA_INFO = "smi";
    public static final String MEDIAINFO_KEY_BITRATE = "br";
    public static final String MEDIAINFO_KEY_RESOLUTION = "res";
    public static final String MEDIAINFO_KEY_SUPPORT_SR = "ss";
    public static final String MEDIAINFO_KEY_CACHE_SIZE = "cs";
    public static final String MEDIAINFO_KEY_WIDTH = "w";
    private static final int PRELOAD_INFO_CACHE_SIZE = 100;
    private SRStrategyConfig mSRConfig = new SRStrategyConfig();
    private ISRStrategyListener mSRStrategyListener = null;
    private int mSRStrategyMode = 1;
    private boolean mSRSatisfied = false;
    private boolean mShouldUseSRTexture = false;
    private int mSRNotUseReason = 0;
    private int mSRStatus = -1;
    private Map<Integer, List<Integer>> mSRBenchmark = new HashMap<Integer, List<Integer>>();
    private Map<String, Map<String, Object>> mMediaInfo = new HashMap<String, Map<String, Object>>();
    private static LruCache<String, Map<String, Object>> mPreloadInfoCache = new LruCache(100);

    public SRStrategy() {
        this.resetAll();
        this.mSRBenchmark.put(2, new ArrayList<Integer>(Arrays.asList(3)));
    }

    public void resetAll() {
        this.mSRConfig.resetAll();
        this.mSRConfig.enableSR(false);
        this.mSRConfig.setEnableHdr(false);
        this.mSRConfig.setIsSpeed(false);
        this.mSRStrategyListener = null;
        this.mSRStrategyMode = 1;
        this.mSRSatisfied = false;
        this.mShouldUseSRTexture = false;
        this.mSRNotUseReason = 0;
        this.mSRStatus = -1;
        this.mMediaInfo.clear();
    }

    private void checkSatisfied() {
        Boolean enableSpeed;
        Integer curScene;
        Boolean isHdr;
        Integer curFormat;
        Integer curDuration;
        this.mSRSatisfied = false;
        this.mShouldUseSRTexture = false;
        this.mSRNotUseReason = 0;
        if (2 == this.mSRStatus) {
            this.mSRNotUseReason = -7874;
            return;
        }
        Boolean enableSr = this.mSRConfig.getEnableSR();
        if (enableSr == null || enableSr != null && !enableSr.booleanValue()) {
            this.mSRNotUseReason = -7888;
            return;
        }
        Boolean resolutionChanged = this.mSRConfig.getResolutionChanged();
        if (resolutionChanged != null && resolutionChanged.booleanValue()) {
            this.mSRNotUseReason = -7879;
            return;
        }
        if (this.mSRBenchmark.size() <= 0) {
            this.mSRNotUseReason = -7878;
            return;
        }
        Long minDuration = this.mSRConfig.getMinDuration();
        Long maxDuration = this.mSRConfig.getMaxDuration();
        if (minDuration != null && maxDuration != null && ((curDuration = this.mSRConfig.getCurrentDuration()) == null || (long)curDuration.intValue() < minDuration || (long)curDuration.intValue() > maxDuration)) {
            this.mSRNotUseReason = -7885;
            return;
        }
        Integer format = this.mSRConfig.getVideoFormatType();
        if (format != null && ((curFormat = this.mSRConfig.getCurrentVideoFormatType()) == null || curFormat.compareTo(curFormat & format) != 0)) {
            this.mSRNotUseReason = -7887;
            return;
        }
        Boolean enableHdr = this.mSRConfig.getEnableHdr();
        if (enableHdr != null && ((isHdr = this.mSRConfig.getIsHdr()) == null || !enableHdr.booleanValue() && isHdr.booleanValue())) {
            this.mSRNotUseReason = -7883;
            return;
        }
        Integer supportScene = this.mSRConfig.getSupportScene();
        if (supportScene != null && ((curScene = this.mSRConfig.getCurrentScene()) == null || curScene.compareTo(curScene & supportScene) != 0)) {
            this.mSRNotUseReason = -7884;
            return;
        }
        this.mShouldUseSRTexture = true;
        Integer strategyType = this.mSRConfig.getStrategyType();
        if (strategyType != null && 1 == strategyType && (enableSpeed = this.mSRConfig.getEnableSpeed()) != null) {
            Boolean isSpeed = this.mSRConfig.getIsSpeed();
            if (!enableSpeed.booleanValue() && isSpeed != null && isSpeed.booleanValue()) {
                this.mSRNotUseReason = -7882;
                return;
            }
        }
        this.mSRSatisfied = true;
    }

    public void updateConfig(SRStrategyConfig cfg) {
        TTVideoEngineLog.i(TAG, "[SRLog]updateConfig cfg=" + cfg);
        if (cfg == null) {
            return;
        }
        this.mSRConfig.updateFrom(cfg);
        String extraConfig = cfg.getExtraConfig();
        if (extraConfig != null && !extraConfig.isEmpty()) {
            extraConfig = extraConfig.toLowerCase();
            HashMap<Integer, List<Integer>> benchmarkMap = new HashMap<Integer, List<Integer>>();
            try {
                JSONObject jRoot = new JSONObject(extraConfig);
                JSONObject jSR = jRoot.getJSONObject("sr");
                JSONObject jSRBenchmark = jSR.getJSONObject("benchmark");
                Iterator iterator = jSRBenchmark.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    int iKey = Integer.parseInt(key);
                    JSONArray jValues = jSRBenchmark.getJSONArray(key);
                    ArrayList<Integer> valList = new ArrayList<Integer>();
                    for (int i = 0; i < jValues.length(); ++i) {
                        int iVal = jValues.getInt(i);
                        valList.add(iVal);
                    }
                    benchmarkMap.put(iKey, valList);
                }
                this.mSRBenchmark = benchmarkMap;
                TTVideoEngineLog.i(TAG, "[SRLog]updateConfig mSRBenchmark=" + this.mSRBenchmark);
            }
            catch (Exception e) {
                TTVideoEngineLog.i(TAG, "[SRLog]updateConfig exception=" + e);
                e.printStackTrace();
            }
        }
        this.checkSatisfied();
    }

    public int getSRStrategyMode() {
        return this.mSRStrategyMode;
    }

    public void setSRStrategyMode(int mode) {
        this.mSRStrategyMode = mode;
    }

    public boolean isSREnabled() {
        Boolean enable = this.mSRConfig.getEnableSR();
        if (enable != null) {
            return enable;
        }
        return false;
    }

    public boolean isSRSatisfied() {
        return this.mSRSatisfied;
    }

    public boolean shouldUseSRTexture() {
        return this.mShouldUseSRTexture;
    }

    public void onSRStatus(int status, int reason) {
        ISRStatusListener listener;
        if (status == this.mSRStatus) {
            return;
        }
        if (0 == status && 2 == this.mSRStatus) {
            return;
        }
        this.mSRStatus = status;
        TTVideoEngineLog.d(TAG, "[SRLog]onSRStatus status=" + status + " reason=" + reason);
        if (2 == this.mSRStatus) {
            this.mSRNotUseReason = reason;
        }
        if ((listener = this.mSRConfig.getListener()) != null) {
            listener.onSRStatus(status);
        }
    }

    public int getSRStatus() {
        return this.mSRStatus;
    }

    public void setSRStrategyListener(ISRStrategyListener listener) {
        this.mSRStrategyListener = listener;
    }

    public int getSRNotUseReason() {
        return this.mSRNotUseReason;
    }

    public Integer getMaxWidth() {
        return this.mSRConfig.getMaxWidth();
    }

    public Integer getMaxHeight() {
        return this.mSRConfig.getMaxHeight();
    }

    public Map<Integer, List<Integer>> getSRBenchmark() {
        return this.mSRBenchmark;
    }

    public Boolean videoInfoSupportSR(VideoInfo info, List<VideoInfo> infos) {
        int resIndex = SRStrategy.getResolutionIndex(info);
        if (!this.mSRBenchmark.containsKey(resIndex)) {
            return false;
        }
        Integer screenWidth = this.mSRConfig.getScreenWidth();
        List<Integer> srResIndexes = this.mSRBenchmark.get(resIndex);
        VideoInfo viSr = null;
        block0: for (VideoInfo vi : infos) {
            int vri = SRStrategy.getResolutionIndex(vi);
            for (Integer ri : srResIndexes) {
                if (ri != vri || viSr != null && viSr.getValueInt(3) >= vi.getValueInt(3)) continue;
                viSr = vi;
                continue block0;
            }
        }
        if (viSr == null || screenWidth != null && viSr.getValueInt(1) <= screenWidth) {
            return false;
        }
        return true;
    }

    public static int getResolutionIndex(VideoInfo info) {
        String qualityDesc;
        int resolutionindex = -1;
        Resolution resolution = info.getResolution();
        if (resolution != null) {
            resolutionindex = resolution.getIndex();
        }
        if ((qualityDesc = info.getValueStr(32)) != null) {
            try {
                resolutionindex = Integer.parseInt(qualityDesc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resolutionindex;
    }

    public JSONObject getConfigJson() {
        return this.mSRConfig.getJson();
    }

    public String configString() {
        return this.mSRConfig.toString();
    }

    public void setMediaInfo(String fileKey, String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)fileKey) || TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        Map<String, Object> mediaInfo = this.mMediaInfo.get(fileKey);
        if (mediaInfo == null) {
            mediaInfo = new HashMap<String, Object>();
            this.mMediaInfo.put(fileKey, mediaInfo);
        }
        mediaInfo.put(key, value);
    }

    public JSONArray getMediaInfoJson() {
        JSONArray infos = new JSONArray();
        for (Map<String, Object> info : this.mMediaInfo.values()) {
            if (info == null) continue;
            try {
                JSONObject infoJson = new JSONObject(info);
                infos.put((Object)infoJson);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return infos;
    }

    public String getMediaInfoString() {
        return this.getMediaInfoJson().toString();
    }

    public static void setPreloadInfo(String vid, Map<String, Object> info) {
        if (TextUtils.isEmpty((CharSequence)vid)) {
            return;
        }
        mPreloadInfoCache.put((Object)vid, info);
    }

    @Nullable
    public static Map<String, Object> getPreloadInfo(String vid) {
        if (TextUtils.isEmpty((CharSequence)vid)) {
            return null;
        }
        return (Map)mPreloadInfoCache.get((Object)vid);
    }
}

