/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import android.os.SystemClock;

public class PlayDuration {
    private static final int STATE_PLAYING = 1;
    private static final int STATE_STOP = 2;
    private int mState = 2;
    private int mPlayedDuration = 0;
    private long mStartPlayTime = 0L;

    public void start() {
        if (this.mState == 2) {
            this.mState = 1;
            this.mStartPlayTime = SystemClock.elapsedRealtime();
        }
    }

    public void stop() {
        if (this.mState == 1) {
            this.mState = 2;
            int duration = (int)(SystemClock.elapsedRealtime() - this.mStartPlayTime);
            if (duration >= 0) {
                this.mPlayedDuration += duration;
            }
        }
    }

    public int getPlayedDuration() {
        if (this.mState == 1) {
            long curTime = SystemClock.elapsedRealtime();
            int duration = (int)(curTime - this.mStartPlayTime);
            if (duration >= 0) {
                this.mPlayedDuration += duration;
            }
            this.mStartPlayTime = curTime;
        }
        return this.mPlayedDuration;
    }

    public void clear() {
        this.mPlayedDuration = 0;
        if (this.mState == 1) {
            this.mStartPlayTime = SystemClock.elapsedRealtime();
        }
    }

    public void reset() {
        this.mState = 2;
        this.mPlayedDuration = 0;
        this.mStartPlayTime = 0L;
    }
}

