/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.support.annotation.Nullable;
import com.pandora.common.env.Env;
import com.pandora.ttlicense2.LicenseManager;
import com.ss.ttvideoengine.AppInfo;
import com.ss.ttvideoengine.FeatureManager;
import com.ss.ttvideoengine.VodSettings;
import com.ss.ttvideoengine.log.AppLogTOBVer2;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.List;
import org.json.JSONArray;

public class InfoWrapper {
    private static final String TAG = "InfoWrapper";

    public static List<String> getLicenseIds() {
        return LicenseManager.getInstance().getLoadedLicenseIds();
    }

    public static String getTTSDKVersion() {
        if (InfoWrapper.isCommonSDKExist()) {
            return Env.getVersion();
        }
        return "";
    }

    public static String getDeviceID() {
        if (AppLogTOBVer2.isAppLogVer2Exist()) {
            return AppLogTOBVer2.getDeviceID();
        }
        return "";
    }

    public static String getAppID() {
        if (InfoWrapper.isSetAppInfo()) {
            return String.valueOf(AppInfo.mAppID);
        }
        if (InfoWrapper.isCommonSDKExist()) {
            return Env.getAppID();
        }
        return "";
    }

    public static String getAppName() {
        if (InfoWrapper.isSetAppInfo()) {
            return AppInfo.mAppName;
        }
        if (InfoWrapper.isCommonSDKExist()) {
            return Env.getAppName();
        }
        return "";
    }

    public static String getRegion() {
        if (InfoWrapper.isSetAppInfo()) {
            return AppInfo.mRegion;
        }
        if (InfoWrapper.isCommonSDKExist()) {
            return Env.getAppRegion();
        }
        return "";
    }

    public static boolean getUseHostSelect() {
        if (!InfoWrapper.isSetAppInfo()) {
            return false;
        }
        return VodSettings.getVodInt("host_select", 0) == 1;
    }

    @Nullable
    public static JSONArray getTopHostArray() {
        if (!InfoWrapper.isSetAppInfo()) {
            return null;
        }
        return VodSettings.getVodJsonArray("byte_vod_host");
    }

    @Nullable
    public static JSONArray getTopHostArrayV2() {
        if (!InfoWrapper.isSetAppInfo()) {
            return null;
        }
        return VodSettings.getVodJsonArray("byte_vod_host_v2");
    }

    public static int getBufferTimeOut() {
        if (!InfoWrapper.isSetAppInfo()) {
            return 30;
        }
        return VodSettings.getVodInt("buffer_timeout", 30);
    }

    public static int maxRetryTimeOut() {
        if (!InfoWrapper.isSetAppInfo()) {
            return 10;
        }
        return VodSettings.getVodInt("http_retry_timeout_when_fail", 10);
    }

    public static int getHardwareEnable() {
        if (!InfoWrapper.isSetAppInfo()) {
            return 0;
        }
        return VodSettings.getVodInt("hardware_decode_enable", 0);
    }

    public static int getH264HardwareEnable() {
        if (!InfoWrapper.isSetAppInfo()) {
            return 0;
        }
        return VodSettings.getVodInt("h264_hardware_enable", 1);
    }

    public static int geth265HardwareEnable() {
        if (!InfoWrapper.isSetAppInfo()) {
            return 0;
        }
        if (FeatureManager.hasPermission("bvc1")) {
            return VodSettings.getVodInt("h265_hardware_enable", 0);
        }
        return 0;
    }

    public static boolean isHDREnable() {
        return VodSettings.getVodInt("hdr_enable", 0) == 1;
    }

    public static boolean isSREnable() {
        return VodSettings.getVodInt("sr_enable", 0) == 1;
    }

    public static int geth266SoftwareEnable() {
        if (!InfoWrapper.isSetAppInfo()) {
            return 0;
        }
        return VodSettings.getVodInt("h266_software_enable", 0);
    }

    public static int geth265SoftwareEnable() {
        if (!InfoWrapper.isSetAppInfo()) {
            return 0;
        }
        return VodSettings.getVodInt("h265_software_enable", 1);
    }

    public static int geth265SoftwareCapabilityEnable() {
        if (!InfoWrapper.isSetAppInfo()) {
            return 0;
        }
        return VodSettings.getVodInt("h265_software_capability_enable", 0);
    }

    public static int getSmartUrlEnabled() {
        if (!InfoWrapper.isSetAppInfo()) {
            return 0;
        }
        return VodSettings.getVodInt("smart_strategy_enable", 1);
    }

    public static int getExpiredDegradeEnabled() {
        return VodSettings.getVodInt("expired_degrade_enable", 1);
    }

    public static int getApiRetryCount() {
        return VodSettings.getVodInt("api_retry_count", 1);
    }

    public static boolean isSetAppInfo() {
        return AppInfo.mAppID > 0 && AppInfo.mContext != null;
    }

    public static boolean isCommonSDKExist() {
        try {
            Class.forName("com.pandora.common.env.Env");
            return true;
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
            return false;
        }
    }

    public static void printSettings() {
        TTVideoEngineLog.d(TAG, "setting notify  host_select:" + InfoWrapper.getUseHostSelect() + ", byte_vod_host:" + InfoWrapper.getTopHostArray() + ", byte_vod_host_v2:" + InfoWrapper.getTopHostArrayV2() + ", buffer_timeout:" + InfoWrapper.getBufferTimeOut() + ", http_retry_timeout_when_fail:" + InfoWrapper.maxRetryTimeOut() + ", hardware_decode_enable:" + InfoWrapper.getHardwareEnable() + ", h264_hardware_enable:" + InfoWrapper.getH264HardwareEnable() + ", h265_hardware_enable:" + InfoWrapper.geth265HardwareEnable() + ", h265_software_enable:" + InfoWrapper.geth265SoftwareEnable() + ", h266_software_enable:" + InfoWrapper.geth266SoftwareEnable() + ", h265_software_capability_enable:" + InfoWrapper.geth265SoftwareCapabilityEnable() + ", " + "smart_strategy_enable" + ":" + InfoWrapper.getSmartUrlEnabled() + ", sr_enable:" + InfoWrapper.isSREnable() + ", hdr_enable:" + InfoWrapper.isHDREnable() + ", expired_degrade_enable:" + InfoWrapper.getExpiredDegradeEnabled());
    }
}

