/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import com.ss.ttvideoengine.log.IVideoEventUploader;
import com.ss.ttvideoengine.log.VideoEventListener;
import com.ss.ttvideoengine.utils.TTVideoEngineInternalLog;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import org.json.JSONArray;
import org.json.JSONObject;

public enum VideoEventManager {
    instance;

    public static final int LOGGER_VERSION_OLD = 1;
    public static final int LOGGER_VERSION_NEW = 2;
    private static final String TAG = "VideoEventManager";
    private VideoEventListener mListener = null;
    private JSONArray mJsonArray = new JSONArray();
    private JSONArray mJsonArrayV2 = new JSONArray();
    private IVideoEventUploader mUploader;
    private Context mContext;
    private int mLoggerVersion = 1;

    public void setUploader(IVideoEventUploader uploader) {
        this.mUploader = uploader;
    }

    public void setListener(VideoEventListener listener) {
        this.mListener = listener;
    }

    public void setLoggerVersion(int version) {
        TTVideoEngineLog.e(TAG, "setLoggerVersion: " + version);
        if (version == 1 || version == 2) {
            this.mLoggerVersion = version;
        }
    }

    public void setContext(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public int getLoggerVersion() {
        TTVideoEngineLog.e(TAG, "getLoggerVersion: " + this.mLoggerVersion);
        return this.mLoggerVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray popAllEvents() {
        JSONArray ret = this.mJsonArray;
        Class<VideoEventManager> clazz = VideoEventManager.class;
        synchronized (VideoEventManager.class) {
            this.mJsonArray = new JSONArray();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEvent(boolean isUpload, JSONObject jsonObject) {
        Class<VideoEventManager> clazz = VideoEventManager.class;
        synchronized (VideoEventManager.class) {
            if (jsonObject == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            TTVideoEngineLog.d(TAG, "addEvent  uploadLog = " + isUpload);
            this.showEvent(jsonObject);
            if (this.mUploader != null && isUpload) {
                this.mUploader.onUplaod("video_playq", jsonObject);
            } else if (this.mListener != null) {
                this.mJsonArray.put((Object)jsonObject);
                this.mListener.onEvent();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray popAllEventsV2() {
        JSONArray ret = this.mJsonArrayV2;
        Class<VideoEventManager> clazz = VideoEventManager.class;
        synchronized (VideoEventManager.class) {
            this.mJsonArrayV2 = new JSONArray();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventV2(boolean isUpload, JSONObject jsonObject, String monitor_name) {
        Class<VideoEventManager> clazz = VideoEventManager.class;
        synchronized (VideoEventManager.class) {
            if (jsonObject == null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            TTVideoEngineLog.d(TAG, "addEventV2  uploadLog = " + isUpload);
            this.showEvent(jsonObject);
            if (this.mUploader != null && isUpload) {
                this.mUploader.onUplaod("video_playq", jsonObject);
            } else {
                this.mJsonArrayV2.put((Object)jsonObject);
                if (this.mListener != null) {
                    this.mListener.onEventV2(monitor_name);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private void showEvent(JSONObject eventJSON) {
        if ((TTVideoEngineInternalLog.LogTurnOn >> 1 & 1) == 1) {
            String debugString = "";
            if (this.mContext != null) {
                debugString = Settings.Global.getString((ContentResolver)this.mContext.getContentResolver(), (String)"engine.debug");
            }
            if (debugString != null) {
                String[] keys = debugString.split(",", -1);
                for (int i = 0; i < keys.length; ++i) {
                    String key = keys[i];
                    if (eventJSON.opt(key) == null) continue;
                    TTVideoEngineLog.i(TAG, key + ":" + eventJSON.opt(key));
                }
            }
        }
    }
}

