/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.ss.ttvideoengine.log.LoggerUtils;
import com.ss.ttvideoengine.log.VideoEventBase;
import com.ss.ttvideoengine.log.VideoEventManager;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class VideoEventOneOpera {
    private static final String TAG = "VideoEventOneOpera";
    public static final String monitorName = "videoplayer_oneopera";
    public static final String OPERA_TYPE_SEEK = "seek";
    public static final String OPERA_TYPE_SWITCH = "switch";
    public static final String END_TYPE_SEEK = "seek";
    public static final String END_TYPE_SWITCH = "switch";
    public static final String END_TYPE_EXIT = "exit";
    public static final String END_TYPE_SPEED = "speed";
    public static final String END_TYPE_EPISODE = "episode";
    public static final String END_TYPE_WAIT = "wait";
    public static final String END_TYPE_TIMEOUT = "timeout";
    public static final String END_TYPE_ERROR = "error";
    public static final int OPERA_REPORT_SEEK = 1;
    public static final int OPERA_REPORT_SWITCH = 2;
    public VideoEventBase mEventBase;
    private HashMap mLastOperaTimeMap = null;
    public OperaContext mOperaContext;
    public long mLastBufferStartT = Integer.MIN_VALUE;
    public long mLastBufferEndT = Integer.MIN_VALUE;
    public int mAccuCostTime = 0;
    public ArrayList<String> mSeekList = new ArrayList();
    public int mReportLevel = 0;

    VideoEventOneOpera(VideoEventBase base) {
        this.mEventBase = base;
        this.mLastOperaTimeMap = new HashMap();
        this.mOperaContext = new OperaContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HashMap hashMap = this.mLastOperaTimeMap;
        synchronized (hashMap) {
            this.mLastOperaTimeMap = new HashMap();
        }
        this.mAccuCostTime = 0;
        this.mSeekList = new ArrayList();
    }

    public void movieShouldRetry() {
        this.mOperaContext.mRetryCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastSeekTime() {
        if (this.mOperaContext.mStartT > 0L) {
            return 0L;
        }
        HashMap hashMap = this.mLastOperaTimeMap;
        synchronized (hashMap) {
            if (this.mLastOperaTimeMap.containsKey("seek")) {
                return (Long)this.mLastOperaTimeMap.get("seek");
            }
            return -1L;
        }
    }

    public void beginSeek(int fromMS, int toMS, int index) {
        TTVideoEngineLog.d(TAG, "brian beginSeek from " + fromMS + " to " + toMS);
        this.mOperaContext.mStartT = System.currentTimeMillis();
        this.mOperaContext.mOperaType = "seek";
        this.mOperaContext.mStateBefore = Integer.toString(fromMS);
        this.mOperaContext.mStateAfter = Integer.toString(toMS);
        this.mOperaContext.mCostTime = 0L;
        this.mOperaContext.mIndex = index;
        if (this.mEventBase != null) {
            this.mOperaContext.mResolutionBefore = this.mEventBase.mCurrentResolution;
            this.mOperaContext.mConfigBitrateBefore = this.mEventBase.mCurrentConfigBitrate;
        }
    }

    public void endSeek(String reason, int isSeekInCached) {
        if (this.mOperaContext.mStartT <= 0L || this.mOperaContext.mOperaType.isEmpty()) {
            TTVideoEngineLog.d(TAG, "endSeek without beginSeek, return.");
            return;
        }
        TTVideoEngineLog.d(TAG, "endSeek, from " + this.mOperaContext.mStateBefore + " to " + this.mOperaContext.mStateAfter);
        this.mOperaContext.mEndT = System.currentTimeMillis();
        this.mOperaContext.mCostTime = this.mOperaContext.mEndT - this.mOperaContext.mStartT;
        if (this.mOperaContext.mCostTime > 0L) {
            this.mAccuCostTime = (int)((long)this.mAccuCostTime + this.mOperaContext.mCostTime);
        }
        this.mOperaContext.mEndType = reason;
        this.mOperaContext.mIsSeekInCached = isSeekInCached;
        if (this.mEventBase != null && this.mEventBase.mDataSource != null) {
            this.mOperaContext.mResolutionAfter = this.mEventBase.mCurrentResolution;
            this.mOperaContext.mConfigBitrateAfter = this.mEventBase.mCurrentConfigBitrate;
            Map<String, Long> info = this.mEventBase.mDataSource.bytesInfo();
            if (info != null) {
                this.mOperaContext.mVideoLenAfterMS = info.get("vlen");
                this.mOperaContext.mAudioLenAfterMS = info.get("alen");
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fr", this.mOperaContext.mStateBefore);
        map.put("to", this.mOperaContext.mStateAfter);
        map.put("t", this.mOperaContext.mEndT);
        map.put("c", this.mOperaContext.mCostTime);
        this.mSeekList.add(new JSONObject(map).toString());
        this.mEventBase.degradeModeChangeSession();
        this.sendOperaEvent(1);
        this.mOperaContext = new OperaContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOperaEvent(int reportType) {
        this.mEventBase.updateVideoInfo(null);
        HashMap hashMap = this.mLastOperaTimeMap;
        synchronized (hashMap) {
            long last_opera_time;
            if (this.mLastOperaTimeMap.containsKey(this.mOperaContext.mOperaType) && (last_opera_time = ((Long)this.mLastOperaTimeMap.get(this.mOperaContext.mOperaType)).longValue()) > 0L) {
                this.mOperaContext.mLastInterval = this.mOperaContext.mStartT - last_opera_time;
            }
            this.mLastOperaTimeMap.remove(this.mOperaContext.mOperaType);
            this.mLastOperaTimeMap.put(this.mOperaContext.mOperaType, this.mOperaContext.mEndT);
        }
        this.mLastBufferStartT = Integer.MIN_VALUE;
        this.mLastBufferEndT = Integer.MIN_VALUE;
        if ((this.mReportLevel & reportType) == 0) {
            return;
        }
        TTVideoEngineLog.i(TAG, "report async");
        EngineThreadPool.addExecuteTask(new AsyncGetLogDataRunnable(this.mEventBase.mContext, this, this.mEventBase, this.mOperaContext));
    }

    private JSONObject toJsonObject(OperaContext operaContext, VideoEventBase eventBase) {
        HashMap map = new HashMap();
        if (eventBase != null) {
            LoggerUtils.putToMap(map, "player_sessionid", eventBase.mSessionID);
            if (eventBase.mCurURL == null || eventBase.mCurURL.isEmpty()) {
                LoggerUtils.putToMap(map, "cdn_url", eventBase.mInitialURL);
            } else {
                LoggerUtils.putToMap(map, "cdn_url", eventBase.mCurURL);
            }
            if (eventBase.mCurIP == null || eventBase.mCurIP.isEmpty()) {
                LoggerUtils.putToMap(map, "cdn_ip", eventBase.mInitialIP);
            } else {
                LoggerUtils.putToMap(map, "cdn_ip", eventBase.mCurIP);
            }
            LoggerUtils.putToMap(map, "source_type", eventBase.mSourceTypeStr);
            LoggerUtils.putToMap(map, "v", eventBase.mVid);
            LoggerUtils.putToMap(map, "pv", eventBase.pv);
            LoggerUtils.putToMap(map, "pc", eventBase.pc);
            LoggerUtils.putToMap(map, "sv", eventBase.sv);
            LoggerUtils.putToMap(map, "sdk_version", eventBase.sdk_version);
            LoggerUtils.putToMap(map, "vtype", eventBase.vtype);
            LoggerUtils.putToMap(map, "tag", eventBase.mTag);
            LoggerUtils.putToMap(map, "subtag", eventBase.mSubTag);
            LoggerUtils.putToMap(map, "p2p_cdn_type", eventBase.mP2PCDNType);
            LoggerUtils.putToMap(map, "codec", eventBase.codec_type);
            LoggerUtils.putToMap(map, "video_codec_nameid", eventBase.videoCodecNameId);
            LoggerUtils.putToMap(map, "audio_codec_nameid", eventBase.audioCodecNameId);
            LoggerUtils.putToMap(map, "format_type", eventBase.formatType);
            LoggerUtils.putToMap(map, "drm_type", eventBase.mDrmType);
            LoggerUtils.putToMap(map, "mdl_speed", eventBase.mdlVideoInfo.mdl_speed);
            LoggerUtils.putToMap(map, "net_type", eventBase.mNetworkType);
            LoggerUtils.putToMap(map, "reuse_socket", eventBase.mReuseSocket);
            LoggerUtils.putToMap(map, "mdl_version", eventBase.mMdlVersion);
            LoggerUtils.putToMap(map, "enable_mdl", eventBase.mEnableMDL);
            LoggerUtils.putToMap(map, "mdl_req_t", eventBase.mdlVideoInfo.mdl_req_t);
            LoggerUtils.putToMap(map, "mdl_end_t", eventBase.mdlVideoInfo.mdl_end_t);
            LoggerUtils.putToMap(map, "mdl_dns_t", eventBase.mdlVideoInfo.mdl_dns_t);
            LoggerUtils.putToMap(map, "mdl_tcp_start_t", eventBase.mdlVideoInfo.mdl_tcp_start_t);
            LoggerUtils.putToMap(map, "mdl_tcp_end_t", eventBase.mdlVideoInfo.mdl_tcp_end_t);
            LoggerUtils.putToMap(map, "mdl_ttfp", eventBase.mdlVideoInfo.mdl_ttfp);
            LoggerUtils.putToMap(map, "mdl_httpfb", eventBase.mdlVideoInfo.mdl_httpfb);
            LoggerUtils.putToMap(map, "mdl_cur_ip", eventBase.mdlVideoInfo.mdl_cur_ip);
            LoggerUtils.putToMap(map, "mdl_cur_req_pos", eventBase.mdlVideoInfo.mdl_cur_req_pos);
            LoggerUtils.putToMap(map, "mdl_cur_end_pos", eventBase.mdlVideoInfo.mdl_cur_end_pos);
            LoggerUtils.putToMap(map, "mdl_cur_cache_pos", eventBase.mdlVideoInfo.mdl_cur_cache_pos);
            LoggerUtils.putToMap(map, "mdl_cache_type", eventBase.mdlVideoInfo.mdl_cache_type);
            LoggerUtils.putToMap(map, "mdl_reply_size", eventBase.mdlVideoInfo.mdl_reply_size);
            LoggerUtils.putToMap(map, "mdl_down_pos", eventBase.mdlVideoInfo.mdl_down_pos);
            LoggerUtils.putToMap(map, "mdl_error_code", eventBase.mdlVideoInfo.mdl_error_code);
            LoggerUtils.putToMap(map, "mdl_http_code", eventBase.mdlVideoInfo.mdl_http_code);
            LoggerUtils.putToMap(map, "mdl_ip_list", eventBase.mdlVideoInfo.mdl_ip_list);
            LoggerUtils.putToMap(map, "mdl_blocked_ips", eventBase.mdlVideoInfo.mdl_blocked_ips);
            LoggerUtils.putToMap(map, "a_mdl_req_t", eventBase.mdlAudioInfo.mdl_req_t);
            LoggerUtils.putToMap(map, "a_mdl_end_t", eventBase.mdlAudioInfo.mdl_end_t);
            LoggerUtils.putToMap(map, "a_mdl_dns_t", eventBase.mdlAudioInfo.mdl_dns_t);
            LoggerUtils.putToMap(map, "a_mdl_tcp_start_t", eventBase.mdlAudioInfo.mdl_tcp_start_t);
            LoggerUtils.putToMap(map, "a_mdl_tcp_end_t", eventBase.mdlAudioInfo.mdl_tcp_end_t);
            LoggerUtils.putToMap(map, "a_mdl_ttfp", eventBase.mdlAudioInfo.mdl_ttfp);
            LoggerUtils.putToMap(map, "a_mdl_httpfb", eventBase.mdlAudioInfo.mdl_httpfb);
            LoggerUtils.putToMap(map, "a_mdl_cur_ip", eventBase.mdlAudioInfo.mdl_cur_ip);
            LoggerUtils.putToMap(map, "a_mdl_cur_req_pos", eventBase.mdlAudioInfo.mdl_cur_req_pos);
            LoggerUtils.putToMap(map, "a_mdl_cur_end_pos", eventBase.mdlAudioInfo.mdl_cur_end_pos);
            LoggerUtils.putToMap(map, "a_mdl_cur_cache_pos", eventBase.mdlAudioInfo.mdl_cur_cache_pos);
            LoggerUtils.putToMap(map, "a_mdl_cache_type", eventBase.mdlAudioInfo.mdl_cache_type);
            LoggerUtils.putToMap(map, "a_mdl_reply_size", eventBase.mdlAudioInfo.mdl_reply_size);
            LoggerUtils.putToMap(map, "a_mdl_down_pos", eventBase.mdlAudioInfo.mdl_down_pos);
            LoggerUtils.putToMap(map, "a_mdl_error_code", eventBase.mdlAudioInfo.mdl_error_code);
            LoggerUtils.putToMap(map, "a_mdl_http_code", eventBase.mdlAudioInfo.mdl_http_code);
            LoggerUtils.putToMap(map, "a_mdl_ip_list", eventBase.mdlAudioInfo.mdl_ip_list);
            LoggerUtils.putToMap(map, "a_mdl_blocked_ips", eventBase.mdlAudioInfo.mdl_blocked_ips);
        }
        LoggerUtils.putToMap(map, "opera_type", operaContext.mOperaType);
        LoggerUtils.putToMap(map, "state_before", operaContext.mStateBefore);
        LoggerUtils.putToMap(map, "state_after", operaContext.mStateAfter);
        LoggerUtils.putToMap(map, "cost_time", operaContext.mCostTime);
        LoggerUtils.putToMap(map, "end_type", operaContext.mEndType);
        LoggerUtils.putToMap(map, "index", operaContext.mIndex);
        LoggerUtils.putToMap(map, "last_interval", operaContext.mLastInterval);
        LoggerUtils.putToMap(map, "retry_count", operaContext.mRetryCount);
        LoggerUtils.putToMap(map, "is_seek_in_buffer", operaContext.mIsSeekInCached);
        LoggerUtils.putToMap(map, "video_len_after", operaContext.mVideoLenAfterMS);
        LoggerUtils.putToMap(map, "audio_len_after", operaContext.mAudioLenAfterMS);
        LoggerUtils.putToMap(map, "st", operaContext.mStartT);
        LoggerUtils.putToMap(map, "et", operaContext.mEndT);
        LoggerUtils.putToMap(map, "resolution_before", operaContext.mResolutionBefore);
        LoggerUtils.putToMap(map, "resolution_after", operaContext.mResolutionAfter);
        LoggerUtils.putToMap(map, "bitrate_before", operaContext.mConfigBitrateBefore);
        LoggerUtils.putToMap(map, "bitrate_after", operaContext.mConfigBitrateAfter);
        LoggerUtils.putToMap(map, "last_buf_start_t", this.mLastBufferStartT);
        LoggerUtils.putToMap(map, "last_buf_end_t", this.mLastBufferEndT);
        return new JSONObject(map);
    }

    private static class AsyncGetLogDataRunnable
    implements Runnable {
        private VideoEventOneOpera rEvent;
        private Handler rHandler;
        private VideoEventBase rEventBase;
        private Context rContext;
        private OperaContext rOperaContext;

        public AsyncGetLogDataRunnable(Context context, VideoEventOneOpera event, VideoEventBase base, OperaContext operaContext) {
            this.rEvent = event;
            this.rEventBase = base;
            this.rContext = context;
            this.rOperaContext = operaContext;
            this.rHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        public void run() {
            if (this.rEvent == null) {
                return;
            }
            if (this.rEventBase != null) {
                this.rEventBase.updateMDLInfo();
                this.rEventBase.mNetworkType = VideoEventBase.getNetType();
            }
            final boolean isUpload = this.rEventBase != null && this.rEventBase.isUploadLogEnabled;
            final JSONObject jsonEvent = this.rEvent.toJsonObject(this.rOperaContext, this.rEventBase);
            if (this.rHandler == null) {
                VideoEventManager.instance.addEventV2(isUpload, jsonEvent, VideoEventOneOpera.monitorName);
                return;
            }
            this.rHandler.post(new Runnable(){

                @Override
                public void run() {
                    VideoEventManager.instance.addEventV2(isUpload, jsonEvent, VideoEventOneOpera.monitorName);
                }
            });
        }
    }

    private class OperaContext {
        public String mOperaType = "";
        public String mStateBefore = "";
        public String mStateAfter = "";
        public long mCostTime = Integer.MIN_VALUE;
        public String mEndType = "";
        private long mStartT = Integer.MIN_VALUE;
        public long mEndT = Integer.MIN_VALUE;
        private int mRetryCount = 0;
        private int mIsSeekInCached = 0;
        public long mVideoLenAfterMS = 0L;
        public long mAudioLenAfterMS = 0L;
        private int mIndex = 0;
        public String mResolutionBefore = "";
        public String mResolutionAfter = "";
        public int mConfigBitrateBefore = Integer.MIN_VALUE;
        public int mConfigBitrateAfter = Integer.MIN_VALUE;
        public long mLastInterval = -1L;

        private OperaContext() {
        }
    }
}

