/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.os.Bundle;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class VideoFilterMonitor {
    private static final String TAG = "VideoFilterMonitor";
    private boolean mIsFilterOn;
    private final ArrayList<String> mHistoryList = new ArrayList();

    public void setEffect(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        if (bundle.getInt("effect_type") != 2) {
            TTVideoEngineLog.d(TAG, "not eye protection filter bundle");
            return;
        }
        boolean on = this.isEyeProtectionModeOn(bundle);
        if (on != this.mIsFilterOn) {
            this.mIsFilterOn = on;
            this.updateHistory(on);
        }
    }

    private void updateHistory(boolean on) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("on", on ? "1" : "0");
        map.put("t", System.currentTimeMillis());
        this.mHistoryList.add(new JSONObject(map).toString());
    }

    private boolean isEyeProtectionModeOn(Bundle bundle) {
        int action = -1;
        action = bundle.getInt("action");
        int type = bundle.getInt("effect_type");
        if (type != 2) {
            return false;
        }
        if (action == 21) {
            return bundle.getInt("use_effect") == 1;
        }
        if (action == 19) {
            return bundle.getInt("int_value") == 1;
        }
        return false;
    }

    public ArrayList<String> getList() {
        return this.mHistoryList;
    }
}

