/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.source.strategy;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.DirectUrlItem;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.source.DirectUrlSource;
import com.ss.ttvideoengine.source.Source;
import com.ss.ttvideoengine.source.VidPlayAuthTokenSource;
import com.ss.ttvideoengine.source.strategy.CodecStrategy;
import com.ss.ttvideoengine.source.strategy.SmartUrlFetcher;
import com.ss.ttvideoengine.strategy.source.StrategySource;
import com.ss.ttvideoengine.utils.EngineException;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CodecStrategyAdapter {
    public final String TAG;
    private StrategySource mSource;
    private CodecStrategy.ResolveResult mResolveResult;
    private final List<CodecStrategy.Dimension> mErrorDimensions = new ArrayList<CodecStrategy.Dimension>();
    private SmartUrlFetcher mSmartUrlFetcher;
    private final SourceSetter mSourceSetter;

    static String createTag(int type) {
        if (type == 0) {
            return "TTVideoEngine_CodecStrategy";
        }
        return "DataLoaderHelper_CodecStrategy";
    }

    public CodecStrategyAdapter(SourceSetter sourceSetter) {
        this.mSourceSetter = sourceSetter;
        this.TAG = CodecStrategyAdapter.createTag(sourceSetter.type());
    }

    public CodecStrategyAdapter(TTVideoEngine engine) {
        this(new PlayerSourceSetter(engine));
    }

    public void reset() {
        if (TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(this.TAG, "reset");
        }
        this.cancelFetchSmartUrlInfo();
        this.mSource = null;
        this.mResolveResult = null;
    }

    public void release() {
        this.reset();
        this.mErrorDimensions.clear();
    }

    public boolean isCodecStrategyValid() {
        if (this.mSource == null) {
            return false;
        }
        return this.mSource.isCodecStrategyValid();
    }

    public boolean isFetchSmartUrl() {
        DirectUrlSource source;
        if (this.mSource == null) {
            return false;
        }
        if (this.mSource.type() == Source.Type.DIRECT_URL_SOURCE && CodecStrategy.SmartUrlVod.isEnable(source = (DirectUrlSource)this.mSource)) {
            return this.mResolveResult != null && this.mResolveResult.requestItem != null;
        }
        return false;
    }

    public void setStrategySource(StrategySource source) throws EngineException {
        this.reset();
        if (source == null) {
            throw new EngineException(new Error("kTTVideoErrorDomainSetStrategySource", -9965));
        }
        if (TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(this.TAG, "setStrategySource " + source);
            TTVideoEngineLog.d(this.TAG, "setStrategySource " + CodecStrategy.dump());
        }
        this.mSource = source;
        if (source.isCodecStrategyValid()) {
            CodecStrategy.ResolveResult result = CodecStrategy.resolveStartPlayback(source, true);
            if (result != null) {
                this.setupSource(this.mSourceSetter, result);
            } else {
                this.setupSource(this.mSourceSetter, source);
            }
        } else {
            this.setupSource(this.mSourceSetter, source);
        }
    }

    public StrategySource getStrategySource() {
        return this.mSource;
    }

    public void fetchSmartUrlInfo(SmartUrlFetcher.Callback callback) {
        if (this.mSmartUrlFetcher != null) {
            this.mSmartUrlFetcher.cancel();
            this.mSmartUrlFetcher = null;
        }
        if (this.mSource == null) {
            return;
        }
        if (this.mResolveResult == null) {
            return;
        }
        DirectUrlSource.UrlItem requestItem = this.mResolveResult.requestItem;
        if (requestItem == null) {
            return;
        }
        if (TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(this.TAG, "fetchSmartUrlInfo " + this.mSource.vid() + " " + this.mResolveResult.requestItem);
        }
        this.mSmartUrlFetcher = new SmartUrlFetcher(callback);
        SmartUrlFetcher.RequestParams requestParams = new SmartUrlFetcher.RequestParams();
        requestParams.videoId = this.mSource.vid();
        requestParams.playUrl = requestItem.getUrl();
        requestParams.cacheKey = requestItem.getCacheKey();
        requestParams.codec = CodecStrategy.SmartUrlVod.encodeType();
        requestParams.definition = CodecStrategy.SmartUrlVod.videoResolution().toString(VideoRef.TYPE_VIDEO);
        this.mSmartUrlFetcher.setRequestParams(requestParams);
        this.mSmartUrlFetcher.start();
    }

    public void cancelFetchSmartUrlInfo() {
        if (this.mSmartUrlFetcher == null) {
            return;
        }
        if (this.mResolveResult != null && this.mSource != null && TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(this.TAG, "cancelFetchSmartUrlInfo " + this.mSource.vid() + " " + this.mResolveResult.requestItem);
        }
        this.mSmartUrlFetcher.cancel();
        this.mSmartUrlFetcher = null;
    }

    public void correctStrategy(IVideoModel model) {
        if (model == null) {
            return;
        }
        if (this.mSourceSetter == null || this.mSourceSetter.type() != 0) {
            return;
        }
        PlayerSourceSetter player = (PlayerSourceSetter)this.mSourceSetter;
        CodecStrategy.ResolveResult result = this.mResolveResult;
        if (result == null) {
            return;
        }
        StrategySource source = this.mSource;
        if (source == null) {
            return;
        }
        if (!source.isCodecStrategyValid()) {
            return;
        }
        String realEncodeType = CodecStrategyAdapter.resolveVideoModelEncoderType(model);
        if (realEncodeType == null) {
            return;
        }
        CodecStrategy.Dimension dimension = result.dimension;
        if (TextUtils.equals((CharSequence)dimension.encodeType, (CharSequence)realEncodeType)) {
            if (TTVideoEngineLog.d()) {
                TTVideoEngineLog.d(this.TAG, "correctStrategy result is [right] " + (Object)((Object)dimension));
            }
            return;
        }
        if (TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(this.TAG, "correctStrategy result is [wrong] " + realEncodeType + " " + (Object)((Object)dimension));
        }
        for (CodecStrategy.Dimension d : CodecStrategy.Dimension.values()) {
            if (!TextUtils.equals((CharSequence)d.encodeType, (CharSequence)dimension.encodeType)) continue;
            this.mErrorDimensions.add(dimension);
        }
        CodecStrategy.Dimension realDimension = CodecStrategy.resolveWithEncoderType(realEncodeType, source, this.mErrorDimensions);
        if (TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(this.TAG, "correctStrategy corrected dimension = " + (Object)((Object)realDimension) + "; old = " + (Object)((Object)dimension));
        }
        if (realDimension == null) {
            return;
        }
        this.correctDimension(player, realDimension);
    }

    private static String resolveVideoModelEncoderType(IVideoModel videoModel) {
        if (videoModel == null) {
            return null;
        }
        String[] codecArr = videoModel.getCodecs();
        if (codecArr == null) {
            return null;
        }
        List<String> codecs = Arrays.asList(codecArr);
        String encoder = codecs.contains("h266") ? "h266" : (codecs.contains("h265") ? "h265" : "h264");
        return encoder;
    }

    public boolean interceptFallbackRetry(Error error) {
        CodecStrategy.ResolveResult fallbackResult;
        if (this.mSourceSetter == null) {
            return false;
        }
        if (this.mSourceSetter.type() != 0) {
            return false;
        }
        PlayerSourceSetter player = (PlayerSourceSetter)this.mSourceSetter;
        StrategySource source = this.mSource;
        if (source == null) {
            return false;
        }
        if (!source.isCodecStrategyValid()) {
            return false;
        }
        CodecStrategy.ResolveResult currentResult = this.mResolveResult;
        if (currentResult == null) {
            return false;
        }
        if (!this.mErrorDimensions.contains((Object)currentResult.dimension)) {
            this.mErrorDimensions.add(currentResult.dimension);
        }
        if ((fallbackResult = CodecStrategy.resolveFallback(source, this.mErrorDimensions)) == null) {
            if (TTVideoEngineLog.e()) {
                TTVideoEngineLog.e(this.TAG, "resolveFallback return null! " + source + " " + this.mErrorDimensions + " " + CodecStrategy.dump());
            }
            return false;
        }
        if (TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(this.TAG, "resolveFallback " + fallbackResult + " " + CodecStrategy.dump());
        }
        this.setupSource((SourceSetter)player, fallbackResult);
        player.play();
        return true;
    }

    public boolean fallbackToDirectUrl() {
        SourceSetter sourceSetter = this.mSourceSetter;
        if (sourceSetter == null) {
            return false;
        }
        DirectUrlSource source = null;
        if (this.mSource != null && this.mSource.type() == Source.Type.DIRECT_URL_SOURCE) {
            source = (DirectUrlSource)this.mSource;
        }
        if (source == null) {
            return false;
        }
        CodecStrategy.ResolveResult result = CodecStrategy.resolveStartPlayback(source, false);
        if (TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(this.TAG, "fallbackToDirectUrl " + source + " " + result);
        }
        if (result == null) {
            this.setupSource(sourceSetter, source);
        } else {
            this.setupSource(sourceSetter, result);
        }
        if (sourceSetter.type() == 0) {
            PlayerSourceSetter player = (PlayerSourceSetter)sourceSetter;
            player.play();
        }
        return true;
    }

    private void correctDimension(PlayerSourceSetter player, CodecStrategy.Dimension dimension) {
        if (dimension == null) {
            return;
        }
        if (this.mResolveResult != null) {
            this.mResolveResult.correctedDimension = dimension;
        }
        player.configPlayerWithDimension(dimension);
    }

    private void setupSource(SourceSetter sourceSetter, CodecStrategy.ResolveResult result) {
        this.mResolveResult = result;
        StrategySource source = result.source;
        CodecStrategy.Dimension dimension = result.correctedDimension != null ? result.correctedDimension : result.dimension;
        Source.Type sourceType = source.type();
        switch (sourceType) {
            case DIRECT_URL_SOURCE: {
                DirectUrlSource.UrlItem urlItem = result.urlItem;
                DirectUrlSource.UrlItem requestItem = result.requestItem;
                if (urlItem != null) {
                    sourceSetter.setDirectUrl(source.vid(), urlItem, dimension, false);
                    break;
                }
                if (requestItem != null) {
                    sourceSetter.setDirectUrl(source.vid(), requestItem, dimension, true);
                    break;
                }
                if (TTVideoEngineLog.d()) {
                    TTVideoEngineLog.d(this.TAG, "setupSource CodecStrategy error:" + result);
                }
                return;
            }
            case VID_PLAY_AUTH_TOKEN_SOURCE: {
                VidPlayAuthTokenSource vidSource = (VidPlayAuthTokenSource)source;
                sourceSetter.setVideoID(vidSource.vid(), vidSource.playAuthToken(), vidSource.resolution(), null, dimension);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported source type! " + (Object)((Object)sourceType));
            }
        }
    }

    private void setupSource(SourceSetter sourceSetter, StrategySource source) {
        this.mResolveResult = null;
        Source.Type type = source.type();
        switch (type) {
            case DIRECT_URL_SOURCE: {
                DirectUrlSource directUrlSource = (DirectUrlSource)source;
                DirectUrlSource.UrlItem urlItem = directUrlSource.firstItem();
                sourceSetter.setDirectUrl(source.vid(), urlItem, null, false);
                break;
            }
            case VID_PLAY_AUTH_TOKEN_SOURCE: {
                VidPlayAuthTokenSource vidSource = (VidPlayAuthTokenSource)source;
                sourceSetter.setVideoID(source.vid(), vidSource.playAuthToken(), vidSource.resolution(), vidSource.encodeType(), null);
                break;
            }
        }
    }

    public static interface PreloadSourceSetter
    extends SourceSetter {
        public static final String TAG = CodecStrategyAdapter.createTag(1);

        @Override
        default public void setVideoID(String vid, String playAuthToken, @Nullable Resolution resolution, @Nullable String encodeType, @Nullable CodecStrategy.Dimension dimension) {
            TTVideoEngineLog.d(TAG, "setVideoID vid = " + vid + ", playAuthToken = " + playAuthToken + ", encodeType = " + encodeType + ", dimension = " + (Object)((Object)dimension));
        }

        @Override
        default public void setDirectUrl(String vid, DirectUrlSource.UrlItem urlItem, @Nullable CodecStrategy.Dimension dimension, boolean isFetchSmartUrl) {
            TTVideoEngineLog.d(TAG, "setDirectUrl vid = " + vid + ", urlItem = " + urlItem + ", dimension = " + (Object)((Object)dimension) + ", isFetchSmartUrl = " + isFetchSmartUrl);
        }

        @Override
        default public int type() {
            return 1;
        }
    }

    private static class PlayerSourceSetter
    implements SourceSetter {
        public static final String TAG = CodecStrategyAdapter.createTag(0);
        TTVideoEngine mEngine;

        public PlayerSourceSetter(TTVideoEngine engine) {
            this.mEngine = engine;
        }

        @Override
        public void setDirectUrl(String vid, DirectUrlSource.UrlItem urlItem, @Nullable CodecStrategy.Dimension dimension, boolean isFetchSmartUrl) {
            TTVideoEngineLog.d(TAG, "setDirectUrl vid = " + vid + ", urlItem = " + urlItem + ", dimension = " + (Object)((Object)dimension) + ", isFetchSmartUrl = " + isFetchSmartUrl);
            if (!isFetchSmartUrl) {
                if (urlItem.getUrlExpiredTime() > 0L) {
                    this.mEngine.setDirectUrlUseDataLoader(new DirectUrlItem(urlItem.getUrls(), urlItem.getCacheKey(), vid, urlItem.getUrlExpiredTime()));
                } else {
                    this.mEngine.setDirectUrlUseDataLoader(urlItem.getUrls(), urlItem.getCacheKey(), vid);
                }
                if (urlItem.getPlayAuth() != null) {
                    this.mEngine.setEncodedKey(urlItem.getPlayAuth());
                }
            }
            if (dimension != null) {
                this.configPlayerWithDimension(dimension);
                this.mEngine.setIntOption(670, 0);
            } else {
                this.mEngine.setIntOption(670, 1);
            }
        }

        @Override
        public void setVideoID(String vid, String playAuthToken, @Nullable Resolution resolution, @Nullable String encodeType, @Nullable CodecStrategy.Dimension dimension) {
            TTVideoEngineLog.d(TAG, "setVideoID vid = " + vid + ", playAuthToken = " + playAuthToken + ", dimension = " + (Object)((Object)dimension));
            this.mEngine.setVideoID(vid);
            this.mEngine.setPlayAuthToken(playAuthToken);
            if (dimension != null) {
                this.configPlayerWithDimension(dimension);
                this.mEngine.setIntOption(670, 0);
            } else if (encodeType != null) {
                this.mEngine.setStringOption(1000, encodeType);
                this.mEngine.setIntOption(670, 1);
            }
            if (resolution != null) {
                this.mEngine.configResolution(resolution);
            }
        }

        private void configPlayerWithDimension(CodecStrategy.Dimension dimension) {
            if (dimension == null) {
                return;
            }
            this.mEngine.setStringOption(1000, dimension.encodeType);
            if (dimension.decoder == 1) {
                this.mEngine.setIntOption(7, 1);
                if (TextUtils.equals((CharSequence)dimension.encodeType, (CharSequence)"h265")) {
                    this.mEngine.setAsyncInit(true, 1);
                } else if (TextUtils.equals((CharSequence)dimension.encodeType, (CharSequence)"h264")) {
                    this.mEngine.setAsyncInit(true, 0);
                }
            } else {
                this.mEngine.setIntOption(7, 0);
            }
        }

        public void play() {
            this.mEngine.play();
        }

        public void stop() {
            this.mEngine.stop();
        }

        public void setEncodedKey(String playAuth) {
            this.mEngine.setEncodedKey(playAuth);
        }

        public void setStringOption(int key, String value) {
            this.mEngine.setStringOption(key, value);
        }

        @Override
        public int type() {
            return 0;
        }
    }

    public static interface SourceSetter {
        public static final int TYPE_PLAYER = 0;
        public static final int TYPE_PRELOAD = 1;

        default public void setDirectUrl(String vid, DirectUrlSource.UrlItem urlItem, @Nullable CodecStrategy.Dimension dimension, boolean isFetchSmartUrl) {
        }

        default public void setVideoID(String vid, String playAuthToken, @Nullable Resolution resolution, @Nullable String encodeType, @Nullable CodecStrategy.Dimension dimension) {
        }

        default public int type() {
            return -1;
        }
    }
}

