/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import com.ss.ttvideoengine.utils.TTVideoEngineInternalLog;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class EngineThreadPool {
    private static final String TAG = "EngineThreadPool";
    private static final int THREADPOOL_CORE_POOL_SIZE = 0;
    private static final int THREADPOOL_MAX_POOL_SIZE = Integer.MAX_VALUE;
    private static final int THREADPOOL_ALIVE_TIME_SEC = 60;
    private static final int THREADPOOL_MAX_RUNNING_TASK_SIZE = 5;
    private static volatile ThreadPoolExecutor mExecutorInstance;
    private static Deque<AsyncRunnable> mReadyRunnables;
    private static Deque<AsyncRunnable> mRunningRunnables;
    private static volatile boolean mEnableThreadPoolOptimize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExecutorInstance(ThreadPoolExecutor executor) {
        Class<EngineThreadPool> clazz = EngineThreadPool.class;
        synchronized (EngineThreadPool.class) {
            mExecutorInstance = executor;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolExecutor getExecutorInstance() {
        if (mExecutorInstance != null) return mExecutorInstance;
        Class<EngineThreadPool> clazz = EngineThreadPool.class;
        synchronized (EngineThreadPool.class) {
            if (mExecutorInstance != null) return mExecutorInstance;
            if (mEnableThreadPoolOptimize) {
                TTVideoEngineInternalLog.i(TAG, "mEnableThreadPoolOptimize true");
                mExecutorInstance = new ThreadPoolExecutor(5, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
                mExecutorInstance.allowCoreThreadTimeOut(true);
            } else {
                mExecutorInstance = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mExecutorInstance;
        }
    }

    public static synchronized Future addExecuteTask(Runnable runnable) {
        if (runnable == null) {
            return null;
        }
        if (mExecutorInstance == null) {
            EngineThreadPool.getExecutorInstance();
        }
        try {
            TTVideoEngineInternalLog.i(TAG, "addExecuteTask,pool size:" + EngineThreadPool.getPoolSize() + ", active:" + mExecutorInstance.getActiveCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mEnableThreadPoolOptimize) {
            return mExecutorInstance.submit(runnable);
        }
        TTVideoEngineInternalLog.i(TAG, "running:" + mRunningRunnables.size() + ", ready:" + mReadyRunnables.size());
        AsyncRunnable asyncRunnable = new AsyncRunnable(runnable);
        if (mRunningRunnables.size() >= 5) {
            mReadyRunnables.add(asyncRunnable);
            return null;
        }
        mRunningRunnables.add(asyncRunnable);
        return mExecutorInstance.submit(asyncRunnable);
    }

    public static synchronized Future addExecuteTaskSync(Runnable runnable, long timeout) {
        TTVideoEngineInternalLog.i(TAG, "addExecuteTaskSync timeout:" + timeout);
        Future taskFuture = EngineThreadPool.addExecuteTask(runnable);
        if (taskFuture != null) {
            try {
                taskFuture.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                TTVideoEngineInternalLog.e(TAG, "set surface time out");
                return taskFuture;
            }
        }
        return taskFuture;
    }

    public static int getPoolSize() {
        if (mExecutorInstance == null) {
            EngineThreadPool.getExecutorInstance();
        }
        return mExecutorInstance.getPoolSize();
    }

    public static void shutdown() {
        if (mExecutorInstance != null) {
            mExecutorInstance.shutdown();
        }
    }

    public static synchronized void setOptimizeEnabled(boolean enabled) {
        mEnableThreadPoolOptimize = enabled;
    }

    private static synchronized void _finished(AsyncRunnable runnable) {
        mRunningRunnables.remove(runnable);
        EngineThreadPool._promoteRunnable();
    }

    private static void _promoteRunnable() {
        Iterator<AsyncRunnable> i;
        if (mReadyRunnables.size() > 0 && (i = mReadyRunnables.iterator()).hasNext()) {
            AsyncRunnable runnable = i.next();
            i.remove();
            mRunningRunnables.add(runnable);
            mExecutorInstance.execute(runnable);
        }
    }

    static {
        mReadyRunnables = new ArrayDeque<AsyncRunnable>();
        mRunningRunnables = new ArrayDeque<AsyncRunnable>();
        mEnableThreadPoolOptimize = true;
    }

    public static class AsyncRunnable
    implements Runnable {
        private Runnable mRunnable;

        public AsyncRunnable(Runnable runnable) {
            this.mRunnable = runnable;
        }

        @Override
        public void run() {
            this.mRunnable.run();
            EngineThreadPool._finished(this);
        }
    }
}

