/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.networkpredictor;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictor;
import com.bytedance.vcloud.networkpredictor.ISpeedRecordOld;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorConfig;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorJniLoader;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorLog;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorNotifyInfo;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorRecord;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorResult;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorResultCollection;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultSpeedPredictor
implements ISpeedPredictor,
Handler.Callback {
    private long mHandle = 0L;
    private Thread subThread;
    private Handler mSpeedUpdateHander;
    public static final int SPEEDPREDICTOR_ALOG_HECNET = 0;
    public static final int SPEEDPREDICTOR_ALOG_HANET = 1;
    public static final int SPEEDPREDICTOR_ALOG_ANET = 2;
    public static final int SPEEDPREDICTOR_ALOG_LSTMNET = 3;
    public static final int SPEEDPREDICTOR_ALOG_KFNET = 4;
    public static final int SPEEDPREDICTOR_ALOG_ANETIES = 6;
    private static final int SPEEDPREDICTOR_LOG_LEVEL_KEY = 0;
    public static final int KeyIsUpdateSpeedRecord = 0;
    private static final String TAG = "SpeedPredictor";
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
    final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public DefaultSpeedPredictor(int type) {
        SpeedPredictorJniLoader.loadLibrary();
        if (!SpeedPredictorJniLoader.isLibraryLoaded) {
            SpeedPredictorLog.e(TAG, "[SpeedPredictor] no predictor native loaded");
            return;
        }
        this.mHandle = this._create(type);
        SpeedPredictorConfig.setLoglevel(0);
        this._setIntValue(this.mHandle, 0, SpeedPredictorConfig.getLogLevel());
    }

    @Override
    public String getVersion() {
        if (this.mHandle == 0L) {
            return "j_1.7.0";
        }
        return this._getVersion();
    }

    @Override
    public void setConfigInfo(Map featureList) {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return;
        }
        this._setConfigSpeedInfo(this.mHandle, featureList);
        this.readLock.unlock();
    }

    @Override
    public void setSpeedQueueSize(int size) {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return;
        }
        this._setSpeedQueueSize(this.mHandle, size);
        this.readLock.unlock();
    }

    @Override
    public void prepare() {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return;
        }
        this._prepare(this.mHandle);
        this.readLock.unlock();
    }

    @Override
    public void start() {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return;
        }
        this._start(this.mHandle);
        this.readLock.unlock();
    }

    @Override
    public void close() {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return;
        }
        this._close(this.mHandle);
        this.readLock.unlock();
    }

    @Override
    public float getPredictSpeed() {
        return this.getPredictSpeed(0);
    }

    @Override
    public float getPredictSpeed(int mediaType) {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return -1.0f;
        }
        float result = this._getPredictSpeed(this.mHandle, mediaType);
        this.readLock.unlock();
        return result;
    }

    @Override
    public float getLastPredictConfidence() {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return -1.0f;
        }
        float result = this._getLastPredictConfidence(this.mHandle);
        this.readLock.unlock();
        return result;
    }

    @Override
    public Map<String, String> getDownloadSpeed(int mediaType) {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return null;
        }
        Map<String, String> result = this._getDownloadSpeed(this.mHandle, mediaType);
        this.readLock.unlock();
        return result;
    }

    @Override
    public void update(String recordStr, Map<String, Integer> streamIdMediaTypeMap) {
        this.readLock.lock();
        if (this.mHandle == 0L || recordStr == null || recordStr.length() < 0 || streamIdMediaTypeMap == null || streamIdMediaTypeMap.size() < 0) {
            this.readLock.unlock();
            return;
        }
        this.readLock.unlock();
        try {
            JSONObject recordsJsonObj = new JSONObject(recordStr);
            JSONArray recordsArray = recordsJsonObj.optJSONArray("data");
            ArrayList<SpeedPredictorRecord> speedPredictorRecords = new ArrayList<SpeedPredictorRecord>();
            for (int i = 0; i < recordsArray.length(); ++i) {
                try {
                    JSONObject speedRecordJsonObj = recordsArray.getJSONObject(i);
                    SpeedPredictorRecord speedRecord = new SpeedPredictorRecord();
                    speedRecord.extractFields(speedRecordJsonObj);
                    speedPredictorRecords.add(speedRecord);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.readLock.lock();
            this._update(this.mHandle, speedPredictorRecords, streamIdMediaTypeMap);
            this.readLock.unlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void update(ISpeedRecordOld record, Map<String, Integer> streamIdMediaTypeMap) {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return;
        }
        final DefaultSpeedPredictor cb = this;
        if (Looper.getMainLooper() == Looper.myLooper()) {
            if (this.subThread == null) {
                this.subThread = new Thread(){

                    @Override
                    public void run() {
                        if (Looper.myLooper() == null) {
                            Looper.prepare();
                        }
                        DefaultSpeedPredictor.this.mSpeedUpdateHander = new Handler(cb);
                        Looper.loop();
                    }
                };
                this.subThread.setName("speed_predict_update_thread");
                this.subThread.start();
            }
            if (this.mSpeedUpdateHander != null) {
                SpeedPredictorNotifyInfo notifyInfo = new SpeedPredictorNotifyInfo();
                notifyInfo.what = 0;
                notifyInfo.mSpeedRecord = record;
                notifyInfo.mStreamIdMediaTypeMap = streamIdMediaTypeMap;
                Message msg = this.mSpeedUpdateHander.obtainMessage();
                msg.what = 0;
                msg.obj = notifyInfo;
                msg.sendToTarget();
            }
        } else {
            this._updateOldWithStreamId(this.mHandle, record, streamIdMediaTypeMap);
        }
        this.readLock.unlock();
    }

    @Override
    public void update(long downloadBytes, long costTime, long timestamp) {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return;
        }
        this._updateWithSizeTime(this.mHandle, downloadBytes, costTime, timestamp);
        this.readLock.unlock();
    }

    @Override
    public String getMultidimensionalDownloadSpeeds() {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return null;
        }
        SpeedPredictorResultCollection speedResults = this._getMultidimensionalDownloadSpeeds(this.mHandle);
        String result = this.speedPredictorResultArrayToString(speedResults.getResultCollection());
        this.readLock.unlock();
        return result;
    }

    @Override
    public String getMultidimensionalPredictSpeeds() {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return null;
        }
        SpeedPredictorResultCollection speedResults = this._getMultidimensionalPredictSpeeds(this.mHandle);
        if (speedResults != null) {
            this.readLock.unlock();
            return this.speedPredictorResultArrayToString(speedResults.getResultCollection());
        }
        this.readLock.unlock();
        return null;
    }

    @Override
    public SpeedPredictorResultCollection getMultidimensionalDownloadSpeedsObj() {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return null;
        }
        SpeedPredictorResultCollection resultCollection = this._getMultidimensionalDownloadSpeeds(this.mHandle);
        this.readLock.unlock();
        return resultCollection;
    }

    @Override
    public SpeedPredictorResultCollection getMultidimensionalPredictSpeedsObj() {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return null;
        }
        SpeedPredictorResultCollection resultCollection = this._getMultidimensionalPredictSpeeds(this.mHandle);
        this.readLock.unlock();
        return resultCollection;
    }

    @Override
    public float getAverageDownloadSpeed(int mediaType, int speed_type, boolean trigger) {
        this.readLock.lock();
        if (this.mHandle == 0L) {
            this.readLock.unlock();
            return -1.0f;
        }
        float result = this._getAverageDownloadSpeed(this.mHandle, mediaType, speed_type, trigger);
        this.readLock.unlock();
        return result;
    }

    private String speedPredictorResultArrayToString(ArrayList<SpeedPredictorResult> speedResults) {
        try {
            if (speedResults == null && speedResults.size() <= 0) {
                return null;
            }
            JSONArray speedResultJsonArray = new JSONArray();
            for (SpeedPredictorResult result : speedResults) {
                JSONObject speedPredictorResultInfo = null;
                if (result == null || (speedPredictorResultInfo = result.toJsonObject()) == null) continue;
                speedResultJsonArray.put((Object)speedPredictorResultInfo);
            }
            if (speedResultJsonArray.length() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("data", (Object)speedResultJsonArray);
                return jsonObject.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void release() {
        this.writeLock.lock();
        if (this.mHandle == 0L) {
            this.writeLock.unlock();
            return;
        }
        this._close(this.mHandle);
        this._release(this.mHandle);
        this.mHandle = 0L;
        this.resetSpeedPredictor();
        this.writeLock.unlock();
    }

    private void resetSpeedPredictor() {
        if (this.mSpeedUpdateHander != null) {
            this.mSpeedUpdateHander.removeCallbacksAndMessages(null);
            this.mSpeedUpdateHander.getLooper().quit();
            this.mSpeedUpdateHander = null;
            this.subThread = null;
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 0) {
            SpeedPredictorNotifyInfo notifyInfo = (SpeedPredictorNotifyInfo)msg.obj;
            this._updateOldWithStreamId(this.mHandle, notifyInfo.mSpeedRecord, notifyInfo.mStreamIdMediaTypeMap);
        }
        return true;
    }

    private native long _create(int var1);

    private native String _getVersion();

    private native float _getPredictSpeed(long var1, int var3);

    private native float _getLastPredictConfidence(long var1);

    private native Map<String, String> _getDownloadSpeed(long var1, int var3);

    private native void _update(long var1, ArrayList<SpeedPredictorRecord> var3, Map<String, Integer> var4);

    private native void _updateOldWithStreamId(long var1, ISpeedRecordOld var3, Map<String, Integer> var4);

    private native void _updateWithSizeTime(long var1, long var3, long var5, long var7);

    private native void _release(long var1);

    private native void _setIntValue(long var1, int var3, int var4);

    private native void _setLongValue(long var1, int var3, long var4);

    private native void _setDoubleValue(long var1, int var3, double var4);

    private native void _setStringValue(long var1, int var3, String var4);

    private native int _getIntValue(long var1, int var3, int var4);

    private native long _getLongValue(long var1, int var3, long var4);

    private native double _getDoubleValue(long var1, int var3, double var4);

    private native SpeedPredictorResultCollection _getMultidimensionalDownloadSpeeds(long var1);

    private native SpeedPredictorResultCollection _getMultidimensionalPredictSpeeds(long var1);

    private native float _getAverageDownloadSpeed(long var1, int var3, int var4, boolean var5);

    private native void _setConfigSpeedInfo(long var1, Map<String, String> var3);

    private native void _setSpeedQueueSize(long var1, int var3);

    private native void _prepare(long var1);

    private native void _start(long var1);

    private native void _close(long var1);
}

