/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vodsetting;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.bytedance.vodsetting.Log;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Storage {
    private static final String TAG = "Storage";
    private static final int LoadLocalInit = 0;
    private static final int LoadLocalLoading = 1;
    private static final int LoadLocalLoadEnd = 2;
    public static final int MEMORY = 1;
    public static final int FILE = 2;
    private final ReentrantReadWriteLock mJsonLock = new ReentrantReadWriteLock();
    public JSONObject mSettingJson = null;
    public Context mContext = null;
    private int mLoadLocaling = 0;
    private final int mType;
    private SharedPreferences mSP = null;
    private final String mName;

    public Storage(String name, int type) {
        this.mName = name;
        this.mType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean tryToLoadLocal(Context context) {
        if (this.mLoadLocaling == 2) {
            return true;
        }
        this.mContext = context;
        if (this.mContext == null) {
            Log.e(TAG, "try to load local. Context is null");
            return false;
        }
        this.mLoadLocaling = 1;
        Log.v(TAG, "loading local settings, name = " + this.mName);
        if ((this.mType & 2) > 0) {
            this.mSP = this.mContext.getSharedPreferences("com.bd.vod.ST.settings." + this.mName, 0);
            if ((this.mType & 1) > 0 && this.mSP != null) {
                String localJson = this.mSP.getString(this._storeJsonKey(), "");
                if (!TextUtils.isEmpty((CharSequence)localJson)) {
                    this.mJsonLock.writeLock().lock();
                    try {
                        this.mSettingJson = new JSONObject(localJson);
                    }
                    catch (JSONException e) {
                        Log.e(TAG, e.toString());
                        this.mLoadLocaling = 0;
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        this.mJsonLock.writeLock().unlock();
                    }
                }
            } else {
                this.mJsonLock.writeLock().lock();
                if (this.mSettingJson == null) {
                    this.mSettingJson = new JSONObject();
                }
                this.mJsonLock.writeLock().unlock();
            }
        } else {
            this.mJsonLock.writeLock().lock();
            if (this.mSettingJson == null) {
                this.mSettingJson = new JSONObject();
            }
            this.mJsonLock.writeLock().unlock();
        }
        this.mLoadLocaling = 2;
        Log.v(TAG, "load local settings, name = " + this.mName);
        return true;
    }

    public void removeAllCache() {
        this.mJsonLock.writeLock().lock();
        if (this.mSettingJson != null) {
            this.mSettingJson = new JSONObject();
        }
        if ((this.mType & 2) > 0 && this.mSP != null) {
            SharedPreferences.Editor editor = this.mSP.edit();
            editor.clear();
            editor.apply();
        }
        this.mJsonLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJsonObject(JSONObject json, boolean isIncremental) {
        if (json == null) {
            return;
        }
        this.tryToLoadLocal(this.mContext);
        this.mJsonLock.writeLock().lock();
        try {
            if (this.mSettingJson == null || !isIncremental) {
                this.mSettingJson = json;
            } else {
                Iterator allKeys = json.keys();
                while (allKeys.hasNext()) {
                    String key = (String)allKeys.next();
                    this.mSettingJson.putOpt(key, json.opt(key));
                    Log.v(TAG, "update json, key = " + key + ", value = " + json.opt(key));
                }
            }
            if ((this.mType & 2) > 0 && this.mSP != null) {
                SharedPreferences.Editor editor = this.mSP.edit();
                editor.putString(this._storeJsonKey(), this.mSettingJson.toString());
                editor.apply();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e(TAG, e.toString());
        }
        finally {
            this.mJsonLock.writeLock().unlock();
        }
    }

    public JSONObject getJsonObject() {
        JSONObject jsonObject = null;
        this.tryToLoadLocal(this.mContext);
        this.mJsonLock.readLock().lock();
        try {
            if (this.mSettingJson != null) {
                jsonObject = new JSONObject(this.mSettingJson.toString());
            }
        }
        catch (JSONException e) {
            Log.e(TAG, e.toString());
            jsonObject = null;
        }
        finally {
            this.mJsonLock.readLock().unlock();
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putString(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        this.tryToLoadLocal(this.mContext);
        if ((this.mType & 1) > 0) {
            this.mJsonLock.writeLock().lock();
            try {
                if (this.mSettingJson != null) {
                    this.mSettingJson.put(key, (Object)value);
                }
            }
            catch (JSONException e) {
                Log.e(TAG, e.toString());
            }
            finally {
                this.mJsonLock.writeLock().unlock();
            }
        }
        if ((this.mType & 2) > 0 && this.mSP != null) {
            SharedPreferences.Editor editor = this.mSP.edit();
            editor.putString(key, value);
            editor.apply();
        }
    }

    public String getString(String key, String dValue) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return dValue;
        }
        String retValue = null;
        int jsonLen = 0;
        this.tryToLoadLocal(this.mContext);
        if ((this.mType & 1) > 0) {
            this.mJsonLock.readLock().lock();
            if (this.mSettingJson != null && !this.mSettingJson.isNull(key)) {
                retValue = this.mSettingJson.optString(key);
                jsonLen = this.mSettingJson.length();
            }
            this.mJsonLock.readLock().unlock();
        }
        if (jsonLen == 0 && retValue == null && (this.mType & 2) > 0 && this.mSP != null) {
            retValue = this.mSP.getString(key, dValue);
            Log.v(TAG, "get string from SP, key = " + key + ", retValue = " + retValue);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLong(String key, long value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.tryToLoadLocal(this.mContext);
        if ((this.mType & 1) > 0) {
            this.mJsonLock.writeLock().lock();
            try {
                if (this.mSettingJson != null) {
                    this.mSettingJson.put(key, value);
                }
            }
            catch (JSONException e) {
                Log.e(TAG, e.toString());
            }
            finally {
                this.mJsonLock.writeLock().unlock();
            }
        }
        if ((this.mType & 2) > 0 && this.mSP != null) {
            SharedPreferences.Editor editor = this.mSP.edit();
            editor.putLong(key, value);
            editor.apply();
        }
    }

    public long getLong(String key, long dValue) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return dValue;
        }
        long retValue = dValue;
        int jsonLen = 0;
        this.tryToLoadLocal(this.mContext);
        if ((this.mType & 1) > 0) {
            this.mJsonLock.readLock().lock();
            if (this.mSettingJson != null && !this.mSettingJson.isNull(key)) {
                retValue = this.mSettingJson.optLong(key);
                jsonLen = this.mSettingJson.length();
            }
            this.mJsonLock.readLock().unlock();
        }
        if (jsonLen == 0 && retValue == dValue && (this.mType & 2) > 0 && this.mSP != null) {
            retValue = this.mSP.getLong(key, dValue);
            Log.v(TAG, "get long from SP, key = " + key + ", retValue = " + retValue);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putInt(String key, int value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.tryToLoadLocal(this.mContext);
        if ((this.mType & 1) > 0) {
            this.mJsonLock.writeLock().lock();
            try {
                if (this.mSettingJson != null) {
                    this.mSettingJson.put(key, value);
                }
            }
            catch (JSONException e) {
                Log.e(TAG, e.toString());
            }
            finally {
                this.mJsonLock.writeLock().unlock();
            }
        }
        if ((this.mType & 2) > 0 && this.mSP != null) {
            SharedPreferences.Editor editor = this.mSP.edit();
            editor.putInt(key, value);
            editor.apply();
        }
    }

    public int getInt(String key, int dValue) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return dValue;
        }
        int retValue = dValue;
        int jsonLen = 0;
        this.tryToLoadLocal(this.mContext);
        if ((this.mType & 1) > 0) {
            this.mJsonLock.readLock().lock();
            if (this.mSettingJson != null && !this.mSettingJson.isNull(key)) {
                retValue = this.mSettingJson.optInt(key);
                jsonLen = this.mSettingJson.length();
            }
            this.mJsonLock.readLock().unlock();
        }
        if (jsonLen == 0 && (this.mType & 2) > 0 && retValue == dValue && this.mSP != null) {
            retValue = this.mSP.getInt(key, dValue);
            Log.v(TAG, "get int from SP, key = " + key + ", retValue = " + retValue);
        }
        return retValue;
    }

    public JSONArray getJsonArray(String key) {
        String strVal;
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        JSONArray retValue = null;
        this.tryToLoadLocal(this.mContext);
        if ((this.mType & 1) > 0) {
            this.mJsonLock.readLock().lock();
            if (this.mSettingJson != null && !this.mSettingJson.isNull(key)) {
                retValue = this.mSettingJson.optJSONArray(key);
            }
            this.mJsonLock.readLock().unlock();
        }
        if (retValue == null && (this.mType & 2) > 0 && this.mSP != null && !TextUtils.isEmpty((CharSequence)(strVal = this.mSP.getString(key, "")))) {
            try {
                retValue = new JSONArray(strVal);
                Log.v(TAG, "get JSONArray from SP, key= " + key + ", retValue = " + retValue);
            }
            catch (JSONException e) {
                Log.e(TAG, e.toString());
                retValue = null;
            }
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putJsonObject(String key, JSONObject value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.tryToLoadLocal(this.mContext);
        if ((this.mType & 1) > 0) {
            this.mJsonLock.writeLock().lock();
            try {
                if (this.mSettingJson != null) {
                    this.mSettingJson.put(key, (Object)value);
                }
            }
            catch (JSONException e) {
                Log.e(TAG, e.toString());
            }
            finally {
                this.mJsonLock.writeLock().unlock();
            }
        }
        if ((this.mType & 2) > 0 && this.mSP != null) {
            SharedPreferences.Editor editor = this.mSP.edit();
            editor.putString(key, value.toString());
            editor.apply();
        }
    }

    public JSONObject getJsonObject(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        JSONObject retValue = null;
        this.tryToLoadLocal(this.mContext);
        if ((this.mType & 1) > 0) {
            this.mJsonLock.readLock().lock();
            if (this.mSettingJson != null) {
                retValue = this.mSettingJson.optJSONObject(key);
            }
            this.mJsonLock.readLock().unlock();
        }
        try {
            String strValue;
            if (retValue == null && (this.mType & 2) > 0 && this.mSP != null && !TextUtils.isEmpty((CharSequence)(strValue = this.mSP.getString(key, "")))) {
                retValue = new JSONObject(strValue);
                Log.v(TAG, "get jsonObject from SP, key = " + key + ", retValue = " + retValue);
            }
        }
        catch (JSONException e) {
            Log.e(TAG, e.toString());
            retValue = null;
        }
        return retValue;
    }

    private String _storeJsonKey() {
        return this.mName + "_whole";
    }
}

