/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.support.annotation.NonNull;
import com.ss.ttm.player.LoadControl;
import com.ss.ttm.player.MediaPlayer;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.log.PortraitNetworkScore;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class DynamicLoadControl
extends LoadControl {
    private static final int CACHE_VIDEO_DURATION_MS = 30;
    private static final int CACHE_AUDIO_DURATION_MS = 40;
    private int mVideoTrackCacheDurationMs;
    private int mAudioTrackCacheDurationMs;
    private int mStartupDurationMinMs = 500;
    private int mStartupDurationMaxMs = 3000;
    private int mRebufferingTimeEarlyMs = 5000;
    private int mCostTimeMaxMs = 1000;
    private float mBeta = 1.25f;
    private float mGamma = 2.32f;
    private int mRebufferingDurationInitMs = 1000;
    private int mRebufferingDurationMaxMs = 5000;
    private float mRebufferingIncFactor = 0.5f;
    private int mRebufferingIncType = 0;
    private int mRebufferingCount = 0;
    private long mNeedBuffer = 2000L;
    private boolean mFirstCallBack = true;
    private boolean mIfStartup = true;
    private int mCaseType = 0;
    private int mCallbackCount = 0;
    private TTVideoEngine mVideoEngine;
    protected MediaPlayer mMediaPlayer;

    public DynamicLoadControl(int startupDurationMinMs, int startupDurationMaxMs, int rebufferingTimeEarlyMs, int costTimeMaxMs, float beta, float gamma, int rebufferingDurationInitMs, int rebufferingDurationMaxMs, float rebufferingIncFactor, int rebufferingIncType, @NonNull TTVideoEngine engine) {
        this.mStartupDurationMinMs = startupDurationMinMs;
        this.mStartupDurationMaxMs = startupDurationMaxMs;
        this.mRebufferingTimeEarlyMs = rebufferingTimeEarlyMs;
        this.mCostTimeMaxMs = costTimeMaxMs;
        this.mBeta = beta;
        this.mGamma = gamma;
        this.mRebufferingDurationInitMs = rebufferingDurationInitMs;
        this.mRebufferingDurationMaxMs = rebufferingDurationMaxMs;
        this.mRebufferingIncFactor = rebufferingIncFactor;
        this.mRebufferingIncType = rebufferingIncType;
        this.mVideoEngine = engine;
    }

    protected int onTrackSelected(int trackType) {
        switch (trackType) {
            case 2: {
                return this.mAudioTrackCacheDurationMs;
            }
            case 1: {
                return this.mVideoTrackCacheDurationMs;
            }
        }
        return -1;
    }

    protected boolean shouldStartPlayback(long bufferedDurationMs, float playbackSpeed, boolean rebuffering) {
        boolean bufferEnd = false;
        if (rebuffering) {
            long needBufferedMs;
            switch (this.mRebufferingIncType) {
                case 0: {
                    needBufferedMs = (long)Math.min((float)this.mRebufferingDurationInitMs + (float)this.mRebufferingCount * this.mRebufferingIncFactor * (float)this.mRebufferingDurationInitMs, (float)this.mRebufferingDurationMaxMs);
                    break;
                }
                case 1: {
                    needBufferedMs = (long)Math.min((double)this.mRebufferingDurationInitMs * (1.0 + (double)this.mRebufferingIncFactor * Math.log1p(this.mRebufferingCount)), (double)this.mRebufferingDurationMaxMs);
                    break;
                }
                case 2: {
                    needBufferedMs = (long)((double)(this.mRebufferingDurationMaxMs + this.mRebufferingDurationInitMs) / 2.0 - ((double)(this.mRebufferingDurationMaxMs + this.mRebufferingDurationInitMs) / 2.0 - (double)this.mRebufferingDurationInitMs) * Math.cos(Math.PI * 2 * (double)this.mRebufferingIncFactor * (double)this.mRebufferingCount));
                    break;
                }
                default: {
                    needBufferedMs = this.mRebufferingDurationInitMs;
                }
            }
            if (bufferedDurationMs >= needBufferedMs) {
                bufferEnd = true;
                ++this.mRebufferingCount;
                TTVideoEngineLog.d("dynamiclc", " parameters:  rdi " + this.mRebufferingDurationInitMs + ", rdm " + this.mRebufferingDurationMaxMs + ", rif " + this.mRebufferingIncFactor + ", rit " + this.mRebufferingIncType);
                TTVideoEngineLog.d("dynamiclc", " buffer end:  rebuf count " + this.mRebufferingCount + ", need buf " + needBufferedMs + ", now buf " + bufferedDurationMs);
            }
        } else {
            long needBufferedMs;
            if (this.mFirstCallBack) {
                int caseType;
                long targetBitrate = (long)(PortraitNetworkScore.getInstance().getLastTargetBitrate() >= 0.0 ? PortraitNetworkScore.getInstance().getLastTargetBitrate() * 1024.0 * 1024.0 : -1.0);
                long videoBitrate = -1L;
                MediaPlayer player = this.mVideoEngine.getMediaPlayer();
                if (player != null) {
                    videoBitrate = player.getLongOption(171, -1L);
                }
                if (this.mIfStartup) {
                    videoBitrate = (long)((double)videoBitrate * ((double)this.mBeta + (double)this.mGamma * Math.exp(1.0 - (double)this.mRebufferingTimeEarlyMs * 1.0 / 1000.0)));
                }
                float rate = (float)targetBitrate * 1.0f / (float)videoBitrate;
                float threshold = (float)((long)this.mRebufferingTimeEarlyMs - bufferedDurationMs) * 1.0f / (float)(this.mRebufferingTimeEarlyMs + this.mCostTimeMaxMs);
                TTVideoEngineLog.d("dynamiclc", " targetBitrate: " + targetBitrate + ", videoBitrate: " + videoBitrate + ", rate: " + rate + ", threshold: " + threshold);
                if (bufferedDurationMs >= (long)this.mRebufferingTimeEarlyMs) {
                    needBufferedMs = this.mStartupDurationMinMs;
                    caseType = 1;
                } else if (targetBitrate > 0L && videoBitrate > 0L) {
                    if (rate >= 1.0f) {
                        needBufferedMs = this.mStartupDurationMinMs;
                        caseType = 2;
                    } else if (rate < 1.0f && rate >= threshold) {
                        needBufferedMs = (long)Math.min(Math.max((1.0f - rate) * (float)this.mRebufferingTimeEarlyMs, (float)this.mStartupDurationMinMs), (float)this.mStartupDurationMaxMs);
                        caseType = 3;
                    } else {
                        needBufferedMs = (long)Math.min(Math.max((1.0f - threshold) * (float)this.mRebufferingTimeEarlyMs, (float)this.mStartupDurationMinMs), (float)this.mStartupDurationMaxMs);
                        caseType = 4;
                    }
                } else {
                    needBufferedMs = (long)Math.min(Math.max((1.0f - threshold) * (float)this.mRebufferingTimeEarlyMs, (float)this.mStartupDurationMinMs), (float)this.mStartupDurationMaxMs);
                    caseType = 5;
                }
                this.mNeedBuffer = needBufferedMs;
                this.mCaseType = caseType;
                this.mFirstCallBack = false;
            } else {
                needBufferedMs = this.mNeedBuffer;
            }
            bufferEnd = bufferedDurationMs >= needBufferedMs;
            ++this.mCallbackCount;
            if (bufferEnd) {
                TTVideoEngineLog.d("dynamiclc", " parameters:  D_min " + this.mStartupDurationMinMs + ", D_max " + this.mStartupDurationMaxMs + ", T_min " + this.mRebufferingTimeEarlyMs + ", C_max " + this.mCostTimeMaxMs);
                TTVideoEngineLog.d("dynamiclc", " start up: ifstartup " + this.mIfStartup + ", case " + this.mCaseType + ", need buf " + needBufferedMs + ", now buf " + bufferedDurationMs + ", callback count " + this.mCallbackCount);
                this.mFirstCallBack = true;
                this.mIfStartup = false;
                this.mCallbackCount = 0;
            }
        }
        return bufferEnd;
    }

    protected int onCodecStackSelected(int trackType) {
        switch (trackType) {
            case 2: {
                return this.mAudioTrackCacheDurationMs;
            }
            case 1: {
                return this.mVideoTrackCacheDurationMs;
            }
        }
        return -1;
    }

    protected int onFilterStackSelected(int trackType) {
        switch (trackType) {
            case 2: {
                return this.mAudioTrackCacheDurationMs;
            }
            case 1: {
                return this.mVideoTrackCacheDurationMs;
            }
        }
        return -1;
    }
}

