/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.os.SystemClock;
import android.text.TextUtils;
import com.ss.ttvideoengine.model.VideoModel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VideoModelCache {
    private static VideoModelCache mInstance;
    private static final int TIME_OUT = 3600;
    private static final int CACHE_NB = 100;
    private static int mTimeOutSetByUser;
    private static int mCacheNB;
    private ConcurrentHashMap<String, VideoModelCacheInfo> mVideoModelCache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VideoModelCache getInstance() {
        if (mInstance != null) return mInstance;
        Class<VideoModelCache> clazz = VideoModelCache.class;
        synchronized (VideoModelCache.class) {
            if (mInstance != null) return mInstance;
            mInstance = new VideoModelCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public synchronized void put(String vid, String apiString, VideoModel model) {
        if (this.mVideoModelCache == null || vid == null || apiString == null) {
            return;
        }
        VideoModelCacheInfo info = new VideoModelCacheInfo();
        info.model = model;
        info.modelGotTime = SystemClock.elapsedRealtime();
        this.put(vid, apiString, info);
    }

    public synchronized void put(String vid, String apiString, VideoModelCacheInfo infoToCache) {
        String key = this.getVideoModelCacheKey(vid, apiString);
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.mVideoModelCache.put(key, infoToCache);
        if (this.mVideoModelCache.size() > mCacheNB) {
            long time = Long.MAX_VALUE;
            String vidToDelete = null;
            for (Map.Entry<String, VideoModelCacheInfo> entry : this.mVideoModelCache.entrySet()) {
                VideoModelCacheInfo cacheInfo = entry.getValue();
                if (cacheInfo.modelGotTime >= time) continue;
                time = cacheInfo.modelGotTime;
                vidToDelete = entry.getKey();
            }
            if (vidToDelete != null) {
                this.mVideoModelCache.remove(vidToDelete);
            }
        }
    }

    private String getVideoModelCacheKey(String vid, String apiString) {
        if (TextUtils.isEmpty((CharSequence)apiString)) {
            return vid;
        }
        if (TextUtils.isEmpty((CharSequence)vid)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String codecType = null;
        String formatType = null;
        String ptoken = null;
        String ssl = null;
        String hdrDefinition = null;
        String fileType = null;
        String unionInfo = null;
        String drmExpire = null;
        String[] strSplitByQM = apiString.split("[?]");
        if (strSplitByQM.length >= 2) {
            String[] paramStrs;
            for (String paramStr : paramStrs = strSplitByQM[1].split("&")) {
                int codecTPos = paramStr.indexOf("codec_type");
                if (codecTPos == 0) {
                    codecType = paramStr.substring(codecTPos + 11);
                    continue;
                }
                codecTPos = paramStr.indexOf("CodecType");
                if (codecTPos == 0) {
                    codecType = paramStr.substring(codecTPos + 10);
                    continue;
                }
                codecTPos = paramStr.indexOf("Codec");
                if (codecTPos == 0) {
                    codecType = paramStr.substring(codecTPos + 6);
                    continue;
                }
                int formatTPos = paramStr.indexOf("format_type");
                if (formatTPos == 0) {
                    formatType = paramStr.substring(formatTPos + 12);
                    continue;
                }
                formatTPos = paramStr.indexOf("FormatType");
                if (formatTPos == 0) {
                    formatType = paramStr.substring(formatTPos + 11);
                    continue;
                }
                formatTPos = paramStr.indexOf("Format");
                if (formatTPos == 0) {
                    formatType = paramStr.substring(formatTPos + 7);
                    continue;
                }
                int ptokenPos = paramStr.indexOf("ptoken");
                if (ptokenPos == 0) {
                    ptoken = paramStr.substring(ptokenPos + 7);
                    continue;
                }
                ptokenPos = paramStr.indexOf("PToken");
                if (ptokenPos == 0) {
                    ptoken = paramStr.substring(ptokenPos + 7);
                    continue;
                }
                int sslPos = paramStr.indexOf("ssl");
                if (sslPos == 0) {
                    ssl = paramStr.substring(sslPos + 4);
                    continue;
                }
                sslPos = paramStr.indexOf("Ssl");
                if (sslPos == 0) {
                    ssl = paramStr.substring(sslPos + 4);
                    continue;
                }
                int hdrPos = paramStr.indexOf("HDRDefinition");
                if (hdrPos == 0) {
                    hdrDefinition = paramStr.substring(hdrPos + 14);
                    continue;
                }
                int fileTypePos = paramStr.indexOf("FileType");
                if (fileTypePos == 0) {
                    fileType = paramStr.substring(fileTypePos + 9);
                    continue;
                }
                int unionInfoPos = paramStr.indexOf("UnionInfo");
                if (unionInfoPos == 0) {
                    unionInfo = paramStr.substring(10);
                    continue;
                }
                int drmExpirePos = paramStr.indexOf("DrmExpireTimestamp");
                if (drmExpirePos != 0) continue;
                drmExpire = paramStr.substring(19);
            }
        }
        stringBuilder.append(vid);
        if (!TextUtils.isEmpty(codecType)) {
            stringBuilder.append(String.format("/%s", codecType));
        }
        if (!TextUtils.isEmpty(formatType)) {
            stringBuilder.append(String.format("/%s", formatType));
        }
        if (!TextUtils.isEmpty(ptoken)) {
            stringBuilder.append(String.format("/%s", ptoken));
        }
        if (!TextUtils.isEmpty(ssl)) {
            stringBuilder.append(String.format("/%s", ssl));
        }
        if (!TextUtils.isEmpty(hdrDefinition)) {
            stringBuilder.append(String.format("/%s", "hdr_" + hdrDefinition));
        }
        if (!TextUtils.isEmpty(fileType)) {
            stringBuilder.append(String.format("/%s", fileType));
        }
        if (!TextUtils.isEmpty(unionInfo)) {
            stringBuilder.append(String.format("/%s", unionInfo));
        }
        if (!TextUtils.isEmpty(drmExpire)) {
            stringBuilder.append(String.format("/%s", drmExpire));
        }
        return stringBuilder.toString();
    }

    public synchronized VideoModelCacheInfo get(String vid, String apiString) {
        if (this.mVideoModelCache != null) {
            String key = this.getVideoModelCacheKey(vid, apiString);
            if (TextUtils.isEmpty((CharSequence)key)) {
                return null;
            }
            VideoModelCacheInfo cacheInfo = this.mVideoModelCache.get(key);
            if (cacheInfo != null) {
                int timeout = 3600;
                if (mTimeOutSetByUser > 0) {
                    timeout = mTimeOutSetByUser;
                } else if (cacheInfo.model != null) {
                    timeout = 3600 + cacheInfo.model.getVideoRefInt(3) - 300;
                }
                cacheInfo.isExpired = SystemClock.elapsedRealtime() - cacheInfo.modelGotTime > (long)(timeout * 1000);
                return cacheInfo;
            }
        }
        return null;
    }

    public synchronized void remove(String vid, String apiString) {
        if (this.mVideoModelCache != null) {
            String key = this.getVideoModelCacheKey(vid, apiString);
            if (TextUtils.isEmpty((CharSequence)key)) {
                return;
            }
            this.mVideoModelCache.remove(key);
        }
    }

    public synchronized void clear() {
        mTimeOutSetByUser = -1;
        mCacheNB = 100;
        if (this.mVideoModelCache != null) {
            this.mVideoModelCache.clear();
        }
    }

    public void setTimeOutInSec(int timeout) {
        mTimeOutSetByUser = timeout;
    }

    public void setCacheNb(int cacheNB) {
        mCacheNB = cacheNB;
    }

    static {
        mTimeOutSetByUser = -1;
        mCacheNB = 100;
    }

    public static class VideoModelCacheInfo {
        public VideoModel model = null;
        public long modelGotTime = 0L;
        public boolean isExpired = false;
    }
}

