/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.download;

import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.download.Downloader;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DownloadTask {
    private static final String TAG = "TTVideoEngine.DownloadTask";
    public static final int DOWNLOAD_TASK_STATE_INIT = 0;
    public static final int DOWNLOAD_TASK_STATE_WAITING = 1;
    public static final int DOWNLOAD_TASK_STATE_RUNNING = 2;
    public static final int DOWNLOAD_TASK_STATE_SUSPENDED = 3;
    public static final int DOWNLOAD_TASK_STATE_CANCELING = 4;
    public static final int DOWNLOAD_TASK_STATE_COMPLETED = 5;
    public static final int MESSAGE_CANCEL = 111;
    public static final int MESSAGE_RECEIVE_ERROR = 112;
    public static final int MESSAGE_FINISHED = 113;
    protected String taskDescription = null;
    protected long taskIdentifier = -1L;
    protected String taskType = "base_task";
    protected long bytesReceived = 0L;
    protected long bytesExpectedToReceive = 0L;
    private int state = 0;
    protected Error error = null;
    protected String availableLocalFilePath = null;
    protected ArrayList<String> mediaKeys = null;
    protected HashMap<String, List<String>> usingUrls = null;
    protected boolean finished = false;
    protected boolean canceled = false;
    protected String videoId = null;
    protected String authToken = null;
    protected Downloader downloader = null;
    protected long updateTs = 0L;
    protected long updateBytesReceived = 0L;
    protected HashMap<String, Long> bytesReceivedMap = null;
    protected HashMap<String, Long> bytesExpectedToReceiveMap = null;
    protected Handler mHandler = null;
    protected boolean mFirstResumeCallback;
    protected EncryptVersion encryptVersion = EncryptVersion.NONE;
    protected String customDir = null;
    protected MediaType mMediaType = MediaType.Unknown;

    public MediaType getMediaType() {
        return this.mMediaType;
    }

    @Nullable
    public String getAvailableLocalFilePath() {
        return this.availableLocalFilePath;
    }

    public long getBytesExpectedToReceive() {
        return this.bytesExpectedToReceive;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public void setCustomDir(String dir) {
        if (!TextUtils.isEmpty((CharSequence)this.customDir)) {
            return;
        }
        this.customDir = dir;
    }

    @Nullable
    public String getTaskDescription() {
        return this.taskDescription;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        if (state != this.state) {
            this.state = state;
            TTVideoEngineLog.d(TAG, "[downloader] state did changed. state = " + state + " key = " + (this.mediaKeys != null ? this.mediaKeys.toString() : null));
            if (this.downloader != null && this.downloader.getListener() != null) {
                TTVideoEngineLog.d(TAG, "[downloader] state did changed. and notify downloader state = " + state);
                this.downloader.getListener().downloaderStateChanged(this.downloader, this, state);
            }
        }
    }

    public Error getError() {
        return this.error;
    }

    public String getVideoId() {
        return null;
    }

    public void invalidateAndCancel() {
        TTVideoEngineLog.d(TAG, "[downloader] did call invalidateAndCancel, key = " + (this.mediaKeys != null ? this.mediaKeys.toString() : null));
        if (this.canceled) {
            TTVideoEngineLog.d(TAG, "[downloader] task did canceled, self.taskIdentifier = " + this.taskIdentifier);
            return;
        }
        this.canceled = true;
        this.finished = false;
        this.setState(4);
        this.initHandle();
        final ArrayList<String> keys = this.mediaKeys;
        EngineThreadPool.addExecuteTask(new Runnable(){

            @Override
            public void run() {
                if (keys != null && keys.size() > 0) {
                    for (int i = 0; i < keys.size(); ++i) {
                        String key = (String)keys.get(i);
                        DataLoaderHelper.getDataLoader().suspendedDownload(key);
                        DataLoaderHelper.getDataLoader().removeDownloadFile(key);
                    }
                }
                if (DownloadTask.this.mHandler != null) {
                    DownloadTask.this.mHandler.sendMessage(Message.obtain((Handler)DownloadTask.this.mHandler, (int)111));
                }
            }
        });
    }

    public void suspend() {
        this.setState(3);
    }

    public void resume() {
        this.initHandle();
        this.error = null;
        this.finished = false;
        this.updateTs = System.currentTimeMillis();
    }

    void setupBaseFiled() {
        this.taskIdentifier = -1L;
        this.taskType = "base_task";
        this.bytesReceived = 0L;
        this.bytesExpectedToReceive = 0L;
        this.state = 0;
        this.error = null;
        this.availableLocalFilePath = null;
        this.mediaKeys = new ArrayList();
        this.usingUrls = null;
        this.finished = false;
        this.videoId = null;
        this.updateTs = 0L;
        this.bytesReceivedMap = new HashMap();
        this.bytesExpectedToReceiveMap = new HashMap();
    }

    void receiveError(Error err) {
        this.initHandle();
        if (this.mHandler != null) {
            this.mHandler.sendMessage(Message.obtain((Handler)this.mHandler, (int)112, (Object)err));
        }
    }

    void downloadEnd() {
        this.error = null;
        this.setState(5);
        if (this.downloader != null) {
            this.downloader.completeError(this, null);
        }
    }

    void assignWithJson(JSONObject jsonObject) {
        JSONObject bytesExpectJson;
        if (jsonObject == null) {
            return;
        }
        this.taskIdentifier = jsonObject.optLong("id");
        this.taskDescription = jsonObject.optString("des");
        this.updateBytesReceived = this.bytesReceived = jsonObject.optLong("res_size");
        this.bytesExpectedToReceive = jsonObject.optLong("content_size");
        this.state = jsonObject.optInt("state");
        this.error = TTHelper.errorWithJson(jsonObject.optJSONObject("error"));
        this.availableLocalFilePath = jsonObject.optString("file_path");
        this.customDir = jsonObject.optString("custom_dir");
        JSONArray array = jsonObject.optJSONArray("media_keys");
        if (array != null && array.length() > 0) {
            this.mediaKeys = new ArrayList();
            for (int i = 0; i < array.length(); ++i) {
                String key = array.optString(i);
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                this.mediaKeys.add(key);
            }
        } else {
            this.mediaKeys = new ArrayList();
        }
        this.finished = jsonObject.optBoolean("finish");
        this.canceled = jsonObject.optBoolean("cancel");
        this.taskType = jsonObject.optString("task_type");
        this.videoId = jsonObject.optString("vid");
        this.authToken = jsonObject.optString("auth_token");
        this.encryptVersion = jsonObject.optInt("encrypt_version", 0) == 1 ? EncryptVersion.MDL_VERSION_1 : EncryptVersion.NONE;
        JSONObject bytesRecJson = jsonObject.optJSONObject("bytes_rec_map");
        if (bytesRecJson != null && bytesRecJson.length() > 0) {
            Iterator keys = bytesRecJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.bytesReceivedMap.put(key, bytesRecJson.optLong(key));
            }
        }
        if ((bytesExpectJson = jsonObject.optJSONObject("bytes_expect_map")) != null && bytesExpectJson.length() > 0) {
            Iterator keys = bytesExpectJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.bytesExpectedToReceiveMap.put(key, bytesExpectJson.optLong(key));
            }
        }
    }

    boolean _shouldRetry(Error error) {
        if (error == null) {
            return false;
        }
        return error.code != -9995 && error.code != -9948 && error.code != -9949 && error.code != -9947 && error.code != -9946;
    }

    JSONObject jsonObject() {
        return new JSONObject(this.mapInfo());
    }

    Map mapInfo() {
        HashMap map = new HashMap();
        DownloadTask.putToMap(map, "id", this.taskIdentifier);
        DownloadTask.putToMap(map, "des", this.taskDescription);
        DownloadTask.putToMap(map, "res_size", this.bytesReceived);
        DownloadTask.putToMap(map, "content_size", this.bytesExpectedToReceive);
        DownloadTask.putToMap(map, "state", this.state);
        if (this.error != null) {
            DownloadTask.putToMap(map, "error", this.error.toMap());
        }
        DownloadTask.putToMap(map, "file_path", this.availableLocalFilePath);
        DownloadTask.putToMap(map, "media_keys", this.mediaKeys);
        DownloadTask.putToMap(map, "use_urls", this.usingUrls);
        DownloadTask.putToMap(map, "finish", this.finished);
        DownloadTask.putToMap(map, "cancel", this.canceled);
        DownloadTask.putToMap(map, "task_type", this.taskType);
        DownloadTask.putToMap(map, "vid", this.videoId);
        DownloadTask.putToMap(map, "auth_token", this.authToken);
        DownloadTask.putToMap(map, "bytes_rec_map", this.bytesReceivedMap);
        DownloadTask.putToMap(map, "bytes_expect_map", this.bytesExpectedToReceiveMap);
        DownloadTask.putToMap(map, "encrypt_version", this.encryptVersion.getVersion());
        if (!TextUtils.isEmpty((CharSequence)this.customDir)) {
            DownloadTask.putToMap(map, "custom_dir", this.customDir);
        }
        return map;
    }

    @NonNull
    public String toString() {
        return super.toString() + "   id = " + this.taskIdentifier + ", state = " + this.state + ",  videoId " + this.videoId;
    }

    @Nullable
    public void setDownloader(Downloader downloader) {
        this.downloader = downloader;
    }

    protected void initHandle() {
        if (this.mHandler != null) {
            return;
        }
        final DownloadTask task = this;
        this.mHandler = new Handler(TTHelper.getLooper()){

            public void handleMessage(Message msg) {
                if (msg == null) {
                    return;
                }
                if (task == null) {
                    return;
                }
                super.handleMessage(msg);
                if (msg.what == 111) {
                    task.setState(0);
                    if (task.downloader != null) {
                        task.downloader.cancel(task);
                    }
                } else if (msg.what == 112) {
                    task.error = (Error)msg.obj;
                    if (!DownloadTask.this._shouldRetry(task.error)) {
                        task.setState(5);
                    }
                    if (task.downloader != null) {
                        task.downloader.completeError(task, task.error);
                    }
                } else if (msg.what == 113) {
                    task.error = null;
                    task.setState(5);
                    if (task.downloader != null) {
                        task.downloader.completeError(task, null);
                    }
                }
            }
        };
    }

    public static void putToMap(Map map, String key, String value) {
        if (!TextUtils.isEmpty((CharSequence)value)) {
            map.put(key, value);
        }
    }

    public static void putToMap(Map map, String key, int value) {
        map.put(key, value);
    }

    public static void putToMap(Map map, String key, long value) {
        map.put(key, value);
    }

    public static void putToMap(Map map, String key, boolean value) {
        map.put(key, value);
    }

    public static void putToMap(Map map, String key, Map value) {
        if (value != null && !value.isEmpty()) {
            map.put(key, value);
        }
    }

    public static void putToMap(Map map, String key, ArrayList value) {
        if (value != null && !value.isEmpty()) {
            map.put(key, value);
        }
    }

    public static enum MediaType {
        Unknown,
        M3u8,
        Other;

    }

    public static enum EncryptVersion {
        NONE(0),
        MDL_VERSION_1(1);

        private int version;

        private EncryptVersion(int version) {
            this.version = version;
        }

        int getVersion() {
            return this.version;
        }
    }
}

