/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.fetcher.mdlfethcer;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.mediakit.fetcher.AVMDLNewFetcherMakerInterface;
import com.ss.mediakit.fetcher.AVMDLURLFetcherInterface;
import com.ss.ttvideoengine.fetcher.mdlfethcer.MDLFetcherListener;
import com.ss.ttvideoengine.fetcher.mdlfethcer.MDLFetcherNew;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FetcherMakerNew
implements AVMDLNewFetcherMakerInterface {
    private static final String TAG = "FetcherMakerNew";
    private static final List<WeakReference<MDLFetcherListener>> sFetcherListenerList = new ArrayList<WeakReference<MDLFetcherListener>>();

    public static synchronized void storeListener(MDLFetcherListener fetcherListener) {
        if (fetcherListener == null) {
            TTVideoEngineLog.i(TAG, "storeListener fetcherListener is null");
            return;
        }
        TTVideoEngineLog.i(TAG, "storeListener " + fetcherListener);
        sFetcherListenerList.add(new WeakReference<MDLFetcherListener>(fetcherListener));
    }

    public static synchronized void removeListener(MDLFetcherListener fetcherListener) {
        if (fetcherListener == null) {
            TTVideoEngineLog.i(TAG, "removeListener fetcherListener is null");
            return;
        }
        TTVideoEngineLog.i(TAG, "removeListener " + fetcherListener);
        Iterator<WeakReference<MDLFetcherListener>> iterator = sFetcherListenerList.iterator();
        while (iterator.hasNext()) {
            WeakReference<MDLFetcherListener> next = iterator.next();
            if (next == null || next.get() == null) {
                iterator.remove();
                continue;
            }
            MDLFetcherListener listener = (MDLFetcherListener)next.get();
            if (listener != fetcherListener) continue;
            iterator.remove();
        }
    }

    public AVMDLURLFetcherInterface getFetcher(String rawKey, String fileKey, String oldURL, String engineId) {
        TTVideoEngineLog.i(TAG, "getFetcher rawKey " + rawKey + ", fileKey " + fileKey + ", engineId " + engineId);
        MDLFetcherListener listener = FetcherMakerNew.getMDLFetchListener(engineId);
        if (listener == null) {
            TTVideoEngineLog.e(TAG, "getFetcher MDLFetcherListener is null");
            return null;
        }
        MDLFetcherNew fetcher = new MDLFetcherNew(listener);
        TTVideoEngineLog.i(TAG, "return fetcher to mdl " + fetcher);
        return fetcher;
    }

    @Nullable
    private static synchronized MDLFetcherListener getMDLFetchListener(String engineId) {
        for (WeakReference<MDLFetcherListener> weakReference : sFetcherListenerList) {
            MDLFetcherListener listener = (MDLFetcherListener)weakReference.get();
            if (listener == null || !TextUtils.equals((CharSequence)engineId, (CharSequence)listener.getId())) continue;
            return listener;
        }
        return null;
    }
}

