/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;

public class DeviceMonitorUtils {
    private static final String TAG = "DeviceMonitorUtils";
    private static final String APM_CPU_MANAGER_CLASS_PATH = "com.bytedance.apm6.cpu.ApmCpuManager";
    private static final String APM_CPU_INFO_CLASS_PATH = "com.bytedance.apm.perf.entity.CpuInfo";
    private static final String THOR_CLASS_PATH = "com.ss.thor.ThorUtils";
    private static Class<?> sCpuManagerClz = null;
    private static Class<?> sCpuInfoClz = null;
    private static Method sGetInstanceMethod = null;
    private static Method sGetCurrentCpuInfoMethod = null;
    private static Method sGetCpuRateMethod = null;
    private static Method sGetCpuSpeedMethod = null;
    private static Class<?> sThorClz = null;
    private static Method sGetGalvanicNowMethod = null;

    public static CPUInfo getCurrentCPUInfo() {
        CPUInfo cpuInfo = new CPUInfo();
        try {
            Object cpuManagerObj;
            if (sCpuManagerClz == null) {
                sCpuManagerClz = Class.forName(APM_CPU_MANAGER_CLASS_PATH);
            }
            if (sGetInstanceMethod == null) {
                sGetInstanceMethod = sCpuManagerClz.getMethod("getInstance", new Class[0]);
            }
            if (sGetCurrentCpuInfoMethod == null) {
                sGetCurrentCpuInfoMethod = sCpuManagerClz.getMethod("getCurrentCpuRate", new Class[0]);
            }
            if (sCpuInfoClz == null) {
                sCpuInfoClz = Class.forName(APM_CPU_INFO_CLASS_PATH);
            }
            if ((cpuManagerObj = sGetInstanceMethod.invoke(null, new Object[0])) != null) {
                Object cpuInfoObj = sGetCurrentCpuInfoMethod.invoke(cpuManagerObj, new Object[0]);
                if (cpuInfoObj != null && sCpuInfoClz.isInstance(cpuInfoObj)) {
                    Field cpuSpeed;
                    Field cpuRate = sCpuInfoClz.getDeclaredField("cpuAppRate");
                    if (cpuRate != null) {
                        cpuInfo.cpuAppRate = cpuRate.getDouble(cpuInfoObj);
                    }
                    if ((cpuSpeed = sCpuInfoClz.getDeclaredField("cpuAppSpeed")) != null) {
                        cpuInfo.cpuAppSpeed = cpuSpeed.getDouble(cpuInfoObj);
                    }
                } else {
                    TTVideoEngineLog.i(TAG, "is not instance");
                }
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.d(TAG, "getCurrentCPUInfo:" + e);
        }
        return cpuInfo;
    }

    public static double getCPUSpeed() {
        double speed = -1.0;
        try {
            Object retObj;
            Object cpuManagerObj;
            if (sCpuManagerClz == null) {
                sCpuManagerClz = Class.forName(APM_CPU_MANAGER_CLASS_PATH);
            }
            if (sGetInstanceMethod == null) {
                sGetInstanceMethod = sCpuManagerClz.getMethod("getInstance", new Class[0]);
            }
            if (sGetCpuSpeedMethod == null) {
                sGetCpuSpeedMethod = sCpuManagerClz.getMethod("getCpuSpeed", new Class[0]);
            }
            if ((cpuManagerObj = sGetInstanceMethod.invoke(null, new Object[0])) != null && (retObj = sGetCpuSpeedMethod.invoke(cpuManagerObj, new Object[0])) != null) {
                Double value = Double.parseDouble(retObj.toString());
                speed = value != null ? value : -1.0;
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.d(TAG, "getCPUSpeed:" + e);
        }
        return speed;
    }

    public static double getCPURate() {
        double rate = -1.0;
        try {
            Object retObj;
            Object cpuManagerObj;
            if (sCpuManagerClz == null) {
                sCpuManagerClz = Class.forName(APM_CPU_MANAGER_CLASS_PATH);
            }
            if (sGetInstanceMethod == null) {
                sGetInstanceMethod = sCpuManagerClz.getMethod("getInstance", new Class[0]);
            }
            if (sGetCpuRateMethod == null) {
                sGetCpuRateMethod = sCpuManagerClz.getMethod("getCpuRate", new Class[0]);
            }
            if ((cpuManagerObj = sGetInstanceMethod.invoke(null, new Object[0])) != null && (retObj = sGetCpuRateMethod.invoke(cpuManagerObj, new Object[0])) != null) {
                Double value = Double.parseDouble(retObj.toString());
                rate = value != null ? value : -1.0;
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.d(TAG, "getCPURate:" + e);
        }
        return rate;
    }

    public static int isPowerSaveMode(Context context) {
        if (context != null && Build.VERSION.SDK_INT >= 21) {
            try {
                PowerManager pm = (PowerManager)context.getSystemService("power");
                if (pm != null) {
                    return pm.isPowerSaveMode() ? 1 : 0;
                }
            }
            catch (Exception e) {
                TTVideoEngineLog.d(TAG, "isPowerSaveMode:" + e);
            }
        }
        return -1;
    }

    public static float getGalvanicNow(Context context) {
        float current = -1.0f;
        if (context == null) {
            return current;
        }
        try {
            if (sThorClz == null) {
                sThorClz = Class.forName(THOR_CLASS_PATH);
            }
            if (sGetGalvanicNowMethod == null) {
                sGetGalvanicNowMethod = sThorClz.getMethod("getGalvanicNow", Context.class);
            }
            current = ((Float)sGetGalvanicNowMethod.invoke(null, context)).floatValue();
        }
        catch (Exception e) {
            TTVideoEngineLog.d(TAG, "startThorMonitor failed:" + e);
        }
        return current;
    }

    public static HashMap<String, Object> getChargingState(Context context) {
        if (context == null) {
            return null;
        }
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = context.registerReceiver(null, ifilter);
        if (batteryStatus == null) {
            return null;
        }
        int status = batteryStatus.getIntExtra("status", -1);
        boolean isCharging = status == 2 || status == 5;
        int chargePlug = batteryStatus.getIntExtra("plugged", -1);
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        int batteryPct = level * 100 / scale;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        hashMap.put("isCharging", isCharging ? 1 : 0);
        hashMap.put("chargePlug", chargePlug);
        hashMap.put("power", batteryPct);
        return hashMap;
    }

    public static class CPUInfo {
        public double cpuAppRate = -1.0;
        public double cpuAppSpeed = -1.0;

        public String toString() {
            return "CpuInfo{cpuAppRate=" + this.cpuAppRate + ", cpuAppSpeed=" + this.cpuAppSpeed + '}';
        }
    }
}

