/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.os.Build;
import com.ss.ttvideoengine.TTNetWorkListener;
import com.ss.ttvideoengine.info.networkRTTLevelListener;
import com.ss.ttvideoengine.portrait.IPortrait;
import com.ss.ttvideoengine.portrait.NetworkPortraitData;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class PortraitNetworkScore
implements IPortrait {
    private static final String TAG = "PortraitNetworkScore";
    public static final int PORTRAIT_OPTION_NET_LEVEL_MAX_COUNT = 2;
    public static final int PORTRAIT_OPTION_NET_TIMER_TASK_INTERVAL = 3;
    public static final int PORTRAIT_OPTION_NET_MIN_DURATION = 4;
    public static final int PORTRAIT_OPTION_VAR_STRING = 4;
    private static PortraitNetworkScore mInstance = null;
    private NetworkQualityAlgorithm mQualityAlg = null;
    private final NetworkPortraitData mPortraitData = new NetworkPortraitData();
    private static double mLastTargetBitrate = -1.0;

    private PortraitNetworkScore() {
    }

    public static PortraitNetworkScore getInstance() {
        if (mInstance == null) {
            mInstance = new PortraitNetworkScore();
        }
        return mInstance;
    }

    public void start() {
        this.mPortraitData.start();
        this.mQualityAlg = new NetworkQualityAlgorithmV1();
    }

    public void stop() {
        this.mPortraitData.stop();
    }

    public int getPortraitResult() {
        return this.mQualityAlg == null ? -1 : this.mQualityAlg.getNetworkScore();
    }

    public int getLastPortraitResult() {
        return this.mQualityAlg == null ? -1 : this.mQualityAlg.getLastNetworkScore();
    }

    public NetworkQualityAlgorithm genNetworkQualityAlg() {
        return new NetworkQualityAlgorithmV2();
    }

    public double getLastTargetBitrate() {
        return mLastTargetBitrate;
    }

    public void setIntOption(int key, int value) {
        switch (key) {
            case 2: {
                this.mPortraitData.setMaxCount(value);
                break;
            }
            case 3: {
                if (value <= 0) break;
                this.mPortraitData.setSampleInterval(value);
                this.start();
                break;
            }
            case 4: {
                if (value < 0) {
                    return;
                }
                this.mPortraitData.setMinDataSize(value);
            }
        }
    }

    public NetworkPortraitData getPortraitData() {
        return this.mPortraitData;
    }

    public void setStringOption(int key, String value) {
        this.mQualityAlg.setStringOption(key, value);
    }

    public void setNetworkRTTLevelListener(networkRTTLevelListener listener) {
        this.mPortraitData.setNetworkRTTLevelListener(listener);
    }

    public int getNetworkRTTLevel() {
        return this.mPortraitData.getNetworkRTTLevel();
    }

    public int getNetworkRTTMS() {
        return this.mPortraitData.getNetworkRTTMS();
    }

    @Override
    public int getId() {
        return 1;
    }

    private static class NetworkQualityAlgorithmV2
    implements NetworkQualityAlgorithm {
        private double[] mParameters = new double[]{0.54551238, -0.03129748, 0.19721764, 0.24254935, 0.01385684, -1.56912212, -0.40001913, -0.57657028, -0.63627456, -0.13389704, 0.0628909, -0.13203807, -0.08140563, -0.09929551, 0.10024534, 0.31530643};
        private String mVarsToParse = null;

        private NetworkQualityAlgorithmV2() {
        }

        @Override
        public void init() {
        }

        @Override
        public double calculateTargetBitrate(ArrayList<Integer> rttList, ArrayList<Float> speedList) {
            TTVideoEngineLog.d(PortraitNetworkScore.TAG, "calculateTargetBitrate rttList:" + rttList + ", speedList:" + speedList);
            double targetBitrate = -1.0;
            if ((rttList == null || rttList.isEmpty()) && (speedList == null || speedList.isEmpty())) {
                return targetBitrate;
            }
            if (Build.VERSION.SDK_INT >= 24) {
                if (this.mVarsToParse != null && !this.mVarsToParse.isEmpty()) {
                    this.parseVariable(this.mVarsToParse);
                    this.mVarsToParse = null;
                }
                double speedMean = 0.0;
                double speedMin = 0.0;
                double speedMax = 0.0;
                double speedStd = 0.0;
                if (speedList != null) {
                    Iterator<Float> itFloat = speedList.iterator();
                    while (itFloat.hasNext()) {
                        float value = itFloat.next().floatValue();
                        if (!(value <= 0.0f)) continue;
                        itFloat.remove();
                    }
                    if (speedList.size() > 0) {
                        DoubleSummaryStatistics speedStat = speedList.stream().mapToDouble(Number::doubleValue).summaryStatistics();
                        speedMean = speedStat.getAverage();
                        speedMin = speedStat.getMin() / 1048576.0;
                        speedMax = speedStat.getMax() / 1048576.0;
                        double speedSum = 0.0;
                        for (int i = 0; i < speedList.size(); ++i) {
                            double s = (double)speedList.get(i).floatValue() - speedMean;
                            speedSum += Math.pow(s, 2.0);
                        }
                        speedStd = Math.sqrt(speedSum / (double)speedList.size()) / 1048576.0;
                        speedMean /= 1048576.0;
                    }
                }
                double rttMean = 0.0;
                double rttVar = 0.0;
                if (rttList != null) {
                    Iterator<Integer> itInt = rttList.iterator();
                    while (itInt.hasNext()) {
                        int value = itInt.next();
                        if (value > 0) continue;
                        itInt.remove();
                    }
                    if (rttList.size() > 0) {
                        IntSummaryStatistics rttStat = rttList.stream().mapToInt(Number::intValue).summaryStatistics();
                        rttMean = rttStat.getAverage() / 1000.0;
                        rttVar = (rttStat.getMax() - rttStat.getMin()) / 1000;
                    }
                }
                int netType = TTNetWorkListener.getInstance().getCurrentAccessType();
                int sigStrength = TTNetWorkListener.getInstance().getCurrentAccessStrength();
                double netTypeVar = 0.0;
                switch (netType) {
                    case 2: {
                        netTypeVar = this.mParameters[7];
                        break;
                    }
                    case 3: {
                        netTypeVar = this.mParameters[8];
                        break;
                    }
                    case 1: {
                        netTypeVar = this.mParameters[9];
                        break;
                    }
                    case 4: {
                        netTypeVar = this.mParameters[10];
                        break;
                    }
                    case 0: {
                        netTypeVar = this.mParameters[11];
                        break;
                    }
                }
                double sigStrengthVar = 0.0;
                switch (sigStrength) {
                    case 1: {
                        sigStrengthVar = this.mParameters[12];
                        break;
                    }
                    case 2: {
                        sigStrengthVar = this.mParameters[13];
                        break;
                    }
                    case 3: {
                        sigStrengthVar = this.mParameters[14];
                        break;
                    }
                    case 4: {
                        sigStrengthVar = this.mParameters[15];
                        break;
                    }
                }
                TTVideoEngineLog.d(PortraitNetworkScore.TAG, "calculateTargetBitrate speedMean:" + speedMean + ", speedStd:" + speedStd + ", speedMin:" + speedMin + ", speedMax:" + speedMax + ", rttMean:" + rttMean + ", rttVar:" + rttVar + ", netTypeVar:" + netTypeVar + ", sigStrengthVar:" + sigStrengthVar);
                double pred = this.mParameters[0] + this.mParameters[1] * speedMean + this.mParameters[2] * speedStd + this.mParameters[3] * speedMin + this.mParameters[4] * speedMax + this.mParameters[5] * rttMean + this.mParameters[6] * rttVar + netTypeVar + sigStrengthVar;
                targetBitrate = pred <= 1.0 ? Math.pow(Math.E, pred - 1.0) : pred;
                if (targetBitrate == Double.NaN) {
                    targetBitrate = -1.0;
                }
                if (targetBitrate > 0.0) {
                    mLastTargetBitrate = targetBitrate;
                }
                TTVideoEngineLog.d(PortraitNetworkScore.TAG, "calculateTargetBitrate pred:" + pred + ", qualityBitrate:" + targetBitrate + ", mLastTargetBitrate:" + mLastTargetBitrate);
            }
            return targetBitrate;
        }

        @Override
        public int getNetworkScore() {
            return -1;
        }

        @Override
        public int getLastNetworkScore() {
            return -1;
        }

        @Override
        public void setStringOption(int key, String value) {
            switch (key) {
                case 4: {
                    this.mVarsToParse = value;
                }
            }
        }

        private void parseVariable(String var) {
            String[] vars = var.split(",");
            int i = 0;
            for (String s : vars) {
                this.mParameters[i++] = Double.valueOf(s);
                if (i == this.mParameters.length) break;
            }
        }
    }

    private class NetworkQualityAlgorithmV1
    implements NetworkQualityAlgorithm {
        private Map<String, Double> mRttCodeMap = null;
        private Map<String, Double> mSigCodeMap = null;
        private Map<String, Integer> mLevelCodeMap = null;
        private int mLastNetworkScore = -1;

        public NetworkQualityAlgorithmV1() {
            this.init();
        }

        @Override
        public void init() {
            this.setDefaultRttMap();
            this.setDefaultSigMap();
            this.setDefaultLevelMap();
        }

        private void setDefaultRttMap() {
            this.mRttCodeMap = new HashMap<String, Double>();
            this.mRttCodeMap.put("-1", 1.8);
            this.mRttCodeMap.put("2", 93.0);
            this.mRttCodeMap.put("3", 70.0);
            this.mRttCodeMap.put("4", 26.0);
            this.mRttCodeMap.put("5", 12.0);
            this.mRttCodeMap.put("6", 7.0);
            this.mRttCodeMap.put("7", 2.0);
            this.mRttCodeMap.put("8", 1.0);
        }

        private void setDefaultSigMap() {
            this.mSigCodeMap = new HashMap<String, Double>();
            this.mSigCodeMap.put("excellent", 1.0);
            this.mSigCodeMap.put("good", 2.4);
            this.mSigCodeMap.put("unknown", 5.4);
            this.mSigCodeMap.put("medium", 7.6);
            this.mSigCodeMap.put("weak", 20.6);
            this.mSigCodeMap.put("unavailable", 36.0);
        }

        private void setDefaultLevelMap() {
            this.mLevelCodeMap = new HashMap<String, Integer>();
            this.mLevelCodeMap.put("1_1", 0);
            this.mLevelCodeMap.put("1_2", 1);
            this.mLevelCodeMap.put("1_3", 2);
            this.mLevelCodeMap.put("2_1", 3);
            this.mLevelCodeMap.put("2_2", 4);
            this.mLevelCodeMap.put("1_4", 5);
            this.mLevelCodeMap.put("2_3", 6);
            this.mLevelCodeMap.put("3_1", 7);
            this.mLevelCodeMap.put("3_2", 8);
            this.mLevelCodeMap.put("3_3", 9);
            this.mLevelCodeMap.put("2_4", 10);
            this.mLevelCodeMap.put("3_4", 11);
            this.mLevelCodeMap.put("4_1", 12);
            this.mLevelCodeMap.put("4_2", 13);
            this.mLevelCodeMap.put("4_3", 14);
            this.mLevelCodeMap.put("4_4", 15);
        }

        @Override
        public void setStringOption(int key, String value) {
            switch (key) {
                case 3: {
                    try {
                        this.mRttCodeMap = this._jsonStringToMap(value, false);
                    }
                    catch (Exception e) {
                        this.setDefaultRttMap();
                    }
                    break;
                }
                case 4: {
                    try {
                        this.mSigCodeMap = this._jsonStringToMap(value, false);
                    }
                    catch (Exception e) {
                        this.setDefaultSigMap();
                    }
                    break;
                }
                case 5: {
                    try {
                        this.mLevelCodeMap = this._jsonStringToMap(value, true);
                    }
                    catch (Exception e) {
                        this.setDefaultLevelMap();
                    }
                    break;
                }
            }
        }

        private Map _jsonStringToMap(String jsonStr, boolean toInt) throws Exception {
            HashMap<String, Number> codeMap = null;
            try {
                if (toInt) {
                    codeMap = new HashMap<String, Number>();
                    JSONObject jsonObject = new JSONObject(jsonStr);
                    Iterator iterator = jsonObject.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        Integer value = jsonObject.getInt(key);
                        codeMap.put(key, value);
                    }
                } else {
                    codeMap = new HashMap();
                    JSONObject jsonObject = new JSONObject(jsonStr);
                    Iterator iterator = jsonObject.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        Double value = jsonObject.getDouble(key);
                        codeMap.put(key, value);
                    }
                }
            }
            catch (Exception e) {
                TTVideoEngineLog.e(PortraitNetworkScore.TAG, e.toString());
                throw e;
            }
            return codeMap;
        }

        public void calculateNetworkScore() {
            List<Integer> rttList = PortraitNetworkScore.this.mPortraitData.getRttList();
            List<String> signalList = PortraitNetworkScore.this.mPortraitData.getSignalStrengthList();
            if (this.mRttCodeMap == null || this.mSigCodeMap == null || this.mLevelCodeMap == null || rttList == null || signalList == null) {
                return;
            }
            if (rttList.isEmpty() || signalList.isEmpty()) {
                return;
            }
            double rttScore = 0.0;
            int rttCount = rttList.size();
            try {
                for (int i = 0; i < rttCount; ++i) {
                    int iKey = rttList.get(i);
                    String key = String.valueOf(iKey);
                    rttScore += this.mRttCodeMap.containsKey(key) ? this.mRttCodeMap.get(key) : 0.0;
                }
                rttScore /= (double)rttCount;
            }
            catch (Exception e) {
                TTVideoEngineLog.e(PortraitNetworkScore.TAG, e.toString());
            }
            if (rttScore < 1.0) {
                return;
            }
            double sigScore = 0.0;
            int sigCount = signalList.size();
            try {
                for (int i = 0; i < sigCount; ++i) {
                    String sKey = signalList.get(i);
                    if (sKey == null) continue;
                    sigScore += this.mSigCodeMap.containsKey(sKey) ? this.mSigCodeMap.get(sKey) : 0.0;
                }
                sigScore /= (double)sigCount;
            }
            catch (Exception e) {
                TTVideoEngineLog.e(PortraitNetworkScore.TAG, e.toString());
            }
            if (sigScore < 1.0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            if (rttScore <= 2.0) {
                sb.append('1');
            } else if (rttScore <= 11.0) {
                sb.append('2');
            } else if (rttScore <= 26.0) {
                sb.append('3');
            } else {
                sb.append('4');
            }
            sb.append('_');
            if (sigScore == 1.0) {
                sb.append('1');
            } else if (sigScore <= 3.0) {
                sb.append('2');
            } else if (sigScore <= 7.0) {
                sb.append('3');
            } else {
                sb.append('4');
            }
            String level = sb.toString();
            int networkScore = -1;
            if (this.mLevelCodeMap.containsKey(level)) {
                networkScore = this.mLevelCodeMap.get(level);
            }
            this.mLastNetworkScore = networkScore;
            TTVideoEngineLog.d(PortraitNetworkScore.TAG, "rtt score:" + rttScore + " sig score:" + sigScore + " level:" + level);
        }

        @Override
        public int getNetworkScore() {
            this.calculateNetworkScore();
            return this.mLastNetworkScore;
        }

        @Override
        public int getLastNetworkScore() {
            if (this.mLastNetworkScore == -1) {
                this.calculateNetworkScore();
            }
            return this.mLastNetworkScore;
        }

        @Override
        public double calculateTargetBitrate(ArrayList<Integer> rttList, ArrayList<Float> speedList) {
            return -1.0;
        }
    }

    public static interface NetworkQualityAlgorithm {
        public void init();

        public int getNetworkScore();

        public int getLastNetworkScore();

        public double calculateTargetBitrate(ArrayList<Integer> var1, ArrayList<Float> var2);

        public void setStringOption(int var1, String var2);
    }
}

