/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.ss.ttvideoengine.log.LoggerUtils;
import com.ss.ttvideoengine.log.VideoEventBase;
import com.ss.ttvideoengine.log.VideoEventManager;
import com.ss.ttvideoengine.strategrycenter.StrategyCenter;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class VideoEventAbrEvent {
    public static final String monitorName = "videoplayer_abrswitch";
    private static final String TAG = "VideoEventAbrEvent";
    public VideoEventBase mEventBase;
    private ArrayList<EventContext> mEventContexts = new ArrayList();

    VideoEventAbrEvent(VideoEventBase base) {
        this.mEventBase = base;
    }

    public void reset() {
        this.mEventContexts.clear();
    }

    public void abrSwitchStart(long oldbr, long newbr) {
        TTVideoEngineLog.d(TAG, "abrSwitchStart");
        EventContext context = new EventContext();
        context.mEventTime = System.currentTimeMillis();
        context.mAbrV = this.mEventBase.mDataSource.getLogValueStr(102);
        context.mOldBr = oldbr;
        context.mNewBr = newbr;
        context.mMaxBufferLen = this.mEventBase.mDataSource.getLogValueInt(103);
        context.mAudioBufferLen = this.mEventBase.mDataSource.getLogValueLong(104);
        context.mVideoBufferLen = this.mEventBase.mDataSource.getLogValueLong(105);
        context.mReason = this.mEventBase.mDataSource.getLogValueInt(109);
        if (StrategyCenter.sNetAbrSpeedPredictor != null) {
            context.mSpeed = StrategyCenter.sNetAbrSpeedPredictor.getPredictSpeed(0);
        }
        this.mEventContexts.add(context);
    }

    public void abrSwitchEnd(long bitrate) {
        if (this.mEventContexts == null) {
            return;
        }
        EventContext context = null;
        while (!(this.mEventContexts.isEmpty() || (context = this.mEventContexts.remove(0)) != null && context.mNewBr == bitrate)) {
        }
        if (context == null) {
            return;
        }
        TTVideoEngineLog.d(TAG, "abrSwitchEnd");
        context.mSwitch2new = (int)this.mEventBase.mDataSource.getLogValueLong(106);
        context.mDelayTime = this.mEventBase.mDataSource.getLogValueLong(107);
        context.mCostTime = System.currentTimeMillis() - context.mEventTime;
        this.sendAbrSwitchEvent(context);
    }

    public void sendAbrSwitchEvent(EventContext context) {
        this.mEventBase.updateVideoInfo(null);
        EngineThreadPool.addExecuteTask(new AsyncGetLogDataRunnable(this.mEventBase.mContext, this, this.mEventBase, context));
    }

    private JSONObject toJsonObject(EventContext eventContext, VideoEventBase eventBase) {
        HashMap map = new HashMap();
        if (eventBase != null) {
            LoggerUtils.putToMap(map, "player_sessionid", eventBase.mSessionID);
            LoggerUtils.putToMap(map, "v", eventBase.mVid);
            LoggerUtils.putToMap(map, "pc", eventBase.pc);
            LoggerUtils.putToMap(map, "sv", eventBase.sv);
            LoggerUtils.putToMap(map, "sdk_version", eventBase.sdk_version);
            LoggerUtils.putToMap(map, "vtype", eventBase.vtype);
        }
        LoggerUtils.putToMap(map, "abrv", eventContext.mAbrV);
        LoggerUtils.putToMap(map, "cost_time", eventContext.mCostTime);
        LoggerUtils.putToMap(map, "pr_time", eventContext.mEventTime);
        LoggerUtils.putToMap(map, "end_type", eventContext.mEndType);
        LoggerUtils.putToMap(map, "old_br", eventContext.mOldBr);
        LoggerUtils.putToMap(map, "new_br", eventContext.mNewBr);
        LoggerUtils.putToMap(map, "max_buf", eventContext.mMaxBufferLen);
        LoggerUtils.putToMap(map, "abuf", eventContext.mAudioBufferLen);
        LoggerUtils.putToMap(map, "vbuf", eventContext.mVideoBufferLen);
        LoggerUtils.putToMap(map, "netspeed", eventContext.mSpeed);
        LoggerUtils.putToMap(map, "delaytime", eventContext.mDelayTime);
        LoggerUtils.putToMap(map, "tonew", eventContext.mSwitch2new);
        LoggerUtils.putToMap(map, "reason", eventContext.mReason);
        TTVideoEngineLog.d(TAG, "AbrSwitch:" + ((Object)map).toString());
        return new JSONObject(map);
    }

    private class EventContext {
        public long mEventTime = Integer.MIN_VALUE;
        public long mCostTime = Integer.MIN_VALUE;
        public String mEndType = "";
        public String mAbrV = "";
        public long mOldBr = -1L;
        public long mNewBr = -1L;
        public long mMaxBufferLen = -1L;
        public long mAudioBufferLen = -1L;
        public long mVideoBufferLen = -1L;
        public float mSpeed = -1.0f;
        public long mDelayTime = -1L;
        public long mWasteByte = -1L;
        public int mSwitch2new = 0;
        public int mReason = -1;

        private EventContext() {
        }
    }

    private static class AsyncGetLogDataRunnable
    implements Runnable {
        private VideoEventAbrEvent rEvent;
        private Handler rHandler;
        private VideoEventBase rEventBase;
        private Context rContext;
        private EventContext rEventContext;

        public AsyncGetLogDataRunnable(Context context, VideoEventAbrEvent event, VideoEventBase base, EventContext eventContext) {
            this.rEvent = event;
            this.rEventBase = base;
            this.rContext = context;
            this.rEventContext = eventContext;
            this.rHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        public void run() {
            if (this.rEvent == null) {
                return;
            }
            final boolean isUpload = this.rEventBase != null && this.rEventBase.isUploadLogEnabled;
            final JSONObject jsonEvent = this.rEvent.toJsonObject(this.rEventContext, this.rEventBase);
            if (this.rHandler == null || this.rHandler.getLooper() == null) {
                VideoEventManager.instance.addEventV2(isUpload, jsonEvent, VideoEventAbrEvent.monitorName);
                return;
            }
            this.rHandler.post(new Runnable(){

                @Override
                public void run() {
                    VideoEventManager.instance.addEventV2(isUpload, jsonEvent, VideoEventAbrEvent.monitorName);
                }
            });
        }
    }
}

