/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.model;

import android.text.TextUtils;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class BarrageMaskInfo {
    public static final int VALUE_VIDEO_MASK_INFO_VERSION = 0;
    public static final int VALUE_VIDEO_MASK_INFO_URL = 1;
    public static final int VALUE_VIDEO_MASK_INFO_FILE_ID = 2;
    public static final int VALUE_VIDEO_MASK_INFO_FILE_HASH = 3;
    public static final int VALUE_VIDEO_MASK_INFO_FILE_SIZE = 4;
    public static final int VALUE_VIDEO_MASK_INFO_UPDATED_AT = 5;
    public static final int VALUE_VIDEO_MASK_INFO_BITRATE = 6;
    public static final int VALUE_VIDEO_MASK_INFO_HEAD_LEN = 7;
    public static final String KEY_MASK_VERSION = "version";
    public static final String KEY_MASK_URL = "barrage_mask_url";
    public static final String KEY_MASK_FILE_ID = "file_id";
    public static final String KEY_MASK_FILE_HASH = "file_hash";
    public static final String KEY_MASK_FILE_SIZE = "file_size";
    public static final String KEY_MASK_UPDATED_AT = "updated_at";
    public static final String KEY_MASK_BITRATE = "bitrate";
    public static final String KEY_MASK_HEAD_LEN = "head_len";
    public static final String KEY_VER4_MASK_VERSION = "Version";
    public static final String KEY_VER4_MASK_URL = "BarrageMaskUrl";
    public static final String KEY_VER4_MASK_FILE_ID = "FileId";
    public static final String KEY_VER4_MASK_FILE_HASH = "FileHash";
    public static final String KEY_VER4_MASK_FILE_SIZE = "FileSize";
    public static final String KEY_VER4_MASK_UPDATED_AT = "UpdatedAt";
    public static final String KEY_VER4_MASK_BITRATE = "Bitrate";
    public static final String KEY_VER4_MASK_HEAD_LEN = "HeadLen";
    public String mMaskVersion;
    public String mMaskUrl;
    public String mMaskFileId;
    public String mMaskFileHash;
    public long mMaskFileSize = 0L;
    public long mMaskUpdatedAt = 0L;
    public int mMaskBitrate = 0;
    public int mMaskHeadLen = 0;

    public void extractFields(JSONObject obj) {
        if (obj == null) {
            return;
        }
        try {
            this.mMaskVersion = obj.optString(KEY_MASK_VERSION);
            this.mMaskUrl = obj.optString(KEY_MASK_URL);
            this.mMaskFileId = obj.optString(KEY_MASK_FILE_ID);
            this.mMaskFileHash = obj.optString(KEY_MASK_FILE_HASH);
            this.mMaskFileSize = obj.optLong(KEY_MASK_FILE_SIZE);
            this.mMaskUpdatedAt = obj.optLong(KEY_MASK_UPDATED_AT);
            this.mMaskBitrate = obj.optInt(KEY_MASK_BITRATE);
            this.mMaskHeadLen = obj.optInt(KEY_MASK_HEAD_LEN);
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
    }

    public void extractFieldsV4(JSONObject obj) {
        if (obj == null) {
            return;
        }
        try {
            this.mMaskVersion = obj.optString(KEY_VER4_MASK_VERSION);
            this.mMaskUrl = obj.optString(KEY_VER4_MASK_URL);
            this.mMaskFileId = obj.optString(KEY_VER4_MASK_FILE_ID);
            this.mMaskFileHash = obj.optString(KEY_VER4_MASK_FILE_HASH);
            this.mMaskFileSize = obj.optLong(KEY_VER4_MASK_FILE_SIZE);
            this.mMaskUpdatedAt = obj.optLong(KEY_VER4_MASK_UPDATED_AT);
            this.mMaskBitrate = obj.optInt(KEY_VER4_MASK_BITRATE);
            this.mMaskHeadLen = obj.optInt(KEY_VER4_MASK_HEAD_LEN);
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
    }

    public String getValueStr(int key) {
        switch (key) {
            case 0: {
                return this.mMaskVersion;
            }
            case 1: {
                return this.mMaskUrl;
            }
            case 2: {
                return this.mMaskFileId;
            }
            case 3: {
                return this.mMaskFileHash;
            }
        }
        return "";
    }

    public long getValueLong(int key) {
        switch (key) {
            case 4: {
                return this.mMaskFileSize;
            }
            case 5: {
                return this.mMaskUpdatedAt;
            }
        }
        return 0L;
    }

    public int getValueInt(int key) {
        switch (key) {
            case 6: {
                return this.mMaskBitrate;
            }
            case 7: {
                return this.mMaskHeadLen;
            }
        }
        return -1;
    }

    public Map<String, Object> getMediaInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put(KEY_MASK_FILE_ID, this.getValueStr(2));
        info.put("media_type", "mask");
        info.put(KEY_MASK_FILE_SIZE, this.getValueLong(4));
        info.put(KEY_MASK_BITRATE, this.getValueInt(6));
        String url = this.getValueStr(1);
        if (!TextUtils.isEmpty((CharSequence)url)) {
            info.put("urls", new String[]{url});
        }
        info.put(KEY_MASK_FILE_HASH, this.getValueStr(3));
        return info;
    }
}

