/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.net;

import android.content.Context;
import android.net.NetworkInfo;
import android.os.SystemClock;
import android.util.Log;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.net.BaseDNS;
import com.ss.ttvideoengine.net.DNSCompletionListener;
import com.ss.ttvideoengine.net.DNSServerIP;
import com.ss.ttvideoengine.net.HTTPDNS;
import com.ss.ttvideoengine.net.IPCache;
import com.ss.ttvideoengine.net.LocalDNS;
import com.ss.ttvideoengine.net.NetUtils;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONObject;

public class DNSParser
extends BaseDNS
implements DNSCompletionListener {
    private static final String TAG = "DNSParser";
    public static final int DNS_TYPE_LOCAL = 0;
    public static final int DNS_TYPE_HTTP_ALI = 1;
    public static final int DNS_TYPE_HTTP_TT = 2;
    public static final String DNS_RESULT_IP = "ip";
    private int mDNSCount;
    private int mIndex = 0;
    private int[] mParserIndex = new int[]{0, 2};
    private BaseDNS mCurrentDNS;
    private Context mContext;
    private boolean hasRecAndExpired = false;
    private IPCache mIPCache;
    private boolean mForceReparse = false;
    private boolean mUseDNSCache = false;
    private boolean mUseServerDNS = false;
    private int mExpiredTime = 120;
    private boolean mIPFromCache = false;
    private boolean mIPFromServer = false;
    private JSONObject mDnsInfo = null;
    private long mDnsTime = 0L;
    private long mClearTime = 0L;

    public DNSParser(Context context, String hostname, TTVNetClient client) {
        super(hostname, client);
        this.mContext = context;
        this.mDNSCount = this.mParserIndex.length;
        int[] dnsType = TTVideoEngine.getDNSType();
        if (dnsType != null && dnsType.length > 0) {
            block4: for (int i = 0; i < dnsType.length; ++i) {
                switch (dnsType[i]) {
                    case 0: 
                    case 2: {
                        this.mParserIndex[i] = dnsType[i];
                        continue block4;
                    }
                    case 1: {
                        this.mParserIndex[i] = 2;
                        continue block4;
                    }
                }
            }
        } else if (TTVideoEngine.isHttpDnsFirst()) {
            this.mParserIndex[0] = 2;
            this.mParserIndex[1] = 0;
        }
        TTVideoEngineLog.i(TAG, "DNSType:" + Arrays.toString(this.mParserIndex));
        this.mIPCache = IPCache.getInstance();
    }

    public void setForceReparse() {
        this.mForceReparse = true;
    }

    public void setIsUseDNSCache(boolean isUse) {
        this.mUseDNSCache = isUse;
    }

    public void setIsUseServerDNS(boolean isUse) {
        this.mUseServerDNS = isUse;
    }

    public void setDnsInfo(JSONObject dnsInfo, Long dnsTime) {
        this.mDnsInfo = dnsInfo;
        this.mDnsTime = dnsTime;
    }

    public boolean getIsUseDNSCache() {
        return this.mUseDNSCache;
    }

    public boolean getIsUseServerDNS() {
        return this.mUseServerDNS;
    }

    public void setDNSExpiredTimeInS(int timeoutInS) {
        this.mExpiredTime = timeoutInS;
    }

    public String getTypeStr() {
        if (this.mIPFromCache) {
            return "FromCache";
        }
        if (this.mIPFromServer) {
            return "FromServer";
        }
        switch (this.mParserIndex[this.mIndex]) {
            case 1: {
                return "HTTP AL";
            }
            case 0: {
                return "local";
            }
            case 2: {
                return "TT_HTTP";
            }
        }
        return "";
    }

    @Override
    public void start() {
        if (this.mCancelled) {
            return;
        }
        if (this.mIndex >= this.mDNSCount) {
            return;
        }
        DNSServerIP.updateDNSServerIP();
        if (this.mForceReparse || !this.mUseDNSCache && !this.mUseServerDNS) {
            this.DNSParseAsync();
            return;
        }
        boolean isClear = false;
        NetworkInfo EnvInfo = NetUtils.getNetworkInfo(this.mContext);
        int EnvNetType = -1;
        String EnvNetExtraInfo = null;
        if (EnvInfo != null && EnvInfo.isAvailable()) {
            EnvNetType = EnvInfo.getType();
            EnvNetExtraInfo = EnvInfo.getExtraInfo();
        }
        int CurNetType = this.mIPCache.getCurNetType();
        if (EnvNetType != -1) {
            if (EnvNetType != CurNetType) {
                isClear = true;
                this.mClearTime = System.currentTimeMillis();
            } else {
                String CurNetExtraInfo = this.mIPCache.getCurNetExtraInfo();
                if (!(EnvNetExtraInfo == null || CurNetExtraInfo != null && EnvNetExtraInfo.equals(CurNetExtraInfo))) {
                    this.mClearTime = System.currentTimeMillis();
                    isClear = true;
                }
            }
        } else {
            Log.d((String)TAG, (String)"start:NetWork may hava some problems");
        }
        if (this.mUseServerDNS) {
            long difftime = this.mClearTime / 1000L - this.mDnsTime;
            if (isClear && CurNetType == -1) {
                this.mIPCache.setCurNetExtraInfo(EnvNetExtraInfo);
                this.mIPCache.setCurNetType(EnvNetType);
                isClear = false;
            } else if (difftime > 0L && this.mDnsTime > 0L) {
                isClear = true;
            }
        }
        if (isClear) {
            this.mIPCache.clear();
            this.mIPCache.setCurNetExtraInfo(EnvNetExtraInfo);
            this.mIPCache.setCurNetType(EnvNetType);
            this.DNSParseAsync();
            return;
        }
        if (this.mUseServerDNS && this.mDnsInfo != null) {
            JSONArray ip_array = this.mDnsInfo.optJSONArray(this.mHostname);
            if (ip_array == null || ip_array.length() == 0) {
                TTVideoEngineLog.d(TAG, "dns_info ips empty");
            } else {
                JSONObject ip_return = new JSONObject();
                try {
                    ip_return.put(DNS_RESULT_IP, (Object)ip_array.optString(0));
                    ip_return.put("time", System.currentTimeMillis());
                    ip_return.put("dns_type", (Object)"httpDNS");
                }
                catch (Exception e) {
                    TTVideoEngineLog.d(e);
                }
                this.mIPFromServer = true;
                this.recordIPInfo(ip_return, this.mExpiredTime);
                if (this.mListener != null) {
                    this.mListener.onCompletion(ip_return, null);
                }
                return;
            }
        }
        if (this.mUseDNSCache) {
            IPCache.IpInfo ipinfo = null;
            if (this.mIPCache != null) {
                ipinfo = this.mIPCache.get(this.mHostname);
            }
            if (ipinfo != null) {
                TTVideoEngineLog.d(TAG, "DNS from cache");
                if (SystemClock.elapsedRealtime() >= ipinfo.ip_expiretime) {
                    this.hasRecAndExpired = true;
                    this.DNSParseAsync();
                }
                this.mIPFromCache = true;
                try {
                    ipinfo.ip_json.put("time", System.currentTimeMillis());
                    ipinfo.ip_json.put("dns_type", (Object)"localDNS");
                }
                catch (Exception e) {
                    TTVideoEngineLog.d(e);
                }
                if (this.mListener != null) {
                    this.mListener.onCompletion(ipinfo.ip_json, null);
                }
                return;
            }
        }
        this.DNSParseAsync();
    }

    private void DNSParseAsync() {
        switch (this.mParserIndex[this.mIndex]) {
            case 2: {
                this.mCurrentDNS = new HTTPDNS(this.mHostname, this.mNetClient, 2);
                break;
            }
            case 1: {
                this.mCurrentDNS = new HTTPDNS(this.mHostname, this.mNetClient, 1);
                break;
            }
            case 0: {
                this.mCurrentDNS = new LocalDNS(this.mHostname);
                break;
            }
        }
        if (this.mCurrentDNS != null) {
            this.mCurrentDNS.setCompletionListener(this);
            this.mCurrentDNS.start();
        }
    }

    @Override
    public void cancel() {
        if (this.mCancelled) {
            return;
        }
        this.mCancelled = true;
        if (this.mCurrentDNS != null) {
            this.mCurrentDNS.cancel();
        }
    }

    @Override
    public void onCancelled() {
    }

    @Override
    public void onRetry(Error error) {
    }

    @Override
    public void onCompletion(JSONObject ipJSON, Error error) {
        if (this.mCancelled) {
            if (!this.hasRecAndExpired || this.mForceReparse) {
                this.notifyCancelled();
            }
            return;
        }
        if (error == null) {
            JSONArray ip_array = null;
            if (ipJSON != null) {
                ip_array = ipJSON.optJSONArray("ips");
            }
            if (ip_array == null || ip_array.length() == 0) {
                if (this.mParserIndex[this.mIndex] == 0) {
                    this.notifyError(new Error("kTTVideoErrorDomainLocalDNS", -9997, "dns result empty,type:" + this.mParserIndex[this.mIndex]));
                } else {
                    this.notifyError(new Error("kTTVideoErrorDomainHTTPDNS", -9997, "dns result empty,type:" + this.mParserIndex[this.mIndex]));
                }
                TTVideoEngineLog.d(TAG, "ips empty");
                return;
            }
            JSONObject ip_return = new JSONObject();
            try {
                ip_return.put(DNS_RESULT_IP, (Object)ip_array.optString(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            long expiredTime = ipJSON.optLong("ttl");
            if (expiredTime == 0L) {
                expiredTime = this.mExpiredTime;
            }
            this.recordIPInfo(ip_return, expiredTime);
            if (!this.hasRecAndExpired || this.mForceReparse) {
                try {
                    ip_return.put("time", ipJSON.optLong("time"));
                    ip_return.put("dns_type", (Object)ipJSON.optString("dns_type"));
                }
                catch (Exception e) {
                    TTVideoEngineLog.d(TAG, e.toString());
                }
                this.notifySuccess(ip_return);
            }
            return;
        }
        if (this.mIndex == this.mDNSCount - 1) {
            if (!this.hasRecAndExpired || this.mForceReparse) {
                this.notifyError(error);
            }
            return;
        }
        if (!this.hasRecAndExpired || this.mForceReparse) {
            this.notifyRetry(error);
        }
        ++this.mIndex;
        this.start();
    }

    private void recordIPInfo(JSONObject ipAddress, long expiredTime) {
        if (this.mIPCache != null) {
            IPCache.IpInfo newIPRec = new IPCache.IpInfo();
            newIPRec.ip_json = ipAddress;
            newIPRec.ip_expiretime = SystemClock.elapsedRealtime() + expiredTime * 1000L;
            this.mIPCache.put(this.mHostname, newIPRec);
        }
    }
}

