/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.net;

import android.os.SystemClock;
import com.ss.ttvideoengine.net.TLSSocketFactory;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionSpec;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONObject;

public class TTHTTPNetwork
extends TTVNetClient {
    private static final String TAG = "TTHTTPNetwork";
    private static final int STATUS_UNKNOWN = 0;
    private static final int STATUS_RUNNING = 1;
    private static final int STATUS_FINISHED = 2;
    private static final int STATUS_CANCEL = 3;
    private static final int HTTP_TIME_OUT = 10;
    private static final int HTTP_MAX_RETRY_TIME_OUT = 10;
    private static OkHttpClient mClient = null;
    private Call mCall;
    public static final MediaType JSON = MediaType.parse((String)"application/json");
    private int mStatus = 0;
    private long mStartTime;
    private static boolean mIsRetryWhenFail = true;
    private static int mMaxRetryTimeOut = 10;
    private static boolean mTLSv1_2 = false;
    private static boolean mClientParamsChanged = false;

    public static void setMaxRetryTimeOut(int timeOut) {
        TTVideoEngineLog.d(TAG, "setMaxRetryTimeOut:" + timeOut);
        mMaxRetryTimeOut = timeOut < 0 || timeOut > 60 ? 10 : timeOut;
    }

    public static void enableTLSv1_2(boolean enable) {
        if (mTLSv1_2 != enable) {
            mTLSv1_2 = enable;
            mClientParamsChanged = true;
        }
    }

    public static void isRetryWhenFail(int isOpen) {
        TTVideoEngineLog.d(TAG, "isRetryWhenFail:" + isOpen);
        if (isOpen < 0 || isOpen > 1) {
            return;
        }
        mIsRetryWhenFail = isOpen == 1;
    }

    private void setupClient() {
        if (mClientParamsChanged) {
            mClient = null;
        }
        if (mClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS);
            if (mTLSv1_2) {
                try {
                    SSLContext sc = SSLContext.getInstance("TLS");
                    sc.init(null, null, null);
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                    TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
                    X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
                    ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).build();
                    ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
                    specs.add(cs);
                    specs.add(ConnectionSpec.COMPATIBLE_TLS);
                    specs.add(ConnectionSpec.CLEARTEXT);
                    builder.connectionSpecs(specs);
                    builder.sslSocketFactory((SSLSocketFactory)new TLSSocketFactory(sc.getSocketFactory()), trustManager);
                    TTVideoEngineLog.i(TAG, "tls1.2 enabled");
                }
                catch (Exception e) {
                    TTVideoEngineLog.e(TAG, "enable tls1.2 error");
                }
            }
            mClient = builder.build();
            mClientParamsChanged = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TTHTTPNetwork() {
        if (mClient != null && !mClientParamsChanged) return;
        Class<TTHTTPNetwork> clazz = TTHTTPNetwork.class;
        synchronized (TTHTTPNetwork.class) {
            this.setupClient();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTask(String urlString, Map<String, String> headers, TTVNetClient.CompletionListener listener) {
        Class<TTHTTPNetwork> clazz = TTHTTPNetwork.class;
        synchronized (TTHTTPNetwork.class) {
            this.setupClient();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            Request.Builder builder = new Request.Builder().url(urlString);
            if (headers != null) {
                for (String key : headers.keySet()) {
                    String value = headers.get(key);
                    builder.header(key, value);
                }
            }
            this._startTask(builder.build(), listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTask(String urlString, Map<String, String> headers, JSONObject jsonBody, int method, TTVNetClient.CompletionListener listener) {
        Class<TTHTTPNetwork> clazz = TTHTTPNetwork.class;
        synchronized (TTHTTPNetwork.class) {
            this.setupClient();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            Request.Builder builder = new Request.Builder().url(urlString);
            if (headers != null && headers.size() > 0) {
                for (String key : headers.keySet()) {
                    String value = headers.get(key);
                    builder.addHeader(key, value);
                }
            }
            if (method == 1) {
                RequestBody body = RequestBody.create((MediaType)JSON, (String)String.valueOf(jsonBody));
                builder.post(body);
            }
            this._startTask(builder.build(), listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTask(String urlString, final TTVNetClient.CompletionListener listener) {
        Class<TTHTTPNetwork> clazz = TTHTTPNetwork.class;
        synchronized (TTHTTPNetwork.class) {
            this.setupClient();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Request.Builder builder = new Request.Builder().url(urlString);
            Request request = builder.build();
            this.mCall = mClient.newCall(request);
            this.mCall.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    TTHTTPNetwork.this.mStatus = 2;
                    listener.onCompletion(null, new Error("", -9994, e.toString()));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(Call call, Response response) {
                    ResponseBody responseBody = null;
                    Exception exception = null;
                    JSONObject jsonObject = null;
                    int code = -1;
                    try {
                        responseBody = response.body();
                        try {
                            jsonObject = new JSONObject(responseBody.string());
                        }
                        catch (Exception e) {
                            exception = e;
                            TTVideoEngineLog.d(e);
                            code = -9979;
                        }
                        if (exception == null && !response.isSuccessful()) {
                            exception = new Exception("http fail");
                            code = response.code();
                        }
                    }
                    finally {
                        if (responseBody != null) {
                            try {
                                responseBody.close();
                            }
                            catch (Exception exception2) {}
                        }
                    }
                    if (exception == null) {
                        listener.onCompletion(jsonObject, null);
                    } else {
                        listener.onCompletion(jsonObject, new Error("", code, exception.toString()));
                    }
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startTask(Request request, final TTVNetClient.CompletionListener listener) {
        Class<TTHTTPNetwork> clazz = TTHTTPNetwork.class;
        synchronized (TTHTTPNetwork.class) {
            if (this.mStatus == 3 || this.mStatus == 1) {
                TTVideoEngineLog.i(TAG, "_startTask status error, return. " + this.mStatus);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            this.mStatus = 1;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.mCall = mClient.newCall(request);
            this.mCall.enqueue(new Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Call call, IOException e) {
                    TTVideoEngineLog.d(TTHTTPNetwork.TAG, "onFailure:" + e.toString());
                    Class<TTHTTPNetwork> clazz = TTHTTPNetwork.class;
                    synchronized (TTHTTPNetwork.class) {
                        if (TTHTTPNetwork.this.mStatus == 3) {
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return;
                        }
                        TTHTTPNetwork.this.mStatus = 2;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        TTHTTPNetwork.this._receivedError(call, e, listener);
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(Call call, Response response) throws IOException {
                    Class<TTHTTPNetwork> clazz = TTHTTPNetwork.class;
                    synchronized (TTHTTPNetwork.class) {
                        if (TTHTTPNetwork.this.mStatus == 3) {
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return;
                        }
                        TTHTTPNetwork.this.mStatus = 2;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        ResponseBody responseBody = null;
                        String errorStr = null;
                        JSONObject jsonBody = null;
                        int code = -1;
                        try {
                            responseBody = response.body();
                            try {
                                String responseBStr = responseBody.string();
                                jsonBody = new JSONObject(responseBStr);
                                TTVideoEngineLog.d(TTHTTPNetwork.TAG, "startTask onResponse body:" + responseBStr);
                            }
                            catch (Exception e) {
                                errorStr = e.toString();
                                e.printStackTrace();
                                code = -9994;
                            }
                            if (!response.isSuccessful()) {
                                errorStr = response.message();
                                code = response.code();
                            }
                        }
                        finally {
                            if (responseBody != null) {
                                try {
                                    responseBody.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (errorStr == null) {
                            listener.onCompletion(jsonBody, null);
                        } else {
                            listener.onCompletion(jsonBody, new Error("", -9994, code, errorStr));
                        }
                        return;
                    }
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTask(String urlString, Map<String, String> headers, JSONObject jsonBody, int method, final TTVNetClient.RawCompletionListener listener) {
        Class<TTHTTPNetwork> clazz = TTHTTPNetwork.class;
        synchronized (TTHTTPNetwork.class) {
            this.setupClient();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            Request.Builder builder = new Request.Builder().url(urlString);
            if (headers != null && headers.size() > 0) {
                for (String key : headers.keySet()) {
                    String value = headers.get(key);
                    builder.addHeader(key, value);
                }
            }
            if (method == 1) {
                RequestBody body = RequestBody.create((MediaType)JSON, (String)String.valueOf(jsonBody));
                builder.post(body);
            }
            this.mCall = mClient.newCall(builder.build());
            this.mCall.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    TTVideoEngineLog.d(TTHTTPNetwork.TAG, "startTask onFailure: " + e.toString());
                    listener.onCompletion(null, new Error("", -9994, e.toString()));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(Call call, Response response) throws IOException {
                    ResponseBody responseBody = null;
                    String errorStr = null;
                    Object jsonBody = null;
                    String responseBStr = null;
                    int code = -1;
                    try {
                        responseBody = response.body();
                        responseBStr = responseBody.string();
                        TTVideoEngineLog.d(TTHTTPNetwork.TAG, "startTask onResponse body:" + responseBStr);
                        if (!response.isSuccessful()) {
                            errorStr = response.message();
                            code = response.code();
                        }
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                    if (errorStr == null) {
                        listener.onCompletion(responseBStr, null);
                    } else if (code == -9979) {
                        listener.onCompletion(null, new Error("", -9979, code, errorStr));
                    } else {
                        listener.onCompletion(responseBStr, new Error("", -9994, code, errorStr));
                    }
                }
            });
            return;
        }
    }

    private void _receivedError(Call call, IOException e, TTVNetClient.CompletionListener listener) {
        if (!mIsRetryWhenFail) {
            listener.onCompletion(null, new Error("", -9994, e.toString()));
            return;
        }
        Request request = call.request();
        if (SystemClock.elapsedRealtime() - this.mStartTime < (long)(mMaxRetryTimeOut * 1000 - 500)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this._startTask(request, listener);
        } else {
            listener.onCompletion(null, new Error("", -9994, e.toString()));
        }
    }

    @Override
    public void cancel() {
        if (this.mCall != null && !this.mCall.isCanceled()) {
            this.mCall.cancel();
        }
    }
}

