/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.portrait;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ss.ttvideoengine.TTNetWorkListener;
import com.ss.ttvideoengine.info.networkRTTLevelListener;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class NetworkPortraitData {
    private static final String TAG = "NetworkPortraitData";
    private static final String NET_PORTRAIT_DATA = "net-portrait-data";
    private static final int MIN_NETWORK_DATA_MS = 120000;
    private List<Integer> mCatowerRttList = Collections.emptyList();
    private List<Integer> mCatowerRttMsList = Collections.emptyList();
    private List<String> mSignalStrengthList = Collections.emptyList();
    private Map<Long, Float> mMdlSpeedList = Collections.emptyMap();
    private networkRTTLevelListener mRTTLevelListener;
    private Timer mTimer;
    private TimerTask mTimerTask;
    private volatile int mNetLevelMaxCount = 100;
    private volatile int mNetTimerTaskIntervalMs = 0;
    private volatile int mNetMinDataSize = 120000;

    public synchronized void start() {
        if (this.mNetTimerTaskIntervalMs <= 0) {
            TTVideoEngineLog.e(TAG, "invalid parameter");
            return;
        }
        if (this.mCatowerRttList == Collections.EMPTY_LIST) {
            this.mCatowerRttList = new ArrayList<Integer>();
        }
        if (this.mCatowerRttMsList == Collections.EMPTY_LIST) {
            this.mCatowerRttMsList = new ArrayList<Integer>();
        }
        if (this.mSignalStrengthList == Collections.EMPTY_LIST) {
            this.mSignalStrengthList = new ArrayList<String>();
        }
        if (this.mMdlSpeedList == Collections.EMPTY_MAP) {
            this.mMdlSpeedList = new LinkedHashMap<Long, Float>();
        }
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
        }
        if (this.mTimer == null) {
            this.mTimer = new Timer(NET_PORTRAIT_DATA);
        }
        this.mTimerTask = new MyTimerTask();
        this.mTimer.schedule(this.mTimerTask, 500L, (long)this.mNetTimerTaskIntervalMs);
        TTVideoEngineLog.d(TAG, "network timer task scheduled, interval " + this.mNetTimerTaskIntervalMs);
    }

    public synchronized void stop() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
            this.mTimerTask = null;
        }
    }

    public synchronized void schedule(@NonNull TimerTask task) {
        if (this.mTimer == null) {
            this.mTimer = new Timer(NET_PORTRAIT_DATA);
        }
        this.mTimer.schedule(task, 1000L, (long)this.mNetTimerTaskIntervalMs);
        if (this.mTimerTask == null) {
            this.mTimerTask = new MyTimerTask();
            this.mTimer.schedule(this.mTimerTask, 1000L, (long)this.mNetTimerTaskIntervalMs);
        }
        TTVideoEngineLog.d(TAG, "network timer task scheduled, interval " + this.mNetTimerTaskIntervalMs);
    }

    public void setMaxCount(int maxCount) {
        if (maxCount < 0) {
            return;
        }
        if (maxCount < 10) {
            maxCount = 10;
        }
        this.mNetLevelMaxCount = maxCount;
    }

    public void setSampleInterval(int interval) {
        if (interval < 0) {
            return;
        }
        if (interval < 500) {
            interval = 500;
        }
        this.mNetTimerTaskIntervalMs = interval;
    }

    public void setMinDataSize(int ms) {
        this.mNetMinDataSize = ms;
    }

    public void setNetworkRTTLevelListener(networkRTTLevelListener networkRTTLevelListener2) {
        this.mRTTLevelListener = networkRTTLevelListener2;
    }

    public int getNetworkRTTLevel() {
        if (this.mRTTLevelListener != null) {
            return this.mRTTLevelListener.onNetworkLog();
        }
        return -1;
    }

    public int getNetworkRTTMS() {
        if (this.mRTTLevelListener != null) {
            return this.mRTTLevelListener.getNetworkRTTMs();
        }
        return -1;
    }

    public void setNetSpeed(float speed) {
        try {
            if (this.mMdlSpeedList != null) {
                if (this.mMdlSpeedList.size() > this.mNetLevelMaxCount) {
                    Long key = this.mMdlSpeedList.keySet().iterator().next();
                    this.mMdlSpeedList.remove(key);
                }
                this.mMdlSpeedList.put(System.currentTimeMillis(), Float.valueOf(speed));
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.e(TAG, e.getMessage());
        }
    }

    @NonNull
    public List<Integer> getRttHistoryData(int size) {
        return this.getSubListToMeetMinSize(this.mCatowerRttList, size);
    }

    @NonNull
    public List<Integer> getRttMsHistoryData(int size) {
        return this.getSubListToMeetMinSize(this.mCatowerRttMsList, size);
    }

    @NonNull
    public List<Float> getNetSpeedHistoryData(int size) {
        return this.getSubListToMeetMinSize(new ArrayList<Float>(this.mMdlSpeedList.values()), size);
    }

    private <T> List<T> getSubListToMeetMinSize(List<T> list, int size) {
        if (this.mNetTimerTaskIntervalMs == 0) {
            return new ArrayList();
        }
        int needSize = this.mNetMinDataSize / this.mNetTimerTaskIntervalMs - size;
        if (needSize <= 0) {
            return new ArrayList();
        }
        if (needSize > list.size()) {
            return new ArrayList<T>(list);
        }
        return list.subList(list.size() - needSize, list.size());
    }

    @Nullable
    public List<Integer> getRttList() {
        return this.mCatowerRttList;
    }

    @Nullable
    public List<String> getSignalStrengthList() {
        return this.mSignalStrengthList;
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int rttLevel = NetworkPortraitData.this.getNetworkRTTLevel();
            int rttMs = NetworkPortraitData.this.getNetworkRTTMS();
            String sigLevel = TTNetWorkListener.getInstance().getSignalStrength();
            TTVideoEngineLog.d(NetworkPortraitData.TAG, "timer rtt:" + rttLevel + " siglevel:" + sigLevel);
            MyTimerTask myTimerTask = this;
            synchronized (myTimerTask) {
                int size = NetworkPortraitData.this.mCatowerRttList.size();
                if (size >= NetworkPortraitData.this.mNetLevelMaxCount) {
                    NetworkPortraitData.this.mCatowerRttList.remove(0);
                    NetworkPortraitData.this.mCatowerRttMsList.remove(0);
                    NetworkPortraitData.this.mSignalStrengthList.remove(0);
                }
                NetworkPortraitData.this.mCatowerRttList.add(rttLevel);
                NetworkPortraitData.this.mCatowerRttMsList.add(rttMs);
                NetworkPortraitData.this.mSignalStrengthList.add(sigLevel);
            }
        }
    }
}

