/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.portrait;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.log.PortraitNetworkScore;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.portrait.IPortrait;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class PortraitEngine {
    private static final String TAG = "PortraitEngine";
    public static final String LABEL_NET_QUALITY_SPEED = "clinet_quality_speed";
    public static final String LABEL_NET_QUALITY_STABILITY = "clinet_quality_stability";
    public static final String LABEL_DEVICE_SCORE = "device_score";
    private final ConcurrentHashMap<String, Object> mLabelMap = new ConcurrentHashMap();
    private final IPortrait mPortraitNetwork = PortraitNetworkScore.getInstance();

    public void setLabel(@NonNull String key, @NonNull Object value) {
        this.mLabelMap.put(key, value);
    }

    @Nullable
    public Object getLabel(@NonNull String key) {
        return this.mLabelMap.get(key);
    }

    public void updateLabelByVideoModel(@NonNull IVideoModel model) {
        String didLabels = model.getVideoRefStr(244);
        if (TextUtils.isEmpty((CharSequence)didLabels)) {
            return;
        }
        try {
            JSONObject obj = new JSONObject(didLabels);
            if (obj.has(LABEL_NET_QUALITY_SPEED)) {
                this.mLabelMap.put(LABEL_NET_QUALITY_SPEED, obj.optInt(LABEL_NET_QUALITY_SPEED));
            }
            if (obj.has(LABEL_NET_QUALITY_STABILITY)) {
                this.mLabelMap.put(LABEL_NET_QUALITY_STABILITY, obj.optInt(LABEL_NET_QUALITY_STABILITY));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, Object> getEventData() {
        return new HashMap<String, Object>(this.mLabelMap);
    }

    @NonNull
    public IPortrait getPortrait(int id) {
        if (id == 1) {
            return this.mPortraitNetwork;
        }
        return IPortrait.EMPTY;
    }

    public static PortraitEngine getInstance() {
        return Holder.Instance;
    }

    private static class Holder {
        private static final PortraitEngine Instance = new PortraitEngine();

        private Holder() {
        }
    }
}

