/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.preload;

import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

public class PreloadUtil {
    private static final String TAG = "PreloadUtil";
    private static final String CancelReasonByBuffering = "buffering";
    private static final String CancelReasonByLowPlayBuffer = "low_buffer";
    private static final int mMaxPlayCount = 2;
    public long mPlayBufferLowerBound = 0L;
    public long mPlayBufferUpperBound = 0L;
    private final ReentrantLock mPlayInfoLock = new ReentrantLock();
    private final HashMap<String, PlayInfo> mPlayInfoMap = new HashMap();

    public void updatePlayInfo(int key1, String key2, String vid, long value) {
        PlayInfo playInfo;
        this.mPlayInfoLock.lock();
        if (!this.mPlayInfoMap.containsKey(vid)) {
            if (this.mPlayInfoMap.size() >= 2) {
                this.mPlayInfoMap.clear();
            }
            playInfo = new PlayInfo();
            playInfo.mVideoID = vid;
            this.mPlayInfoMap.put(vid, playInfo);
        }
        if ((playInfo = this.mPlayInfoMap.get(vid)) == null) {
            this.mPlayInfoLock.unlock();
            return;
        }
        switch (key1) {
            case 22: {
                playInfo.mDuration = value;
                break;
            }
            case 23: {
                playInfo.mLastPlayPosition = value;
                this.checkPlayBuffer(vid);
                break;
            }
            case 25: {
                this.cancelPreload(CancelReasonByBuffering, vid);
                break;
            }
            case 27: {
                playInfo.mLastPlayableBuffer = value;
                this.checkPlayBuffer(vid);
                break;
            }
        }
        this.mPlayInfoLock.unlock();
    }

    public void notifyCacheEnd(String key) {
        this.mPlayInfoLock.lock();
        if (!this.mPlayInfoMap.containsKey(key)) {
            if (this.mPlayInfoMap.size() >= 2) {
                this.mPlayInfoMap.clear();
            }
            this.mPlayInfoMap.put(key, new PlayInfo());
        }
        TTVideoEngineLog.d(TAG, "key :" + key + " cache end.");
        PlayInfo playInfo = this.mPlayInfoMap.get(key);
        if (playInfo != null) {
            playInfo.mCacheEnd = true;
            if (!playInfo.mTriggered) {
                TTVideoEngineLog.d(TAG, "cached video trigger preload " + key + " cache end ");
                DataLoaderHelper.getDataLoader().notifyTriggerPreload(playInfo.mLastPlayableBuffer);
                playInfo.mTriggered = true;
            }
        } else {
            TTVideoEngineLog.d(TAG, "key :" + key + " play info null");
        }
        this.mPlayInfoLock.unlock();
    }

    public void removePlayInfo(String key) {
        this.mPlayInfoLock.lock();
        if (this.mPlayInfoMap.containsKey(key)) {
            this.mPlayInfoMap.remove(key);
        }
        this.mPlayInfoLock.unlock();
    }

    private void checkPlayBuffer(String key) {
        PlayInfo playInfo = this.mPlayInfoMap.get(key);
        if (playInfo == null) {
            return;
        }
        if (playInfo.mLastPlayableBuffer > this.mPlayBufferUpperBound && !playInfo.mTriggered) {
            TTVideoEngineLog.d(TAG, "trigger preload " + key + " playable buffer is: " + playInfo.mLastPlayableBuffer);
            DataLoaderHelper.getDataLoader().notifyTriggerPreload(playInfo.mLastPlayableBuffer);
            playInfo.mTriggered = true;
        }
        if (playInfo.mCacheEnd || playInfo.mDuration > 0L && playInfo.mLastPlayableBuffer + playInfo.mLastPlayPosition + 1000L >= playInfo.mDuration) {
            if (!playInfo.mTriggered) {
                TTVideoEngineLog.d(TAG, "cached video trigger preload " + key + " playable buffer is: " + playInfo.mLastPlayableBuffer);
                DataLoaderHelper.getDataLoader().notifyTriggerPreload(playInfo.mLastPlayableBuffer);
                playInfo.mTriggered = true;
            }
            return;
        }
        if (playInfo.mLastPlayableBuffer < this.mPlayBufferLowerBound) {
            long count = DataLoaderHelper.getDataLoader().getPreloadTaskCount();
            if (playInfo.mTriggered && count > 0L) {
                this.cancelPreload(CancelReasonByLowPlayBuffer, key);
                playInfo.mTriggered = false;
            }
        }
    }

    private void cancelPreload(String reason, String key) {
        TTVideoEngineLog.d(TAG, "cancel preload because:" + reason + " traceId:" + key);
        DataLoaderHelper.getDataLoader().cancelAllTasks();
        DataLoaderHelper.getDataLoader().notifyPreloadCancelled(reason, key);
    }

    static class PlayInfo {
        long mLastPlayableBuffer = 0L;
        long mLastPlayPosition = 0L;
        long mDuration = 0L;
        String mVideoID = "";
        boolean mCacheEnd = false;
        boolean mTriggered = false;

        PlayInfo() {
        }
    }
}

