/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.source;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.source.Source;
import com.ss.ttvideoengine.strategy.source.StrategySource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class VidPlayAuthTokenSource
implements StrategySource {
    public static final String TAG = "VidPlayAuthTokenSource";
    public static final List<String> DEFAULT_SUPPORTED_ENCODE_TYPES = Collections.unmodifiableList(Arrays.asList("h264", "h265", "h266"));
    private final String vid;
    private final String playAuthToken;
    private final String encodeType;
    private final List<String> supportedEncodeTypes;
    private final Resolution resolution;
    private final int codecStrategy;

    private VidPlayAuthTokenSource(Builder builder) {
        this.vid = builder.vid;
        this.playAuthToken = builder.playAuthToken;
        this.encodeType = builder.encodeType;
        this.supportedEncodeTypes = builder.supportedEncodeTypes;
        this.resolution = builder.resolution;
        this.codecStrategy = builder.codecStrategy;
    }

    @Override
    public Source.Type type() {
        return Source.Type.VID_PLAY_AUTH_TOKEN_SOURCE;
    }

    @Override
    @NonNull
    public String vid() {
        return this.vid;
    }

    @NonNull
    public String playAuthToken() {
        return this.playAuthToken;
    }

    @Nullable
    public String encodeType() {
        return this.encodeType;
    }

    public List<String> supportedEncodeTypes() {
        return Collections.unmodifiableList(this.supportedEncodeTypes);
    }

    @Override
    public int codecStrategy() {
        return this.codecStrategy;
    }

    @NonNull
    public Resolution resolution() {
        return this.resolution;
    }

    public String toString() {
        return "VidPlayAuthTokenSource{vid='" + this.vid + '\'' + ", playAuthToken='" + this.playAuthToken + '\'' + ", encodeType='" + this.encodeType + '\'' + ", supportedEncodeTypes=" + this.supportedEncodeTypes + ", resolution=" + (Object)((Object)this.resolution) + ", codecStrategy=" + this.codecStrategy + '}';
    }

    public static class Builder {
        private String vid;
        private String playAuthToken;
        private String encodeType;
        private List<String> supportedEncodeTypes;
        private Resolution resolution;
        private int codecStrategy;

        public Builder() {
        }

        public Builder(VidPlayAuthTokenSource source) {
            this.vid = source.vid;
            this.playAuthToken = source.playAuthToken;
            this.encodeType = source.encodeType;
            this.resolution = source.resolution;
            this.codecStrategy = source.codecStrategy;
        }

        public Builder setVid(@NonNull String vid) {
            if (vid == null) {
                throw new NullPointerException("vid is null");
            }
            this.vid = vid;
            return this;
        }

        public Builder setPlayAuthToken(@NonNull String playAuthToken) {
            if (playAuthToken == null) {
                throw new NullPointerException("playAuthToken is null");
            }
            this.playAuthToken = playAuthToken;
            return this;
        }

        public Builder setEncodeType(@Nullable String encodeType) {
            this.encodeType = encodeType;
            return this;
        }

        public Builder setSupportedEncodeTypes(@NonNull List<String> list) {
            if (list == null || list.isEmpty()) {
                throw new IllegalArgumentException("supportedEncodeTypes can't be null or empty!");
            }
            this.supportedEncodeTypes = new ArrayList<String>(list);
            return this;
        }

        public Builder setResolution(@Nullable Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder setCodecStrategy(int codecStrategy) {
            this.codecStrategy = codecStrategy;
            return this;
        }

        public VidPlayAuthTokenSource build() {
            if (this.vid == null) {
                throw new NullPointerException("vid is null");
            }
            if (this.playAuthToken == null) {
                throw new NullPointerException("playAuthToken is null");
            }
            if (this.resolution == null) {
                this.resolution = Resolution.Standard;
            }
            if (this.supportedEncodeTypes != null && this.encodeType != null && !this.supportedEncodeTypes.contains(this.encodeType)) {
                throw new IllegalArgumentException("supportedEncodeTypes:" + this.supportedEncodeTypes + " must contains encodeType:" + this.encodeType);
            }
            if (this.supportedEncodeTypes == null || this.supportedEncodeTypes.isEmpty()) {
                this.supportedEncodeTypes = DEFAULT_SUPPORTED_ENCODE_TYPES;
            }
            return new VidPlayAuthTokenSource(this);
        }
    }
}

