/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.source.strategy;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.AppInfo;
import com.ss.ttvideoengine.FeatureManager;
import com.ss.ttvideoengine.InfoWrapper;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.selector.BestResolution;
import com.ss.ttvideoengine.source.DirectUrlSource;
import com.ss.ttvideoengine.source.Source;
import com.ss.ttvideoengine.source.VidPlayAuthTokenSource;
import com.ss.ttvideoengine.strategy.source.StrategySource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CodecStrategy {
    public static final String TAG = "CodecStrategy";
    public static final int KEY_COST_SAVING_FIST = 1;
    public static final int KEY_HARDWARE_DECODE_FIRST = 2;
    public static final List<Dimension> COST_SAVING_FIRST_LIST = Collections.unmodifiableList(Arrays.asList(Dimension.h266_SOFTWARE, Dimension.h265_HARDWARE, Dimension.h265_SOFTWARE, Dimension.H264_HARDWARE, Dimension.H264_SOFTWARE));
    public static final List<Dimension> HARDWARE_DECODE_FIRST_LIST = Collections.unmodifiableList(Arrays.asList(Dimension.h265_HARDWARE, Dimension.H264_HARDWARE, Dimension.h266_SOFTWARE, Dimension.h265_SOFTWARE, Dimension.H264_SOFTWARE));
    public static final List<Dimension> FALLBACK_LIST = Collections.unmodifiableList(Arrays.asList(Dimension.H264_SOFTWARE, Dimension.H264_HARDWARE, Dimension.h265_SOFTWARE, Dimension.h265_HARDWARE, Dimension.h266_SOFTWARE));

    public static boolean isCodecStrategyValid(int codecStrategy) {
        return codecStrategy == 1 || codecStrategy == 2;
    }

    private static List<Dimension> supportedDimensions(StrategySource source, List<Dimension> dimensions) {
        List<String> supportedEncodeTypes = null;
        if (source.type() == Source.Type.VID_PLAY_AUTH_TOKEN_SOURCE) {
            supportedEncodeTypes = ((VidPlayAuthTokenSource)source).supportedEncodeTypes();
        }
        ArrayList<Dimension> supportedDimensions = new ArrayList<Dimension>();
        for (Dimension dimension : dimensions) {
            if (!Decoder.isSupport(dimension) || supportedEncodeTypes != null && !supportedEncodeTypes.contains(dimension.encodeType)) continue;
            supportedDimensions.add(dimension);
        }
        return supportedDimensions;
    }

    public static List<Dimension> dimensions(StrategySource source) {
        int codecStrategy = source.codecStrategy();
        if (codecStrategy == 1) {
            return CodecStrategy.supportedDimensions(source, COST_SAVING_FIRST_LIST);
        }
        if (codecStrategy == 2) {
            return CodecStrategy.supportedDimensions(source, HARDWARE_DECODE_FIRST_LIST);
        }
        throw new IllegalArgumentException("unsupported strategy! " + codecStrategy);
    }

    public static List<Dimension> fallbackDimensions(StrategySource source) {
        return CodecStrategy.supportedDimensions(source, FALLBACK_LIST);
    }

    @Nullable
    public static ResolveResult resolveStartPlayback(@NonNull StrategySource source, boolean enableSmartUrl) {
        List<Dimension> candidates = CodecStrategy.dimensions(source);
        Source.Type type = source.type();
        switch (type) {
            case DIRECT_URL_SOURCE: {
                DirectUrlSource directUrl = (DirectUrlSource)source;
                if (SmartUrlVod.isEnable(directUrl) && enableSmartUrl) {
                    return CodecStrategy.resolveSmartUrl(directUrl, candidates, null);
                }
                return CodecStrategy.resolveDirectUrl(directUrl, candidates, null);
            }
            case VID_PLAY_AUTH_TOKEN_SOURCE: {
                return CodecStrategy.resolveVidPlayAuthToken((VidPlayAuthTokenSource)source, candidates, null);
            }
        }
        throw new IllegalArgumentException("unsupported type! " + (Object)((Object)type));
    }

    @Nullable
    public static ResolveResult resolveFallback(@NonNull StrategySource source, @Nullable List<Dimension> errors) {
        List<Dimension> candidates = CodecStrategy.fallbackDimensions(source);
        Source.Type type = source.type();
        switch (type) {
            case DIRECT_URL_SOURCE: {
                return CodecStrategy.resolveDirectUrl((DirectUrlSource)source, candidates, errors);
            }
            case VID_PLAY_AUTH_TOKEN_SOURCE: {
                return CodecStrategy.resolveVidPlayAuthToken((VidPlayAuthTokenSource)source, candidates, errors);
            }
        }
        throw new IllegalArgumentException("unsupported type! " + (Object)((Object)type));
    }

    @Nullable
    public static Dimension resolveWithEncoderType(@NonNull String encoderType, @NonNull StrategySource source, @Nullable List<Dimension> errors) {
        List<Dimension> candidates = CodecStrategy.dimensions(source);
        for (Dimension dimension : candidates) {
            if (errors != null && errors.contains((Object)dimension) || !TextUtils.equals((CharSequence)encoderType, (CharSequence)dimension.encodeType)) continue;
            return dimension;
        }
        return null;
    }

    @Nullable
    private static ResolveResult resolveVidPlayAuthToken(@NonNull VidPlayAuthTokenSource source, @NonNull List<Dimension> candidates, @Nullable List<Dimension> excludes) {
        for (Dimension dimension : candidates) {
            if (excludes != null && excludes.contains((Object)dimension) || source.encodeType() != null && !TextUtils.equals((CharSequence)source.encodeType(), (CharSequence)dimension.encodeType)) continue;
            return new ResolveResult(source, dimension);
        }
        return null;
    }

    @Nullable
    private static ResolveResult resolveSmartUrl(@NonNull DirectUrlSource source, @NonNull List<Dimension> candidates, @Nullable List<Dimension> excludes) {
        List<DirectUrlSource.UrlItem> items = source.allItems();
        if (items.isEmpty()) {
            return null;
        }
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        for (Dimension dimension : candidates) {
            if (excludes != null && excludes.contains((Object)dimension)) continue;
            dimensions.add(dimension);
        }
        if (dimensions.isEmpty()) {
            return null;
        }
        for (Dimension dimension : dimensions) {
            DirectUrlSource.UrlItem urlItem = source.findItemByEncodeType(dimension.encodeType);
            if (urlItem != null) {
                return new ResolveResult(source, dimension, urlItem, null);
            }
            if (!TextUtils.equals((CharSequence)dimension.encodeType, (CharSequence)SmartUrlVod.encodeType())) continue;
            DirectUrlSource.UrlItem requestItem = source.firstItem();
            return new ResolveResult(source, dimension, null, requestItem);
        }
        return null;
    }

    @Nullable
    private static ResolveResult resolveDirectUrl(@NonNull DirectUrlSource source, @NonNull List<Dimension> candidates, @Nullable List<Dimension> excludes) {
        List<DirectUrlSource.UrlItem> items = source.allItems();
        if (items.isEmpty()) {
            return null;
        }
        for (Dimension dimension : candidates) {
            DirectUrlSource.UrlItem urlItem;
            if (excludes != null && excludes.contains((Object)dimension) || (urlItem = source.findItemByEncodeType(dimension.encodeType)) == null) continue;
            return new ResolveResult(source, dimension, urlItem, null);
        }
        return null;
    }

    public static String dump() {
        return "smartUrl=" + InfoWrapper.getSmartUrlEnabled() + ", 4_h=" + InfoWrapper.getH264HardwareEnable() + ", b_h=" + InfoWrapper.geth265HardwareEnable() + ", b_s=" + InfoWrapper.geth265SoftwareEnable() + ", b_s_cap=" + InfoWrapper.geth265SoftwareCapabilityEnable() + ", b2_s=" + InfoWrapper.geth266SoftwareEnable();
    }

    public static class ResolveResult {
        @NonNull
        public final Dimension dimension;
        @Nullable
        public Dimension correctedDimension;
        @NonNull
        public final StrategySource source;
        @Nullable
        public final DirectUrlSource.UrlItem urlItem;
        @Nullable
        public final DirectUrlSource.UrlItem requestItem;

        public ResolveResult(@NonNull VidPlayAuthTokenSource source, @NonNull Dimension dimension) {
            this.source = source;
            this.dimension = dimension;
            this.urlItem = null;
            this.requestItem = null;
        }

        public ResolveResult(@NonNull DirectUrlSource source, @NonNull Dimension dimension, @Nullable DirectUrlSource.UrlItem urlItem, @Nullable DirectUrlSource.UrlItem requestItem) {
            this.source = source;
            this.dimension = dimension;
            this.urlItem = urlItem;
            this.requestItem = requestItem;
        }

        public String toString() {
            return "ResolveResult{vid=" + this.source.vid() + ", sourceType=" + (Object)((Object)this.source.type()) + ", dimension=" + (Object)((Object)this.dimension) + ", correctedDimension=" + (Object)((Object)this.correctedDimension) + ", urlItem=" + this.urlItem + ", requestItem=" + this.requestItem + '}';
        }
    }

    public static enum Dimension {
        h265_HARDWARE(1, "h265"),
        h265_SOFTWARE(0, "h265"),
        h266_SOFTWARE(0, "h266"),
        H264_HARDWARE(1, "h264"),
        H264_SOFTWARE(0, "h264");

        public final int decoder;
        public final String encodeType;

        private Dimension(int decoder, String encodeType) {
            this.decoder = decoder;
            this.encodeType = encodeType;
        }
    }

    public static final class Decoder {
        public static final int SOFTWARE = 0;
        public static final int HARDWARE = 1;

        public static boolean isSupport(Dimension dimension) {
            return Decoder.isDeviceSupport(dimension) && Decoder.isSDKSupport(dimension);
        }

        private static boolean isDeviceSupport(Dimension dimension) {
            switch (dimension) {
                case h265_HARDWARE: {
                    return Decoder.isSupporth265HardwareDecode();
                }
                case h265_SOFTWARE: {
                    return Decoder.isSupporth265SoftwareDecode();
                }
                case h266_SOFTWARE: {
                    if (Decoder.isSupporth265SoftwareDecode()) {
                        return Decoder.isSupporth266SoftWareDecode();
                    }
                    return false;
                }
                case H264_HARDWARE: {
                    return Decoder.isSupportH264HardwareDecode();
                }
                case H264_SOFTWARE: {
                    return true;
                }
            }
            throw new IllegalArgumentException("unsupported dimension! " + (Object)((Object)dimension));
        }

        private static boolean isSDKSupport(Dimension dimension) {
            switch (dimension) {
                case h265_HARDWARE: {
                    return true;
                }
                case H264_HARDWARE: {
                    return true;
                }
                case h266_SOFTWARE: {
                    return FeatureManager.hasPermission("h266");
                }
                case h265_SOFTWARE: {
                    return Decoder.isSupporth265SoftwareCapability();
                }
                case H264_SOFTWARE: {
                    return true;
                }
            }
            throw new IllegalArgumentException("unsupported dimension! " + (Object)((Object)dimension));
        }

        private static boolean isSupporth265HardwareDecode() {
            return InfoWrapper.geth265HardwareEnable() == 1;
        }

        private static boolean isSupporth265SoftwareDecode() {
            return InfoWrapper.geth265SoftwareEnable() == 1;
        }

        private static boolean isSupporth266SoftWareDecode() {
            return InfoWrapper.geth266SoftwareEnable() == 1;
        }

        private static boolean isSupportH264HardwareDecode() {
            return InfoWrapper.getH264HardwareEnable() == 1;
        }

        private static boolean isSupporth265SoftwareCapability() {
            return InfoWrapper.geth265SoftwareCapabilityEnable() == 1;
        }
    }

    public static final class SmartUrlVod {
        private static final Resolution SMART_URL_DEFAULT_RESOLUTION = Resolution.SuperHigh;

        public static boolean isEnable(DirectUrlSource source) {
            return source.isSmartUrlValid() && SmartUrlVod.isSettingsEnable();
        }

        public static boolean isSettingsEnable() {
            return InfoWrapper.getSmartUrlEnabled() == 1;
        }

        public static Resolution videoResolution() {
            return SMART_URL_DEFAULT_RESOLUTION;
        }

        public static String encodeType() {
            return "h265";
        }

        public static String getApiHost() {
            return AppInfo.getSmartUrlApiHost();
        }

        public static Resolution findTargetResolution(IVideoModel videoModel) {
            return BestResolution.findDefaultResolution(videoModel, SmartUrlVod.videoResolution());
        }
    }
}

