/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategy.preload;

import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.strategy.StrategyManager;
import com.ss.ttvideoengine.strategy.StrategySettings;
import com.ss.ttvideoengine.strategy.preload.PreloadListener;
import com.ss.ttvideoengine.strategy.preload.PreloadSync;
import com.ss.ttvideoengine.strategy.source.StrategySource;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;

public class StrategyPreload {
    private static final String TAG = "Strategy Preload";
    private static final String COUNT = "count";
    private static final String SIZE = "size";
    private static final String START_BUFFER_LIMIT = "start_buffer_limit";
    private static final String STOP_BUFFER_LIMIT = "stop_buffer_limit";
    private int mCount = 3;
    private int mSize = 800;
    private int mStartBufferLimitInS = 14;
    private int mStopBufferLimitInS = 5;
    private boolean mEnable;
    private boolean mEnablePreload;
    private final PreloadListener mListener;
    private final Set<String> mPreloadedList = new HashSet<String>();
    private final int mScene;
    private PreloadSync mPreloadSync;

    public StrategyPreload(int scene, PreloadListener listener) {
        this.mScene = scene;
        this.mListener = listener;
        this.updateConfig();
    }

    public void start() {
        TTVideoEngineLog.d(TAG, "start");
        this.mEnable = true;
        this.startPreload(this.getPlayingEngine());
    }

    public void stop() {
        TTVideoEngineLog.d(TAG, "stop");
        this.mEnable = false;
        this.stopPreload();
    }

    public void updateSource() {
        this.stopPreload();
        this.startPreload(this.getPlayingEngine());
    }

    public void updateConfig() {
        JSONObject preloadConfig = StrategySettings.getInstance().getPreload(this.mScene);
        TTVideoEngineLog.d(TAG, "updateConfig " + preloadConfig);
        if (preloadConfig == null) {
            return;
        }
        this.mCount = preloadConfig.optInt(COUNT, 3);
        this.mSize = preloadConfig.optInt(SIZE, 800);
        this.mStartBufferLimitInS = preloadConfig.optInt(START_BUFFER_LIMIT, 14);
        this.mStopBufferLimitInS = preloadConfig.optInt(STOP_BUFFER_LIMIT, 5);
    }

    public void updateEngine() {
        this.stopPreload();
    }

    public void onCacheEnd(TTVideoEngine engine) {
        if (!this.isPlayingEngine(engine)) {
            return;
        }
        if (!this.mEnablePreload) {
            TTVideoEngineLog.d(TAG, "onCacheEnd start preload");
            this.mEnablePreload = true;
            this.startPreload(engine);
        }
    }

    public void onCacheSize(TTVideoEngine engine, long cacheSizeInMS) {
        if (!this.isPlayingEngine(engine)) {
            return;
        }
        if (this.mEnablePreload && cacheSizeInMS < (long)this.mStopBufferLimitInS * 1000L) {
            this.stopPreload();
            return;
        }
        if (!this.mEnablePreload && cacheSizeInMS > (long)this.mStartBufferLimitInS * 1000L) {
            TTVideoEngineLog.d(TAG, "onCacheSize " + cacheSizeInMS + " start preload");
            this.mEnablePreload = true;
            this.startPreload(engine);
        }
    }

    public void onBufferStart(TTVideoEngine engine) {
        TTVideoEngineLog.d(TAG, "onBufferStart " + engine);
        if (!this.isPlayingEngine(engine)) {
            return;
        }
        this.stopPreload();
    }

    private void startPreload(TTVideoEngine playEngine) {
        if (!this.mEnablePreload || !this.mEnable) {
            return;
        }
        if (playEngine == null || !this.isPlayingEngine(playEngine)) {
            return;
        }
        int playIndex = StrategyManager.instance().getPlayIndex();
        List<StrategySource> strategySources = StrategyManager.instance().getSource();
        TTVideoEngineLog.d(TAG, "startPreload play index " + playIndex);
        if (playIndex < 0 || playIndex >= strategySources.size() - 1) {
            return;
        }
        int startIndex = playIndex + 1;
        int lastIndex = Math.min(strategySources.size() - 1, startIndex + this.mCount - 1);
        ArrayList<StrategySource> preloadSources = new ArrayList<StrategySource>();
        for (int i = startIndex; i <= lastIndex; ++i) {
            preloadSources.add(strategySources.get(i));
        }
        this.mPreloadSync = new PreloadSync(new ArrayList<StrategySource>(preloadSources), this.mSize);
        this.mPreloadSync.setListener((result, vid) -> {
            if (result == 2) {
                this.mPreloadedList.add(vid);
            }
            if (this.mListener != null) {
                this.mListener.onResult(result, vid);
            }
        });
        this.mPreloadSync.start();
    }

    private void stopPreload() {
        if (!this.mEnablePreload) {
            return;
        }
        TTVideoEngineLog.d(TAG, "stopPreload");
        this.mEnablePreload = false;
        if (this.mPreloadSync != null) {
            this.mPreloadSync.stop();
            this.mPreloadSync = null;
        }
        TTVideoEngine.cancelAllPreloadTasks();
    }

    private boolean isPlayingEngine(TTVideoEngine engine) {
        return engine == StrategyManager.instance().getPlayEngine();
    }

    private TTVideoEngine getPlayingEngine() {
        return StrategyManager.instance().getPlayEngine();
    }

    public boolean isPreloaded(String videoID) {
        return this.mPreloadedList.contains(videoID);
    }
}

