/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule;

import com.bytedance.vcloud.cacheModule.CacheFileManager;
import com.bytedance.vcloud.cacheModule.PlaylistLoader;
import com.bytedance.vcloud.cacheModule.utils.CmLog;
import com.ss.mediakit.medialoader.AVMDLDataLoaderNotifyInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PlaylistLoaderManager {
    private static final String TAG = PlaylistLoaderManager.class.getSimpleName();
    private static final CacheFileManager.CacheFileType PRELOAD_FILE = CacheFileManager.CacheFileType.Preload;
    private final Map<String, PlaylistLoader> mPreloaders = new HashMap<String, PlaylistLoader>();
    private final Object mLock = new Object();
    private final List<PlaylistLoader.ILoaderListener> mListeners = new ArrayList<PlaylistLoader.ILoaderListener>();

    public static PlaylistLoaderManager getInstance() {
        return PlaylistLoaderMangerInner.sInstance;
    }

    public void preloadSource(String url, int size) {
        CmLog.d(TAG, "preloadSource : url = " + url);
        if (this.mPreloaders.containsKey(url)) {
            return;
        }
        PlaylistLoader playlistLoader = new PlaylistLoader(url, size);
        this.mPreloaders.put(url, playlistLoader);
        playlistLoader.setLoaderListener(new PlaylistLoader.ILoaderListener(){

            @Override
            public void onStart(String url, AVMDLDataLoaderNotifyInfo info) {
                for (PlaylistLoader.ILoaderListener item : PlaylistLoaderManager.this.mListeners) {
                    item.onStart(url, info);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCancel(String fileKey, String url) {
                PlaylistLoader playlistLoader = null;
                Iterator iterator = PlaylistLoaderManager.this.mLock;
                synchronized (iterator) {
                    if (PlaylistLoaderManager.this.mPreloaders.containsKey(url)) {
                        playlistLoader = (PlaylistLoader)PlaylistLoaderManager.this.mPreloaders.remove(url);
                    }
                }
                if (playlistLoader != null) {
                    playlistLoader.release();
                }
                for (PlaylistLoader.ILoaderListener item : PlaylistLoaderManager.this.mListeners) {
                    item.onCancel(fileKey, url);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(String url, AVMDLDataLoaderNotifyInfo info) {
                PlaylistLoader playlistLoader = null;
                Iterator iterator = PlaylistLoaderManager.this.mLock;
                synchronized (iterator) {
                    if (PlaylistLoaderManager.this.mPreloaders.containsKey(url)) {
                        playlistLoader = (PlaylistLoader)PlaylistLoaderManager.this.mPreloaders.remove(url);
                    }
                }
                if (playlistLoader != null) {
                    playlistLoader.release();
                }
                for (PlaylistLoader.ILoaderListener item : PlaylistLoaderManager.this.mListeners) {
                    item.onCompleted(url, info);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(String url, AVMDLDataLoaderNotifyInfo info) {
                PlaylistLoader playlistLoader = null;
                Iterator iterator = PlaylistLoaderManager.this.mLock;
                synchronized (iterator) {
                    if (PlaylistLoaderManager.this.mPreloaders.containsKey(url)) {
                        playlistLoader = (PlaylistLoader)PlaylistLoaderManager.this.mPreloaders.remove(url);
                    }
                }
                if (playlistLoader != null) {
                    playlistLoader.release();
                }
                for (PlaylistLoader.ILoaderListener item : PlaylistLoaderManager.this.mListeners) {
                    item.onError(url, info);
                }
            }
        });
        playlistLoader.preload();
    }

    public boolean isCacheKey(String fileKey) {
        boolean cacheKey = CacheFileManager.isCacheKey(fileKey, PRELOAD_FILE);
        CmLog.d(TAG, "isCacheKey : fileKey = " + fileKey + ":" + cacheKey);
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this.mLock;
        synchronized (object) {
            for (String key : this.mPreloaders.keySet()) {
                PlaylistLoader playlistLoader = this.mPreloaders.get(key);
                playlistLoader.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String fileKey) {
        CmLog.d(TAG, "cancel : fileKey = " + fileKey);
        PlaylistLoader playlistLoader = null;
        Object object = this.mLock;
        synchronized (object) {
            for (String url : this.mPreloaders.keySet()) {
                PlaylistLoader loader = this.mPreloaders.get(url);
                if (!loader.isMyKey(fileKey)) continue;
                playlistLoader = loader;
                break;
            }
        }
        if (playlistLoader != null) {
            CmLog.d(TAG, "cancel : playlistLoader = " + fileKey);
            playlistLoader.cancel();
        }
    }

    public long getCacheSize(String fileKey) {
        return CacheFileManager.getCacheSize(fileKey, PRELOAD_FILE);
    }

    public long getAllCacheSize() {
        return CacheFileManager.getAllPlaylistCacheSize(PRELOAD_FILE);
    }

    public void clearAllPlaylistCache() {
        CacheFileManager.clearAllPlaylistCache(PRELOAD_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFileCache(String fileKey) {
        PlaylistLoader playlistLoader = null;
        Object object = this.mLock;
        synchronized (object) {
            for (String url : this.mPreloaders.keySet()) {
                PlaylistLoader loader = this.mPreloaders.get(url);
                if (!loader.isMyKey(fileKey)) continue;
                playlistLoader = loader;
                break;
            }
        }
        if (playlistLoader != null) {
            return false;
        }
        CacheFileManager.removeFileCache(fileKey, PRELOAD_FILE);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onPreloadStatusChanged(String fileKey, PlaylistLoader.LoadStatus status, AVMDLDataLoaderNotifyInfo info) {
        CmLog.d(TAG, "onPreloadStatusChanged : fileKey = " + fileKey + ", status = " + status.name());
        Object object = this.mLock;
        synchronized (object) {
            for (String key : this.mPreloaders.keySet()) {
                PlaylistLoader playlistLoader = this.mPreloaders.get(key);
                if (!playlistLoader.isMyKey(fileKey)) continue;
                return playlistLoader.processTsPreloadStatus(fileKey, status, info);
            }
        }
        return false;
    }

    public void addLoaderListener(PlaylistLoader.ILoaderListener listener) {
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    public void removeLoaderListener(PlaylistLoader.ILoaderListener listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    private static class PlaylistLoaderMangerInner {
        private static final PlaylistLoaderManager sInstance = new PlaylistLoaderManager();

        private PlaylistLoaderMangerInner() {
        }
    }
}

