/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.content.Context;
import android.os.Looper;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class TTVideoEnginePool {
    private static final String TAG = "TTVideoEnginePool";
    public final int CORE_POOL_SIZE_UPPER_LIMIT = 0;
    private AtomicInteger corePoolSizeUpperLimit = new AtomicInteger(2);
    private Queue<TTVideoEngine> corePool = new LinkedBlockingQueue<TTVideoEngine>();
    private Set<TTVideoEngine> resetingEngines = new HashSet<TTVideoEngine>();
    private int refreshingEnginesCount = 0;
    private WeakHashMap<TTVideoEngine, Integer> weakHashOfEngineInUse = new WeakHashMap();
    private static volatile TTVideoEnginePool instance;

    private TTVideoEnginePool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TTVideoEnginePool getInstance() {
        if (instance != null) return instance;
        Class<TTVideoEnginePool> clazz = TTVideoEnginePool.class;
        synchronized (TTVideoEnginePool.class) {
            if (instance != null) return instance;
            instance = new TTVideoEnginePool();
            TTVideoEngineLog.i(TAG, "Construct TTVideoEnginePool");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public TTVideoEngine getEngine(Context context, int type) {
        return this.getEngine(context, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TTVideoEngine getEngine(Context context, int type, Map params) {
        TTVideoEngine ret;
        if (type != 0) {
            TTVideoEngine eng = new TTVideoEngine(context, type, params);
            TTVideoEngineLog.i(TAG, "getEngine finished, Engine:" + eng + " ,Type is :" + type + " , do not manage in Enginepool! ");
            return eng;
        }
        String str = "params is null, ";
        if (null != params) {
            str = "params is not null, ";
        }
        int corepoolSizeBeforeGetEngine = -1;
        TTVideoEnginePool tTVideoEnginePool = this;
        synchronized (tTVideoEnginePool) {
            corepoolSizeBeforeGetEngine = this.corePool.size();
            ret = this.corePool.poll();
            ++this.refreshingEnginesCount;
        }
        String str1 = "";
        if (null != ret) {
            ret.refreshEnginePara(context, type, params);
            ret.setStringOption(1205, "get existing from EnginePool");
            str1 = "get an existing Engine from corePool";
        } else {
            ret = new TTVideoEngine(context, type, params);
            ret.setStringOption(1205, "new by EnginePool");
            str1 = "create a new Engine by TTVideoEnginePool";
        }
        int countOfEngineInUse = -1;
        TTVideoEnginePool tTVideoEnginePool2 = this;
        synchronized (tTVideoEnginePool2) {
            this.weakHashOfEngineInUse.put(ret, 0);
            countOfEngineInUse = this.weakHashOfEngineInUse.size();
            --this.refreshingEnginesCount;
            this.notify();
        }
        ret.setIntOption(1206, this.corePoolSizeUpperLimit.get());
        ret.setIntOption(1207, corepoolSizeBeforeGetEngine);
        ret.setIntOption(1208, countOfEngineInUse);
        TTVideoEngineLog.i(TAG, "getEngine finished, " + str + str1 + ", Engine:  " + ret + ", corePool.size = " + this.corePool.size() + ", countOfEngineInUse:" + countOfEngineInUse);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void giveBackEngine(TTVideoEngine engine) {
        if (null == engine) {
            return;
        }
        if (!engine.isPlayerType(0)) {
            TTVideoEngineLog.i(TAG, "giveBackEngine , Engine:" + engine + " released directly, do not manage in Enginepool! ");
            engine.release();
            this.weakHashOfEngineInUse.remove(engine);
            return;
        }
        TTVideoEngineLog.i(TAG, "giveBackEngine Enter\uff0c Engine:" + engine);
        if (!engine.isPlayerType(0)) {
            TTVideoEngineLog.i(TAG, "giveBackEngine , Engine:" + engine + " released directly, do not manage in Enginepool! ");
            engine.release();
            this.weakHashOfEngineInUse.remove(engine);
            return;
        }
        TTVideoEngineLog.i(TAG, "giveBackEngine Enter\uff0c Engine:" + engine);
        TTVideoEnginePool tTVideoEnginePool = this;
        synchronized (tTVideoEnginePool) {
            if (this.resetingEngines.contains(engine) || this.corePool.contains(engine) || null != engine && 5 == engine.getIntOption(57) || null == engine) {
                TTVideoEngineLog.i(TAG, "giveBackEngine got canceled! because the engine has already been giveback before! Engine:" + engine);
                return;
            }
            this.resetingEngines.add(engine);
        }
        engine.resetByPoolSyncPart();
        TTVideoEngineLog.i(TAG, "giveBackEngine\uff0cbefore engine.resetByPoolEngine:" + engine);
        engine.resetByPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFinish(TTVideoEngine engine) {
        TTVideoEngineLog.i(TAG, "giveBackEngine resetFinish Enter, Engine:" + engine + ", curLooper:" + Looper.myLooper() + ", corePool.size = " + this.corePool.size());
        boolean needRelease = true;
        TTVideoEnginePool tTVideoEnginePool = this;
        synchronized (tTVideoEnginePool) {
            if (this.corePool.size() < this.corePoolSizeUpperLimit.get()) {
                if (this.corePool.offer(engine)) {
                    needRelease = false;
                    TTVideoEngineLog.i(TAG, "giveBackEngine Engine:" + engine + " give back to corePool");
                } else {
                    needRelease = true;
                    TTVideoEngineLog.i(TAG, "giveBackEngine Engine:" + engine + " , Warning:give back to corePool failed!");
                }
            }
        }
        if (needRelease) {
            TTVideoEngineLog.d(TAG, "giveBackEngine Engine:" + engine + " need release");
            engine.release();
            TTVideoEngineLog.i(TAG, "giveBackEngine Engine:" + engine + " released by TTVideoEnginePool");
        }
        int countOfEngineInUse = 0;
        TTVideoEnginePool tTVideoEnginePool2 = this;
        synchronized (tTVideoEnginePool2) {
            TTVideoEngineLog.d(TAG, "giveBackEngine Engine:" + engine + " remove...");
            this.weakHashOfEngineInUse.remove(engine);
            countOfEngineInUse = this.weakHashOfEngineInUse.size();
            this.resetingEngines.remove(engine);
            this.notify();
        }
        TTVideoEngineLog.i(TAG, "giveBackEngine resetFinish End, Engine:" + engine + ", corePool.size = " + this.corePool.size() + ", countOfEngineInUse:" + countOfEngineInUse);
    }

    public void setCorePoolSizeUpperLimit(int size) {
        this.corePoolSizeUpperLimit.set(size);
        TTVideoEngineLog.i(TAG, "setCorePoolSizeUpperLimit, size:" + size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCoreEngines() {
        TTVideoEnginePool tTVideoEnginePool = this;
        synchronized (tTVideoEnginePool) {
            int size = this.corePool.size();
            while (!this.corePool.isEmpty()) {
                TTVideoEngine engine = this.corePool.poll();
                if (null == engine) continue;
                engine.release();
            }
            TTVideoEngineLog.i(TAG, "releaseCoreEngines finished, corePool.size:" + size + " -> 0");
        }
    }

    public void releaseCoreEnginesAndCodecAsync() {
        EngineThreadPool.addExecuteTask(this::doReleaseCoreEnginesAndCodecAsync);
    }

    public synchronized void doReleaseCoreEnginesAndCodecAsync() {
        while (!this.resetingEngines.isEmpty() || 0 != this.refreshingEnginesCount) {
            try {
                TTVideoEngineLog.i(TAG, "releaseCoreEnginesAndCodecAsync thread enters wait mode. Current resetingEngines.size = " + this.resetingEngines.size() + ", refreshingEnginesCount = " + this.refreshingEnginesCount);
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int size = this.corePool.size();
        String logstr = "";
        if (this.corePool.isEmpty()) {
            logstr = "can not close codecpool because corePool is null";
        } else {
            while (!this.corePool.isEmpty()) {
                TTVideoEngine engine = this.corePool.poll();
                if (this.corePool.isEmpty()) {
                    if (!this.weakHashOfEngineInUse.isEmpty()) {
                        logstr = "do not close codecpool because weakHashOfEngineInUse is not Empty!";
                    } else if (null != engine) {
                        engine.setIntOption(985, 1);
                        logstr = "do close codecpool!";
                    }
                }
                if (null == engine) continue;
                engine.release();
            }
        }
        TTVideoEngineLog.i(TAG, "releaseCoreEnginesAndCodecAsync finished, corePool.size:" + size + " -> 0, " + logstr);
    }

    public int getIntStatus(int key) {
        int ret = 0;
        switch (key) {
            case 0: {
                ret = this.corePoolSizeUpperLimit.get();
            }
        }
        return ret;
    }
}

