/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.download;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.JniUtils;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.download.DownloadTask;
import com.ss.ttvideoengine.download.IDownloadVidTaskListener;
import com.ss.ttvideoengine.fetcher.FetcherApiHelper;
import com.ss.ttvideoengine.fetcher.VideoInfoFetcher;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.FormatProvider;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import com.ss.ttvideoengine.utils.TTVideoEngineUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class DownloadVidTask
extends DownloadTask {
    private static final String TAG = "TTVideoEngine.DownloadVidTask";
    private Resolution resolution = null;
    private String codecType = "h264";
    private boolean baseDashEnable = false;
    private boolean httpsEnable = false;
    private boolean boeEnable = false;
    private VideoInfoFetcher fetcher = null;
    private VideoModel videoModel = null;
    private int apiVersion = 0;
    private Map<Integer, String> params = null;
    private HashMap<String, Resolution> resolutionMap = null;
    private Resolution currentResolution = null;
    private String apiString = null;
    private String authString = null;
    private String fallbackAPI = null;
    private String keySeed = null;
    Context mContext = null;
    private TTVNetClient netClient = null;
    private IDownloadVidTaskListener fetchListener = null;
    private int retryCount = 0;

    private DownloadVidTask() {
    }

    static DownloadVidTask taskItem() {
        DownloadVidTask task = new DownloadVidTask();
        task.setupBaseFiled();
        return task;
    }

    static DownloadVidTask taskItem(String videoId, Resolution resolution, boolean h265Enable, boolean baseDashEnable, boolean httpsEnable) {
        String codecType = "h264";
        if (h265Enable) {
            codecType = "h265";
        }
        return DownloadVidTask.taskItem(videoId, resolution, codecType, baseDashEnable, httpsEnable);
    }

    static DownloadVidTask taskItem(String videoId, Resolution resolution, String codecType, boolean baseDashEnable, boolean httpsEnable) {
        return DownloadVidTask.taskItem(videoId, resolution, codecType, baseDashEnable, httpsEnable, null);
    }

    static DownloadVidTask taskItem(String videoId, Resolution resolution, String codecType, boolean baseDashEnable, boolean httpsEnable, String authToken) {
        return DownloadVidTask.taskItem(videoId, resolution, codecType, baseDashEnable, httpsEnable, authToken, DownloadTask.EncryptVersion.NONE);
    }

    static DownloadVidTask taskItem(String videoId, Resolution resolution, String codecType, boolean baseDashEnable, boolean httpsEnable, String authToken, DownloadTask.EncryptVersion encryptVersion) {
        TTVideoEngineLog.d(TAG, "taskItem videoId:" + videoId + ", resolution:" + (Object)((Object)resolution) + ", codecType:" + codecType + ", baseDashEnable:" + baseDashEnable + ", httpsEnable:" + httpsEnable + ",authToken:" + authToken);
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            TTVideoEngineLog.d(TAG, "[downloader] videoId is invalid");
            return null;
        }
        if (resolution == null) {
            TTVideoEngineLog.d(TAG, "[downloader]  resolution is invalid");
            return null;
        }
        DownloadVidTask task = DownloadVidTask.taskItem();
        task.videoId = videoId;
        task.resolution = resolution;
        task.codecType = TextUtils.isEmpty((CharSequence)codecType) ? "h264" : codecType;
        task.baseDashEnable = baseDashEnable;
        task.httpsEnable = httpsEnable;
        task.authToken = authToken;
        task.encryptVersion = encryptVersion;
        return task;
    }

    @Nullable
    static DownloadVidTask taskItem(VideoModel videoModel, Resolution resolution) {
        if (videoModel == null || resolution == null) {
            TTVideoEngineLog.d(TAG, "[downloader] videoModel or resolution is invalid");
            return null;
        }
        String videoId = videoModel.getVideoRefStr(2);
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            TTVideoEngineLog.d(TAG, "[downloader] videoId is invalid");
            return null;
        }
        DownloadVidTask task = DownloadVidTask.taskItem();
        task.videoId = videoId;
        task.setVideoModel(videoModel);
        task.resolution = resolution;
        if (Arrays.asList(videoModel.getCodecs()).contains("h266")) {
            task.codecType = "h266";
        } else if (Arrays.asList(videoModel.getCodecs()).contains("h265")) {
            task.codecType = "h265";
        }
        String dtype = videoModel.getDynamicType();
        if (dtype != null) {
            task.baseDashEnable = dtype.equals("segment_base");
        }
        task.httpsEnable = videoModel.getVideoRefBool(106);
        return task;
    }

    @Override
    public String getVideoId() {
        return this.videoId;
    }

    public void setNetClient(TTVNetClient netClient) {
        this.netClient = netClient;
    }

    @Nullable
    public TTVNetClient getNetClient() {
        return this.netClient;
    }

    public void setFetchListener(IDownloadVidTaskListener fetchListener) {
        this.fetchListener = fetchListener;
    }

    @Nullable
    public IDownloadVidTaskListener getFetchListener() {
        return this.fetchListener;
    }

    public void setApiVersion(int apiVersion) {
        this.apiVersion = apiVersion;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    @Nullable
    public VideoModel getVideoModel() {
        return this.videoModel;
    }

    public void setVideoModel(VideoModel videoModel) {
        this.videoModel = videoModel;
        this.mMediaType = DownloadTask.MediaType.Unknown;
        String temFallBackApi = videoModel.getVideoRefStr(217);
        String temKeySeed = videoModel.getVideoRefStr(218);
        if (!TextUtils.isEmpty((CharSequence)temFallBackApi)) {
            this.fallbackAPI = temFallBackApi;
            TTVideoEngineLog.i(TAG, "[downloader] set fallbackapi " + temFallBackApi);
        }
        if (!TextUtils.isEmpty((CharSequence)temKeySeed)) {
            this.keySeed = temKeySeed;
            TTVideoEngineLog.i(TAG, "[downloader] set keyseed " + this.keySeed);
        }
    }

    public boolean isBaseDashEnable() {
        return this.baseDashEnable;
    }

    public boolean ish265Enable() {
        return this.codecType.equals("h265");
    }

    public boolean ish266Enable() {
        return this.codecType.equals("h266");
    }

    public boolean isHttpsEnable() {
        return this.httpsEnable;
    }

    public boolean isBoeEnable() {
        return this.boeEnable;
    }

    public void setBoeEnable(boolean boeEnable) {
        this.boeEnable = boeEnable;
    }

    @Nullable
    public Resolution getCurrentResolution() {
        return this.currentResolution;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setParams(Map<Integer, String> params) {
        this.params = params;
    }

    @Nullable
    public Map<Integer, String> getParams() {
        return this.params;
    }

    public void setResolutionMap(HashMap<String, Resolution> resolutionMap) {
        this.resolutionMap = resolutionMap;
    }

    @Nullable
    public HashMap<String, Resolution> getResolutionMap() {
        return this.resolutionMap;
    }

    @Override
    public void invalidateAndCancel() {
        if (this.fetcher != null) {
            this.fetcher.cancel();
        }
        super.invalidateAndCancel();
    }

    @Override
    public void suspend() {
        TTVideoEngineLog.d(TAG, "[downloader] did call suspend, videoId = " + this.videoId);
        if (this.canceled) {
            TTVideoEngineLog.d(TAG, "[downloader] task did canceled");
            return;
        }
        if (this.getState() == 3 || this.getState() == 0 || this.getState() == 5) {
            TTVideoEngineLog.d(TAG, "[downloader] not need suspend, state = " + this.getState());
            return;
        }
        if (!this.downloader.suspended(this)) {
            TTVideoEngineLog.d(TAG, "[downloader] suspend task, task in waiting, taskIdentifier: " + this.taskIdentifier);
            return;
        }
        super.suspend();
        if (this.mediaKeys != null && this.mediaKeys.size() > 0) {
            for (int i = 0; i < this.mediaKeys.size(); ++i) {
                String key = (String)this.mediaKeys.get(i);
                DataLoaderHelper.getDataLoader().suspendedDownload(key);
            }
        }
    }

    @Override
    public void resume() {
        TTVideoEngineLog.d(TAG, "[downloader] did call resume, videoId = " + this.videoId);
        if (this.canceled) {
            TTVideoEngineLog.d(TAG, "[downloader] task did canceled");
            return;
        }
        if (this.getState() == 2) {
            TTVideoEngineLog.d(TAG, "[downloader] state is running");
            return;
        }
        super.resume();
        if (this.downloader != null && !this.downloader.shouldResume(this)) {
            return;
        }
        this.retryCount = 0;
        this.setState(2);
        if (this.downloader != null) {
            this.downloader.resume(this);
        }
        if (this.getVideoModel() != null) {
            this._downloadWithVideoModel(this.getVideoModel());
        } else {
            this._fetchVideoModel();
        }
    }

    @Override
    void setupBaseFiled() {
        super.setupBaseFiled();
        this.retryCount = 0;
        this.taskType = "vid_task";
        this.apiVersion = 0;
        this.resolution = Resolution.Standard;
    }

    @Override
    void receiveError(Error err) {
        if (this._shouldRetry(err)) {
            ++this.retryCount;
            this._fetchVideoModel();
        } else {
            super.receiveError(err);
        }
    }

    @Override
    @Nullable
    public String getAvailableLocalFilePath() {
        if (this.baseDashEnable) {
            return null;
        }
        if (this.getVideoModel() != null && this.getVideoModel().getSpadea() != null) {
            return null;
        }
        return super.getAvailableLocalFilePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void assignWithJson(JSONObject jsonObject) {
        JSONObject mapObject;
        JSONObject paramObject;
        JSONObject baseObject = jsonObject.optJSONObject("base_json");
        super.assignWithJson(baseObject);
        this.codecType = jsonObject.optString("codec_type");
        this.baseDashEnable = jsonObject.optBoolean("base_dash");
        this.httpsEnable = jsonObject.optBoolean("https");
        this.boeEnable = jsonObject.optBoolean("boe");
        this.resolution = Resolution.forString(jsonObject.optString("resolution"));
        if (this.resolution == Resolution.Undefine) {
            this.resolution = Resolution.Standard;
        }
        if ((paramObject = jsonObject.optJSONObject("param")) != null && paramObject.length() > 0) {
            this.params = new HashMap<Integer, String>();
            Iterator keys = paramObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.params.put(Integer.valueOf(key), paramObject.optString(key));
            }
        }
        if ((mapObject = jsonObject.optJSONObject("resolution_map")) != null && mapObject.length() > 0) {
            this.resolutionMap = new HashMap();
            Iterator keys = mapObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.resolutionMap.put(key, Resolution.forString(mapObject.optString(key)));
            }
        }
        this.apiVersion = jsonObject.optInt("api_version");
        this.currentResolution = Resolution.forString(jsonObject.optString("curr_resolution"));
        JSONObject modelObject = jsonObject.optJSONObject("video_model");
        if (modelObject != null && modelObject.length() > 0) {
            VideoModel temModel = new VideoModel();
            try {
                temModel.extractFields(modelObject);
            }
            catch (Throwable e) {
                TTVideoEngineLog.e(TAG, "[downloader] ssignWithJson fail.");
                temModel = null;
            }
            finally {
                this.setVideoModel(temModel);
            }
        }
    }

    @Override
    boolean _shouldRetry(Error error) {
        if (!super._shouldRetry(error)) {
            return false;
        }
        return this.retryCount < 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    JSONObject jsonObject() {
        HashMap map = new HashMap();
        DownloadVidTask.putToMap(map, "base_json", super.mapInfo());
        DownloadVidTask.putToMap(map, "codec_type", this.codecType);
        DownloadVidTask.putToMap(map, "base_dash", this.baseDashEnable);
        DownloadVidTask.putToMap(map, "https", this.httpsEnable);
        DownloadVidTask.putToMap(map, "boe", this.boeEnable);
        DownloadVidTask.putToMap(map, "resolution", Resolution.toString(this.resolution));
        DownloadVidTask.putToMap(map, "param", this.params);
        if (this.resolutionMap != null && this.resolutionMap.size() > 0) {
            HashMap<String, String> temMap = new HashMap<String, String>();
            for (String key : this.resolutionMap.keySet()) {
                temMap.put(key, Resolution.toString(this.resolutionMap.get(key)));
            }
            DownloadVidTask.putToMap(map, "resolution_map", temMap);
        }
        DownloadVidTask.putToMap(map, "api_version", this.apiVersion);
        DownloadVidTask.putToMap(map, "curr_resolution", Resolution.toString(this.currentResolution));
        JSONObject jsonObject = new JSONObject(map);
        try {
            if (this.getVideoModel() != null) {
                jsonObject.putOpt("video_model", (Object)this.getVideoModel().getJsonInfo());
            }
        }
        catch (JSONException e) {
            TTVideoEngineLog.e(TAG, "[downloader] jsonObject fail.");
        }
        finally {
            return jsonObject;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        if (!obj.getClass().equals(DownloadVidTask.class)) {
            return false;
        }
        DownloadVidTask other = (DownloadVidTask)obj;
        if (this.mediaKeys != null && this.mediaKeys.size() > 0 && other.mediaKeys != null) {
            return this.mediaKeys.equals(other.mediaKeys);
        }
        boolean result = false;
        result = this.videoId != null && other.videoId != null ? this.videoId.equals(other.videoId) : this.videoId == null && other.videoId == null;
        result = result && this.baseDashEnable == other.baseDashEnable;
        result = result && this.codecType.equals(other.codecType);
        result = result && this.resolution == other.resolution;
        return result;
    }

    private boolean _downloadUrlInfo(VideoInfo info) {
        String[] urls = null;
        String key = null;
        if (info != null) {
            urls = info.getValueStrArr(16);
            key = info.getValueStr(15);
        }
        if (urls == null || urls.length < 1 || TextUtils.isEmpty((CharSequence)key)) {
            String domain = "kTTVideoErrorDomainFetchingInfo";
            int code = -9996;
            int innerCode = 0;
            String errDes = "error info  urls or filehash is null: apiString = " + this.apiString + " authString = " + this.authString + " filehash = " + key;
            Error error = new Error(domain, code, innerCode, errDes);
            this.receiveError(error);
            return false;
        }
        TTVideoEngineLog.d(TAG, "[downloader] download urlinfo videoId = " + this.videoId + " " + info.getResolution().toString() + " filehash = " + key);
        this.mediaKeys.add(key);
        this.usingUrls.put(key, Arrays.asList(urls));
        String downloadUrl = DataLoaderHelper.getDataLoader().downloadUrl(key, this.videoId, urls, this.encryptVersion.getVersion(), this.customDir);
        boolean isM3u = FormatProvider.FormatProviderHolder.isM3u8(urls[0]);
        this.mMediaType = isM3u ? DownloadTask.MediaType.M3u8 : DownloadTask.MediaType.Other;
        boolean result = DataLoaderHelper.getDataLoader().startDownload(downloadUrl, isM3u);
        if (!result) {
            this.receiveError(new Error("kTTVideoErrorDomainDownload", -9996, 0, "resume download fail. url = " + downloadUrl + " dataloader state is " + DataLoaderHelper.getDataLoader().isRunning()));
            return false;
        }
        return true;
    }

    private void _downloadWithVideoModel(VideoModel model) {
        this.mediaKeys.clear();
        this.usingUrls = new HashMap();
        String dynamicType = model.getDynamicType();
        if (!TextUtils.isEmpty((CharSequence)dynamicType) && dynamicType.equals("segment_base")) {
            VideoInfo temVideoInfo;
            VideoInfo temAudioInfo = model.getVideoInfo(this.resolution, VideoRef.TYPE_AUDIO, this.params, true);
            if (temAudioInfo != null) {
                if (!this._downloadUrlInfo(temAudioInfo)) {
                    return;
                }
                this.currentResolution = temAudioInfo.getResolution();
            }
            if ((temVideoInfo = model.getVideoInfo(this.resolution, VideoRef.TYPE_VIDEO, this.params, true)) != null) {
                if (!this._downloadUrlInfo(temVideoInfo)) {
                    return;
                }
                this.currentResolution = temVideoInfo.getResolution();
            }
        } else {
            VideoInfo temVideoInfo = model.getVideoInfo(this.resolution, this.params, true);
            if (!this._downloadUrlInfo(temVideoInfo)) {
                return;
            }
            this.currentResolution = temVideoInfo.getResolution();
        }
    }

    private void _fetchVideoModel() {
        this.apiString = null;
        this.authString = null;
        this.fetcher = null;
        this.fetcher = new VideoInfoFetcher(this.mContext, this.netClient);
        this.fetcher.setListener(new MyFetcherListener(this));
        this.fetcher.setResolutionMap(this.resolutionMap);
        this.fetcher.setVideoID(this.videoId);
        this.fetcher.setUseVideoModelCache(true);
        if (!TextUtils.isEmpty((CharSequence)this.fallbackAPI)) {
            int method = 0;
            try {
                method = JniUtils.getDecodeMethod();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.apiString = String.format("%s&method=%d", this.fallbackAPI, method);
            if (this.boeEnable) {
                this.apiString = TTHelper.buildBoeUrl(this.apiString);
            }
        } else {
            this.apiVersion = 4;
            FetcherApiHelper apiHelper = new FetcherApiHelper(this.authToken, this.codecType);
            String apiString = apiHelper.getAPIString();
            this.fetcher.fetchInfo(apiString, null, 4);
            return;
        }
        this.apiString = TTVideoEngineUtils.BuildHttpsApi(this.apiString);
        TTVideoEngineLog.i(TAG, String.format("[downloader] api string from fallback api:%s ,keySeed = %s", this.apiString, this.keySeed));
        this.fetcher.setUseFallbakApi(true);
        this.fetcher.fetchInfo(this.apiString, null, 0, this.keySeed);
    }

    private class MyFetcherListener
    implements VideoInfoFetcher.FetcherListener {
        private final WeakReference<DownloadVidTask> mTaskItemRef;

        public MyFetcherListener(DownloadVidTask taskItem) {
            this.mTaskItemRef = new WeakReference<DownloadVidTask>(taskItem);
        }

        @Override
        public void onRetry(Error error) {
        }

        @Override
        public void onCompletion(VideoModel model, Error error) {
            DownloadVidTask vidTask = (DownloadVidTask)this.mTaskItemRef.get();
            if (vidTask == null) {
                return;
            }
            TTVideoEngineLog.d(DownloadVidTask.TAG, "did fetch video modeo, videoId is " + vidTask.videoId);
            if (vidTask.getState() == 4 || vidTask.getState() == 5) {
                TTVideoEngineLog.d(DownloadVidTask.TAG, "but state is canceled. videoId = " + vidTask.videoId);
                return;
            }
            if (model != null) {
                vidTask.setVideoModel(model);
                if (vidTask.getState() == 3) {
                    TTVideoEngineLog.d(DownloadVidTask.TAG, "but state is suspended. videoId = " + vidTask.videoId);
                    return;
                }
                vidTask._downloadWithVideoModel(model);
            } else if (error != null) {
                vidTask.receiveError(error);
            }
        }

        @Override
        public void onStatusException(int status, String message) {
            DownloadVidTask vidTask = (DownloadVidTask)this.mTaskItemRef.get();
            if (vidTask == null) {
                return;
            }
            String domain = "kTTVideoErrorDomainFetchingInfo";
            int code = -9996;
            int innerCode = status;
            String errDes = "error info: apiString = " + DownloadVidTask.this.apiString + " authString = " + DownloadVidTask.this.authString + " apiVersion = " + DownloadVidTask.this.apiVersion + " state = " + status;
            Error error = new Error(domain, code, innerCode, errDes);
            vidTask.receiveError(error);
        }

        @Override
        public void onLog(String message) {
        }
    }
}

