/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.httpdns;

import android.content.Context;
import android.os.SystemClock;
import com.bytedancehttpdns.httpdns.DnsResult;
import com.bytedancehttpdns.httpdns.HttpDns;
import com.bytedancehttpdns.httpdns.IHttpDnsDepend;
import com.ss.mediakit.net.AVMDLCustomHTTPDNSParser;
import com.ss.mediakit.net.AVMDLCustomHTTPDNSParserResult;
import com.ss.mediakit.net.AVMDLDNSParser;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.httpdns.ByteDanceHttpDnsDepend;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.List;

public class BytedanceHTTPDNSParser
implements AVMDLCustomHTTPDNSParser {
    public static final int DNS_TYPE_CUSTOM_INNER_BYTEDANCE_HTTPDNS = 1;
    private static final String TAG = "BytedanceHTTPDNSParser";
    private final ByteDanceHttpDnsDepend mByteDanceHttpDnsDepend;

    public BytedanceHTTPDNSParser(ByteDanceHttpDnsDepend byteDanceHttpDnsDepend) {
        TTVideoEngineLog.d(TAG, "new parser depend:" + byteDanceHttpDnsDepend);
        this.mByteDanceHttpDnsDepend = byteDanceHttpDnsDepend;
        this.setHttpDnsDepend();
    }

    public AVMDLCustomHTTPDNSParserResult parseHost(String host) {
        TTVideoEngineLog.i(TAG, "parseHost " + host);
        long start = SystemClock.elapsedRealtime();
        DnsResult result = HttpDns.getService().getHttpDnsResultForHostSyncBlock(host);
        long time = SystemClock.elapsedRealtime() - start;
        TTVideoEngineLog.d(TAG, "parseHost result:" + result + ", time:" + time);
        if (result == null) {
            TTVideoEngineLog.i(TAG, "parseHost result DnsResult is null");
            return null;
        }
        ArrayList<String> allIps = new ArrayList<String>();
        if (result.ipv4List != null && result.ipv4List.size() > 0) {
            allIps.addAll(result.ipv4List);
        }
        if (result.ipv6List != null && result.ipv6List.size() > 0) {
            allIps.addAll(result.ipv6List);
        }
        if (allIps.size() <= 0) {
            TTVideoEngineLog.i(TAG, "parseHost result DnsResult ipList is null");
            return null;
        }
        String ipList = this.listToIPList(allIps);
        int ttl = (int)result.ttl;
        TTVideoEngineLog.i(TAG, "parseHost result host:" + host + "ipList:" + ipList + ", ttl:" + ttl);
        return new AVMDLCustomHTTPDNSParserResult(host, ipList, ttl);
    }

    private void setHttpDnsDepend() {
        HttpDns.getService().setHttpDnsDepend(new IHttpDnsDepend(){

            public Context getContext() {
                if (BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend != null) {
                    return BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend.getContext();
                }
                return null;
            }

            public String getHttpdnsAccountID() {
                if (BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend != null) {
                    return BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend.getHttpdnsAccountID();
                }
                return null;
            }

            public String getHttpdnsSecretKey() {
                if (BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend != null) {
                    return BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend.getHttpdnsSecretKey();
                }
                return null;
            }

            public boolean isTemporaryAuthentication() {
                if (BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend != null) {
                    return BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend.isTemporaryAuthentication();
                }
                return false;
            }

            public long getHttpdnsTemporaryKeyTimeStamp() {
                if (BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend != null) {
                    return BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend.getHttpdnsTemporaryKeyTimeStamp();
                }
                return 0L;
            }

            public String[] getPreloadDomains() {
                if (BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend != null) {
                    return BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend.getPreloadDomains();
                }
                return new String[0];
            }

            public String getAppId() {
                if (BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend != null) {
                    return BytedanceHTTPDNSParser.this.mByteDanceHttpDnsDepend.getAppId();
                }
                return null;
            }
        });
    }

    public String listToIPList(List<String> list) {
        StringBuilder ipList = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                ipList.append(",");
            }
            ipList.append(list.get(i));
        }
        return ipList.toString();
    }

    public int start() {
        TTVideoEngineLog.d(TAG, "start");
        TTVideoEngine.setIntValue(1127, 1);
        TTVideoEngine.setIntValue(7, 1);
        TTVideoEngine.setIntValue(90, 4);
        TTVideoEngine.setIntValue(91, 0);
        TTVideoEngine.setIntValue(92, 1);
        TTVideoEngine.setIntValue(8, 1);
        AVMDLDNSParser.setCustomHttpDNSParser((AVMDLCustomHTTPDNSParser)this);
        return 1;
    }
}

