/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetUtils {
    public static final int NETTYPE_UNKNOWN = -1;
    public static long netUpdateTimeMs = -1L;
    public static boolean registerNetworkReceiver = false;
    private static final BroadcastReceiver networkReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (this.isInitialStickyBroadcast()) {
                return;
            }
            if (!"android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                return;
            }
            netUpdateTimeMs = System.currentTimeMillis();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkInfo getNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        try {
            if (!registerNetworkReceiver) {
                BroadcastReceiver broadcastReceiver = networkReceiver;
                synchronized (broadcastReceiver) {
                    if (!registerNetworkReceiver) {
                        registerNetworkReceiver = true;
                        context.getApplicationContext().registerReceiver(networkReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                    }
                }
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            return connectivityManager.getActiveNetworkInfo();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static int getNetType(Context context) {
        try {
            NetworkInfo info = NetUtils.getNetworkInfo(context);
            if (info != null && info.isAvailable()) {
                return info.getType();
            }
            return -1;
        }
        catch (Throwable e) {
            return -1;
        }
    }

    public static String getNetExtraInfo(Context context) {
        try {
            NetworkInfo info = NetUtils.getNetworkInfo(context);
            if (info != null && info.isAvailable()) {
                return info.getExtraInfo();
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean isNetAvailable(Context context) {
        NetworkInfo info = NetUtils.getNetworkInfo(context);
        return info != null && info.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(Context context) {
        try {
            BroadcastReceiver broadcastReceiver = networkReceiver;
            synchronized (broadcastReceiver) {
                if (registerNetworkReceiver && context != null) {
                    registerNetworkReceiver = false;
                    context.getApplicationContext().unregisterReceiver(networkReceiver);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

