/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public interface FormatProvider {
    public static final FormatProvider DEFAULT = new Default();
    public static final int FORMAT_NORMAL = 0;
    public static final int FORMAT_M3U8 = 1;
    public static final int FORMAT_MPD = 2;

    public int provideFormat(@NonNull String var1);

    public static class Default
    implements FormatProvider {
        private static boolean isM3u8(String url) {
            return url.contains(".m3u8?") || url.endsWith(".m3u8") || url.contains(".m3u?") || url.endsWith(".m3u");
        }

        private static boolean isMpd(String url) {
            return url.endsWith(".mpd") || url.contains(".mpd?");
        }

        @Override
        public int provideFormat(@NonNull String url) {
            if (url == null) {
                return 0;
            }
            String lowerCaseUrl = url.toLowerCase();
            if (Default.isM3u8(lowerCaseUrl)) {
                return 1;
            }
            if (Default.isMpd(lowerCaseUrl)) {
                return 2;
            }
            return 0;
        }
    }

    public static class FormatProviderHolder {
        private static FormatProvider sInstance = DEFAULT;

        public static boolean isM3u8(@Nullable String url) {
            if (url == null) {
                return false;
            }
            return FormatProviderHolder.get().provideFormat(url) == 1;
        }

        public static boolean isMpd(@Nullable String url) {
            if (url == null) {
                return false;
            }
            return FormatProviderHolder.get().provideFormat(url) == 2;
        }

        public static void set(FormatProvider provider) {
            sInstance = provider;
        }

        public static FormatProvider get() {
            if (sInstance == null) {
                return DEFAULT;
            }
            return sInstance;
        }
    }
}

