/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.view.Display;
import android.view.WindowManager;

public class ScreenUtils {
    public static final int MAX_SYSTEM_BRIGHTNESS = 255;
    public static final int MIN_SYSTEM_BRIGHTNESS = 0;

    public static int getScreenHeight() {
        return Resources.getSystem().getDisplayMetrics().heightPixels;
    }

    public static int getScreenWidth() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    public static int getScreenPixelDensity() {
        return Resources.getSystem().getDisplayMetrics().densityDpi;
    }

    public static float getScreenXdpi() {
        return Resources.getSystem().getDisplayMetrics().xdpi;
    }

    public static float getScreenYdpi() {
        return Resources.getSystem().getDisplayMetrics().ydpi;
    }

    public static Point getRealScreenSize(Context context) {
        Point point = new Point();
        WindowManager manager = (WindowManager)context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealSize(point);
        } else {
            display.getSize(point);
        }
        return point;
    }

    public static int getSystemBrightness(Context context) {
        int brightness = 0;
        try {
            brightness = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        return brightness;
    }

    public static float getNormalizedBrightness(Context context) {
        return (float)ScreenUtils.getSystemBrightness(context) * 1.0f / 255.0f;
    }
}

