/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule;

import com.bytedance.vcloud.cacheModule.CacheModuleLoader;
import com.ss.mediakit.medialoader.AVMDLDataLoader;

public class CacheFileManager {
    private static final String TAG = CacheFileManager.class.getSimpleName();

    public static void removeFileCache(String fileKey, CacheFileType type) {
        TsCacheNodeInfo[] tsNodeList = (TsCacheNodeInfo[])CacheFileManager.getTsCacheInfos(fileKey, type);
        CacheFileManager.removeHlsCacheWithoutTs(fileKey, type);
        if (tsNodeList == null) {
            return;
        }
        for (TsCacheNodeInfo info : tsNodeList) {
            if (info.version == 1 || info.version == 2 && info.keyType == 2) {
                AVMDLDataLoader.getInstance().removeFileCache(info.fileKey);
                continue;
            }
            if (info.version != 2 || info.keyType != 1) continue;
            CacheFileManager.removeFileCache(info.fileKey, type);
        }
    }

    public static long getCacheSize(String fileKey, CacheFileType type) {
        TsCacheNodeInfo[] tsNodeList;
        long cacheSize = -1L;
        long playlistCacheSize = CacheFileManager.getHlsCacheSizeWithoutTs(fileKey, type);
        if (playlistCacheSize > 0L) {
            cacheSize = playlistCacheSize;
        }
        if ((tsNodeList = (TsCacheNodeInfo[])CacheFileManager.getTsCacheInfos(fileKey, type)) == null) {
            return cacheSize;
        }
        for (TsCacheNodeInfo info : tsNodeList) {
            long subM3u8CacheSize;
            if (info.version == 1 || info.version == 2 && info.keyType == 2) {
                long tsCacheSize = AVMDLDataLoader.getInstance().getCacheSize(info.fileKey);
                if (tsCacheSize <= 0L) continue;
                cacheSize += tsCacheSize;
                continue;
            }
            if (info.version != 2 || info.keyType != 1 || (subM3u8CacheSize = CacheFileManager.getCacheSize(info.fileKey, type)) <= 0L) continue;
            cacheSize += subM3u8CacheSize;
        }
        return cacheSize;
    }

    public static long getHlsCacheSizeWithoutTs(String fileKey, CacheFileType type) {
        if (CacheModuleLoader.inited) {
            return CacheFileManager._getHlsCacheSizeWithoutTs(fileKey, type.ordinal());
        }
        return 0L;
    }

    public static long getAllPlaylistCacheSize(CacheFileType type) {
        if (CacheModuleLoader.inited) {
            return CacheFileManager._getAllHlsCacheSizeWithoutTs(type.ordinal());
        }
        return 0L;
    }

    public static void clearAllPlaylistCache(CacheFileType type) {
        if (CacheModuleLoader.inited) {
            CacheFileManager._removeAllHlsCacheWithoutTs(type.ordinal());
        }
    }

    private static void removeHlsCacheWithoutTs(String fileKey, CacheFileType type) {
        if (CacheModuleLoader.inited) {
            CacheFileManager._removeHlsCacheWithoutTs(fileKey, type.ordinal());
        }
    }

    private static Object[] getTsCacheInfos(String fileKey, CacheFileType type) {
        if (CacheModuleLoader.inited) {
            return CacheFileManager._getTsCacheInfos(fileKey, type.ordinal());
        }
        return null;
    }

    public static boolean isCacheKey(String fileKey, CacheFileType type) {
        if (CacheModuleLoader.inited) {
            return CacheFileManager._isCacheKey(fileKey, type.ordinal());
        }
        return false;
    }

    private static native void _removeHlsCacheWithoutTs(String var0, int var1);

    private static native long _getHlsCacheSizeWithoutTs(String var0, int var1);

    private static native Object[] _getTsCacheInfos(String var0, int var1);

    private static native boolean _isCacheKey(String var0, int var1);

    private static native long _getAllHlsCacheSizeWithoutTs(int var0);

    private static native void _removeAllHlsCacheWithoutTs(int var0);

    static {
        CacheModuleLoader.loadLibrary();
    }

    public static class TsCacheNodeInfo {
        public static final int KEY_TYPE_UNKNOWN = 0;
        public static final int KEY_TYPE_M3U8 = 1;
        public static final int KEY_TYPE_TS = 2;
        public int version = 1;
        public String fileKey = null;
        public int keyType = 0;
    }

    public static class HlsCacheNodeInfo {
        public int version = 1;
        public String fileKey = null;
    }

    public static enum CacheFileType {
        Unkown,
        Preload,
        Download;

    }
}

