/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule;

import com.bytedance.vcloud.cacheModule.CacheFileManager;
import com.bytedance.vcloud.cacheModule.PlaylistDownloader;
import com.bytedance.vcloud.cacheModule.utils.CmLog;
import com.ss.mediakit.medialoader.AVMDLDataLoaderNotifyInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PlaylistDownloaderManager {
    private static final String TAG = PlaylistDownloaderManager.class.getSimpleName();
    private static final CacheFileManager.CacheFileType DOWNLOAD_FILE = CacheFileManager.CacheFileType.Download;
    private final Map<String, PlaylistDownloader> mDownloaders = new HashMap<String, PlaylistDownloader>();
    private final Object mLock = new Object();
    private final List<PlaylistDownloader.IDownloadListener> mListeners = new ArrayList<PlaylistDownloader.IDownloadListener>();

    public static PlaylistDownloaderManager getInstance() {
        return PlaylistDownloaderMangerInner.sInstance;
    }

    public void downloadSource(String url) {
        CmLog.d(TAG, "downloadSource : url = " + url);
        if (this.mDownloaders.containsKey(url)) {
            return;
        }
        PlaylistDownloader playlistDownloader = new PlaylistDownloader(url);
        this.mDownloaders.put(url, playlistDownloader);
        playlistDownloader.setLoaderListener(new PlaylistDownloader.IDownloadListener(){

            @Override
            public void onStart(String url, AVMDLDataLoaderNotifyInfo info) {
                for (PlaylistDownloader.IDownloadListener item : PlaylistDownloaderManager.this.mListeners) {
                    item.onStart(url, info);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCancel(String fileKey, String url) {
                PlaylistDownloader playlistDownloader = null;
                Iterator iterator = PlaylistDownloaderManager.this.mLock;
                synchronized (iterator) {
                    if (PlaylistDownloaderManager.this.mDownloaders.containsKey(url)) {
                        playlistDownloader = (PlaylistDownloader)PlaylistDownloaderManager.this.mDownloaders.remove(url);
                    }
                }
                if (playlistDownloader != null) {
                    playlistDownloader.release();
                }
                for (PlaylistDownloader.IDownloadListener item : PlaylistDownloaderManager.this.mListeners) {
                    item.onCancel(fileKey, url);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(String url, AVMDLDataLoaderNotifyInfo info) {
                PlaylistDownloader playlistDownloader = null;
                Iterator iterator = PlaylistDownloaderManager.this.mLock;
                synchronized (iterator) {
                    if (PlaylistDownloaderManager.this.mDownloaders.containsKey(url)) {
                        playlistDownloader = (PlaylistDownloader)PlaylistDownloaderManager.this.mDownloaders.remove(url);
                    }
                }
                if (playlistDownloader != null) {
                    playlistDownloader.release();
                }
                for (PlaylistDownloader.IDownloadListener item : PlaylistDownloaderManager.this.mListeners) {
                    item.onCompleted(url, info);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(String url, AVMDLDataLoaderNotifyInfo info) {
                PlaylistDownloader playlistDownloader = null;
                Iterator iterator = PlaylistDownloaderManager.this.mLock;
                synchronized (iterator) {
                    if (PlaylistDownloaderManager.this.mDownloaders.containsKey(url)) {
                        playlistDownloader = (PlaylistDownloader)PlaylistDownloaderManager.this.mDownloaders.remove(url);
                    }
                }
                if (playlistDownloader != null) {
                    playlistDownloader.release();
                }
                for (PlaylistDownloader.IDownloadListener item : PlaylistDownloaderManager.this.mListeners) {
                    item.onError(url, info);
                }
            }

            @Override
            public void onProgress(String url, AVMDLDataLoaderNotifyInfo info) {
                for (PlaylistDownloader.IDownloadListener item : PlaylistDownloaderManager.this.mListeners) {
                    item.onProgress(url, info);
                }
            }
        });
        playlistDownloader.download();
    }

    public boolean isHlsDownloadKey(String fileKey) {
        boolean isDownloadKey = CacheFileManager.isCacheKey(fileKey, DOWNLOAD_FILE);
        CmLog.d(TAG, "isHlsDownloadKey, fileKey = " + fileKey + " : " + isDownloadKey);
        return isDownloadKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this.mLock;
        synchronized (object) {
            for (String key : this.mDownloaders.keySet()) {
                PlaylistDownloader playlistDownloader = this.mDownloaders.get(key);
                playlistDownloader.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String fileKey) {
        CmLog.d(TAG, "cancel : fileKey = " + fileKey);
        PlaylistDownloader playlistDownloader = null;
        Object object = this.mLock;
        synchronized (object) {
            for (String url : this.mDownloaders.keySet()) {
                PlaylistDownloader loader = this.mDownloaders.get(url);
                if (!loader.isMyKey(fileKey) || loader.isTsFileKey(fileKey)) continue;
                playlistDownloader = loader;
                break;
            }
        }
        if (playlistDownloader != null) {
            CmLog.d(TAG, "cancel : playlistDownloader = " + fileKey);
            playlistDownloader.cancel();
        }
    }

    public long getCacheSize(String fileKey) {
        return CacheFileManager.getCacheSize(fileKey, DOWNLOAD_FILE);
    }

    public long getAllCacheSize() {
        return CacheFileManager.getAllPlaylistCacheSize(DOWNLOAD_FILE);
    }

    public void clearAllPlaylistCache() {
        CacheFileManager.clearAllPlaylistCache(DOWNLOAD_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDownloadFile(String fileKey) {
        PlaylistDownloader playlistDownloader = null;
        Object object = this.mLock;
        synchronized (object) {
            for (String url : this.mDownloaders.keySet()) {
                PlaylistDownloader loader = this.mDownloaders.get(url);
                if (!loader.isMyKey(fileKey)) continue;
                playlistDownloader = loader;
                break;
            }
        }
        if (playlistDownloader != null) {
            return false;
        }
        CacheFileManager.removeFileCache(fileKey, DOWNLOAD_FILE);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onDownloadStatusChanged(String fileKey, PlaylistDownloader.DownloadStatus status, AVMDLDataLoaderNotifyInfo info) {
        CmLog.d(TAG, "onDownloadStatusChanged : fileKey = " + fileKey + ", status = " + status.name());
        Object object = this.mLock;
        synchronized (object) {
            for (String key : this.mDownloaders.keySet()) {
                PlaylistDownloader playlistDownloader = this.mDownloaders.get(key);
                if (!playlistDownloader.isMyKey(fileKey)) continue;
                return playlistDownloader.processStatusChange(fileKey, status, info);
            }
        }
        return false;
    }

    public void addLoaderListener(PlaylistDownloader.IDownloadListener listener) {
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    public void removeLoaderListener(PlaylistDownloader.IDownloadListener listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    private static class PlaylistDownloaderMangerInner {
        private static final PlaylistDownloaderManager sInstance = new PlaylistDownloaderManager();

        private PlaylistDownloaderMangerInner() {
        }
    }
}

