/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import com.ss.ttm.ttvideodecode.Native;
import com.ss.ttvideoengine.EngineGlobalConfig;
import com.ss.ttvideoengine.LibraryLoaderProxy;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class JniUtils {
    public static volatile LibraryLoaderProxy mProxy = null;
    public static volatile boolean isLibraryLoaded = false;
    public static volatile String exception = "";
    private static final String TAG = "JniUtils";

    public static void setLoadProxy(LibraryLoaderProxy proxy) {
        if (proxy != null) {
            mProxy = proxy;
        }
    }

    public static synchronized void loadLibrary() {
        try {
            if (!isLibraryLoaded) {
                TTVideoEngineLog.d(TAG, "JniUtils.loadLibrary");
                if (mProxy != null) {
                    mProxy.loadLibrary("videodec");
                } else {
                    System.loadLibrary("videodec");
                }
                isLibraryLoaded = true;
            }
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
            exception = e.toString();
        }
    }

    @Nullable
    public static String getEncryptionKeyWithCheck(byte[] convertedKey) throws Exception {
        if (!isLibraryLoaded) {
            throw new Exception("library not load suc exception:" + (exception == null ? "exception is null" : exception));
        }
        if (convertedKey == null) {
            TTVideoEngineLog.e(TAG, "getEncryptionKeyWithCheck convertedKey is null");
            return null;
        }
        String result = null;
        try {
            result = JniUtils.getEncryptionKey(convertedKey);
        }
        catch (Throwable e) {
            throw new Exception("getEncryptionKey exception:" + (e.toString() == null ? "exception is null" : e.toString()));
        }
        return result;
    }

    public static String getDecodedStrWithKey(byte[] encoded, byte[] key) throws Exception {
        if (!isLibraryLoaded) {
            throw new Exception("library not load suc exception:" + (exception == null ? "exception is null" : exception));
        }
        String result = null;
        try {
            result = JniUtils.getDecodedStr(encoded, key);
        }
        catch (Throwable e) {
            throw new Exception("getDecodedStr exception:" + (e.toString() == null ? "exception is null" : e.toString()));
        }
        return result;
    }

    public static int getDecodeMethod() throws Exception {
        if (!isLibraryLoaded) {
            throw new Exception("library not load suc exception:" + (exception == null ? "exception is null" : exception));
        }
        int result = 0;
        try {
            result = JniUtils.getSupportedMethod();
        }
        catch (Throwable e) {
            throw new Exception("getDecodedStr exception:" + (e.toString() == null ? "exception is null" : e.toString()));
        }
        return result;
    }

    public static byte[] getSettingSignature(String content) {
        if (!isLibraryLoaded) {
            TTVideoEngineLog.d(TAG, "library not load exception:" + exception);
            return null;
        }
        if (content == null) {
            TTVideoEngineLog.d(TAG, "getSettingSignature content is null");
            return null;
        }
        try {
            return JniUtils.getSignature(content);
        }
        catch (Throwable throwable) {
            TTVideoEngineLog.d(TAG, "getSettingSignature throwable:" + throwable);
            return null;
        }
    }

    public static String getEncryptionKey(byte[] convertedKey) {
        return Native.getEncryptionKey(convertedKey);
    }

    public static String getDecodedStr(byte[] encoded, byte[] key) {
        return Native.getDecodedStr(encoded, key);
    }

    public static int getSupportedMethod() {
        return Native.getSupportedMethod();
    }

    public static byte[] getSignature(String content) {
        return Native.getSignature(content);
    }

    public static String encryptTimestamp(String timestamp, String encKey) {
        if (!isLibraryLoaded) {
            TTVideoEngineLog.d(TAG, "library not load exception:" + exception);
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)timestamp) || TextUtils.isEmpty((CharSequence)encKey)) {
            return "";
        }
        byte[] encryptContent = JniUtils.encryptAesCbc128(timestamp.getBytes(), encKey.getBytes());
        if (encryptContent.length <= 0) {
            return "";
        }
        byte[] encode = Base64.encode((byte[])encryptContent, (int)0);
        return new String(encode);
    }

    private static byte[] encryptAesCbc128(byte[] content, byte[] encKey) {
        return Native.encryptAesCbc128(content, encKey);
    }

    static {
        if (EngineGlobalConfig.getInstance().getLazyLoadVideodec() == 1) {
            TTVideoEngineLog.d(TAG, "JniUtils.loadLibrary in static block");
            JniUtils.loadLibrary();
        }
    }
}

