/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.ss.ttm.player.ABRStrategy;
import com.ss.ttm.player.AudioProcessor;
import com.ss.ttm.player.FrameMetadataListener;
import com.ss.ttm.player.IMediaDataSource;
import com.ss.ttm.player.LoadControl;
import com.ss.ttm.player.MaskInfo;
import com.ss.ttm.player.MediaPlayer;
import com.ss.ttm.player.MediaPlayerClient;
import com.ss.ttm.player.MediaTransport;
import com.ss.ttm.player.OSPlayerClient;
import com.ss.ttm.player.PlaybackParams;
import com.ss.ttm.player.SubInfo;
import com.ss.ttm.player.TTPlayerConfiger;
import com.ss.ttvideoengine.FeatureManager;
import com.ss.ttvideoengine.PlayerCreateErrorListener;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.TTVideoEngineConfig;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineInternalLog;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MediaPlayerWrapper
implements MediaPlayer {
    public static final String TAG = "MediaPlayerWrapper";
    private MediaPlayerClient mClient;
    private boolean mHasException = false;
    private String mExceptionStr = "";
    private static final List<Throwable> sErrorList = new ArrayList<Throwable>();
    private static boolean sHasLoadPlayerClass = false;
    private static final String OWN_PLAYER_CLASS_NAME = "com.ss.ttm.player.TTPlayerClient";
    private static final String OWN_LITE_PLAYER_CLASS_NAME = "com.ss.ttmplayer.player.TTPlayerClient";
    private static final String OWN_PLUGIN_PLAYER_CLASS_NAME = "com.ss.ttmplugin.player.TTPlayerClient";
    private static final String OWN_PLUGIN_PLAYER_VERSION_CLASS_NAME = "com.ss.ttmplugin.player.TTVersion";
    private static final String EXO_PLAYER_CLIENT_CLASS_NAME = "com.ss.ttexo.ExoPlayerClient";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaPlayer create(Context context, int degradeMode, HashMap<Integer, Integer> configParams) {
        MediaPlayerWrapper player = new MediaPlayerWrapper();
        PlayerCreateErrorListener errorListener = TTVideoEngineConfig.getPlayerCreateErrorListener();
        Class<MediaPlayerWrapper> clazz = MediaPlayerWrapper.class;
        synchronized (MediaPlayerWrapper.class) {
            block27: {
                Method createMethod;
                Class<?> clsz;
                block32: {
                    Throwable targetEx;
                    block30: {
                        block31: {
                            block28: {
                                block29: {
                                    if (configParams != null && configParams.get(26) == 1 && MediaPlayerWrapper.createExoClient(context, player)) break block27;
                                    if (configParams == null || configParams.get(100) != 1 || configParams.get(1) != 0) break block28;
                                    if (configParams.get(2) != 1 || configParams.get(7) != 1 || configParams.get(10) < 3) break block29;
                                    configParams.put(2, 0);
                                    break block30;
                                }
                                if (configParams.get(11) != 0) break block30;
                                TTVideoEngineInternalLog.i(TAG, "crash or timeout, return.");
                                break block27;
                            }
                            if (TTPlayerConfiger.isOnTTPlayer()) break block30;
                            if (!TTPlayerConfiger.getValue((int)2, (boolean)false) || TTPlayerConfiger.getValue((int)7, (int)0) != 1 && TTPlayerConfiger.getValue((int)10, (int)0) < 3) break block31;
                            TTPlayerConfiger.setValue((int)2, (boolean)false);
                            break block30;
                        }
                        if (configParams == null || configParams.get(1) != 0) break block30;
                        TTVideoEngineInternalLog.i(TAG, "not on ttplayer, return.");
                        break block27;
                    }
                    if (TTVideoEngine.isForceUseLitePlayer()) break block32;
                    if (TTVideoEngine.isForceUsePluginPlayer()) {
                        try {
                            clsz = TTHelper.getClzUsingPluginLoader(201, OWN_PLUGIN_PLAYER_CLASS_NAME);
                            createMethod = clsz.getDeclaredMethod("create", MediaPlayer.class, Context.class);
                            createMethod.setAccessible(true);
                            player.mClient = (MediaPlayerClient)createMethod.invoke(clsz, player, context);
                        }
                        catch (Throwable e) {
                            TTVideoEngineInternalLog.e(TAG, e.toString());
                            player.mHasException = true;
                            player.mExceptionStr = e.toString();
                            sErrorList.add(e);
                        }
                    }
                    if (player.mClient != null) break block27;
                    try {
                        clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
                        createMethod = clsz.getDeclaredMethod("create", MediaPlayer.class, Context.class, HashMap.class);
                        createMethod.setAccessible(true);
                        player.mClient = (MediaPlayerClient)createMethod.invoke(clsz, player, context, configParams);
                        sHasLoadPlayerClass = true;
                    }
                    catch (Throwable e) {
                        TTVideoEngineInternalLog.e(TAG, e.toString());
                        player.mHasException = true;
                        player.mExceptionStr = player.mExceptionStr + e.toString();
                        if (e instanceof InvocationTargetException) {
                            targetEx = ((InvocationTargetException)e).getTargetException();
                            if (targetEx != null) {
                                player.mExceptionStr = player.mExceptionStr + ", " + targetEx.toString();
                                sErrorList.add(targetEx);
                                TTVideoEngineInternalLog.e(TAG, targetEx.toString());
                            }
                        } else {
                            sErrorList.add(e);
                        }
                        player.mExceptionStr = player.mExceptionStr + ";";
                    }
                    if (player.mClient == null) {
                        try {
                            clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
                            createMethod = clsz.getDeclaredMethod("create", MediaPlayer.class, Context.class);
                            createMethod.setAccessible(true);
                            player.mClient = (MediaPlayerClient)createMethod.invoke(clsz, player, context);
                            sHasLoadPlayerClass = true;
                        }
                        catch (Throwable e) {
                            TTVideoEngineInternalLog.e(TAG, e.toString());
                            player.mHasException = true;
                            player.mExceptionStr = player.mExceptionStr + e.toString();
                            if (e instanceof InvocationTargetException) {
                                targetEx = ((InvocationTargetException)e).getTargetException();
                                if (targetEx != null) {
                                    player.mExceptionStr = player.mExceptionStr + ", " + targetEx.toString();
                                    sErrorList.add(targetEx);
                                    TTVideoEngineInternalLog.e(TAG, targetEx.toString());
                                }
                            } else {
                                sErrorList.add(e);
                            }
                            player.mExceptionStr = player.mExceptionStr + ";";
                        }
                    }
                }
                if (player.mClient == null && degradeMode != 1) {
                    try {
                        clsz = Class.forName(OWN_LITE_PLAYER_CLASS_NAME);
                        createMethod = clsz.getDeclaredMethod("create", MediaPlayer.class, Context.class);
                        createMethod.setAccessible(true);
                        player.mClient = (MediaPlayerClient)createMethod.invoke(clsz, player, context);
                    }
                    catch (Throwable e) {
                        TTVideoEngineInternalLog.e(TAG, e.toString());
                        player.mHasException = true;
                        player.mExceptionStr = player.mExceptionStr + e.toString();
                        sErrorList.add(e);
                    }
                }
            }
            if (player.mHasException) {
                player.mExceptionStr = player.mExceptionStr + ",sHasLoadPlayerClass:" + sHasLoadPlayerClass;
            }
            if (player.mClient == null && configParams != null && configParams.get(26) == 0 && configParams.get(1) == 0 && configParams.get(11) == 0) {
                player.mClient = OSPlayerClient.create((MediaPlayer)player, (Context)context);
            }
            if (player.mClient == null && MediaPlayerWrapper.shouldFallbackExoPlayer(configParams)) {
                MediaPlayerWrapper.createExoClient(context, player);
            }
            if (player.mClient == null && configParams.get(11) == 0) {
                player.mClient = OSPlayerClient.create((MediaPlayer)player, (Context)context);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (errorListener != null && !sErrorList.isEmpty()) {
                errorListener.onCreatePlayerFailed(sErrorList);
            }
            sErrorList.clear();
            return player;
        }
    }

    public static void setGlobalIntOptionForKey(int key, int value) {
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
            Method setGSOptionMethod = clsz.getDeclaredMethod("setGlobalIntOptionForKey", Integer.TYPE, Integer.TYPE);
            setGSOptionMethod.setAccessible(true);
            setGSOptionMethod.invoke(clsz, key, value);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static boolean createExoClient(Context context, MediaPlayerWrapper player) {
        if (!FeatureManager.hasPermission("lite")) {
            return false;
        }
        boolean createSuccess = false;
        try {
            Class<?> clz = Class.forName(EXO_PLAYER_CLIENT_CLASS_NAME);
            Method createMethod = clz.getDeclaredMethod("create", MediaPlayer.class, Context.class);
            createMethod.setAccessible(true);
            player.mClient = (MediaPlayerClient)createMethod.invoke(clz, player, context);
            createSuccess = true;
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.e(TAG, e.toString());
            player.mHasException = true;
            player.mExceptionStr = player.mExceptionStr + e.toString();
            sErrorList.add(e);
        }
        return createSuccess;
    }

    private static boolean shouldFallbackExoPlayer(HashMap<Integer, Integer> param) {
        boolean globalFlag = TTVideoEngine.isFallbackUseExoPlayer();
        boolean instanceFlag = false;
        if (param == null || !param.containsKey(27)) {
            return globalFlag;
        }
        try {
            instanceFlag = TTHelper.nonNullElse(param.get(27), 0) == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instanceFlag;
    }

    public static boolean tryLoadPlayerPlugin() {
        if (sHasLoadPlayerClass) {
            return true;
        }
        try {
            TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
            sHasLoadPlayerClass = true;
            return true;
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
            return false;
        }
    }

    public static String getPluginVersion() {
        String ret = "";
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(201, OWN_PLUGIN_PLAYER_VERSION_CLASS_NAME);
            Field fild = clsz.getField("VERSION_NAME");
            ret = fild.get(null).toString();
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
        }
        return ret;
    }

    public boolean hasException() {
        return this.mHasException;
    }

    public String getExceptionStr() {
        return this.mExceptionStr;
    }

    public boolean isOSPlayer() {
        return this.mClient instanceof OSPlayerClient;
    }

    public int getPlayerType() {
        if (this.mClient != null) {
            return this.mClient.getType();
        }
        return 0;
    }

    public void prevClose() {
        if (this.mClient != null) {
            this.mClient.prevClose();
        }
    }

    public void release() {
        if (this.mClient != null) {
            this.mClient.release();
        }
    }

    public void releaseAsync() {
        if (this.mClient != null) {
            this.mClient.releaseAsync();
        }
    }

    public void start() {
        if (this.mClient != null) {
            this.mClient.start();
        }
    }

    public void pause() {
        if (this.mClient != null) {
            this.mClient.pause();
        }
    }

    public void reset() {
        if (this.mClient != null) {
            this.mClient.reset();
        }
    }

    public void stop() {
        if (this.mClient != null) {
            this.mClient.stop();
        }
    }

    public void prepare() {
        if (this.mClient != null) {
            this.mClient.prepare();
        }
    }

    public void prepareAsync() {
        if (this.mClient != null) {
            this.mClient.prepareAsync();
        }
    }

    public int getCurrentPosition() {
        if (this.mClient != null) {
            return this.mClient.getCurrentPosition();
        }
        return 0;
    }

    public int getVideoHeight() {
        if (this.mClient != null) {
            return this.mClient.getVideoHeight();
        }
        return 0;
    }

    public int getVideoWidth() {
        if (this.mClient != null) {
            return this.mClient.getVideoWidth();
        }
        return 0;
    }

    public int getDuration() {
        if (this.mClient != null) {
            return this.mClient.getDuration();
        }
        return 0;
    }

    public int getVideoType() {
        if (this.mClient != null) {
            return this.mClient.getVideoType();
        }
        return 0;
    }

    public void setPanoVideoControlModel(int model) {
        if (this.mClient != null) {
            this.mClient.setPanoVideoControlModel(model);
        }
    }

    public void setDisplay(SurfaceHolder surfaceHolder) {
        if (this.mClient != null) {
            this.mClient.setDisplay(surfaceHolder);
        }
    }

    public void setSurface(Surface surface) {
        if (surface != null && !surface.isValid() || this.mClient == null) {
            return;
        }
        this.mClient.setSurface(surface);
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        if (this.mClient != null) {
            this.mClient.setDataSource(context, uri, headers);
        }
    }

    public void setDataSource(String path) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        if (this.mClient != null) {
            this.mClient.setDataSource(path);
        }
    }

    public void setDataSource(Context context, Uri uri) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        if (this.mClient != null) {
            this.mClient.setDataSource(context, uri);
        }
    }

    public void setDataSource(FileDescriptor fileDescriptor, long offset, long length) throws IllegalStateException, IllegalArgumentException, IOException {
        if (this.mClient != null) {
            this.mClient.setDataSource(fileDescriptor, offset, length);
        }
    }

    public void setDataSource(IMediaDataSource iMediaDataSource) throws IllegalArgumentException, IOException {
        if (this.mClient != null) {
            this.mClient.setDataSource(iMediaDataSource);
        }
    }

    public String getDataSource() {
        if (this.mClient != null) {
            return this.mClient.getDataSource();
        }
        return null;
    }

    public boolean isPlaying() {
        if (this.mClient != null) {
            return this.mClient.isPlaying();
        }
        return false;
    }

    public boolean isLooping() {
        if (this.mClient != null) {
            return this.mClient.isLooping();
        }
        return false;
    }

    public void setLooping(boolean b) {
        if (this.mClient != null) {
            this.mClient.setLooping(b);
        }
    }

    public void setVolume(float left, float right) {
        if (this.mClient != null) {
            this.mClient.setVolume(left, right);
        }
    }

    public void mouseEvent(int action, int deltaX, int deltaY) {
        if (this.mClient != null) {
            this.mClient.mouseEvent(action, deltaX, deltaY);
        }
    }

    public void seekTo(int msec) {
        if (this.mClient != null) {
            this.mClient.seekTo(msec);
        }
    }

    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mClient != null) {
            this.mClient.setScreenOnWhilePlaying(screenOn);
        }
    }

    public void setOnLogListener(MediaPlayer.OnLogListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnLogListener(listener);
        }
    }

    public void setOnBufferingUpdateListener(MediaPlayer.OnBufferingUpdateListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnBufferingUpdateListener(listener);
        }
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnCompletionListener(listener);
        }
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnErrorListener(listener);
        }
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnInfoListener(listener);
        }
    }

    public void setOnExternInfoListener(MediaPlayer.OnExternInfoListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnExternInfoListener(listener);
        }
    }

    public void setOnSARChangedListener(MediaPlayer.onSARChangedListener onSARChangedListener2) {
        if (this.mClient != null) {
            this.mClient.setOnSARChangedListener(onSARChangedListener2);
        }
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnPreparedListener(listener);
        }
    }

    public void setOnSeekCompleteListener(MediaPlayer.OnSeekCompleteListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnSeekCompleteListener(listener);
        }
    }

    public void setOnVideoSizeChangedListener(MediaPlayer.OnVideoSizeChangedListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnVideoSizeChangedListener(listener);
        }
    }

    public void setFrameMetadataListener(FrameMetadataListener listener) {
        if (this.mClient != null) {
            this.mClient.setFrameMetadataListener(listener);
        }
    }

    public void setIntOption(int key, int value) {
        if (this.mClient != null) {
            this.mClient.setIntOption(key, value);
        }
    }

    public int setFloatOption(int key, float value) {
        if (this.mClient != null) {
            this.mClient.setFloatOption(key, value);
        }
        return 0;
    }

    public float getFloatOption(int key, float dValue) {
        if (this.mClient != null) {
            return this.mClient.getFloatOption(key, dValue);
        }
        return dValue;
    }

    public void setWakeMode(Context context, int mode) {
        if (this.mClient != null) {
            this.mClient.setWakeMode(context, mode);
        }
    }

    public void setIsMute(boolean isMute) {
        if (this.mClient != null) {
            this.mClient.setIsMute(isMute);
        }
    }

    public boolean isMute() {
        if (this.mClient != null) {
            return this.mClient.isMute();
        }
        return false;
    }

    public void setCacheFile(String path, int mode) {
        if (this.mClient != null) {
            this.mClient.setCacheFile(path, mode);
        }
    }

    public void setStringOption(int key, String value) {
        if (this.mClient != null) {
            this.mClient.setStringOption(key, value);
        }
    }

    public int getIntOption(int key, int dValue) {
        if (this.mClient != null) {
            return this.mClient.getIntOption(key, dValue);
        }
        return dValue;
    }

    public String getStringOption(int key) {
        if (this.mClient != null) {
            return this.mClient.getStringOption(key);
        }
        return null;
    }

    public long getLongOption(int key, long dValue) {
        if (this.mClient != null) {
            return this.mClient.getLongOption(key, dValue);
        }
        return dValue;
    }

    public long setLongOption(int key, long value) {
        if (this.mClient != null) {
            return this.mClient.setLongOption(key, value);
        }
        return -1L;
    }

    public void rotateCamera(float angleX, float angleY) {
        if (this.mClient != null) {
            this.mClient.rotateCamera(angleX, angleY);
        }
    }

    public void takeScreenshot(MediaPlayer.OnScreenshotListener listener) {
        if (this.mClient != null) {
            this.mClient.takeScreenshot(listener);
        }
    }

    public void switchStream(int bitrate, int streamType) {
        if (this.mClient != null) {
            this.mClient.switchStream(bitrate, streamType);
        }
    }

    public void setPlaybackParams(PlaybackParams playbackParams) {
        if (this.mClient != null) {
            this.mClient.setPlaybackParams(playbackParams);
        }
    }

    public void selectTrack(int i) {
        if (this.mClient != null) {
            this.mClient.selectTrack(i);
        }
    }

    public int getSelectedTrack(int var1) {
        if (this.mClient != null) {
            this.mClient.getSelectedTrack(var1);
        }
        return 0;
    }

    public void deselectTrack(int var1) {
        if (this.mClient != null) {
            this.mClient.deselectTrack(var1);
        }
    }

    public MediaPlayer.TrackInfo[] getTrackInfo() {
        if (this.mClient != null) {
            return this.mClient.getTrackInfo();
        }
        return null;
    }

    public void setMediaTransport(MediaTransport transport) {
        if (this.mClient == null) {
            return;
        }
        this.mClient.setMediaTransport(transport);
    }

    public void seekTo(int msec, int flag) {
        if (this.mClient == null) {
            return;
        }
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
            Method method = clsz.getMethod("seekTo", Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.mClient, msec, flag);
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAudioProcessor(AudioProcessor processor) {
        if (this.mClient == null) {
            return;
        }
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
            Method method = clsz.getMethod("setAudioProcessor", AudioProcessor.class);
            method.setAccessible(true);
            method.invoke((Object)this.mClient, processor);
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadControl(LoadControl loadControl) {
        if (this.mClient == null) {
            return;
        }
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
            Method method = clsz.getMethod("setLoadControl", LoadControl.class);
            method.setAccessible(true);
            method.invoke((Object)this.mClient, loadControl);
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaskInfo(MaskInfo maskInfo) {
        if (this.mClient == null) {
            return;
        }
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
            Method method = clsz.getMethod("setMaskInfo", MaskInfo.class);
            method.setAccessible(true);
            method.invoke((Object)this.mClient, maskInfo);
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAIBarrageInfo(MaskInfo barrageInfo) {
        if (this.mClient == null) {
            return;
        }
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
            Method method = clsz.getMethod("setAIBarrageInfo", MaskInfo.class);
            method.setAccessible(true);
            method.invoke((Object)this.mClient, barrageInfo);
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getSubtitleContent(int queryTime) {
        if (this.mClient == null) {
            return null;
        }
        Object result = null;
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
            Method method = clsz.getMethod("getSubtitleContent", Integer.TYPE);
            method.setAccessible(true);
            result = method.invoke((Object)this.mClient, queryTime);
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
        }
        if (result != null && result instanceof String) {
            return (String)result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubInfo(SubInfo subInfo) {
        if (this.mClient == null) {
            return;
        }
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
            Method method = clsz.getMethod("setSubInfo", SubInfo.class);
            method.setAccessible(true);
            method.invoke((Object)this.mClient, subInfo);
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setABRStrategy(ABRStrategy abrStrategy) {
        if (this.mClient == null) {
            return;
        }
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
            Method method = clsz.getMethod("setABRStrategy", ABRStrategy.class);
            method.setAccessible(true);
            method.invoke((Object)this.mClient, abrStrategy);
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectOption(int key) {
        Object ret = null;
        if (this.mClient == null) {
            return ret;
        }
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_CLASS_NAME);
            Method method = clsz.getMethod("getObjectOption", Integer.TYPE);
            method.setAccessible(true);
            ret = method.invoke((Object)this.mClient, key);
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
        }
        return ret;
    }

    public MediaPlayerClient getPlayerClient() {
        return this.mClient;
    }
}

