/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.view.Surface;
import android.view.SurfaceHolder;
import com.ss.texturerender.VideoSurface;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.TTVideoEngineConfig;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;

public class TTVideoEngineSurfaceCallback
implements SurfaceHolder.Callback {
    private static final String TAG = "TTVideoEngineSurfaceCallback";
    private WeakReference<TTVideoEngine> mEngine;

    public TTVideoEngineSurfaceCallback(TTVideoEngine engine) {
        this.mEngine = new WeakReference<TTVideoEngine>(engine);
        TTVideoEngineLog.d(TAG, "new surface callback:" + this);
    }

    public void reset() {
        this.mEngine.clear();
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        TTVideoEngineLog.d(TAG, "surfaceCreated, " + surfaceHolder);
        TTVideoEngine engine = (TTVideoEngine)this.mEngine.get();
        if (engine != null) {
            engine.getLogger().setSurfaceSourceType("surface created");
            Surface surface = surfaceHolder.getSurface();
            VideoSurface textureSurface = engine.getTextureSurface();
            if (textureSurface != null) {
                textureSurface.setIntOption(9, 1);
                textureSurface.updateRenderSurface(surface);
                textureSurface.setIntOption(9, 0);
                textureSurface.setIntOption(25, 1);
                TTVideoEngineLog.d(TAG, "set texturerender force draw");
            } else {
                engine.setSurfaceSync(surface, TTVideoEngineConfig.setSurfaceTimeoutForCreated == Long.MIN_VALUE ? engine.getLongOption(950) : TTVideoEngineConfig.setSurfaceTimeoutForCreated);
            }
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i1, int i2) {
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        TTVideoEngineLog.d(TAG, "surfaceDestroyed, " + surfaceHolder);
        TTVideoEngine engine = (TTVideoEngine)this.mEngine.get();
        if (engine != null) {
            engine.getLogger().setSurfaceSourceType("surface destroyed");
            VideoSurface videoSurface = engine.getTextureSurface();
            if (videoSurface != null) {
                videoSurface.setIntOption(9, 1);
                videoSurface.updateRenderSurface(null);
                videoSurface.setIntOption(9, 0);
            } else {
                engine.setSurfaceSync(null, TTVideoEngineConfig.setSurfaceTimeoutForDestroy == Long.MIN_VALUE ? engine.getLongOption(950) : TTVideoEngineConfig.setSurfaceTimeoutForDestroy);
            }
        }
    }
}

