/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.abr;

import com.bytedance.vcloud.abrmodule.ISegmentInfo;
import com.bytedance.vcloud.abrmodule.ISegmentItem;
import com.ss.ttvideoengine.abr.SegmentItem;
import com.ss.ttvideoengine.utils.TTHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class SegmentInfo
implements ISegmentInfo {
    private Object playerSidxList;
    private boolean loadObjectSucceed = false;
    private static final String PLAYER_SIDX_OBJECT_NAME = "com.ss.ttm.player.SidxListObject";
    private static boolean loadClassFailed = false;
    private static Class<?> sidxListObjectClass;
    private static Method sidxGetMediaType;
    private static Method sidxGetTotalNum;
    private static Method sidxGetStartIndex;
    private static Method sidxGetEndIndex;
    private static Method sidxGetBitRate;
    private static Method sidxGetFileId;
    private static Method sidxGetItem;
    private Integer mMediaType;
    private Integer mTotalNum;
    private Integer mStartIndex;
    private Integer mEndIndex;
    private Long mBitrate;
    private String mFileId;

    public SegmentInfo(Object playerSidxList) {
        this.playerSidxList = playerSidxList;
        if (sidxListObjectClass == null && !loadClassFailed) {
            try {
                sidxListObjectClass = TTHelper.getClzUsingPluginLoader(200, PLAYER_SIDX_OBJECT_NAME);
                sidxGetMediaType = sidxListObjectClass.getMethod("getMediaType", new Class[0]);
                sidxGetTotalNum = sidxListObjectClass.getMethod("getTotalNum", new Class[0]);
                sidxGetStartIndex = sidxListObjectClass.getMethod("getStartIndex", new Class[0]);
                sidxGetEndIndex = sidxListObjectClass.getMethod("getEndIndex", new Class[0]);
                sidxGetBitRate = sidxListObjectClass.getMethod("getBitrate", new Class[0]);
                sidxGetFileId = sidxListObjectClass.getMethod("getFileId", new Class[0]);
                sidxGetItem = sidxListObjectClass.getMethod("getItem", Integer.TYPE);
            }
            catch (Exception e) {
                this.playerSidxList = null;
                loadClassFailed = true;
            }
        } else if (sidxListObjectClass == null) {
            this.playerSidxList = null;
        }
        if (this.playerSidxList != null && this.playerSidxList.getClass().equals(sidxListObjectClass)) {
            this.loadObjectSucceed = true;
        }
    }

    @Override
    public int getMediaType() {
        if (this.mMediaType != null) {
            return this.mMediaType;
        }
        int type = -1;
        if (this.loadObjectSucceed && sidxGetMediaType != null) {
            try {
                this.mMediaType = (Integer)sidxGetMediaType.invoke(this.playerSidxList, new Object[0]);
                type = this.mMediaType;
            }
            catch (Exception e) {
                this.mMediaType = -1;
            }
        }
        return type;
    }

    @Override
    public int getTotalNum() {
        if (this.mTotalNum != null) {
            return this.mTotalNum;
        }
        int totalNum = -1;
        if (this.loadObjectSucceed && sidxGetTotalNum != null) {
            try {
                this.mTotalNum = (Integer)sidxGetTotalNum.invoke(this.playerSidxList, new Object[0]);
                totalNum = this.mTotalNum;
            }
            catch (Exception e) {
                this.mTotalNum = -1;
            }
        }
        return totalNum;
    }

    @Override
    public int getStartIndex() {
        if (this.mStartIndex != null) {
            return this.mStartIndex;
        }
        int index = 0;
        if (this.loadObjectSucceed && sidxGetStartIndex != null) {
            try {
                this.mStartIndex = (Integer)sidxGetStartIndex.invoke(this.playerSidxList, new Object[0]);
                index = this.mStartIndex;
            }
            catch (Exception e) {
                index = -1;
            }
        }
        return index;
    }

    @Override
    public int getEndIndex() {
        if (this.mEndIndex != null) {
            return this.mEndIndex;
        }
        int index = 0;
        if (this.loadObjectSucceed && sidxGetEndIndex != null) {
            try {
                this.mEndIndex = (Integer)sidxGetEndIndex.invoke(this.playerSidxList, new Object[0]);
                index = this.mEndIndex;
            }
            catch (Exception e) {
                index = -1;
            }
        }
        return index;
    }

    @Override
    public String getFileId() {
        if (this.mFileId != null) {
            return this.mFileId;
        }
        if (this.loadObjectSucceed && sidxGetFileId != null) {
            try {
                this.mFileId = (String)sidxGetFileId.invoke(this.playerSidxList, new Object[0]);
            }
            catch (Exception e) {
                this.mFileId = null;
            }
        }
        return this.mFileId;
    }

    @Override
    public long getBitrate() {
        if (this.mBitrate != null) {
            return this.mBitrate;
        }
        long bitrate = -1L;
        if (this.loadObjectSucceed && sidxGetBitRate != null) {
            try {
                this.mBitrate = (Long)sidxGetBitRate.invoke(this.playerSidxList, new Object[0]);
                bitrate = this.mBitrate;
            }
            catch (Exception e) {
                this.mBitrate = -1L;
            }
        }
        return bitrate;
    }

    @Override
    public List<? extends ISegmentItem> getItems() {
        ArrayList<SegmentItem> items = new ArrayList<SegmentItem>();
        if (this.loadObjectSucceed && sidxGetItem != null) {
            try {
                int i = 0;
                while (i + this.getStartIndex() <= this.getEndIndex()) {
                    Object item = sidxGetItem.invoke(this.playerSidxList, i);
                    items.add(new SegmentItem(item));
                    ++i;
                }
            }
            catch (Exception e) {
                items = null;
            }
        }
        return items;
    }
}

