/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.fetcher;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.mediakit.fetcher.AVMDLFetcherMakerInterface;
import com.ss.mediakit.fetcher.AVMDLURLFetcherInterface;
import com.ss.ttvideoengine.fetcher.FetcherBase;
import com.ss.ttvideoengine.fetcher.MDLFetcher;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.Hashtable;

public class FetcherMaker
implements AVMDLFetcherMakerInterface {
    private static final String TAG = "FetcherMaker";
    private static Hashtable<String, FetcherBase> sFallbackCenter = new Hashtable();
    private final Context mContext;

    public FetcherMaker(Context context) {
        this.mContext = context;
    }

    public FetcherMaker() {
        this.mContext = null;
    }

    public static void store(String videoID, String keyseed, String fallbackAPI, int version) {
        TTVideoEngineLog.i(TAG, "store videoId " + videoID + ", keyseed " + keyseed + ", fallbackAPI " + fallbackAPI + ", version " + version);
        if (TextUtils.isEmpty((CharSequence)videoID) || TextUtils.isEmpty((CharSequence)fallbackAPI) || version != 3 && TextUtils.isEmpty((CharSequence)keyseed)) {
            TTVideoEngineLog.i(TAG, "mdlFetch store fail");
            return;
        }
        sFallbackCenter.put(videoID, new FetcherBase(keyseed, fallbackAPI, version));
    }

    public static void remove(String videoID) {
        if (TextUtils.isEmpty((CharSequence)videoID)) {
            return;
        }
        sFallbackCenter.remove(videoID);
    }

    @Nullable
    public AVMDLURLFetcherInterface getFetcher(String rawKey, String fileKey, String oldURL) {
        TTVideoEngineLog.i(TAG, "getFetcher rawKey " + rawKey + ", fileKey " + fileKey + ", oldURL " + oldURL);
        FetcherBase base = sFallbackCenter.get(rawKey);
        if (base == null) {
            TTVideoEngineLog.i(TAG, "getFetcher FetcherBase is null");
            return null;
        }
        String keyseed = base.getKeyseed();
        String fallbackAPI = base.getFallbackAPI();
        int version = base.getVideoModelVersion();
        if (TextUtils.isEmpty((CharSequence)fallbackAPI) || version != 3 && TextUtils.isEmpty((CharSequence)keyseed)) {
            TTVideoEngineLog.i(TAG, "getFetcher FetcherBase is error " + base);
            return null;
        }
        MDLFetcher mdlFetcher = new MDLFetcher(this.mContext, fallbackAPI, keyseed);
        TTVideoEngineLog.i(TAG, "return fetcher to mdl " + mdlFetcher);
        return mdlFetcher;
    }
}

