/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorResultCollection;
import com.ss.ttm.player.PlaybackParams;
import com.ss.ttvideoengine.AppInfo;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.VideoInfoCollector;
import com.ss.ttvideoengine.log.BrightnessMonitor;
import com.ss.ttvideoengine.log.ContentDataReporter;
import com.ss.ttvideoengine.log.DeviceMonitorUtils;
import com.ss.ttvideoengine.log.EventLoggerSource;
import com.ss.ttvideoengine.log.EventSaver;
import com.ss.ttvideoengine.log.HeadsetStateHistory;
import com.ss.ttvideoengine.log.HeadsetStateMonitor;
import com.ss.ttvideoengine.log.IVideoEventLogger;
import com.ss.ttvideoengine.log.LoggerUtils;
import com.ss.ttvideoengine.log.PortraitNetworkScore;
import com.ss.ttvideoengine.log.SuperResolutionMonitor;
import com.ss.ttvideoengine.log.VideoEventAbrEvent;
import com.ss.ttvideoengine.log.VideoEventBase;
import com.ss.ttvideoengine.log.VideoEventManager;
import com.ss.ttvideoengine.log.VideoEventOneEvent;
import com.ss.ttvideoengine.log.VideoEventOneNoRender;
import com.ss.ttvideoengine.log.VideoEventOneOpera;
import com.ss.ttvideoengine.log.VideoEventOneOutSync;
import com.ss.ttvideoengine.log.VideoEventOnePlay;
import com.ss.ttvideoengine.log.VideoEventOneStorage;
import com.ss.ttvideoengine.log.VideoEventSampleRecord;
import com.ss.ttvideoengine.log.VideoFilterMonitor;
import com.ss.ttvideoengine.log.ViewSizeMonitor;
import com.ss.ttvideoengine.metrics.IMediaMetrics;
import com.ss.ttvideoengine.metrics.MetricsFactory;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.model.VideoStyle;
import com.ss.ttvideoengine.net.DNSServerIP;
import com.ss.ttvideoengine.portrait.NetworkPortraitData;
import com.ss.ttvideoengine.portrait.PortraitEngine;
import com.ss.ttvideoengine.setting.SettingsHelper;
import com.ss.ttvideoengine.superresolution.SRStrategy;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.ScreenUtils;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import com.ss.ttvideoengine.utils.TTVideoEngineUtils;
import com.ss.ttvideoengine.utils.TimeService;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class VideoEventLoggerV2
implements IVideoEventLogger {
    private static final String TAG = "VideoEventLoggerV2";
    private static final int LOGGER_STATE_IDLE = 0;
    private static final int LOGGER_STATE_STARTING = 1;
    private static final int LOGGER_STATE_PLAYING = 2;
    private static final int LOGGER_STATE_LOADING = 3;
    private static final int LOGGER_STATE_SEEKING = 4;
    private static final int LOGGER_STATE_ERROR = 5;
    public static final String SETTINGS_CALCULATE_INTERVAL = "calculate_interval";
    public static final String SETTINGS_LINK_FUNCTION_OFFSET = "link_function_offset";
    public static final String SETTINGS_NET_QUALITY = "net_quality";
    @NonNull
    private final EventLoggerSource mDataSource;
    @NonNull
    private VideoEventOnePlay mEvent;
    @NonNull
    private final VideoEventOneEvent mEventOneEvent;
    @NonNull
    private final VideoEventOneOpera mEventOneOpera;
    @NonNull
    private final VideoEventOneOutSync mEventOneOutSync;
    @NonNull
    private final VideoEventOneNoRender mEventOneNoRender;
    @NonNull
    private VideoEventBase mEventBase;
    @NonNull
    private final VideoEventAbrEvent mEventAbrSwitch;
    private final HeadsetStateMonitor mHeadsetStateMonitor;
    private final HeadsetStateHistory mHeadsetStateHistory;
    private VideoEventSampleRecord mEventSample;
    private boolean mIsLocal = false;
    private boolean mLeave;
    private boolean mFetchComplete = false;
    private int mAsyncInit = Integer.MIN_VALUE;
    private int mUseCodecPool = Integer.MIN_VALUE;
    private ArrayList mRetryFetchErrorInfo;
    private ArrayList<String> mMDLRetryInfo;
    private ArrayList mFirstDNSErrorInfo;
    private ArrayList mErrorInfo;
    private ArrayList mVUArray;
    private Map mMainError;
    private String mCustomStr;
    private String mInitialURL;
    private String mAudioInitURL;
    private String mInitialHost;
    private String mInitialIP;
    private String mInitialResolution = "";
    private String mInitialQuality = "";
    private int mInitialQualityType = Integer.MIN_VALUE;
    private String mProxyUrl = "";
    private String mMessage = "";
    private int mIsStartPlayAutomatically = Integer.MIN_VALUE;
    private int mBufferDataSeconds = Integer.MIN_VALUE;
    private int mLoopCount = 0;
    private boolean mLooping = false;
    private Map mPlaybackParams = null;
    private int mCustomP2PCDNType = Integer.MIN_VALUE;
    private String mP2PUrl = "";
    private String mP2PSDKVersion = "";
    private int mDuration = Integer.MIN_VALUE;
    private int mStartTime = Integer.MIN_VALUE;
    private int mWidth = Integer.MIN_VALUE;
    private int mHeight = Integer.MIN_VALUE;
    private int mDisableAccurateStart = Integer.MIN_VALUE;
    private long mSurfaceSetTime = Integer.MIN_VALUE;
    private String mSurfaceCode = null;
    private int mNetWorkTryCount = Integer.MIN_VALUE;
    private long mDecodeBufferingStartT = 0L;
    private int mAsyncCodecId = Integer.MIN_VALUE;
    private int mEnableBash = Integer.MIN_VALUE;
    private int mPlayCount = 0;
    public int mCurDecoderBufferCount = 0;
    public long mCurDecoderBufferAccuT = 0L;
    public int mCurBufferCount = 0;
    public int mNetBufferIndex = 0;
    public int mBreakCount = 0;
    private int mApiVer = Integer.MIN_VALUE;
    private String mAuth;
    private int mSwitchResolutionCount = 0;
    private int mSeekCount = 0;
    private IVideoModel mVideoModel;
    private long mBlockBeginT = Integer.MIN_VALUE;
    private long mSeekBeginT = Integer.MIN_VALUE;
    private long mAccumVPS = 0L;
    private long mAccumVDS = 0L;
    private int mState = 0;
    private Context mContext;
    private String mExtraInfo = "";
    private int mLeaveReason = -1002;
    private long mBitrate = Integer.MIN_VALUE;
    private long mAudioBitrate = Integer.MIN_VALUE;
    public static int sIsColdStart = 1;
    private int mFirstRangeSize = Integer.MIN_VALUE;
    private int mNetSpeedLevel = Integer.MIN_VALUE;
    private int mModelVersion = Integer.MIN_VALUE;
    public int mMediaCodecRender = Integer.MIN_VALUE;
    public int mBufferTimeout = Integer.MIN_VALUE;
    public int mNetworkTimeout = Integer.MIN_VALUE;
    private long prepare_before_play_t = Integer.MIN_VALUE;
    private long setds_t = Integer.MIN_VALUE;
    private long ps_t = Integer.MIN_VALUE;
    private int mRadioMode = Integer.MIN_VALUE;
    private boolean mVideoStreamDisabled = false;
    private boolean mAudioStreamDisabled = false;
    private int mIsReplay = Integer.MIN_VALUE;
    private int mEnableNNSR = Integer.MIN_VALUE;
    private int mReadCacheMode = Integer.MIN_VALUE;
    private int mPreRangeOff = Integer.MIN_VALUE;
    private boolean mIsEngineReuse = false;
    private boolean mUploadLogEnabled;
    private boolean mEnableSpeedReport = false;
    private float mNetworkSpeedPredictSamplingRate = Float.MIN_VALUE;
    private boolean mEnablePlayerDegrade = false;
    private boolean mIsDegradeRelease = false;
    private String mPlayerSurfaceCode = null;
    private TimerTask mTimerTask = null;
    private PortraitNetworkScore.BitrateCalculationTask mBitrateCalculationTask;
    private int mNetLevelIntervalMs = 0;
    private int mNetLevelMaxCount = 100;
    private int mNetSpeedUpdateInterval = 0;
    private long mMDLDownloadSize = 0L;
    private long mMDLDownloadTime = 0L;
    private SuperResolutionMonitor mSrMonitor;
    private VideoFilterMonitor mFilterMonitor;
    private BrightnessMonitor mBrightMonitor;
    private ViewSizeMonitor mViewSizeMonitor;
    private PortraitNetworkScore.NetworkQualityAlgorithm mNetworkQualityAlgorithm;
    private String mNetworkQualityVar = null;
    private Error mFirstError;
    private EventSaver mEventSaver;
    private int mReportLevel = 12;
    private Map mFeatures = new HashMap();
    private static Map sFeatures = new HashMap();
    private int mHardwareConfType = Integer.MIN_VALUE;
    private int mSubLanSwitchCount = 0;
    private int mSubIdsCount = Integer.MIN_VALUE;
    private int mEnableSub = Integer.MIN_VALUE;
    private int mEnableOptSubLoad = Integer.MIN_VALUE;
    private int mEnableSubThread = Integer.MIN_VALUE;
    private int mEnableMask = Integer.MIN_VALUE;
    private int mEnableMaskThread = Integer.MIN_VALUE;
    private String mSubReqURL = "";
    private String mMaskURL = "";
    private String mSubError = "";
    private int mMaskErrc = Integer.MIN_VALUE;
    private int mMaskRangeOpt = Integer.MIN_VALUE;
    private int mMaskEnableDataloader = Integer.MIN_VALUE;
    private int mMaskDelayLoading = Integer.MIN_VALUE;
    private String mMaskFileHash = "";
    private long mMaskFileSize = Integer.MIN_VALUE;
    private FeatureConfigs mFeatureConfigs;
    private ArrayList<String> mPlayList = new ArrayList();
    private ArrayList<String> mPauseList = new ArrayList();
    private ArrayList<String> mResolutionList = new ArrayList();
    private ArrayList<String> mPlaySpeedList = new ArrayList();
    private ArrayList<String> mRadiomodeList = new ArrayList();
    private ArrayList<String> mLoopList = new ArrayList();
    private ArrayList<String> mErrorList = new ArrayList();
    private ArrayList<Integer> mPowerList = new ArrayList();
    private ArrayList<Integer> mChargingList = new ArrayList();
    private ArrayList<String> mAVBadInterlacedList = new ArrayList();
    private boolean mAVOutSyncing = false;
    private Error mCurError = null;
    private int mRetryStrategy = -1;
    private long mRetryStartT = Integer.MIN_VALUE;
    public long mCustomClickT = Integer.MIN_VALUE;
    public long mCustomGetVideoModelT = Integer.MIN_VALUE;
    public long mCustomInitEngineT = Integer.MIN_VALUE;
    public long mCustomPlayEngineT = Integer.MIN_VALUE;
    public int mEngineHash = Integer.MIN_VALUE;
    private long mSetSurfaceBeginT = Integer.MIN_VALUE;
    private String mSetSurfaceType = null;
    private ArrayList<String> mSetSurfaceTimeList = null;
    private String mFromEnginePool = "default";
    private int mCorePoolSizeUpperLimit = Integer.MIN_VALUE;
    private int mCorepoolSizeBeforeGetEngine = Integer.MIN_VALUE;
    private int mCountOfEngineInUse = Integer.MIN_VALUE;
    private ArrayList<String> mVrDistanceList = new ArrayList();
    private float mVrFrameRate = Float.MIN_VALUE;
    private int mVrScreenRefreshRate = Integer.MIN_VALUE;
    private long mVrHeadMovementDelay = Integer.MIN_VALUE;
    private HashMap<String, Object> mCastObject = null;
    private int mOttPluginVersion = Integer.MIN_VALUE;
    private String mCompanyID = "";
    private ArrayList<String> mTrEffectList = new ArrayList();
    private String mTrPerEffectAverageTime = "";
    private String mTrEffectErrorCode = "";
    public static boolean sEnableContentDataReport = false;
    private ContentDataReporter mContentDataReporter = null;
    private boolean mUrlMatchCondition = false;

    public VideoEventLoggerV2(Context context, EventLoggerSource dataSource, HeadsetStateMonitor monitor) {
        this.mDataSource = dataSource;
        this.mEventBase = new VideoEventBase(this.mDataSource, this.mUploadLogEnabled, context);
        this.mEvent = new VideoEventOnePlay();
        this.mEventOneOpera = new VideoEventOneOpera(this.mEventBase);
        this.mEventOneEvent = new VideoEventOneEvent(this.mEventBase, this.mEventOneOpera);
        this.mEventSample = new VideoEventSampleRecord(this.mEventBase);
        this.mEventOneOutSync = new VideoEventOneOutSync(this.mEventBase);
        this.mEventOneNoRender = new VideoEventOneNoRender(this.mEventBase);
        this.mEventAbrSwitch = new VideoEventAbrEvent(this.mEventBase);
        this.mEventSaver = EventSaver.getInstance(context);
        this.mFeatureConfigs = new FeatureConfigs();
        this.mRetryFetchErrorInfo = new ArrayList();
        this.mMDLRetryInfo = new ArrayList();
        this.mFirstDNSErrorInfo = new ArrayList();
        this.mErrorInfo = new ArrayList();
        this.mVUArray = new ArrayList();
        this.mLeave = true;
        this.mFetchComplete = false;
        this.mContext = context;
        this.mHeadsetStateMonitor = monitor;
        this.mHeadsetStateHistory = new HeadsetStateHistory(monitor);
        this.mSrMonitor = new SuperResolutionMonitor();
        this.mFilterMonitor = new VideoFilterMonitor();
        this.mBrightMonitor = new BrightnessMonitor(this.mContext);
        this.mViewSizeMonitor = new ViewSizeMonitor();
        this.mSetSurfaceTimeList = new ArrayList();
    }

    @Override
    public void setUploadLogEnabled(boolean isUploadLogEnabled) {
        this.mUploadLogEnabled = isUploadLogEnabled;
        this.mEventBase.isUploadLogEnabled = isUploadLogEnabled;
    }

    @Override
    public boolean isUploadLogEnabled() {
        return this.mUploadLogEnabled;
    }

    @Override
    public void stop(int stopMethod) {
        this.mBrightMonitor.stop();
        this.mHeadsetStateHistory.stop();
        if (this.mState == 0) {
            return;
        }
        boolean isUpdateEventBase = true;
        long curTime = System.currentTimeMillis();
        if (this.mState == 4) {
            this.mEventOneOpera.endSeek("exit", 0);
            isUpdateEventBase = false;
        }
        if (this.mState == 3) {
            this.mEventOneEvent.movieStallEnd("exit");
            isUpdateEventBase = false;
            this.mEvent.lastBufferEndT = curTime;
        }
        this.mState = 0;
        if (this.mLeave && this.mEvent.pt_new > 0L && this.mEvent.vt <= 0L) {
            if (this.mEvent.lt <= 0L) {
                this.mEvent.lt = curTime;
            }
        } else {
            this.mEvent.et = curTime;
        }
        if (isUpdateEventBase) {
            this.mEventBase.movieFinish();
        }
        if (this.mAVOutSyncing) {
            long pos = -1L;
            if (this.mDataSource != null) {
                pos = this.mDataSource.getLogValueInt(67);
            }
            this.mEventOneOutSync.AVOutSyncEnd((int)pos, "exit");
            this.mAVOutSyncing = false;
        }
        if (this.mEvent.playerFirstFrameT <= 0L) {
            Map info = this._getFirstFrameSplitInfo();
            this.mDataSource.onInfo(2, info);
        }
        this._upload(stopMethod);
    }

    @Override
    public void setPlayType(int type) {
        this.mEventBase.mPlayType = type;
    }

    @Override
    public void setPlayAPIVersion(int apiVersion, String authorization) {
        this.mApiVer = apiVersion;
        this.mAuth = authorization;
    }

    @Override
    public void useHardwareDecode(int hw) {
        this.mEventBase.useVideoHW(hw);
    }

    @Override
    public void useAsyncInit(int asyncInit, int asyncCodecId) {
        this.mAsyncInit = asyncInit;
        this.mAsyncCodecId = asyncCodecId;
    }

    @Override
    public void enableStartPlayAutomatically(boolean isEnable) {
        this.mIsStartPlayAutomatically = isEnable ? 1 : 0;
    }

    @Override
    public void bufferDataSeconds(int seconds) {
        this.mBufferDataSeconds = seconds;
    }

    @Override
    public void updateNetworkSpeedPredictorSampleValue(String downloadVideoStreamId, String downloadAudioStreamid, float downVideoSpeed, float downAudioSpeed, float predictVideoSpeed, float predictAudioSpeed, long timeInterval, Map<String, String> extraVideoMap, Map<String, String> extraAudioMap) {
        if (this.mEventSample == null) {
            return;
        }
        this.mEventSample.updateNetworkSpeed(downloadVideoStreamId, downloadAudioStreamid, downVideoSpeed, downAudioSpeed, predictVideoSpeed, predictAudioSpeed, timeInterval, extraVideoMap, extraAudioMap);
    }

    @Override
    public void updateNetworkSpeedPredictorSampleMutiValue(SpeedPredictorResultCollection mutiDownSpeed, SpeedPredictorResultCollection mutiPredictSpeed, long timeInterval) {
        if (mutiDownSpeed == null || mutiPredictSpeed == null || this.mEventSample == null) {
            return;
        }
        this.mEventSample.updateNetworkMutiSpeed(mutiDownSpeed, mutiPredictSpeed, timeInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateGlobalNetworkSpeed(long size, long time, int interval) {
        if (interval != this.mNetSpeedUpdateInterval && interval != -1) return;
        String string = TAG;
        synchronized (TAG) {
            TTVideoEngineLog.d(TAG, "global speed size:" + size + ", time:" + time + ", totalsize:" + this.mMDLDownloadSize + ", totaltime:" + this.mMDLDownloadTime);
            this.mMDLDownloadSize += size;
            this.mMDLDownloadTime += time;
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void updateMultiNetworkSpeed(final String info) {
        EngineThreadPool.addExecuteTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String string = VideoEventLoggerV2.TAG;
                synchronized (VideoEventLoggerV2.TAG) {
                    try {
                        JSONObject jsonObject = new JSONObject(info);
                        JSONArray dataArray = jsonObject.optJSONArray("data");
                        long maxCostTime = 0L;
                        for (int i = 0; i < dataArray.length(); ++i) {
                            JSONObject speedRecordJsonObj = dataArray.getJSONObject(i);
                            JSONArray downInfoArray = speedRecordJsonObj.optJSONArray("downinfo");
                            if (downInfoArray == null || downInfoArray.length() <= 0) continue;
                            for (int j = 0; j < downInfoArray.length(); ++j) {
                                JSONObject downInfoItem = downInfoArray.getJSONObject(j);
                                long size = downInfoItem.optLong("size");
                                long time = downInfoItem.optLong("costTime");
                                if (size == 0L && time == -1L) continue;
                                VideoEventLoggerV2.this.mMDLDownloadSize = VideoEventLoggerV2.this.mMDLDownloadSize + size;
                                maxCostTime = Math.max(maxCostTime, time);
                            }
                        }
                        VideoEventLoggerV2.this.mMDLDownloadTime = maxCostTime;
                        TTVideoEngineLog.d(VideoEventLoggerV2.TAG, "update multi speed size:" + VideoEventLoggerV2.this.mMDLDownloadSize + ", time:" + VideoEventLoggerV2.this.mMDLDownloadTime);
                    }
                    catch (Exception e) {
                        TTVideoEngineLog.e(VideoEventLoggerV2.TAG, "update networkspeed error " + e.toString());
                    }
                    return;
                }
            }
        });
    }

    @Override
    public void setFeed(IVideoModel model) {
        if (model == null) {
            return;
        }
        this.updateVideoInfo(model);
    }

    @Override
    public void setFeed(VideoModel model) {
        this.setFeed((IVideoModel)model);
    }

    @Override
    public void setCustomStr(String customStr) {
        this.mCustomStr = customStr;
    }

    @Override
    public void setCustomInfo(IVideoEventLogger.VideoEventCustomInfo key, Object value) {
        TTVideoEngineLog.d(TAG, "brian setCustomInfo key:" + (Object)((Object)key) + ", value:" + value);
        if (this.mEvent != null) {
            try {
                switch (key) {
                    case VIDEOEVENT_CUSTOM_INFO_FFTIME_CLICK: {
                        this.mCustomClickT = (Long)value;
                        break;
                    }
                    case VIDEOEVENT_CUSTOM_INFO_FFTIME_VIDEOMODEL: {
                        this.mCustomGetVideoModelT = (Long)value;
                        break;
                    }
                    case VIDEOEVENT_CUSTOM_INFO_FFTIME_CUSTOMPLAY: {
                        break;
                    }
                    case VIDEOEVENT_CUSTOM_INFO_FFTIME_INITENGINE: {
                        this.mCustomInitEngineT = (Long)value;
                        break;
                    }
                    case VIDEOEVENT_CUSTOM_INFO_FFTIME_PLAYENGINE: {
                        this.mCustomPlayEngineT = (Long)value;
                        break;
                    }
                    case VIDEOEVENT_CUSTOM_INFO_CAST_OBJECT: {
                        if (value instanceof HashMap) {
                            this.mCastObject = (HashMap)value;
                        }
                        break;
                    }
                    case VIDEOEVENT_CUSTOM_INFO_OTT_PLUGIN_VERSION: {
                        this.mOttPluginVersion = (Integer)value;
                        break;
                    }
                    case VIDEOEVENT_CUSTOM_INFO_COMPANY_ID: {
                        this.mCompanyID = (String)value;
                        break;
                    }
                    default: {
                        TTVideoEngineLog.e(TAG, "setCustomInfo invalid key:" + (Object)((Object)key) + ", value:" + value);
                        break;
                    }
                }
            }
            catch (Exception e) {
                TTVideoEngineLog.e(TAG, "setCustomInfo fail:" + e.toString());
            }
        }
    }

    @Override
    public void setInitialURL(String videoInitUrl, String audioInitUrl) {
        this.mInitialURL = videoInitUrl;
        if (this.mEventBase != null) {
            this.mEventBase.mInitialURL = videoInitUrl;
        }
        this.mAudioInitURL = audioInitUrl;
    }

    @Override
    public void setCurURL(String url) {
        if (this.mEventBase != null && url != null && !url.isEmpty()) {
            this.mEventBase.setCurURL(url);
        }
    }

    @Override
    public void setInitialHost(String initialHost) {
        this.mInitialHost = initialHost;
        if (this.mEventBase != null) {
            this.mEventBase.mInitialHost = initialHost;
        }
    }

    @Override
    public void setCurHost(String host) {
        if (this.mEventBase != null && host != null && !host.isEmpty()) {
            this.mEventBase.setCurHost(host);
        }
    }

    @Override
    public void setInitialIP(String initialIP) {
        this.mInitialIP = initialIP;
        if (this.mEventBase != null) {
            this.mEventBase.mInitialIP = initialIP;
        }
    }

    @Override
    public void setCurIP(String ip) {
        if (this.mEventBase != null && ip != null && !ip.isEmpty()) {
            this.mEventBase.setCurIP(ip);
        }
    }

    @Override
    public void setInitialResolution(String initialResolution) {
        this.mInitialResolution = initialResolution;
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("to", initialResolution);
        map.put("p", -1);
        map.put("t", System.currentTimeMillis());
        map.put("c", 0);
        map.put("seam", false);
        this.mResolutionList.add(new JSONObject(map).toString());
    }

    @Override
    public void setCurResolution(String res) {
        if (this.mEventBase != null) {
            this.mEventBase.setCurResolution(res);
        }
    }

    @Override
    public void setInitialQuality(String quality) {
        this.mInitialQuality = quality;
    }

    @Override
    public void setInitialQualityType(int qualityType) {
        this.mInitialQualityType = qualityType;
    }

    @Override
    public void setCurQuality(String quality) {
        if (this.mEventBase != null) {
            this.mEventBase.setCurQuality(quality);
        }
    }

    @Override
    public void setStartPlayWidth(int width) {
        this.mWidth = width;
    }

    @Override
    public void setStartPlayHeight(int height) {
        this.mHeight = height;
    }

    @Override
    public void setDNSParseTime(long timeStamp, int module) {
        if (this.mEvent == null) {
            return;
        }
        if (this.mEvent.dnsT <= 0L) {
            this.mEvent.dnsT = timeStamp;
            this.mEvent.dnsModule = module;
        }
    }

    @Override
    public void setTranConnectTime(long timeStamp) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.tranConnectT = timeStamp;
    }

    @Override
    public void setTranFirstPacketTime(long timeStamp) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.tranFirstPacketT = timeStamp;
    }

    @Override
    public void setAudioDNSParseTime(long timeStamp, int module) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.audioDnsT = timeStamp;
    }

    @Override
    public void setAudioTranConnectTime(long timeStamp) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.audioTranConnectT = timeStamp;
    }

    @Override
    public void setAudioTranFirstPacketTime(long timeStamp) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.audioTranFirstPacketT = timeStamp;
    }

    @Override
    public void setReceiveFirstVideoFrameTime(long timeStamp) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.receiveFirstVideoFrameT = timeStamp;
    }

    @Override
    public void setDecodeFirstVideoFrameTime(long timeStamp) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.decodeFirstVideoFrameT = timeStamp;
    }

    @Override
    public void setReceiveFirstAudioFrameTime(long timeStamp) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.receiveFirstAudioFrameT = timeStamp;
    }

    @Override
    public void setDecodeFirstAudioFrameTime(long timeStamp) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.decodeFirstAudioFrameT = timeStamp;
    }

    @Override
    public void setFirstPlayerFirstFrameTime(long timeStamp) {
        if (this.mEvent == null) {
            return;
        }
        if (this.mEvent.playerFirstFrameT <= 0L) {
            this.mEvent.playerFirstFrameT = timeStamp;
        }
    }

    @Override
    public void setPlayerHostAddr(String addr) {
        if (this.mEvent == null || TextUtils.isEmpty((CharSequence)addr)) {
            return;
        }
        this.mEvent.internalIP = addr;
    }

    @Override
    public void setNetWorkTryCount(int tryCount) {
        this.mNetWorkTryCount = tryCount;
    }

    @Override
    public void setVUArray(ArrayList vuArray) {
        this.mVUArray = vuArray;
    }

    @Override
    public void setSourceType(int sourceType, String vid) {
        if (sourceType == 0) {
            this.mIsLocal = true;
        }
        this.mEventBase.setSourceType(sourceType, vid);
        this.mPlayCount = 0;
        this._setDefaultExitReason(sourceType);
    }

    @Override
    public void setDnsMode(int mode) {
        this.mEvent.dnsModule = mode == 1 || mode != 0 && this.mEventBase.mSourceTypeStr.equals("dir_url") || this.mEventBase.mEnableMDL == 1 || this.mEventBase.mEnableMDL == 2 ? 1 : 0;
    }

    private void collectPowerStatistics() {
        if (this.mEventBase.mEnablePowerReport) {
            HashMap<String, Object> batteryInfo;
            double cpuRate = this.mEventBase.getCPURate();
            double cpuSpeed = this.mEventBase.getCPUSpeed();
            if (cpuRate > 0.0 && cpuSpeed > 0.0) {
                this.mEvent.mCpuRateBegin = cpuRate;
                this.mEvent.mCpuSpeedBegin = cpuSpeed;
            } else {
                EngineThreadPool.addExecuteTask(new StatisticDataRunnable(this.mEvent, this.mEventBase));
            }
            int isPowerSaveMod = DeviceMonitorUtils.isPowerSaveMode(this.mContext);
            if (isPowerSaveMod >= 0) {
                this.mEvent.mPowerSaveModeBegin = isPowerSaveMod;
            }
            if ((batteryInfo = this.mEventBase.getChargingState()) != null) {
                this.mPowerList.add((Integer)batteryInfo.get("power"));
                this.mChargingList.add((Integer)batteryInfo.get("isCharging"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void beginToPlay(String vid, long time, String device_id) {
        this.mState = 1;
        this.mEventBase.beginToPlay(vid, device_id);
        this.mEventBase.registerNetwork();
        if (this.mIsReplay == 1) {
            this.setds_t = time;
        }
        if (this.ps_t <= 0L) {
            this.ps_t = time;
            this.collectPowerStatistics();
        }
        this.mLeave = true;
        this.mEvent.traceID = this.mEventBase.mSessionID;
        this.mEvent.prepare_start_time = this.mIsReplay == 1 ? time : Integer.MIN_VALUE;
        this.mEvent.prepare_end_time = Integer.MIN_VALUE;
        this.mEvent.dnsT = Integer.MIN_VALUE;
        this.mEvent.tranConnectT = Integer.MIN_VALUE;
        this.mEvent.tranFirstPacketT = Integer.MIN_VALUE;
        this.mEvent.audioDnsT = Integer.MIN_VALUE;
        this.mEvent.audioTranConnectT = Integer.MIN_VALUE;
        this.mEvent.audioTranFirstPacketT = Integer.MIN_VALUE;
        this.mEvent.receiveFirstVideoFrameT = Integer.MIN_VALUE;
        this.mEvent.receiveFirstAudioFrameT = Integer.MIN_VALUE;
        this.mEvent.decodeFirstVideoFrameT = Integer.MIN_VALUE;
        this.mEvent.decodeFirstAudioFrameT = Integer.MIN_VALUE;
        this.mEvent.videoDeviceStartTime = Integer.MIN_VALUE;
        this.mEvent.audioDeviceStartTime = Integer.MIN_VALUE;
        this.mEvent.videoDeviceOpenedTime = Integer.MIN_VALUE;
        this.mEvent.audioDeviceOpenedTime = Integer.MIN_VALUE;
        ++this.mPlayCount;
        this.mEvent.lastSeekStartT = Integer.MIN_VALUE;
        this.mEvent.lastSeekEndT = Integer.MIN_VALUE;
        this.mEvent.lastBufferStartT = Integer.MIN_VALUE;
        this.mEvent.lastBufferEndT = Integer.MIN_VALUE;
        this.mEvent.lastResolutionStartT = Integer.MIN_VALUE;
        this.mEvent.lastResolutionEndT = Integer.MIN_VALUE;
        this.mEvent.lastSeekPosition = Integer.MIN_VALUE;
        this.mEvent.mIsEngineReuse = this.mIsEngineReuse;
        if (!this.mIsEngineReuse) {
            this.mIsEngineReuse = true;
        }
        if (this.mEventBase.mSourceTypeStr.equals("vid")) {
            this._recordExitReason(-1002, true);
        } else if (this.mEventBase.mSourceTypeStr.equals("local_url")) {
            this._recordExitReason(-1005, true);
        } else if (this.mEvent.dnsModule == 0) {
            this._recordExitReason(-1003, true);
        } else if (this.mEvent.dnsModule == 1) {
            this._recordExitReason(-1005, true);
        }
        if (this.mEnableSpeedReport) {
            this.mEventSample.startRecord();
        }
        TTVideoEngineLog.i(TAG, "netlevel interval:" + this.mNetLevelIntervalMs + ", max count:" + this.mNetLevelMaxCount);
        if (this.mNetLevelIntervalMs <= 0 || this.mTimerTask != null) return;
        NetworkPortraitData portraitData = PortraitNetworkScore.getInstance().getPortraitData();
        portraitData.setSampleInterval(this.mNetLevelIntervalMs);
        portraitData.setMaxCount(this.mNetLevelMaxCount);
        this.mTimerTask = new MyTimerTask();
        portraitData.start();
        portraitData.schedule(this.mTimerTask, this.mNetLevelIntervalMs);
        this.mEvent.mNetQualityInterval = this.mNetLevelIntervalMs;
        this.mNetSpeedUpdateInterval = this.mNetLevelIntervalMs / 3;
        this.mNetSpeedUpdateInterval = Math.max(this.mNetSpeedUpdateInterval, 200);
        String string = TAG;
        synchronized (TAG) {
            JSONObject netSettings;
            int interval;
            this.mMDLDownloadTime = 0L;
            this.mMDLDownloadSize = 0L;
            // ** MonitorExit[var6_5] (shouldn't be in output)
            this.mNetworkQualityAlgorithm = PortraitNetworkScore.getInstance().genNetworkQualityAlg();
            if (this.mNetworkQualityVar != null && !this.mNetworkQualityVar.isEmpty()) {
                this.mNetworkQualityAlgorithm.setStringOption(4, this.mNetworkQualityVar);
                this.mNetworkQualityVar = null;
            }
            int n = interval = (netSettings = SettingsHelper.helper().getVodJsonObject(SETTINGS_NET_QUALITY)) == null ? 0 : netSettings.optInt(SETTINGS_CALCULATE_INTERVAL);
            if (this.mBitrateCalculationTask != null || interval <= 0) return;
            this.mBitrateCalculationTask = new PortraitNetworkScore.BitrateCalculationTask(portraitData, this.mNetworkQualityAlgorithm);
            portraitData.schedule(this.mBitrateCalculationTask, interval);
            TTVideoEngineLog.d(TAG, "bitrate calculate interval: " + interval);
            return;
        }
    }

    @Override
    public void setTag(String tag) {
        if (this.mEventBase != null && tag != null && !tag.isEmpty()) {
            this.mEventBase.mTag = tag;
        }
    }

    @Override
    public void logPluginException(String exceptionStr) {
        if (this.mEvent != null) {
            this.mEvent.pluginException = 1;
            if (!TextUtils.isEmpty((CharSequence)exceptionStr)) {
                this.mEvent.ownPlayerCreateException = exceptionStr;
            }
        }
    }

    @Override
    public void needRetryToFetch(Error error, int apiVersion) {
        HashMap map = error.toMap();
        map.put("apiver", apiVersion);
        this.mRetryFetchErrorInfo.add(map);
    }

    @Override
    public void firstDNSFailed(Error error) {
        this.mFirstDNSErrorInfo.add(error);
    }

    @Override
    public void fetchInfoComplete(VideoModel model, Error error) {
        this.fetchInfoComplete((IVideoModel)model, error);
    }

    @Override
    public void fetchInfoComplete(IVideoModel model, Error error) {
        if (model != null) {
            this.updateVideoInfo(model);
            if (this.mEvent.vt <= 0L) {
                this.mEvent.at = System.currentTimeMillis();
            }
            this.mFetchComplete = true;
            if (this.mEvent.dnsModule == 1) {
                this._recordExitReason(-1005, true);
            } else if (this.mEvent.dnsModule == 0) {
                this._recordExitReason(-1004, true);
            }
        }
    }

    @Override
    public void mdlRetryResult(int resultCode, String fileHash, Error error) {
        HashMap map = new HashMap();
        if (error != null) {
            map = error.toMap();
        }
        map.put("result", resultCode);
        if (fileHash != null) {
            map.put("filehash", fileHash);
        }
        this.mMDLRetryInfo.add(new JSONObject((Map)map).toString());
        if (resultCode != 0) {
            this.mEvent.mExpirePlayCode = 3;
        }
    }

    @Override
    public void updateVideoInfo(VideoModel model) {
        this.updateVideoInfo((IVideoModel)model);
    }

    @Override
    public void updateVideoInfo(IVideoModel model) {
        if (model == null) {
            return;
        }
        this.mEventBase.setVideoInfo(model);
        this.mVideoModel = model;
        PortraitEngine.getInstance().updateLabelByVideoModel(model);
    }

    @Override
    public void setDuration(int duration) {
        this.mDuration = duration;
        this.mEventBase.vd = duration;
    }

    @Override
    public void setStartTime(int startTime) {
        this.mStartTime = startTime;
    }

    @Override
    public void setDisableAccurateStart(int disableAccurateStart) {
        this.mDisableAccurateStart = disableAccurateStart;
    }

    @Override
    public void prepareStart() {
        if (this.mEvent.vt <= 0L) {
            this.mEvent.prepare_start_time = System.currentTimeMillis();
        }
    }

    @Override
    public void prepareEnd() {
        if (this.mEvent.vt <= 0L) {
            this.mEvent.prepare_end_time = System.currentTimeMillis();
        }
    }

    @Override
    public void validateVideoMetaInfoFail(Error error) {
        this.mEvent.hijack = 1;
        this.mErrorInfo.add(error);
    }

    @Override
    public void showedOneFrame() {
        if (this.mState != 4 || this.mLeave) {
            this.mState = 2;
            this.mLeave = false;
            if (this.mIsReplay == 1 && this.mEvent.prepare_end_time <= 0L) {
                this.mEvent.prepare_end_time = System.currentTimeMillis();
            }
            if (this.mEvent.vt <= 0L) {
                int asyncInit;
                this.mEvent.vt = System.currentTimeMillis();
                if (this.mEventOneEvent != null) {
                    this.mEventOneEvent.showedFirstFrame();
                }
                if (this.mEventOneOutSync != null) {
                    this.mEventOneOutSync.showedFirstFrame();
                }
                if (this.mEventOneNoRender != null) {
                    this.mEventOneNoRender.showedFirstFrame();
                }
                this.mEventBase.showedOneFrame();
                if (this.mDataSource != null) {
                    this.mEvent.mVideoCodecProfile = this.mDataSource.getLogValueInt(63);
                    this.mEvent.mAudioCodecProfile = this.mDataSource.getLogValueInt(64);
                }
                if (this.mAsyncInit == 1 && (asyncInit = this.mDataSource.getLogValueInt(97)) == 0) {
                    this.mAsyncInit = -1;
                }
            }
            this._recordExitReason(-2001, true);
        }
    }

    @Override
    public void showedFirstAVSyncVideoFrame(long t) {
        if (this.mEvent.vt > 0L) {
            this.mEvent.v_first_sync_t = t;
        }
    }

    @Override
    public void configResolution(String toResolution, String lastResolution) {
        this.mEventBase.configResolution(toResolution, lastResolution);
    }

    @Override
    public void switchResolution(String toResolution, String fromResolution, boolean isSeamSwitch) {
        if (isSeamSwitch) {
            if (this.mState == 4) {
                this.mEventOneOpera.endSeek("switch", 0);
            }
            if (this.mState == 3) {
                this.mEventOneEvent.movieStallEnd("switch");
                this.mEvent.lastBufferEndT = System.currentTimeMillis();
            }
        }
        if (this.mAVOutSyncing) {
            long pos = -1L;
            if (this.mDataSource != null) {
                pos = this.mDataSource.getLogValueInt(67);
            }
            this.mEventOneOutSync.AVOutSyncEnd((int)pos, "switch");
            this.mAVOutSyncing = false;
        }
        this.mEvent.et = System.currentTimeMillis();
        if (!toResolution.equals(fromResolution)) {
            ++this.mSwitchResolutionCount;
        }
        this.mEventBase.configResolution(toResolution, fromResolution);
        if (this.mEvent != null) {
            this.mEvent.lastResolutionStartT = System.currentTimeMillis();
        }
        if (isSeamSwitch) {
            this._recordExitReason(-2005, true);
        }
    }

    @Override
    public void setCurrentQualityDesc(String qualityDesc) {
        this.mEventBase.setCurrentQualityDesc(qualityDesc);
    }

    @Override
    @Deprecated
    public void switchResolution() {
        if (this.mEvent != null) {
            this.mEvent.lastResolutionStartT = System.currentTimeMillis();
        }
        this._recordExitReason(-2005, true);
    }

    @Override
    public void switchResolutionEnd(boolean isSeamSwitch) {
        if (isSeamSwitch) {
            if (this.mState == 4) {
                this.mEventOneOpera.endSeek("wait", 0);
            }
            if (this.mState == 3) {
                this.mState = 2;
            }
        }
        if (this.mEvent != null) {
            this.mEvent.lastResolutionEndT = System.currentTimeMillis();
            if (this.mEvent.lastResolutionStartT > 0L) {
                long costTime = this.mEvent.lastResolutionEndT - this.mEvent.lastResolutionStartT;
                int pos = -1;
                if (this.mDataSource != null) {
                    pos = this.mDataSource.getLogValueInt(67);
                }
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                map.put("to", this.mEventBase.mCurrentResolution);
                map.put("p", pos);
                map.put("t", System.currentTimeMillis());
                map.put("c", costTime);
                map.put("seam", isSeamSwitch);
                this.mResolutionList.add(new JSONObject(map).toString());
            }
        }
        if (isSeamSwitch) {
            this._recordExitReason(-2005, false);
        }
    }

    @Override
    public void recordBlockReason(int reason, boolean isStart) {
        if (this.mEvent == null) {
            return;
        }
        if (isStart) {
            this.mLeaveReason = reason;
            this.mBlockBeginT = SystemClock.elapsedRealtime();
        } else {
            this.mLeaveReason = Integer.MIN_VALUE;
            this.mBlockBeginT = Integer.MIN_VALUE;
        }
    }

    @Override
    public void play(boolean byPlay) {
        int pos = -1;
        if (this.mDataSource != null) {
            pos = this.mDataSource.getLogValueInt(67);
        }
        HashMap<String, Number> map = new HashMap<String, Number>(2);
        map.put("p", pos);
        map.put("t", System.currentTimeMillis());
        this.mPlayList.add(new JSONObject(map).toString());
        if (byPlay && this.enableReport(4)) {
            this.mBrightMonitor.setPlaying(true);
            this.mBrightMonitor.start();
        }
        this.mViewSizeMonitor.tryAddLastSizeToHistory();
        if (this.enableReport(8)) {
            this.mHeadsetStateMonitor.start();
            this.mHeadsetStateHistory.start();
        }
    }

    private boolean enableReport(int level) {
        return (this.mReportLevel & level) != 0;
    }

    @Override
    public void pause() {
        int pos = -1;
        if (this.mDataSource != null) {
            pos = this.mDataSource.getLogValueInt(67);
        }
        HashMap<String, Number> map = new HashMap<String, Number>(2);
        long curT = System.currentTimeMillis();
        map.put("p", pos);
        map.put("t", curT);
        this.mPauseList.add(new JSONObject(map).toString());
        this.mBrightMonitor.setPlaying(false);
        if (this.mAVOutSyncing) {
            this.mEventOneOutSync.setLongValue(1, curT);
        }
    }

    @Override
    public void seekTo(int fromT, int toT, boolean isSwitching) {
        if (!this.mLeave) {
            if (!isSwitching) {
                long curTime = System.currentTimeMillis();
                if (this.mState == 3) {
                    this.mEventOneEvent.movieStallEnd("seek");
                    this.mEvent.lastBufferEndT = curTime;
                }
                if (this.mState == 4) {
                    this.mEventOneOpera.endSeek("seek", 0);
                }
                ++this.mSeekCount;
                this.mState = 4;
                this.mEventOneOpera.beginSeek(fromT, toT, this.mSeekCount);
                this.mEventOneOpera.mLastBufferStartT = this.mEvent.lastBufferStartT;
                this.mEventOneOpera.mLastBufferEndT = this.mEvent.lastBufferEndT;
                this.mSeekBeginT = curTime;
                if (this.mEvent != null) {
                    this.mEvent.lastSeekStartT = this.mSeekBeginT;
                    this.mEvent.lastSeekPosition = toT;
                }
                this.mSeekBeginT = SystemClock.elapsedRealtime();
                if (this.mAVOutSyncing) {
                    this.mEventOneOutSync.AVOutSyncEnd(fromT, "seek");
                    this.mAVOutSyncing = false;
                }
            }
            this._recordExitReason(-2002, true);
        }
    }

    @Override
    public void seekCompleted() {
        if (this.mSeekBeginT > 0L) {
            this.mSeekBeginT = Integer.MIN_VALUE;
            if (this.mEvent != null) {
                this.mEvent.lastSeekEndT = System.currentTimeMillis();
            }
        }
    }

    @Override
    public void renderSeekCompleted(int isSeekInCached) {
        this._recordExitReason(-2002, false);
        this.mState = 2;
        this.mEventOneOpera.endSeek("wait", isSeekInCached);
    }

    @Override
    public void moviePreStalled(int type) {
        TTVideoEngineLog.i(TAG, "movie may stall");
        this.mEventOneEvent.moviePreStalled(type);
    }

    @Override
    public int getMovieStalledType() {
        if (this.mEventOneEvent != null) {
            return this.mEventOneEvent.getMovieStalledType();
        }
        return -1;
    }

    @Override
    public void reportBufferingMetrics() {
        if (this.mEventOneEvent != null) {
            this.mEventOneEvent.triggerBufferStartCb();
        }
    }

    @Override
    public void movieStalled(int type, int curPos) {
        TTVideoEngineLog.i(TAG, "movieStalled, type: " + type);
        if (type == 0) {
            if (this.mState != 3 && this.mState != 4) {
                this.mState = 3;
                ++this.mNetBufferIndex;
                this.mEventOneEvent.movieStalled(curPos, this.mNetBufferIndex);
            }
            ++this.mCurBufferCount;
            if (this.mState != 4) {
                this._recordExitReason(-2003, true);
            }
        } else if (type == 1) {
            ++this.mCurDecoderBufferCount;
            this._recordExitReason(-2004, true);
        }
        if (this.mEvent == null) {
            return;
        }
        long curTime = System.currentTimeMillis();
        if (this.mEvent.firstBufferStartT <= 0L) {
            this.mEvent.firstBufferStartT = curTime;
        }
        if (type == 1) {
            this.mDecodeBufferingStartT = curTime;
        }
        this.mEvent.lastBufferStartT = curTime;
    }

    @Override
    public void movieStallEnd(int type) {
        if (type == 0 && this.mState == 3) {
            this.mState = 2;
            this.mEventOneEvent.movieStallEnd("wait");
        }
        if (this.mEvent == null) {
            return;
        }
        if (type == 0) {
            if (this.mState != 4) {
                this._recordExitReason(-2003, false);
            }
        } else if (type == 1) {
            this._recordExitReason(-2004, false);
        }
        long curTime = System.currentTimeMillis();
        if (this.mEvent.firstBufferEndT <= 0L) {
            this.mEvent.firstBufferEndT = curTime;
        }
        if (type == 1 && this.mDecodeBufferingStartT > 0L && curTime >= this.mDecodeBufferingStartT) {
            long difftime = curTime - this.mDecodeBufferingStartT;
            this.mCurDecoderBufferAccuT += difftime;
            this.mDecodeBufferingStartT = 0L;
        }
        this.mEvent.lastBufferEndT = curTime;
    }

    @Override
    public void AVOutSyncStart(int pos) {
        this.mAVOutSyncing = true;
        long lastRebufTime = -1L;
        long lastSeekTime = -1L;
        if (this.mEventOneEvent != null) {
            lastRebufTime = this.mEventOneEvent.getLastRebufTime();
        }
        if (this.mEventOneOpera != null) {
            lastSeekTime = this.mEventOneOpera.getLastSeekTime();
        }
        this.mEventOneOutSync.AVOutSyncStart(pos, lastRebufTime, lastSeekTime, this.mHeadsetStateHistory.getLastSwitchTime());
        if (this.mState == 2) {
            this._recordExitReason(-2006, true);
        }
    }

    @Override
    public void AVOutSyncEnd(int pos) {
        this.mEventOneOutSync.AVOutSyncEnd(pos, "wait");
        this.mAVOutSyncing = false;
        if (this.mState == 2) {
            this._recordExitReason(-2006, false);
        }
    }

    @Override
    public void AVNoRenderStart(int type, int reason) {
        TTVideoEngineLog.d(TAG, "AVNoRenderStart, type: " + type + ", reason: " + reason);
        if (this.mEventOneNoRender.isStarted()) {
            this.mEventOneNoRender.updateReason(reason);
            TTVideoEngineLog.d(TAG, "AVNoRenderStart event is already started, abort");
            return;
        }
        long lastRebufTime = -1L;
        long lastSeekTime = -1L;
        if (this.mEventOneEvent != null) {
            lastRebufTime = this.mEventOneEvent.getLastRebufTime();
        }
        if (this.mEventOneOpera != null) {
            lastSeekTime = this.mEventOneOpera.getLastSeekTime();
        }
        this.mEventOneNoRender.start(type, reason, 0, lastRebufTime, lastSeekTime, this.mHeadsetStateHistory.getLastSwitchTime());
        String nStageError = this.mEventOneNoRender.getRenderStageError();
        if (!TextUtils.isEmpty((CharSequence)nStageError)) {
            this.mEvent.mRenderStageError = nStageError;
        }
        long firstFrameCost = -1L;
        if (this.mEvent.vt > 0L) {
            firstFrameCost = this.mEvent.vt - this.mEvent.pt_new;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", type);
        param.put("t", System.currentTimeMillis());
        param.put("codec", this.mEventBase.getCodecType());
        param.put("resolution", this.mEventBase.getCurResolution());
        param.put("quality_desc", this.mEventBase.mCurrentQualityDesc);
        param.put("hw", this.mEventBase.mVideoHW);
        param.put("ps_t", this.ps_t);
        param.put("first_frame_cost", firstFrameCost);
        if (this.mEvent.lastSeekStartT != Integer.MIN_VALUE) {
            param.put("seek_t", this.mEvent.lastSeekStartT);
        }
        if (this.mDataSource != null) {
            param.put("enable_nnsr", this.mDataSource.getLogValueInt(101));
            param.put("surface_error_code", this.mDataSource.getLogValueInt(100));
            param.put("switch_resolution_t", this.mDataSource.getLogValueLong(92));
            this.mDataSource.onInfo(5, param);
        }
        if (type == 0) {
            this._recordExitReason(-2007, true);
        } else if (type == 1) {
            this._recordExitReason(-2008, true);
        }
    }

    @Override
    public void AVNoRenderEnd(int type) {
        TTVideoEngineLog.d(TAG, "AVNoRenderEnd, type: " + type);
        if (!this.mEventOneNoRender.isStarted()) {
            TTVideoEngineLog.i(TAG, "AVNoRenderEnd, not started before, abort");
            return;
        }
        if (!this.mEventOneNoRender.isType(type)) {
            TTVideoEngineLog.i(TAG, "AVNoRenderEnd, type does not match, abort");
            return;
        }
        this.mEventOneNoRender.end(0, "wait");
        this.callbackNoRenderEnd(type);
        if (type == 0) {
            this._recordExitReason(-2007, false);
        } else if (type == 1) {
            this._recordExitReason(-2008, false);
        }
    }

    private void callbackNoRenderEnd(int type) {
        HashMap<String, Number> param = new HashMap<String, Number>(2);
        param.put("type", type);
        param.put("t", System.currentTimeMillis());
        if (this.mDataSource != null) {
            this.mDataSource.onInfo(6, param);
        }
    }

    @Override
    public void abrEventStart(long oldbr, long newbr) {
        this.mEventAbrSwitch.abrSwitchStart(oldbr, newbr);
    }

    @Override
    public void abrEventEnd(long bitrate) {
        this.mEventAbrSwitch.abrSwitchEnd(bitrate);
    }

    @Override
    public void accuBuffingTime(long time) {
    }

    @Override
    public void movieBufferDidReachEnd() {
        if (this.mEvent.bft <= 0L) {
            this.mEvent.bft = System.currentTimeMillis();
        }
    }

    @Override
    public void movieShouldRetry(Error error, int retryStrategy, int apiVersion) {
        if (error.isPlayerErrorDomain() && this.mVUArray.size() <= 1) {
            ++this.mBreakCount;
        }
        HashMap map = error.toMap();
        map.put("strategy", retryStrategy);
        map.put("apiver", apiVersion);
        this.mErrorInfo.add(map);
        this.logFirstError(error);
        this._accumulateVPS();
        if (this.mState == 3) {
            this.mEventOneEvent.movieShouldRetry();
        }
        if (this.mState == 4) {
            this.mEventOneOpera.movieShouldRetry();
        }
        long curT = System.currentTimeMillis();
        if (this.mCurError != null && this.mRetryStartT > 0L) {
            long costTime = curT - this.mRetryStartT;
            int pos = -1;
            HashMap<String, Number> map1 = new HashMap<String, Number>(5);
            if (this.mDataSource != null) {
                pos = this.mDataSource.getLogValueInt(67);
            }
            map1.put("ec", this.mCurError.code);
            map1.put("p", pos);
            map1.put("t", System.currentTimeMillis());
            map1.put("c", costTime);
            map1.put("st", this.mRetryStrategy);
            this.mErrorList.add(new JSONObject(map1).toString());
        }
        this.mCurError = error;
        this.mRetryStartT = curT;
        this.mRetryStrategy = retryStrategy;
        if (this.mLeave) {
            switch (retryStrategy) {
                case 1: {
                    this.mEvent.at = Integer.MIN_VALUE;
                }
                case 2: {
                    this.mEventBase.mDNSType = "";
                    this.mEvent.dns_start_t = Integer.MIN_VALUE;
                    this.mEvent.dns_end_t = Integer.MIN_VALUE;
                    this.mEvent.dnsT = Integer.MIN_VALUE;
                    this.mEvent.audioDnsT = Integer.MIN_VALUE;
                    this.mEvent.a_dns_start_t = Integer.MIN_VALUE;
                }
                case 3: {
                    if (this.mEvent.dnsModule == 1) {
                        this.mEventBase.mDNSType = "";
                        this.mEvent.dns_start_t = Integer.MIN_VALUE;
                        this.mEvent.dns_end_t = Integer.MIN_VALUE;
                        this.mEvent.dnsT = Integer.MIN_VALUE;
                        this.mEvent.audioDnsT = Integer.MIN_VALUE;
                        this.mEvent.a_dns_start_t = Integer.MIN_VALUE;
                    }
                    this.mEvent.prepare_start_time = Integer.MIN_VALUE;
                    this.mEvent.prepare_end_time = Integer.MIN_VALUE;
                    this.mEvent.tranConnectT = Integer.MIN_VALUE;
                    this.mEvent.tranFirstPacketT = Integer.MIN_VALUE;
                    this.mEvent.audioTranConnectT = Integer.MIN_VALUE;
                    this.mEvent.audioTranFirstPacketT = Integer.MIN_VALUE;
                    this.mEvent.receiveFirstAudioFrameT = Integer.MIN_VALUE;
                    this.mEvent.receiveFirstVideoFrameT = Integer.MIN_VALUE;
                    this.mEvent.decodeFirstAudioFrameT = Integer.MIN_VALUE;
                    this.mEvent.decodeFirstVideoFrameT = Integer.MIN_VALUE;
                    this.mEvent.videoDeviceStartTime = Integer.MIN_VALUE;
                    this.mEvent.videoDeviceOpenedTime = Integer.MIN_VALUE;
                    this.mEvent.audioDeviceStartTime = Integer.MIN_VALUE;
                    this.mEvent.audioDeviceOpenedTime = Integer.MIN_VALUE;
                    this.mEvent.formater_create_t = Integer.MIN_VALUE;
                    this.mEvent.avformat_open_t = Integer.MIN_VALUE;
                    this.mEvent.demuxer_create_t = Integer.MIN_VALUE;
                    this.mEvent.demuxer_begin_t = Integer.MIN_VALUE;
                    this.mEvent.dec_create_t = Integer.MIN_VALUE;
                    this.mEvent.outlet_create_t = Integer.MIN_VALUE;
                    this.mEvent.v_render_f_t = Integer.MIN_VALUE;
                    this.mEvent.a_render_f_t = Integer.MIN_VALUE;
                    this.mEvent.a_dec_start_t = Integer.MIN_VALUE;
                    this.mEvent.a_dec_opened_t = Integer.MIN_VALUE;
                    this.mEvent.v_dec_opened_t = Integer.MIN_VALUE;
                    this.mEvent.v_dec_start_t = Integer.MIN_VALUE;
                    this.mEvent.sub_req_finish_t = Integer.MIN_VALUE;
                    this.mEvent.sub_load_finish_t = Integer.MIN_VALUE;
                    this.mEvent.mask_open_t = Integer.MIN_VALUE;
                    this.mEvent.mask_opened_t = Integer.MIN_VALUE;
                    break;
                }
            }
        }
    }

    @Override
    public void retryFinish() {
        if (this.mCurError != null && this.mRetryStartT > 0L) {
            long curT = System.currentTimeMillis();
            long costTime = curT - this.mRetryStartT;
            int pos = -1;
            HashMap<String, Number> map1 = new HashMap<String, Number>(5);
            if (this.mDataSource != null) {
                pos = this.mDataSource.getLogValueInt(67);
            }
            map1.put("ec", this.mCurError.code);
            map1.put("p", pos);
            map1.put("t", curT);
            map1.put("c", costTime);
            map1.put("st", this.mRetryStrategy);
            this.mErrorList.add(new JSONObject(map1).toString());
        }
        this.mCurError = null;
        this.mRetryStartT = Integer.MIN_VALUE;
        this.mRetryStrategy = -1;
    }

    @Override
    public void movieFinish(Error error, int apiVersion) {
        boolean isUpdateEventBase = true;
        long curTime = System.currentTimeMillis();
        if (this.mState == 4) {
            this.mEventOneOpera.endSeek("error", 0);
            isUpdateEventBase = false;
        }
        if (this.mState == 3) {
            this.mEventOneEvent.movieStallEnd("error");
            isUpdateEventBase = false;
            this.mEvent.lastBufferEndT = curTime;
        }
        this.mState = 5;
        HashMap map = error.toMap();
        map.put("strategy", 0);
        map.put("apiver", apiVersion);
        this.mErrorInfo.add(map);
        if (this.mLeave && this.mEvent.vt <= 0L) {
            this.mEvent.lt = curTime;
        } else {
            if (error.isPlayerErrorDomain() && this.mVUArray.size() <= 1) {
                ++this.mBreakCount;
            }
            this.mEvent.et = curTime;
        }
        this.logFirstError(error);
        long pos = -1L;
        if (this.mDataSource != null) {
            pos = this.mDataSource.getLogValueInt(67);
            if (this.mEvent.playerFirstFrameT <= 0L) {
                Map info = this._getFirstFrameSplitInfo();
                this.mDataSource.onInfo(2, info);
            }
        }
        if (this.mCurError != null && this.mRetryStartT > 0L) {
            long costTime = curTime - this.mRetryStartT;
            HashMap<String, Number> map1 = new HashMap<String, Number>(5);
            map1.put("ec", this.mCurError.code);
            map1.put("p", pos);
            map1.put("t", curTime);
            map1.put("c", costTime);
            map1.put("st", this.mRetryStrategy);
            this.mErrorList.add(new JSONObject(map1).toString());
            this.mCurError = null;
            this.mRetryStrategy = -1;
            this.mRetryStartT = Integer.MIN_VALUE;
        }
        if (isUpdateEventBase) {
            this.mEventBase.movieFinish();
        }
        if (this.mAVOutSyncing) {
            this.mEventOneOutSync.AVOutSyncEnd((int)pos, "error");
            this.mAVOutSyncing = false;
        }
        this.mEvent.errt = error.getType();
        this.mEvent.errc = error.code;
        this._upload(4);
    }

    @Override
    public void movieFinish(int status, String message) {
        boolean isUpdateEventBase = true;
        if (this.mState == 4) {
            this.mEventOneOpera.endSeek("error", 0);
            isUpdateEventBase = false;
        }
        if (this.mState == 3) {
            this.mEventOneEvent.movieStallEnd("error");
            isUpdateEventBase = false;
            this.mEvent.lastBufferEndT = System.currentTimeMillis();
        }
        this.mState = 5;
        if (isUpdateEventBase) {
            this.mEventBase.movieFinish();
        }
        this.mEvent.vsc = status;
        this.mEvent.vscMessage = message;
        this.movieFinish(5);
    }

    @Override
    public void movieFinish(int leave_method) {
        long curTime = System.currentTimeMillis();
        if (leave_method != 5) {
            boolean isUpdateEventBase = true;
            if (this.mState == 4) {
                this.mEventOneOpera.endSeek("wait", 0);
                isUpdateEventBase = false;
            }
            if (this.mState == 3) {
                this.mEventOneEvent.movieStallEnd("wait");
                isUpdateEventBase = false;
                this.mEvent.lastBufferEndT = curTime;
            }
            if (isUpdateEventBase) {
                this.mEventBase.movieFinish();
            }
        }
        if (this.mAVOutSyncing) {
            long pos = -1L;
            if (this.mDataSource != null) {
                pos = this.mDataSource.getLogValueInt(67);
            }
            this.mEventOneOutSync.AVOutSyncEnd((int)pos, "finish");
            this.mAVOutSyncing = false;
        }
        if (this.mLeave && this.mEvent.vt <= 0L) {
            this.mEvent.lt = curTime;
        } else {
            this.mEvent.et = curTime;
        }
        this._upload(leave_method);
    }

    @Override
    public void watchFinish() {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.finish = 1;
    }

    @Override
    public void curPlayBackTime(int curPlayBackTime) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.curPlayBackTime = curPlayBackTime;
    }

    @Override
    public void curVideoOutputFps(float videoOutputFps) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.curVideoOutputFps = videoOutputFps;
    }

    @Override
    public void containerFps(float containerFps) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.containerFps = containerFps;
    }

    @Override
    public void curVideoDecoderFps(int videoDecoderFps) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.curVideoDecoderFps = videoDecoderFps;
    }

    @Override
    public void hwCodecException(int hwCodecException) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.hwCodecException = hwCodecException;
    }

    @Override
    public void hwCodecName(String hwCodecName) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.hwCodecName = hwCodecName;
    }

    @Override
    public void clockDiff(long clockDiff) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.clockDiff = clockDiff;
    }

    @Override
    public void enableSharp(int enableSharp) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.enableSharp = enableSharp;
    }

    @Override
    public void dropCount(int dropCount) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.dropCount = dropCount;
    }

    @Override
    public void deviceStartTime(int streamType, long startTime) {
        if (this.mEvent == null) {
            return;
        }
        switch (streamType) {
            case 0: {
                this.mEvent.videoDeviceStartTime = startTime;
                break;
            }
            case 1: {
                this.mEvent.audioDeviceStartTime = startTime;
                break;
            }
        }
    }

    @Override
    public void devicedOpenedTime(int streamType, long endTime) {
        if (this.mEvent == null) {
            return;
        }
        switch (streamType) {
            case 0: {
                this.mEvent.videoDeviceOpenedTime = endTime;
                break;
            }
            case 1: {
                this.mEvent.audioDeviceOpenedTime = endTime;
                break;
            }
        }
    }

    @Override
    public void codecName(int streamType, int codecNameId) {
        if (this.mEvent == null) {
            return;
        }
        switch (streamType) {
            case 0: {
                this.mEventBase.videoCodecNameId = codecNameId;
                break;
            }
            case 1: {
                this.mEventBase.audioCodecNameId = codecNameId;
                break;
            }
        }
    }

    @Override
    public void setSurface(String surface_code) {
        if (TextUtils.isEmpty((CharSequence)this.mSurfaceCode)) {
            this.mSurfaceCode = surface_code;
        }
        if (this.mSurfaceSetTime <= 0L) {
            this.mSurfaceSetTime = System.currentTimeMillis();
        }
    }

    @Override
    public void setFramesDropNum(int framesDropNum) {
        if (this.mEvent != null) {
            this.mEvent.mFramesSetDropNum = framesDropNum;
        }
    }

    @Override
    public void setVideoBufferLength(long videoBufferLength) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.videoBufferLength = (int)videoBufferLength;
    }

    @Override
    public void setAudioBufferLength(long audioBufferLength) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.audioBufferLength = (int)audioBufferLength;
    }

    @Override
    public void engineState(int engineState) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.engineState = engineState;
    }

    @Override
    public void setPlaybackParams(PlaybackParams params) {
        if (this.mEvent == null) {
            return;
        }
        float speed = params.getSpeed();
        HashMap<String, Number> paramMap = new HashMap<String, Number>(3);
        paramMap.put("AFMode", params.getAudioFallbackMode());
        paramMap.put("pitch", Float.valueOf(params.getPitch()));
        paramMap.put("speed", Float.valueOf(speed));
        this.mPlaybackParams = paramMap;
        if (this.mEventBase.mPlaySpeed != speed || this.mPlaySpeedList.isEmpty()) {
            this.mEventBase.mPlaySpeed = speed;
            HashMap<String, Number> map = new HashMap<String, Number>(3);
            int pos = -1;
            if (this.mDataSource != null) {
                pos = this.mDataSource.getLogValueInt(67);
            }
            map.put("to", Float.valueOf(this.mEventBase.mPlaySpeed));
            map.put("p", pos);
            map.put("t", System.currentTimeMillis());
            this.mPlaySpeedList.add(new JSONObject(map).toString());
        }
    }

    @Override
    public void curVideoDecodeError(int videoDecodeError) {
        if (this.mEvent == null) {
            return;
        }
        if (videoDecodeError > 0) {
            this.mEvent.curVideoDecodeError = videoDecodeError;
        }
    }

    @Override
    public void curAudioDecodeError(int audioDecodeError) {
        if (this.mEvent == null) {
            return;
        }
        if (audioDecodeError > 0) {
            this.mEvent.curAudioDecodeError = audioDecodeError;
        }
    }

    @Override
    public void curVideoRenderError(int videoRenderError) {
        if (this.mEvent == null) {
            return;
        }
        if (videoRenderError >= 0) {
            this.mEvent.curVideoRenderError = videoRenderError;
        }
    }

    @Override
    public void setCustomP2PCDNType(int type) {
        this.mCustomP2PCDNType = type;
    }

    @Override
    public void setP2PCDNType(int type) {
        this.mEventBase.setP2PCDNType(type);
    }

    @Override
    public void setP2PUrl(String url) {
        if (url != null) {
            this.mP2PUrl = url;
        }
    }

    @Override
    public void setP2PSDKVersion(String version) {
        if (version != null) {
            this.mP2PSDKVersion = version;
        }
    }

    @Override
    public void setProxyUrl(String value) {
        this.mProxyUrl = value;
    }

    @Override
    public void setEnableBash(int value) {
        this.mEnableBash = value;
    }

    @Override
    public void setEnableMDL(int value) {
        this.mEventBase.mEnableMDL = value;
    }

    @Override
    public void logMessage(String message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.mMessage = this.mMessage + message;
        }
    }

    @Override
    public void setLooping(boolean isLoop) {
        this.mLooping = isLoop;
    }

    @Override
    public void loopAgain() {
        ++this.mLoopCount;
        this.mLoopList.add(String.valueOf(System.currentTimeMillis()));
    }

    @Override
    public void addWatchedDuration(int duration) {
        this.mEvent.watchduration = duration;
    }

    @Override
    public void fetchedAndLeaveByUser(int FetchedAndLeave) {
        this.mEvent.fetchedAndLeaveByUser = FetchedAndLeave;
    }

    @Override
    public String getTraceID() {
        if (this.mEvent != null) {
            return this.mEvent.traceID;
        }
        return null;
    }

    @Override
    public String getExtraInfo() {
        return this.mExtraInfo;
    }

    @Override
    public int getAsyncInit() {
        return this.mAsyncInit;
    }

    @Override
    @Nullable
    public String getEncryptKey() {
        if (this.mEvent != null) {
            return this.mEvent.encryptKey;
        }
        return null;
    }

    @Override
    @Nullable
    public Error getFirstError() {
        return this.mFirstError;
    }

    @Override
    public void setTraceID(String traceID) {
        if (this.mEvent != null) {
            this.mEvent.traceID = traceID;
        }
        this.mEventBase.mTraceID = traceID;
    }

    @Override
    public void setDrmType(int drmType) {
        this.mEventBase.mDrmType = drmType;
    }

    @Override
    public void setDrmTokenUrl(String drmTokenUrl) {
        this.mEventBase.mDrmTokenUrl = drmTokenUrl;
    }

    @Override
    public void setSubTag(String subTag) {
        if (this.mEventBase != null && subTag != null && !subTag.isEmpty()) {
            this.mEventBase.mSubTag = subTag;
        }
    }

    @Override
    public void setCheckHijack(int value) {
        if (this.mEvent != null) {
            this.mEvent.checkHijack = value;
        }
    }

    @Override
    public void setHijackRetry(int value) {
        if (this.mEvent != null) {
            this.mEvent.hijackRetry = value;
        }
    }

    @Override
    public void setHijackCode(int value) {
        if (this.mEvent != null && value != -1) {
            if (this.mEvent.firstHijackCode == Integer.MIN_VALUE) {
                this.mEvent.firstHijackCode = value;
            } else {
                this.mEvent.lastHijackCode = value;
            }
        }
    }

    @Override
    public void reset() {
        this.mIsLocal = false;
        this.mLeave = true;
        this.mRetryFetchErrorInfo = new ArrayList();
        this.mMDLRetryInfo = new ArrayList();
        this.mFirstDNSErrorInfo = new ArrayList();
        this.mErrorInfo = new ArrayList();
        this.mVUArray = new ArrayList();
        this.mCustomStr = null;
        this.mInitialURL = null;
        this.mAudioInitURL = null;
        this.mInitialHost = null;
        this.mInitialIP = null;
        this.mInitialResolution = null;
        this.mInitialQuality = null;
        this.mInitialQualityType = Integer.MIN_VALUE;
        this.mMessage = "";
        this.mBufferDataSeconds = Integer.MIN_VALUE;
        this.mPlaybackParams = null;
        this.mDuration = Integer.MIN_VALUE;
        this.mStartTime = Integer.MIN_VALUE;
        this.mCurBufferCount = 0;
        this.mNetBufferIndex = 0;
        this.mCurDecoderBufferCount = 0;
        this.mBreakCount = 0;
        this.mCurDecoderBufferAccuT = 0L;
        this.mSeekCount = 0;
        this.mSwitchResolutionCount = 0;
        this.mAccumVPS = 0L;
        this.mAccumVDS = 0L;
        this.mRadioMode = Integer.MIN_VALUE;
        this.mEnableNNSR = Integer.MIN_VALUE;
        this.mReadCacheMode = Integer.MIN_VALUE;
        this.mPreRangeOff = Integer.MIN_VALUE;
        this.mAudioStreamDisabled = false;
        this.mVideoStreamDisabled = false;
        this.mMediaCodecRender = Integer.MIN_VALUE;
        this.mWidth = Integer.MIN_VALUE;
        this.mHeight = Integer.MIN_VALUE;
        this.mProxyUrl = null;
        this.mFetchComplete = false;
        this.mEnableBash = Integer.MIN_VALUE;
        int enableMDL = this.mEventBase.mEnableMDL;
        boolean enablePowerReport = this.mEventBase.mEnablePowerReport;
        this.mEventBase.unregisterNetwork();
        this.mEventBase = new VideoEventBase(this.mDataSource, this.mUploadLogEnabled, this.mContext);
        this.mEventBase.mEnableMDL = enableMDL;
        this.mEventBase.mEnablePowerReport = enablePowerReport;
        this.mEventSample = new VideoEventSampleRecord(this.mEventBase);
        this.mEventSample.mSampingRate = this.mNetworkSpeedPredictSamplingRate;
        this.mEventOneEvent.mEventBase = this.mEventBase;
        this.mEventOneOpera.mEventBase = this.mEventBase;
        this.mEventOneOutSync.mEventBase = this.mEventBase;
        this.mEventAbrSwitch.mEventBase = this.mEventBase;
        this.mEventOneNoRender.updateEventBase(this.mEventBase);
        this.mFeatureConfigs = new FeatureConfigs();
        this.mViewSizeMonitor = new ViewSizeMonitor();
        this.mFirstError = null;
        this.mUrlMatchCondition = false;
    }

    @Override
    public void setIsVideoModelCache(int value) {
        if (this.mEvent != null) {
            this.mEvent.useVideoModelCache = value;
        }
    }

    @Override
    public void setAbrInfo(Map<String, Object> abrInfo) {
        if (this.mEventBase != null) {
            this.mEventBase.abrInfo = abrInfo;
        }
    }

    @Override
    public void setAbrGeneralInfo(Map<String, Object> abrGeneralInfo) {
        if (this.mEventBase != null) {
            this.mEventBase.abrGeneralInfo = abrGeneralInfo;
        }
    }

    @Override
    public void setSpeedPredictorAlgoType(int speedPredictorAlgoType) {
        this.mEventBase.speed_predict_type = speedPredictorAlgoType;
    }

    @Override
    public void setIsEnableABR(int enableABR) {
        this.mEventBase.is_enable_abr = enableABR;
    }

    @Override
    public void setIsMultiDimensionsOut(int isMultiDimensionsOut) {
        this.mEventBase.is_multi_dimensions = isMultiDimensionsOut;
    }

    @Override
    public void setIsMultiDimensionsInput(int isMultiDimensionsInput) {
        this.mEventBase.is_multi_dimensionsInput = isMultiDimensionsInput;
    }

    @Override
    public void setEncryptKey(String encryptKey) {
        if (this.mEvent != null) {
            this.mEvent.encryptKey = encryptKey;
        }
    }

    @Override
    public void setDNSStartTime(long time, int mode) {
        if (this.mEvent != null) {
            this.mEvent.dns_start_t = time;
            this.mEvent.dnsModule = mode;
            if (this.mLeave && mode == 0) {
                this._recordExitReason(-1004, true);
            }
        }
    }

    @Override
    public void setDNSEndTime(long time) {
        if (this.mEvent != null) {
            this.mEvent.dns_end_t = time;
            if (this.mLeave && this.mEvent.dnsModule == 0) {
                this._recordExitReason(-1005, true);
            }
        }
    }

    @Override
    public void setPlayerCreatedT(long time) {
        if (this.mEvent != null && this.mEvent.player_created_t <= 0L) {
            this.mEvent.player_created_t = time;
        }
    }

    @Override
    public void logFirstError(Error error) {
        this.mFirstError = error;
        if (this.mEvent != null && this.mEvent.first_errc == Integer.MIN_VALUE && this.mEvent.first_errt == Integer.MIN_VALUE && this.mEvent.first_errc_internal == Integer.MIN_VALUE) {
            this.mEvent.first_errt = error.getType();
            this.mEvent.first_errc = error.code;
            this.mEvent.first_errc_internal = error.internalCode;
        }
    }

    @Override
    public void setVideoCacheSize(long cacheSize) {
        if (this.mEvent != null) {
            this.mEvent.vpls = cacheSize;
        }
    }

    @Override
    public void setDashAudioCacheSize(long cacheSize) {
        if (this.mEvent != null) {
            this.mEvent.d_apls = cacheSize;
        }
    }

    @Override
    public void setDashVideoCacheSize(long cacheSize) {
        if (this.mEvent != null) {
            this.mEvent.d_vpls = cacheSize;
        }
    }

    @Override
    public void setNetworkSpeedFrom(double speed, int key) {
        if (this.mEvent == null) {
            return;
        }
        switch (key) {
            case 0: {
                this.mEvent.firstFrameSpeed = speed;
                break;
            }
            case 1: {
                this.mEvent.playEndSpeed = speed;
                break;
            }
        }
    }

    @Override
    public void useTextureRender(int used) {
        if (this.mEvent == null) {
            return;
        }
        this.mEvent.textureRender = used;
    }

    @Override
    public void setTextureRenderError(String error) {
        if (this.mEvent == null || TextUtils.isEmpty((CharSequence)error)) {
            return;
        }
        this.mEvent.textureRenderErrorMsg = error;
    }

    @Override
    public void setMediaCodecRender(int mediaCodecRender) {
        this.mMediaCodecRender = mediaCodecRender;
    }

    @Override
    public void didSentEvent(int did) {
    }

    @Override
    public void playbackBufferStart() {
        if (this.mEvent.playbackBufferStartT <= 0L) {
            this.mEvent.playbackBufferStartT = System.currentTimeMillis();
        }
    }

    @Override
    public void playbackBufferEnd() {
        if (this.mEvent.playbackBufferEndT <= 0L) {
            this.mEvent.playbackBufferEndT = System.currentTimeMillis();
        }
    }

    @Override
    public IMediaMetrics buildMetrics(int metricsType) {
        IMediaMetrics metrics = MetricsFactory.createMetrics(metricsType, this.mEvent);
        return metrics;
    }

    @Override
    public void useCodecPool(int used) {
        this.mUseCodecPool = used;
    }

    @Override
    public String getStringOption(int key) {
        String ret = "";
        try {
            switch (key) {
                case 47: {
                    ret = this.mEventBase.mSourceTypeStr;
                    break;
                }
                case 86: {
                    ret = this.mEventBase.mSessionID;
                    break;
                }
            }
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        return ret;
    }

    @Override
    public void setLongOption(int key, long value) {
        switch (key) {
            case 21: {
                this.mBitrate = value;
                break;
            }
            case 56: {
                this.mAudioBitrate = value;
                break;
            }
            case 66: {
                this.mEvent.a_dns_start_t = value;
                break;
            }
            case 67: {
                this.mEvent.formater_create_t = value;
                break;
            }
            case 68: {
                this.mEvent.avformat_open_t = value;
                break;
            }
            case 78: {
                this.mEvent.demuxer_begin_t = value;
                break;
            }
            case 69: {
                this.mEvent.demuxer_create_t = value;
                break;
            }
            case 70: {
                this.mEvent.dec_create_t = value;
                break;
            }
            case 71: {
                this.mEvent.outlet_create_t = value;
                break;
            }
            case 72: {
                this.mEvent.v_dec_start_t = value;
                break;
            }
            case 73: {
                this.mEvent.a_dec_start_t = value;
                break;
            }
            case 74: {
                this.mEvent.v_dec_opened_t = value;
                break;
            }
            case 75: {
                this.mEvent.a_dec_opened_t = value;
                break;
            }
            case 76: {
                this.mEvent.v_render_f_t = value;
                break;
            }
            case 77: {
                this.mEvent.a_render_f_t = value;
                break;
            }
            case 83: {
                this.mEvent.sub_req_finish_t = value;
                break;
            }
            case 82: {
                this.mEvent.sub_load_finish_t = value;
                break;
            }
            case 84: {
                this.mEvent.mask_open_t = value;
                break;
            }
            case 85: {
                this.mEvent.mask_opened_t = value;
                break;
            }
            case 87: {
                this.mEvent.httpResponseT = value;
                break;
            }
            case 88: {
                this.mEvent.player_prepared_time = value;
                break;
            }
            case 120: {
                this.mEvent.v_http_open_t = value;
                break;
            }
            case 121: {
                this.mEvent.a_http_open_t = value;
                break;
            }
            case 122: {
                this.mEvent.v_tran_open_t = value;
                break;
            }
            case 123: {
                this.mEvent.a_tran_open_t = value;
                break;
            }
            case 124: {
                this.mEvent.v_sock_create_t = value;
                break;
            }
            case 125: {
                this.mEvent.a_sock_create_t = value;
                break;
            }
            case 98: {
                this.mEvent.mVideoStreamDuration = value;
                this.mEventOneOutSync.mVideoStreamDuration = value;
                break;
            }
            case 99: {
                this.mEvent.mAudioStreamDuration = value;
                this.mEventOneOutSync.mAudioStreamDuration = value;
                break;
            }
            case 101: {
                this.mEvent.mGearStrategyInfo.put("gs_bitrate", value);
                break;
            }
            case 103: {
                this.mEvent.mGearStrategyInfo.put("gs_speed", value);
                break;
            }
            case 105: {
                this.mEvent.mGearStrategyInfo.put("gs_select_begin", value);
                break;
            }
            case 106: {
                this.mEvent.mGearStrategyInfo.put("gs_select_end", value);
                break;
            }
            case 107: {
                this.mEvent.mGearStrategyInfo.put("gs_on_before_begin", value);
                break;
            }
            case 108: {
                this.mEvent.mGearStrategyInfo.put("gs_on_before_end", value);
                break;
            }
            case 109: {
                this.mEvent.mGearStrategyInfo.put("gs_on_after_begin", value);
                break;
            }
            case 110: {
                this.mEvent.mGearStrategyInfo.put("gs_on_after_end", value);
                break;
            }
            case 136: {
                this.mEvent.mSRStrategyInfo.put("bbd", value);
                break;
            }
            case 137: {
                this.mEvent.mSRStrategyInfo.put("bad", value);
                break;
            }
            case 147: {
                this.mMaskFileSize = value;
                break;
            }
        }
    }

    @Override
    public void setLoggerTimes(int key) {
        long curT = System.currentTimeMillis();
        switch (key) {
            case 65: {
                if (this.prepare_before_play_t > 0L) break;
                this.prepare_before_play_t = curT;
                break;
            }
            case 63: {
                if (this.setds_t > 0L) break;
                this.setds_t = curT;
                break;
            }
            case 64: {
                if (this.mEvent.pt_new > 0L) break;
                this.mEvent.pt_new = curT;
                break;
            }
        }
    }

    @Override
    public void setIntOption(int key, int value) {
        switch (key) {
            case 132: {
                this.mEngineHash = value;
                break;
            }
            case 129: {
                this.mCorePoolSizeUpperLimit = value;
                break;
            }
            case 130: {
                this.mCorepoolSizeBeforeGetEngine = value;
                break;
            }
            case 131: {
                this.mCountOfEngineInUse = value;
                break;
            }
            case 10: {
                break;
            }
            case 59: {
                this.mFirstRangeSize = value;
                break;
            }
            case 60: {
                this.mNetSpeedLevel = value;
                break;
            }
            case 62: {
                this.mModelVersion = value;
                break;
            }
            case 11: {
                this.mRadioMode = value;
                break;
            }
            case 45: {
                int pos = -1;
                HashMap<String, Number> map = new HashMap<String, Number>(3);
                if (this.mDataSource != null) {
                    pos = this.mDataSource.getLogValueInt(67);
                }
                map.put("s", value);
                map.put("p", pos);
                map.put("t", System.currentTimeMillis());
                this.mRadiomodeList.add(new JSONObject(map).toString());
                break;
            }
            case 12: {
                this.mVideoStreamDisabled = value == 1;
                break;
            }
            case 13: {
                this.mAudioStreamDisabled = value == 1;
                break;
            }
            case 14: {
                this.mIsReplay = value;
                break;
            }
            case 79: {
                this.mEnableNNSR = value;
                break;
            }
            case 80: {
                this.mReadCacheMode = value;
                break;
            }
            case 81: {
                this.mPreRangeOff = value;
                break;
            }
            case 16: {
                this.mEventBase.mAudioHwUser = value;
                break;
            }
            case 17: {
                this.mEventSample.setInterval(value);
                break;
            }
            case 18: {
                if (value != 0) {
                    this.mEnableSpeedReport = true;
                    this.mEventSample.startRecord();
                    break;
                }
                this.mEnableSpeedReport = false;
                this.mEventSample.stopRecord();
                break;
            }
            case 19: {
                this.mEventSample.setMaxWindowSize(value);
                break;
            }
            case 23: {
                this.mNetLevelMaxCount = value;
                break;
            }
            case 22: {
                this.mNetLevelIntervalMs = value;
                break;
            }
            case 24: {
                this.mBufferTimeout = value;
                break;
            }
            case 25: {
                this.mNetworkTimeout = value;
                break;
            }
            case 26: {
                this.mFeatureConfigs.mEnableBufferDirectly = value;
                break;
            }
            case 27: {
                this.mFeatureConfigs.mFirstBufEndMs = value;
                break;
            }
            case 29: {
                this.mFeatureConfigs.mEnableVolumeBalance = value;
                break;
            }
            case 54: {
                this.mFeatureConfigs.mAEType = value;
                break;
            }
            case 30: {
                this.mFeatureConfigs.mEnableEngineLooper = value;
                break;
            }
            case 31: {
                this.mFeatureConfigs.mEnableAutoRange = value;
                break;
            }
            case 32: {
                this.mFeatureConfigs.mEnableHwDropNonRef = value;
                break;
            }
            case 33: {
                this.mFeatureConfigs.mEnableHttps = value;
                break;
            }
            case 34: {
                this.mFeatureConfigs.mEnableFallbackApi = value;
                break;
            }
            case 35: {
                this.mFeatureConfigs.mEnableAsyncPosition = value;
                break;
            }
            case 36: {
                this.mFeatureConfigs.mEnableLoadControl = value;
                break;
            }
            case 37: {
                this.mFeatureConfigs.mRenderType = value;
                break;
            }
            case 38: {
                this.mFeatureConfigs.mImageScaleType = value;
                break;
            }
            case 39: {
                this.mFeatureConfigs.mAudioRenderType = value;
                break;
            }
            case 40: {
                this.mFeatureConfigs.mSkipFindStreamInfo = value;
                break;
            }
            case 41: {
                this.mFeatureConfigs.mEnableAsyncPrepare = value;
                break;
            }
            case 42: {
                this.mFeatureConfigs.mCodecFrcLevel = value;
                break;
            }
            case 43: {
                this.mFeatureConfigs.mEnableLazySeek = value;
                break;
            }
            case 44: {
                this.mFeatureConfigs.mKeepFormatThreadAlive = value;
                break;
            }
            case 49: {
                this.mEnableSub = value;
                break;
            }
            case 50: {
                this.mEnableOptSubLoad = value;
                break;
            }
            case 47: {
                this.mEnableSubThread = value;
                break;
            }
            case 48: {
                this.mEnableMask = value;
                break;
            }
            case 46: {
                this.mEnableMaskThread = value;
                break;
            }
            case 89: {
                this.mEvent.color_trc = value;
                break;
            }
            case 90: {
                if (value <= 0) break;
                FeatureConfigs featureConfigs = this.mFeatureConfigs;
                featureConfigs.mHDRType = featureConfigs.mHDRType | value;
                break;
            }
            case 91: {
                this.mFeatureConfigs.mEnableABRStartup = value;
                break;
            }
            case 127: {
                this.mFeatureConfigs.mEnableGearStrategy = value;
                break;
            }
            case 92: {
                if (value <= 0) break;
                this.mFeatureConfigs.mEnableThreadPriority = value;
                break;
            }
            case 93: {
                this.mFeatureConfigs.mEnableSmoothClock = value;
                break;
            }
            case 94: {
                this.mFeatureConfigs.mDisableSplitVoice = value;
                break;
            }
            case 96: {
                this.mFeatureConfigs.mEnableStrategyCenter = value;
                break;
            }
            case 95: {
                this.mHardwareConfType = value;
                break;
            }
            case 51: {
                this.mEventBase.mEnablePlayerDegrade = this.mEnablePlayerDegrade = value == 1;
                break;
            }
            case 52: {
                this.mIsDegradeRelease = value == 1;
                break;
            }
            case 55: {
                this.mFeatureConfigs.mEnableNativeYV12 = value;
                break;
            }
            case 97: {
                this.mFeatureConfigs.mEnableOutletDropLimit = value;
                break;
            }
            case 100: {
                this.mReportLevel = value;
                this.mEventOneOpera.mReportSeek = this.enableReport(1);
                break;
            }
            case 102: {
                this.mEvent.mGearStrategyInfo.put("gs_reason", value);
                break;
            }
            case 104: {
                this.mEvent.mGearStrategyInfo.put("gs_error", value);
                break;
            }
            case 111: {
                this.mEvent.mHasNoSurfaceWhenAudioRenderStart = value;
                break;
            }
            case 112: {
                this.mEventBase.mEnableTmpLog = value == 1;
                break;
            }
            case 126: {
                this.mEventBase.mEnablePowerReport = value == 1;
                break;
            }
            case 133: {
                this.mEvent.mSRStrategyInfo.put("ess", value);
                this.mFeatureConfigs.mEnableSRStrategy = value;
                break;
            }
            case 134: {
                this.mEvent.mSRStrategyInfo.put("eas", value);
                break;
            }
            case 138: {
                this.mEvent.mSRStrategyInfo.put("ss", value);
                break;
            }
            case 139: {
                this.mEvent.mSRStrategyInfo.put("sfr", value);
                break;
            }
            case 140: {
                this.mEvent.mSRStrategyInfo.put("sm", value);
                break;
            }
            case 148: {
                this.mEvent.mSRStrategyInfo.put("srs", value);
                break;
            }
            case 149: {
                this.mEvent.mSRStrategyInfo.put("sut", value);
                break;
            }
            case 150: {
                this.mEvent.mSRStrategyInfo.put("so", value);
                break;
            }
            case 142: {
                this.mEvent.mExpirePlayCode = value;
                break;
            }
            case 143: {
                this.mMaskRangeOpt = value;
                break;
            }
            case 144: {
                this.mMaskEnableDataloader = value;
                break;
            }
            case 145: {
                this.mMaskDelayLoading = value;
                break;
            }
        }
    }

    @Override
    public int getIntOption(int key) {
        int ret = -1;
        switch (key) {
            case 49: {
                if (this.mEventBase == null) break;
                ret = this.mEventBase.formatType;
            }
        }
        return ret;
    }

    @Override
    public void setStringOption(int key, String value) {
        switch (key) {
            case 161: {
                this.mEvent.mTrVersion = value;
                break;
            }
            case 163: {
                this.mTrPerEffectAverageTime = value;
                break;
            }
            case 165: {
                this.mTrEffectErrorCode = value;
                break;
            }
            case 128: {
                this.mFromEnginePool = value;
                break;
            }
            case 15: {
                this.mEvent.log_id = value;
                break;
            }
            case 86: {
                this.mEventBase.mDNSType = value;
                break;
            }
            case 53: {
                this.mEventBase.mOriginVid = value;
                break;
            }
            case 113: {
                if (this.mNetworkQualityAlgorithm != null) {
                    this.mNetworkQualityAlgorithm.setStringOption(4, value);
                    break;
                }
                this.mNetworkQualityVar = value;
                break;
            }
            case 135: {
                try {
                    JSONObject cfgJson = new JSONObject(value);
                    this.mEvent.mSRStrategyInfo.put("sc", cfgJson);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 151: {
                try {
                    JSONArray mediaJson = new JSONArray(value);
                    this.mEvent.mSRStrategyInfo.put("smi", mediaJson);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 141: {
                this.mEvent.mGearStrategyInfo.put("headers", value);
                break;
            }
            case 146: {
                this.mMaskFileHash = value;
                break;
            }
            case 152: {
                this.mEvent.mVideoFileHash = value;
                break;
            }
            case 153: {
                this.mEvent.mAudioFileHash = value;
                break;
            }
            case 154: {
                this.mEventBase.mMediaID = value;
                break;
            }
        }
    }

    @Override
    public void setFloatOption(int key, float value) {
        switch (key) {
            case 162: {
                this.mEvent.mTrFPS = Float.valueOf(value);
                break;
            }
            case 164: {
                this.mEvent.mTrEffectChainAverageTime = Float.valueOf(value);
                break;
            }
            case 20: {
                this.mNetworkSpeedPredictSamplingRate = value;
                this.mEventSample.setSamplingRate(value);
                break;
            }
            case 167: {
                this.mSrMonitor.setProccessSuccessRate(value);
                break;
            }
            case 166: {
                this.mSrMonitor.setProcessorAverageCostTime(value);
                break;
            }
        }
    }

    @Override
    public int getCurDecoderBufferCount() {
        return this.mCurDecoderBufferCount;
    }

    @Override
    public long getCurDecoderBufferAccuT() {
        return this.mCurDecoderBufferAccuT;
    }

    @Override
    public long getLeaveWaitTime() {
        if (this.mEvent != null && this.mEvent.pt_new > 0L && this.mEvent.lt > 0L) {
            return this.mEvent.lt - this.mEvent.pt_new;
        }
        return 0L;
    }

    public void _recordExitReason(int reason, boolean isStart) {
        if (this.mEvent == null) {
            return;
        }
        if (isStart) {
            this.mLeaveReason = reason;
            if (reason == -1002 || reason == -1003 || reason == -1004 || reason == -1005) {
                if (this.mBlockBeginT <= 0L) {
                    this.mBlockBeginT = SystemClock.elapsedRealtime();
                }
            } else {
                this.mBlockBeginT = reason == -2003 || reason == -2002 ? SystemClock.elapsedRealtime() : Integer.MIN_VALUE;
            }
        } else {
            this.mLeaveReason = -2001;
            this.mBlockBeginT = Integer.MIN_VALUE;
        }
    }

    private void _setDefaultExitReason(int sourceType) {
        if (sourceType == 6 || sourceType == 0) {
            this.mLeaveReason = -1005;
        } else if (sourceType == 1 || sourceType == 4 || sourceType == 2 || sourceType == 3 || sourceType == 7) {
            this.mLeaveReason = -1004;
        } else if (sourceType == 5) {
            this.mLeaveReason = -1002;
        }
    }

    private void _clear() {
        this.mRetryFetchErrorInfo = new ArrayList();
        this.mMDLRetryInfo = new ArrayList();
        this.mFirstDNSErrorInfo = new ArrayList();
        this.mErrorInfo = new ArrayList();
        this.mEventOneNoRender.reset();
        this.mState = 0;
        this.mBlockBeginT = Integer.MIN_VALUE;
        this.mAccumVPS = 0L;
        this.mAccumVDS = 0L;
        this.mBitrate = Integer.MIN_VALUE;
        this.mAudioBitrate = Integer.MIN_VALUE;
        this.mLeave = true;
        this.mCurBufferCount = 0;
        this.mNetBufferIndex = 0;
        this.mCurDecoderBufferCount = 0;
        this.mBreakCount = 0;
        this.mCurDecoderBufferAccuT = 0L;
        this.mLoopCount = 0;
        this.mLooping = false;
        this.mSwitchResolutionCount = 0;
        this.mSeekCount = 0;
        this.mSeekBeginT = Integer.MIN_VALUE;
        this.prepare_before_play_t = Integer.MIN_VALUE;
        this.ps_t = Integer.MIN_VALUE;
        this.setds_t = Integer.MIN_VALUE;
        this.mRadioMode = Integer.MIN_VALUE;
        this.mAudioStreamDisabled = false;
        this.mVideoStreamDisabled = false;
        this.mIsReplay = Integer.MIN_VALUE;
        this.mSurfaceCode = null;
        this.mSurfaceSetTime = Integer.MIN_VALUE;
        this.mPlayList = new ArrayList();
        this.mPauseList = new ArrayList();
        this.mResolutionList = new ArrayList();
        this.mPlaySpeedList = new ArrayList();
        this.mRadiomodeList = new ArrayList();
        this.mLoopList = new ArrayList();
        this.mErrorList = new ArrayList();
        this.mPowerList = new ArrayList();
        this.mChargingList = new ArrayList();
        this.mAVBadInterlacedList = new ArrayList();
        this.mCurError = null;
        this.mRetryStartT = Integer.MIN_VALUE;
        this.mRetryStrategy = -1;
        this.mCustomClickT = Integer.MIN_VALUE;
        this.mCustomGetVideoModelT = Integer.MIN_VALUE;
        this.mCustomInitEngineT = Integer.MIN_VALUE;
        this.mCustomPlayEngineT = Integer.MIN_VALUE;
        this.mAVOutSyncing = false;
        this.mEnableSub = Integer.MIN_VALUE;
        this.mEnableOptSubLoad = Integer.MIN_VALUE;
        this.mEnableSubThread = Integer.MIN_VALUE;
        this.mEnableMask = Integer.MIN_VALUE;
        this.mEnableMaskThread = Integer.MIN_VALUE;
        this.mMaskURL = null;
        this.mSubReqURL = null;
        this.mSubError = null;
        this.mSubIdsCount = Integer.MIN_VALUE;
        this.mSubLanSwitchCount = 0;
        this.mMaskErrc = Integer.MIN_VALUE;
        this.mFeatureConfigs.mHDRType = 0;
        this.mFeatureConfigs.mEnableABRStartup = 0;
        this.mFeatureConfigs.mEnableThreadPriority = 0;
        this.mSrMonitor = new SuperResolutionMonitor();
        this.mFilterMonitor = new VideoFilterMonitor();
        this.mBrightMonitor.stop();
        this.mBrightMonitor = new BrightnessMonitor(this.mContext);
        this.mViewSizeMonitor.reset();
        this.mFeatures.clear();
        this.mHeadsetStateHistory.reset();
        this.mFeatureConfigs.mEnableGearStrategy = 0;
        this.mFeatureConfigs.mEnableSRStrategy = 0;
        this.mFromEnginePool = "after clear V2";
        this.mCorePoolSizeUpperLimit = Integer.MIN_VALUE;
        this.mCorepoolSizeBeforeGetEngine = Integer.MIN_VALUE;
        this.mCountOfEngineInUse = Integer.MIN_VALUE;
        this.mVrDistanceList = new ArrayList();
        this.mVrFrameRate = Float.MIN_VALUE;
        this.mVrScreenRefreshRate = Integer.MIN_VALUE;
        this.mVrHeadMovementDelay = Integer.MIN_VALUE;
        this.mSetSurfaceBeginT = Integer.MIN_VALUE;
        this.mSetSurfaceType = null;
        this.mSetSurfaceTimeList = new ArrayList();
        this.mPlayerSurfaceCode = null;
        this.mMaskFileSize = Integer.MIN_VALUE;
        this.mMaskDelayLoading = Integer.MIN_VALUE;
        this.mMaskFileHash = "";
        this.mMaskRangeOpt = Integer.MIN_VALUE;
        this.mMaskEnableDataloader = Integer.MIN_VALUE;
        this.mTrEffectList = new ArrayList();
        this.mTrPerEffectAverageTime = "";
        this.mTrEffectErrorCode = "";
        this.mOttPluginVersion = Integer.MIN_VALUE;
        this.mCompanyID = "";
    }

    @Override
    public void accumulateSize() {
        this._accumulateVPS();
    }

    @Override
    public long getStalledVideoBufferTime() {
        long bt = -1L;
        if (this.mEventOneEvent != null) {
            bt = this.mEventOneEvent.getStalledVideoBufferTime();
        }
        return bt;
    }

    @Override
    public long getStalledAudioBufferTime() {
        long bt = -1L;
        if (this.mEventOneEvent != null) {
            bt = this.mEventOneEvent.getStatlledAudioBufferTime();
        }
        return bt;
    }

    @Override
    public void addSubtitleSwitchTime() {
        ++this.mSubLanSwitchCount;
    }

    @Override
    public void setSubtitleIdsCount(int subtitleIdsCount) {
        this.mSubIdsCount = subtitleIdsCount;
    }

    @Override
    public void setSubtitleRequestUrl(String url) {
        this.mSubReqURL = url;
    }

    @Override
    public void setMaskUrl(String url) {
        this.mMaskURL = url;
    }

    @Override
    public void setSubtitleError(String subtitleError) {
        this.mSubError = subtitleError;
    }

    @Override
    public void setMaskErrorCode(int maskErrorCode) {
        this.mMaskErrc = maskErrorCode;
    }

    private void _getSubEvents() {
        if (this.mEvent != null) {
            HashMap subMap = new HashMap(9);
            LoggerUtils.putToMap(subMap, "sub_langs_c", this.mSubIdsCount);
            LoggerUtils.putToMap(subMap, "sub_req_fin_ts", this.mEvent.sub_req_finish_t);
            LoggerUtils.putToMap(subMap, "sub_load_fin_ts", this.mEvent.sub_load_finish_t);
            LoggerUtils.putToMap(subMap, "sub_switch_c", this.mSubLanSwitchCount);
            LoggerUtils.putToMap(subMap, "sub_error", this.mSubError);
            LoggerUtils.putToMap(subMap, "sub_req_url", this.mSubReqURL);
            LoggerUtils.putToMap(subMap, "sub_enable", this.mEnableSub);
            LoggerUtils.putToMap(subMap, "sub_enable_opt_load", this.mEnableOptSubLoad);
            LoggerUtils.putToMap(subMap, "sub_thread_enable", this.mEnableSubThread);
            this.mEvent.subEvents = subMap;
        }
    }

    private void _getMaskEvents() {
        if (this.mEvent != null) {
            HashMap maskMap = new HashMap(11);
            LoggerUtils.putToMap(maskMap, "mask_open_ts", this.mEvent.mask_open_t);
            LoggerUtils.putToMap(maskMap, "mask_opened_ts", this.mEvent.mask_opened_t);
            LoggerUtils.putToMap(maskMap, "mask_errc", this.mMaskErrc);
            LoggerUtils.putToMap(maskMap, "mask_enable", this.mEnableMask);
            LoggerUtils.putToMap(maskMap, "mask_thread_enable", this.mEnableMaskThread);
            LoggerUtils.putToMap(maskMap, "mask_url", this.mMaskURL);
            LoggerUtils.putToMap(maskMap, "mask_range_opt", this.mMaskRangeOpt);
            LoggerUtils.putToMap(maskMap, "mask_enable_mdl", this.mMaskEnableDataloader);
            LoggerUtils.putToMap(maskMap, "mask_delay_loading", this.mMaskDelayLoading);
            LoggerUtils.putToMap(maskMap, "mask_file_hash", this.mMaskFileHash);
            LoggerUtils.putToMap(maskMap, "mask_file_size", this.mMaskFileSize);
            this.mEvent.maskEvents = maskMap;
        }
    }

    private void _accumulateVPS() {
        Map<String, Long> bytesinfo;
        if (this.mDataSource != null && (bytesinfo = this.mDataSource.bytesInfo()) != null) {
            long vps = TTHelper.safelyUnbox(bytesinfo.get("vps"));
            long vds = TTHelper.safelyUnbox(bytesinfo.get("vds"));
            this.mAccumVPS += vps;
            this.mAccumVDS += vds;
            TTVideoEngineLog.i(TAG, "_accumulateVPS accumVPS:" + this.mAccumVPS + ", accumVDS:" + this.mAccumVDS + ", vps:" + vps + ", vds:" + vds);
        }
    }

    private void _parseUrlLogID() {
        String url = "";
        String format = "&l=";
        if (!TextUtils.isEmpty((CharSequence)this.mInitialURL)) {
            url = this.mInitialURL;
        } else if (!TextUtils.isEmpty((CharSequence)this.mProxyUrl)) {
            url = this.mProxyUrl;
        } else if (!TextUtils.isEmpty((CharSequence)this.mAudioInitURL)) {
            url = this.mAudioInitURL;
        } else {
            return;
        }
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            TTVideoEngineLog.e(TAG, "exception:" + e.toString());
        }
        catch (IllegalArgumentException e) {
            TTVideoEngineLog.e(TAG, "exception:" + e.toString());
        }
        int index = url.indexOf(format);
        if (index > 0) {
            int end = url.indexOf("&", index + 1);
            String log_id = "";
            log_id = end > 0 ? url.substring(index + 3, end) : url.substring(index + 3);
            this.mEvent.log_id = log_id;
        }
    }

    private void _updateFeatures() {
        int enableExternDNS;
        int value;
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        map.putAll(sFeatures);
        map.putAll(this.mFeatures);
        if (this.mEventBase.mVideoHW != 0) {
            map.put("v_hw", this.mEventBase.mVideoHW);
        }
        if (this.mEventBase.mAudioHwUser != 0) {
            map.put("a_hw", this.mEventBase.mAudioHwUser);
        }
        if (this.mAsyncInit > 0) {
            map.put("async_init", this.mAsyncInit);
        }
        if (this.mUseCodecPool > 0) {
            map.put("codec_pool", this.mUseCodecPool);
        }
        if (this.mEventBase.codec_type.equals("h265")) {
            map.put("h265", 1);
        } else if (this.mEventBase.codec_type.equals("h266")) {
            map.put("h266", 1);
        }
        if (this.mNetworkTimeout > 0) {
            map.put("network_timeout", this.mNetworkTimeout);
        }
        if (this.mBufferTimeout > 0) {
            map.put("buffer_timeout", this.mBufferTimeout);
        }
        if (this.mFeatureConfigs.mEnableBufferDirectly > 0) {
            map.put("buffer_directly", this.mFeatureConfigs.mEnableBufferDirectly);
        }
        if (this.mFeatureConfigs.mFirstBufEndMs > 0) {
            map.put("first_buf_end_ms", this.mFeatureConfigs.mFirstBufEndMs);
        }
        if (this.mEvent.textureRender > 0) {
            map.put("oes_texture", this.mEvent.textureRender);
        }
        if (this.mEnableNNSR > 0) {
            map.put("sr", this.mEnableNNSR);
        }
        if (this.mFeatureConfigs.mEnableVolumeBalance > 0) {
            if (this.mFeatureConfigs.mAEType == 0) {
                map.put("volume_balance", 1);
            } else if (this.mFeatureConfigs.mAEType == 1) {
                map.put("volume_balancev2", 1);
            } else if (this.mFeatureConfigs.mAEType == 4) {
                map.put("volume_balance_tob", 1);
            }
        }
        if (this.mEnableBash > 0) {
            map.put("bash", this.mEnableBash);
        }
        if (this.mEventBase.is_enable_abr > 0) {
            map.put("abr", this.mEventBase.is_enable_abr);
        }
        if (this.mFeatureConfigs.mEnableEngineLooper > 0) {
            map.put("engine_looper", this.mFeatureConfigs.mEnableEngineLooper);
        }
        if (this.mFeatureConfigs.mEnableAutoRange > 0) {
            map.put("auto_range", this.mFeatureConfigs.mEnableAutoRange);
        }
        if (this.mFeatureConfigs.mEnableHwDropNonRef > 0) {
            map.put("hw_drop", this.mFeatureConfigs.mEnableHwDropNonRef);
        }
        if (this.mFeatureConfigs.mEnableHttps > 0) {
            map.put("enable_https", this.mFeatureConfigs.mEnableHttps);
        }
        if (this.mEvent.checkHijack > 0) {
            map.put("enable_hijack", this.mEvent.checkHijack);
        }
        if (this.mEvent.hijackRetry > 0) {
            map.put("hijack_retry", this.mEvent.hijackRetry);
        }
        if (this.mFeatureConfigs.mEnableFallbackApi > 0) {
            map.put("fallback_api", this.mFeatureConfigs.mEnableFallbackApi);
        }
        if (this.mFeatureConfigs.mEnableAsyncPosition > 0) {
            map.put("async_pos", this.mFeatureConfigs.mEnableAsyncPosition);
        }
        if (this.mEventBase.mReuseSocket > 0) {
            map.put("socket_reuse", this.mEventBase.mReuseSocket);
        }
        if (this.mEventBase.mEnableMDL > 0) {
            map.put("mdl_type", this.mEventBase.mEnableMDL);
        }
        if (this.mFeatureConfigs.mEnableLoadControl > 0) {
            map.put("enable_loadcontrol", this.mFeatureConfigs.mEnableLoadControl);
        }
        if (this.mFeatureConfigs.mRenderType == 5) {
            if (this.mEventBase.mVideoHW == 0) {
                map.put("render_type", 5);
            } else {
                map.put("render_type", 3);
            }
        } else {
            map.put("render_type", this.mFeatureConfigs.mRenderType);
        }
        map.put("image_scale", this.mFeatureConfigs.mImageScaleType);
        if (this.mMediaCodecRender >= 0) {
            map.put("mc_render", this.mMediaCodecRender);
        }
        if (this.mFeatureConfigs.mAudioRenderType >= 0) {
            map.put("audio_render_type", this.mFeatureConfigs.mAudioRenderType);
        }
        if (this.mFeatureConfigs.mSkipFindStreamInfo > 0) {
            map.put("skip_find_stream", this.mFeatureConfigs.mSkipFindStreamInfo);
        }
        if (this.mFeatureConfigs.mEnableAsyncPrepare > 0) {
            map.put("async_prepare", this.mFeatureConfigs.mEnableAsyncPrepare);
        }
        if (this.mFeatureConfigs.mCodecFrcLevel > 0) {
            map.put("frc_level", this.mFeatureConfigs.mCodecFrcLevel);
        }
        if (this.mFeatureConfigs.mEnableLazySeek > 0) {
            map.put("lazy_seek", this.mFeatureConfigs.mEnableLazySeek);
        }
        if (this.mFeatureConfigs.mKeepFormatThreadAlive > 0) {
            map.put("keep_formater_alive", this.mFeatureConfigs.mKeepFormatThreadAlive);
        }
        if (this.mEvent.isDisableShortSeek > 0) {
            map.put("dis_short_seek", this.mEvent.isDisableShortSeek);
        }
        if (this.mEvent.isPreferNearestSample > 0) {
            map.put("pref_near_sample", this.mEvent.isPreferNearestSample);
        }
        if (this.mEnableSubThread > 0) {
            map.put("sub_thread_enable", this.mEnableSubThread);
        }
        if (this.mEnableMaskThread > 0) {
            map.put("mask_thread_enable", this.mEnableMaskThread);
        }
        if ((this.mFeatureConfigs.mHDRType & 1) == 1) {
            map.put("hdr_pq", 1);
        }
        if ((this.mFeatureConfigs.mHDRType & 2) == 2) {
            map.put("hdr_hlg", 1);
        }
        if (this.mFeatureConfigs.mEnableABRStartup > 0) {
            map.put("abr_startup", 1);
        }
        if (this.mFeatureConfigs.mEnableGearStrategy > 0) {
            map.put("gear_strategy", this.mFeatureConfigs.mEnableGearStrategy);
        }
        if (this.mFeatureConfigs.mEnableSRStrategy > 0) {
            map.put("sr_strategy", this.mFeatureConfigs.mEnableSRStrategy);
        }
        if (this.mFeatureConfigs.mEnableThreadPriority > 0) {
            map.put("thread_priority", 1);
        }
        if (this.mFeatureConfigs.mEnableSmoothClock > 0) {
            map.put("smooth_clock", 1);
        }
        if (this.mFeatureConfigs.mDisableSplitVoice > 0) {
            map.put("disable_split_voice", 1);
        }
        if (this.mEventBase.mVideoHW == 0 && this.mFeatureConfigs.mEnableNativeYV12 > 0) {
            map.put("yv12", 1);
        }
        if (this.mEvent.mAudioCodecProfile == 28) {
            map.put("heaacv2", 1);
        }
        if (this.mFeatureConfigs.mEnableStrategyCenter > 0) {
            map.put("strategy_center", 1);
        } else {
            map.put("strategy_center", 0);
        }
        if (this.mFeatureConfigs.mEnableOutletDropLimit >= 0) {
            map.put("drop_limit", this.mFeatureConfigs.mEnableOutletDropLimit);
        }
        if ((value = DataLoaderHelper.getDataLoader().getIntValue(8)) > 0) {
            map.put("mdl_socket_reuse", value);
        }
        if ((value = DataLoaderHelper.getDataLoader().getIntValue(1001)) > 0) {
            map.put("mdl_preconn", value);
        }
        if ((enableExternDNS = DataLoaderHelper.getDataLoader().getIntValue(7)) > 0) {
            map.put("mdl_externdns", 1);
            if (TextUtils.equals((CharSequence)this.mEventBase.mDNSType, (CharSequence)"httpDNS_own") || TextUtils.equals((CharSequence)this.mEventBase.mDNSType, (CharSequence)"httpDNS_google") || TextUtils.equals((CharSequence)this.mEventBase.mDNSType, (CharSequence)"customDNSInnerByteDanceHTTPDNS")) {
                map.put("mdl_httpdns", 1);
            }
        }
        if ((value = DataLoaderHelper.getDataLoader().getIntValue(114)) > 0) {
            map.put("mdl_predns", value);
        }
        if ((value = DataLoaderHelper.getDataLoader().getIntValue(105)) > 0) {
            map.put("mdl_dns_refresh", value);
        }
        if ((value = DataLoaderHelper.getDataLoader().getIntValue(103)) > 0) {
            map.put("mdl_dns_parallel", value);
        }
        if ((value = DataLoaderHelper.getDataLoader().getIntValue(115)) > 0) {
            map.put("mdl_backip", value);
        }
        if ((value = DataLoaderHelper.getDataLoader().getIntValue(101)) > 0) {
            map.put("mdl_session_reuse", value);
        }
        if ((value = DataLoaderHelper.getDataLoader().getIntValue(100)) == 3) {
            map.put("mdl_tls_ver", value);
        }
        long mdl_monitor_interval = DataLoaderHelper.getDataLoader().getLongValue(1152);
        String socketConfig = DataLoaderHelper.getDataLoader().getStringValue(9010);
        if (mdl_monitor_interval > 0L && !TextUtils.isEmpty((CharSequence)socketConfig)) {
            map.put("mdl_socket_monitor", 1);
        }
        this.mEvent.mFeatures = map;
    }

    private void _checkFirstFrameTimes() {
        long audioTranFirstPacketT;
        long audioTranConnectT;
        long tranFirstPacketT;
        long tranConnectT;
        if (this.mEvent.dnsT <= 0L) {
            this.mEvent.dnsModule = 1;
            this.mEvent.dnsT = this.mDataSource.getLogValueLong(7);
        }
        if (this.mEvent.tranConnectT <= 0L && (tranConnectT = this.mDataSource.getLogValueLong(10)) > this.ps_t) {
            this.mEvent.tranConnectT = tranConnectT;
        }
        if (this.mEvent.tranFirstPacketT <= 0L && (tranFirstPacketT = this.mDataSource.getLogValueLong(11)) > this.ps_t) {
            this.mEvent.tranFirstPacketT = tranFirstPacketT;
        }
        if (this.mEvent.audioDnsT <= 0L) {
            this.mEvent.audioDnsT = this.mDataSource.getLogValueLong(51);
        }
        if (this.mEvent.audioTranConnectT <= 0L && (audioTranConnectT = this.mDataSource.getLogValueLong(52)) > this.ps_t) {
            this.mEvent.audioTranConnectT = audioTranConnectT;
        }
        if (this.mEvent.audioTranFirstPacketT <= 0L && (audioTranFirstPacketT = this.mDataSource.getLogValueLong(53)) > this.ps_t) {
            this.mEvent.audioTranFirstPacketT = audioTranFirstPacketT;
        }
        if (this.mEvent.receiveFirstVideoFrameT <= 0L) {
            this.mEvent.receiveFirstVideoFrameT = this.mDataSource.getLogValueLong(12);
        }
        if (this.mEvent.receiveFirstAudioFrameT <= 0L) {
            this.mEvent.receiveFirstAudioFrameT = this.mDataSource.getLogValueLong(13);
        }
        if (this.mEvent.decodeFirstVideoFrameT <= 0L) {
            this.mEvent.decodeFirstVideoFrameT = this.mDataSource.getLogValueLong(14);
        }
        if (this.mEvent.decodeFirstAudioFrameT <= 0L) {
            this.mEvent.decodeFirstAudioFrameT = this.mDataSource.getLogValueLong(15);
        }
        if (this.mEvent.videoDeviceStartTime <= 0L) {
            this.mEvent.videoDeviceStartTime = this.mDataSource.getLogValueLong(17);
        }
        if (this.mEvent.audioDeviceStartTime <= 0L) {
            this.mEvent.audioDeviceStartTime = this.mDataSource.getLogValueLong(16);
        }
        if (this.mEvent.videoDeviceOpenedTime <= 0L) {
            this.mEvent.videoDeviceOpenedTime = this.mDataSource.getLogValueLong(19);
        }
        if (this.mEvent.audioDeviceOpenedTime <= 0L) {
            this.mEvent.audioDeviceOpenedTime = this.mDataSource.getLogValueLong(18);
        }
        if (this.mEvent.playPreparedT <= 0L) {
            this.mEvent.playPreparedT = this.mDataSource.getLogValueLong(38);
        }
        if (this.mEvent.playStartedT <= 0L) {
            this.mEvent.playStartedT = this.mDataSource.getLogValueLong(39);
        }
        if (this.mEvent.v_http_open_t <= 0L) {
            this.mEvent.v_http_open_t = this.mDataSource.getLogValueLong(115);
        }
        if (this.mEvent.a_http_open_t <= 0L) {
            this.mEvent.a_http_open_t = this.mDataSource.getLogValueLong(116);
        }
        if (this.mEvent.v_tran_open_t <= 0L) {
            this.mEvent.v_tran_open_t = this.mDataSource.getLogValueLong(117);
        }
        if (this.mEvent.a_tran_open_t <= 0L) {
            this.mEvent.a_tran_open_t = this.mDataSource.getLogValueLong(118);
        }
        if (this.mEvent.v_sock_create_t <= 0L) {
            this.mEvent.v_sock_create_t = this.mDataSource.getLogValueLong(119);
        }
        if (this.mEvent.a_sock_create_t <= 0L) {
            this.mEvent.a_sock_create_t = this.mDataSource.getLogValueLong(120);
        }
    }

    private void _upload(int leaveMethod) {
        this.mEvent.leave_method = leaveMethod;
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
            this.mTimerTask = null;
        }
        if (this.mBitrateCalculationTask != null) {
            this.mBitrateCalculationTask.cancel();
            this.mBitrateCalculationTask = null;
        }
        if (this.mEnableSpeedReport) {
            this.mEventSample.stopRecord();
        }
        this._sendEvent();
        this.mEvent = new VideoEventOnePlay();
        this.mEventSample.mEventBase = this.mEventBase;
        this.mEventOneEvent.reset();
        this.mEventOneOpera.reset();
        this.mEventOneOutSync.reset();
        this.mEventAbrSwitch.reset();
    }

    private void _sendEvent() {
        if (this.mEvent == null) {
            return;
        }
        if (this.mEnablePlayerDegrade && this.mIsDegradeRelease) {
            TTVideoEngineLog.i(TAG, "player degrade, store context");
        } else {
            TTVideoEngineLog.i(TAG, "sendEvent pt_new:" + this.mEvent.pt_new + ", mEvent:" + this.mEvent + ", eventBase:" + this.mEventBase);
        }
        if (this.mEvent.pt_new <= 0L && this.ps_t <= 0L) {
            return;
        }
        this.updateEventData();
        if (!this.mEnablePlayerDegrade) {
            EngineThreadPool.addExecuteTask(new AsyncGetLogDataRunnable(this.mContext, this.mEvent, this, this.mEventBase, this.mNetworkQualityAlgorithm, this.mEventSaver));
        } else if (this.mIsDegradeRelease) {
            TTVideoEngineLog.i(TAG, "degrade1, vid:" + this.mEventBase.mOriginVid);
            VideoEventOneStorage.getInstance().storeOnePlay(this.mEventBase.mOriginVid, this.mEvent);
            VideoEventOneStorage.getInstance().storeSessionId(this.mEventBase.mOriginVid, this.mEventBase.mSessionID);
            this.mIsDegradeRelease = false;
        } else {
            TTVideoEngineLog.i(TAG, "degrade2, vid:" + this.mEventBase.mOriginVid);
            VideoEventOneStorage.getInstance().storeOnePlay(this.mEventBase.mOriginVid, this.mEvent);
            this.mEventBase.degradeModeChangeSession();
            this.mEvent = VideoEventOneStorage.getInstance().restoreOnePlay(this.mEventBase.mOriginVid);
            EngineThreadPool.addExecuteTask(new AsyncGetLogDataRunnable(this.mContext, this.mEvent, this, this.mEventBase, this.mNetworkQualityAlgorithm, this.mEventSaver));
            VideoEventOneStorage.getInstance().removeByVideoId(this.mEventBase.mOriginVid);
        }
        this.contentReporterStartTaskIfNeeded();
        this._clear();
    }

    private void updateEventData() {
        VideoStyle videoStyle;
        if (this.mDataSource != null) {
            long subtitleDownloadSize;
            ArrayList forebackSwitchList;
            String loaderType;
            Map<String, Long> bytesInfo = this.mDataSource.bytesInfo();
            if (bytesInfo != null) {
                long vps = ((Number)bytesInfo.get("vps")).longValue();
                long vds = ((Number)bytesInfo.get("vds")).longValue();
                long single_vds = ((Number)bytesInfo.get("single_vds")).longValue();
                long accu_vds = ((Number)bytesInfo.get("accu_vds")).longValue();
                this.mEvent.vps = this.mAccumVPS + vps;
                this.mEvent.vds = this.mLooping ? this.mAccumVDS + single_vds : this.mAccumVDS + vds;
                this.mEvent.accu_vds = this.mAccumVDS + accu_vds;
                TTVideoEngineLog.i(TAG, "_sendEvent accumVDS:" + this.mAccumVDS + ", vds:" + vds + ", single_vds:" + single_vds + ", mEvent.vds:" + this.mEvent.vds + ", accu_vds:" + accu_vds);
                EngineThreadPool.addExecuteTask(new VideoInfoCollector.myVideoCollectorAddConsumeSize(this.mEvent.vps));
            }
            this.mEvent.render_type = this.mDataSource.getLogValueStr(1);
            this.logMessage(this.mDataSource.getLogValueStr(2));
            this.mEvent.apiString = this.mDataSource.getLogValueStr(3);
            this.mEvent.netClient = this.mDataSource.getLogValueStr(4);
            this.mEvent.engineState = this.mDataSource.getLogValueInt(23);
            this.mEvent.isPreferNearestSample = this.mDataSource.getLogValueInt(34);
            this.mEvent.networkTimeout = this.mDataSource.getLogValueInt(35);
            this.mEvent.isDisableShortSeek = this.mDataSource.getLogValueInt(36);
            if (this.mEvent.internalIP == null) {
                String ip = this.mDataSource.getLogValueStr(5);
                if (ip == null) {
                    ip = "";
                }
                this.mEvent.internalIP = ip;
            }
            if (!TextUtils.isEmpty((CharSequence)(loaderType = this.mDataSource.getLogValueStr(33)))) {
                this.mEvent.loaderType = loaderType;
            }
            this._checkFirstFrameTimes();
            this.mEvent.core_volume = this.mDataSource.getLogValueInt(61);
            this.mEvent.mute = this.mDataSource.getLogValueInt(27);
            this.mEvent.apiverFinal = this.mDataSource.getLogValueInt(30);
            this.mEvent.chipBoardName = this.mDataSource.getLogValueStr(31);
            this.mEvent.chipHardwareName = this.mDataSource.getLogValueStr(32);
            this.mEvent.chipHardwareNameNew = this.mDataSource.getLogValueStr(111);
            if (this.mFeatureConfigs.mEnableVolumeBalance > 0) {
                if (this.mFeatureConfigs.mAEType == 0) {
                    this.mEvent.ae_type = 0;
                } else if (this.mFeatureConfigs.mAEType == 1) {
                    this.mEvent.ae_type = 1;
                }
            }
            this.mEvent.videoAudioGap = this.mDataSource.getLogValueLong(54);
            this.mEvent.moovPos = this.mDataSource.getLogValueLong(57);
            this.mEvent.mdatPos = this.mDataSource.getLogValueLong(58);
            int trErrorCode = this.mDataSource.getLogValueInt(100);
            if (trErrorCode != 0) {
                this.mEvent.textureRenderErrorCode = trErrorCode;
            }
            this.mEvent.minAudioFrameSize = this.mDataSource.getLogValueLong(140);
            this.mEvent.minVideoFrameSize = this.mDataSource.getLogValueLong(141);
            this.mEvent.feedInBeforeDecoded = this.mDataSource.getLogValueInt(142);
            this.mEvent.mPreloadGear = this.mDataSource.getLogValueStr(143);
            int bufferingThresholdSize = this.mDataSource.getLogValueInt(145);
            float videoFrameRate = this.mDataSource.getLogValueFloat(82);
            if (bufferingThresholdSize > 0 && videoFrameRate > 0.0f) {
                int netblockBufferthreshold;
                this.mEvent.netblockBufferthreshold = netblockBufferthreshold = (int)((double)((float)bufferingThresholdSize / videoFrameRate) * 1000.0);
            }
            if (this.mEvent.mVideoCodecProfile == Integer.MIN_VALUE) {
                this.mEvent.mVideoCodecProfile = this.mDataSource.getLogValueInt(63);
            }
            if (this.mEvent.mAudioCodecProfile == Integer.MIN_VALUE) {
                this.mEvent.mAudioCodecProfile = this.mDataSource.getLogValueInt(64);
            }
            this.mEvent.mVideoHWErrReason = this.mDataSource.getLogValueInt(77);
            this.mEvent.mMaxFramesInMediaCodec = this.mDataSource.getLogValueInt(147);
            this.mEvent.mIsViewHidden = this.mDataSource.getLogValueInt(87);
            HashMap<String, Object> batteryInfo = this.mEventBase.getChargingState();
            if (batteryInfo != null) {
                this.mPowerList.add((Integer)batteryInfo.get("power"));
                this.mChargingList.add((Integer)batteryInfo.get("isCharging"));
            }
            if ((forebackSwitchList = this.mDataSource.forebackSwitchList()) != null) {
                this.mEvent.mForebackSwitchList = forebackSwitchList;
            }
            this.mEvent.mNetworkConnectCount = this.mDataSource.getLogValueInt(114);
            long maskDownloadSize = this.mDataSource.getLogValueLong(137);
            if (maskDownloadSize > 0L) {
                this.mEvent.mMaskDownloadSize = maskDownloadSize;
            }
            if ((subtitleDownloadSize = this.mDataSource.getLogValueLong(138)) > 0L) {
                this.mEvent.mSubtitleDownloadSize = subtitleDownloadSize;
            }
        }
        if (this.mDuration > 0) {
            this.mEventBase.vd = this.mDuration;
        }
        if (this.mContext != null) {
            SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("VideoEventLogger", 0);
            this.mEvent.mLastSessionID = sharedPreferences.getString("playersessionid", "");
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString("playersessionid", this.mEventBase.mSessionID);
            editor.apply();
        }
        this.mEvent.mSessionID = this.mEventBase.mSessionID;
        this.mEvent.leave_reason = this.mLeaveReason;
        this.mEvent.apiver = this.mApiVer;
        this.mEvent.auth = this.mAuth;
        this.mEvent.startTime = this.mStartTime;
        this.mEvent.disableAccurateStart = this.mDisableAccurateStart;
        this.mEvent.vu = this.mVUArray;
        this.mEvent.lf = this.mEventBase.mLastResolution;
        this.mEvent.df = this.mEventBase.mCurrentResolution;
        this.mEvent.isStartPlayAutomatically = this.mIsStartPlayAutomatically;
        this.mEvent.bufferSeconds = this.mBufferDataSeconds;
        this.mEvent.loopcount = this.mLoopCount;
        this.mEvent.width = this.mWidth;
        this.mEvent.height = this.mHeight;
        this.mEvent.p2pUrl = this.mP2PUrl;
        this.mEvent.customP2PCDNType = this.mCustomP2PCDNType;
        this.mEvent.asyncInit = this.mAsyncInit;
        this.mEvent.asyncCodecId = this.mAsyncCodecId;
        this.mEvent.dns_server_ip = DNSServerIP.getDNSServerIP();
        this.mEvent.bc = this.mCurBufferCount;
        this.mEvent.br = this.mBreakCount;
        this.mEvent.bitrate = this.mBitrate;
        this.mEvent.audioBitrate = this.mAudioBitrate;
        this.mEvent.firstRangeSize = this.mFirstRangeSize;
        this.mEvent.netSpeedLevel = this.mNetSpeedLevel;
        this.mEvent.modelVersion = this.mModelVersion;
        this.mEvent.mRadioMode = this.mRadioMode;
        this.mEvent.mAudioStreamDisabled = this.mAudioStreamDisabled;
        this.mEvent.mVideoStreamDisabled = this.mVideoStreamDisabled;
        this.mEvent.isReplay = this.mIsReplay;
        this.mEvent.mediaCodecRender = this.mMediaCodecRender;
        this.mEvent.codecPool = this.mUseCodecPool;
        if (this.mSurfaceSetTime > 0L) {
            this.mEvent.surfaceSetTime = this.mSurfaceSetTime;
        }
        this.mEvent.surfaceCode = this.mSurfaceCode;
        this.mEvent.playerSurfaceCode = this.mPlayerSurfaceCode;
        if (this.mEventOneEvent != null) {
            this.mEvent.bufferAccuT = this.mEventOneEvent.mAccuCostTime;
        }
        this.mEvent.decoderBufferAccuT = this.mCurDecoderBufferAccuT;
        this.mEvent.seekCount = this.mSeekCount;
        this.mEvent.switchResolutionCount = this.mSwitchResolutionCount;
        this.mEvent.mEnableNNSR = this.mEnableNNSR;
        this.mEvent.mReadCacheMode = this.mReadCacheMode;
        this.mEvent.mPreRangeOff = this.mPreRangeOff;
        this.mEvent.mBufferTimeout = this.mBufferTimeout;
        this.mEvent.mCustomPlayEngineT = this.mCustomPlayEngineT;
        this.mEvent.mCustomInitEngineT = this.mCustomInitEngineT;
        this.mEvent.mCustomGetVideoModelT = this.mCustomGetVideoModelT;
        this.mEvent.mCustomClickT = this.mCustomClickT;
        this.mEvent.mHardwareConfType = this.mHardwareConfType;
        this.mEvent.mScreenWidth = this.getScreenWidth();
        this.mEvent.mScreenHeight = this.getScreenHeight();
        this.mEvent.mPixelDensity = ScreenUtils.getScreenPixelDensity();
        this.mEvent.xdpi = ScreenUtils.getScreenXdpi();
        this.mEvent.ydpi = ScreenUtils.getScreenYdpi();
        if (this.mSrMonitor.getWidthFactor() > 0.0f) {
            this.mEvent.mSrWidthFactor = this.mSrMonitor.getWidthFactor();
        }
        if (this.mSrMonitor.getHeightFactor() > 0.0f) {
            this.mEvent.mSrHeightFactor = this.mSrMonitor.getHeightFactor();
        }
        this.mEvent.mSrProccessSuccessRate = this.mSrMonitor.getProccessSuccessRate();
        this.mEvent.mSrProcessorCostTime = this.mSrMonitor.getProcessorAverageCostTime();
        this.mEvent.mSrAlgorithm = this.mSrMonitor.getSrAlgorithm();
        this.mEvent.mSrEnableBmf = this.mSrMonitor.getEnableBmf();
        this.mEvent.mVideoFilterList = this.mFilterMonitor.getList();
        this.mEvent.mBrightList = this.mBrightMonitor.getList();
        this.mEvent.mViewSizeList = this.mViewSizeMonitor.getHistory();
        this.mEvent.mEngineHash = this.mEngineHash;
        this.mEvent.mFromEnginePool = this.mFromEnginePool;
        this.mEvent.mCorePoolSizeUpperLimit = this.mCorePoolSizeUpperLimit;
        this.mEvent.mCorepoolSizeBeforeGetEngine = this.mCorepoolSizeBeforeGetEngine;
        this.mEvent.mCountOfEngineInUse = this.mCountOfEngineInUse;
        HashMap<String, Object> extra = new HashMap<String, Object>();
        try {
            int i;
            for (i = 0; i < this.mRetryFetchErrorInfo.size() && i < 3; ++i) {
                String key = String.format("fetchretry%d", i);
                extra.put(key, this.mRetryFetchErrorInfo.get(i));
            }
            for (i = 0; i < this.mFirstDNSErrorInfo.size() && i < 3; ++i) {
                String key = String.format("ldns%d", i);
                Error error = (Error)this.mFirstDNSErrorInfo.get(i);
                extra.put(key, error.toMap());
            }
            for (i = 0; i < this.mErrorInfo.size(); ++i) {
                if (i >= 2 && i != this.mErrorInfo.size() - 1) continue;
                String key = String.format("error%d", i);
                extra.put(key, this.mErrorInfo.get(i));
            }
            if (!TextUtils.isEmpty((CharSequence)this.mMessage)) {
                extra.put("log", this.mMessage);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mEvent.textureRenderErrorMsg)) {
                extra.put("tr_err_msg", this.mEvent.textureRenderErrorMsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mMessage = "";
        this.mEvent.ex = extra;
        this.mExtraInfo = extra.toString();
        if (this.mCustomStr != null) {
            this.mEvent.mCustomStr = this.mCustomStr;
        }
        if (this.mInitialURL != null) {
            this.mEvent.mInitialURL = this.mInitialURL;
        }
        if (this.mAudioInitURL != null) {
            this.mEvent.mAudioInitUrl = this.mAudioInitURL;
        }
        if (this.mInitialHost != null) {
            this.mEvent.mInitialHost = this.mInitialHost;
        }
        if (this.mInitialIP != null) {
            this.mEvent.mInitialIP = this.mInitialIP;
        }
        if (this.mInitialResolution != null) {
            this.mEvent.mInitialResolution = this.mInitialResolution;
        }
        if (this.mInitialQuality != null) {
            this.mEvent.mInitialQuality = this.mInitialQuality;
        }
        this.mEvent.mInitialQualityType = this.mInitialQualityType;
        if (this.mPlaybackParams != null) {
            this.mEvent.playbackparams = this.mPlaybackParams;
        }
        if (this.mSubReqURL != null) {
            this.mEvent.mSubReqURL = this.mSubReqURL;
        }
        if (this.mMaskURL != null) {
            this.mEvent.mMaskURL = this.mMaskURL;
        }
        if (this.mSubError != null) {
            this.mEvent.mSubError = this.mSubError;
        }
        if (this.mEvent.mask_opened_t <= 0L) {
            this.mEvent.mask_opened_t = Integer.MIN_VALUE;
        }
        if (this.mEvent.mask_open_t <= 0L) {
            this.mEvent.mask_open_t = Integer.MIN_VALUE;
        }
        if (this.mEvent.sub_req_finish_t <= 0L) {
            this.mEvent.sub_req_finish_t = Integer.MIN_VALUE;
        }
        if (this.mEvent.sub_load_finish_t <= 0L) {
            this.mEvent.sub_load_finish_t = Integer.MIN_VALUE;
        }
        this.mEvent.enableSub = this.mEnableSub;
        this.mEvent.enableSubThread = this.mEnableSubThread;
        this.mEvent.enableMask = this.mEnableMask;
        this.mEvent.enableMaskThread = this.mEnableMaskThread;
        this.mEvent.maskErrc = this.mMaskErrc;
        this.mEvent.subLanSwichCount = this.mSubLanSwitchCount;
        this.mEvent.subIdsCount = this.mSubIdsCount;
        this.mEvent.enableBash = this.mEnableBash;
        this.mEvent.enableMDL = this.mEventBase.mEnableMDL;
        this.mEvent.netWorkTryCount = this.mNetWorkTryCount;
        this.mEvent.isColdStart = sIsColdStart;
        sIsColdStart = 0;
        if (this.mEvent.lastSeekEndT < this.mEvent.lastSeekStartT) {
            this.mEvent.lastSeekEndT = Integer.MIN_VALUE;
        }
        if (this.mEvent.lastResolutionEndT < this.mEvent.lastResolutionStartT) {
            this.mEvent.lastResolutionEndT = Integer.MIN_VALUE;
        }
        this.mEvent.prepare_before_play_t = this.prepare_before_play_t;
        this.mEvent.setds_t = this.setds_t;
        this.mEvent.pt = this.mEvent.pt_new;
        this.mEvent.ps_t = this.ps_t;
        if (this.mEvent.et <= 0L && this.mEvent.vt > 0L) {
            this.mEvent.et = System.currentTimeMillis();
        }
        this.mEvent.mPlayList = this.mPlayList;
        this.mEvent.mPauseList = this.mPauseList;
        this.mEvent.mResolutionList = this.mResolutionList;
        this.mEvent.mPlaySpeedList = this.mPlaySpeedList;
        this.mEvent.mRadiomodeList = this.mRadiomodeList;
        this.mEvent.mLoopList = this.mLoopList;
        this.mEvent.mErrorList = this.mErrorList;
        this.mEvent.mRebufList = this.mEventOneEvent.mRebufList;
        this.mEvent.mSeekList = this.mEventOneOpera.mSeekList;
        this.mEvent.mHeadsetStateList = this.mHeadsetStateHistory.get();
        this.mEvent.mAVOutsyncList = this.mEventOneOutSync.mList;
        this.mEvent.mAVOutsyncCount = this.mEventOneOutSync.mAVOutSyncCount;
        this.mEvent.mMDLRetryList = this.mMDLRetryInfo;
        this.mEvent.mPowerList = this.mPowerList;
        this.mEvent.mChargingList = this.mChargingList;
        this.mEvent.mAVBadInterlacedList = this.mAVBadInterlacedList;
        this.mEvent.mVrDistanceList = this.mVrDistanceList;
        this.mEvent.mVrFrameRate = this.mVrFrameRate;
        this.mEvent.mVrScreenRefreshRate = this.mVrScreenRefreshRate;
        this.mEvent.mVrHeadMovementDelay = this.mVrHeadMovementDelay;
        this.mEvent.mSetSurfaceTimeList = this.mSetSurfaceTimeList;
        if (this.mEventOneNoRender.isStarted()) {
            this.mEventOneNoRender.end(0, "exit");
            this.callbackNoRenderEnd(this.mEventOneNoRender.getType());
        }
        this.mEvent.mNoVideoRenderList = this.mEventOneNoRender.getVideoHistory();
        this.mEvent.mNoAudioRenderList = this.mEventOneNoRender.getAudioHistory();
        this.mEvent.mTrEffectList = this.mTrEffectList;
        this.mEvent.mTrPerEffectAverageTime = this.mTrPerEffectAverageTime;
        this.mEvent.mTrEffectErrorCode = this.mTrEffectErrorCode;
        this.mEvent.mOttPluginVersion = this.mOttPluginVersion;
        this.mEvent.mCompanyID = this.mCompanyID;
        this._getMaskEvents();
        this._getSubEvents();
        if (TextUtils.isEmpty((CharSequence)this.mEvent.log_id)) {
            this._parseUrlLogID();
        }
        if (this.mBlockBeginT > 0L) {
            this.mEvent.leave_block_t = (int)(SystemClock.elapsedRealtime() - this.mBlockBeginT);
        }
        if (this.mEventOneOpera != null) {
            this.mEvent.seek_accu_t = this.mEventOneOpera.mAccuCostTime;
        }
        if (TimeService.isUpdated()) {
            this.mEvent.server_local_diff = TimeService.currentTimeMillis() - System.currentTimeMillis();
        }
        this._updateFeatures();
        this._getCastInfo();
        if (this.mVideoModel != null && (videoStyle = this.mVideoModel.getVideoStyle()) != null && videoStyle.getValueInt(0) == 1) {
            this.mEvent.mVideoStyle = 1;
            this.mEvent.mDimension = videoStyle.getValueInt(1);
            this.mEvent.mProjectionModel = videoStyle.getValueInt(2);
            this.mEvent.mViewSize = videoStyle.getValueInt(3);
        }
    }

    private static void updateTimeConsumingEventData(Context context, VideoEventOnePlay event, VideoEventBase base, PortraitNetworkScore.NetworkQualityAlgorithm algorithm) {
        if (event == null) {
            TTVideoEngineLog.e(TAG, "event is null, return.");
            return;
        }
        event.volume = (int)TTHelper.getVolume(context);
        if (base != null) {
            base.updateMDLInfo();
            base.mNetworkType = VideoEventBase.getNetType();
            if (base.mdlVideoInfo.mdl_cache_type == 2) {
                event.mFeatures.put("preload", 1);
            }
            if (base.mdlFeatures != null && !base.mdlFeatures.isEmpty()) {
                event.mFeatures.putAll(base.mdlFeatures);
                if (base.mdlP2pLoader >= 0) {
                    event.loaderType = String.valueOf(base.mdlP2pLoader);
                }
            }
        }
        event.mSensitiveMode = TTVideoEngineUtils.getSensitiveScene();
        if (base.mEnablePowerReport) {
            int isPowerSaveMod;
            double cpuRate = base.getCPURate();
            double cpuSpeed = base.getCPUSpeed();
            if (cpuRate > 0.0 && cpuSpeed > 0.0) {
                event.mCpuRateEnd = cpuRate;
                event.mCpuSpeedEnd = cpuSpeed;
            } else {
                DeviceMonitorUtils.CPUInfo cpuInfo = base.getCurrentCPUInfo();
                if (cpuInfo != null) {
                    event.mCpuRateEnd = cpuInfo.cpuAppRate > 0.0 ? cpuInfo.cpuAppRate : (double)1.4E-45f;
                    double d = event.mCpuSpeedEnd = cpuInfo.cpuAppSpeed > 0.0 ? cpuInfo.cpuAppSpeed : (double)1.4E-45f;
                }
            }
            if (!event.mCurrentList.isEmpty()) {
                double sum = 0.0;
                for (Float cur : event.mCurrentList) {
                    sum += (double)cur.floatValue();
                }
                event.mAvgCurrent = (float)(sum / (double)event.mCurrentList.size());
            }
            if ((isPowerSaveMod = DeviceMonitorUtils.isPowerSaveMode(context)) >= 0) {
                event.mPowerSaveModeEnd = isPowerSaveMod;
            }
        }
        event.mNetworkScore = PortraitNetworkScore.getInstance().getPortraitResult();
        if (algorithm != null) {
            event.mNetworkQualityBitrate = algorithm.calculateTargetBitrate(event.mCatowerRttMsList, event.mMdlMultiSpeedList);
        }
        event.mHostAbiBits = VideoEventLoggerV2.getHostabiBits();
    }

    private int getScreenHeight() {
        if (AppInfo.mScreenHeight <= 0) {
            AppInfo.mScreenHeight = ScreenUtils.getRealScreenSize((Context)this.mContext).y;
        }
        return AppInfo.mScreenHeight;
    }

    private int getScreenWidth() {
        if (AppInfo.mScreenWidth <= 0) {
            AppInfo.mScreenWidth = ScreenUtils.getRealScreenSize((Context)this.mContext).x;
        }
        return AppInfo.mScreenWidth;
    }

    private Map _getFirstFrameSplitInfo() {
        HashMap<String, Long> ffInfo = new HashMap<String, Long>(7);
        ffInfo.put("format_open_input", this.mEvent.demuxer_create_t);
        ffInfo.put("tran_connect", this.mEvent.tranConnectT);
        ffInfo.put("http_response", this.mEvent.httpResponseT);
        ffInfo.put("receive_first_video_frame", this.mEvent.receiveFirstVideoFrameT);
        ffInfo.put("decode_first_video_frame", this.mEvent.decodeFirstVideoFrameT);
        ffInfo.put("render_first_video_frame", this.mEvent.v_render_f_t);
        ffInfo.put("prepared", this.mEvent.player_prepared_time);
        return ffInfo;
    }

    private void _getCastInfo() {
        if (this.mCastObject != null) {
            if (this.mCastObject.containsKey("is_cast_live")) {
                this.mEvent.mCastinfoIsCastLive = (Integer)this.mCastObject.get("is_cast_live");
            }
            if (this.mCastObject.containsKey("cast_source_app_id")) {
                this.mEvent.mCastinfoSourceAppId = (Integer)this.mCastObject.get("cast_source_app_id");
            }
            if (this.mCastObject.containsKey("cast_scene_id")) {
                this.mEvent.mCastinfoSceneId = (Integer)this.mCastObject.get("cast_scene_id");
            }
            if (this.mCastObject.containsKey("cast_protocal")) {
                this.mEvent.mCastinfoProtocal = (String)this.mCastObject.get("cast_protocal");
            }
            TTVideoEngineLog.d(TAG, "get CastInfo, castLive:" + this.mEvent.mCastinfoIsCastLive + ", sourceAppId:" + this.mEvent.mCastinfoSourceAppId + ", sceneId:" + this.mEvent.mCastinfoSceneId + ", protocal:" + this.mEvent.mCastinfoProtocal);
        }
    }

    @Override
    public void showedFirstFrame() {
        if (this.mDataSource != null) {
            Map info = this._getFirstFrameSplitInfo();
            this.mDataSource.onInfo(2, info);
            if (this.mEvent != null) {
                this.mEvent.mStSpeed = TTVideoEngine.getNetworkSpeedFromPredictor();
            }
        }
    }

    @Override
    public void setSrAlgorithm(int algType) {
        this.mSrMonitor.setAlgorithm(algType);
    }

    @Override
    public void setSrScaleType(int srScaleType) {
        this.mSrMonitor.setSrScaleType(srScaleType);
    }

    @Override
    public void setEnableBmfSr(int enable) {
        this.mSrMonitor.setEnableBmf(enable);
    }

    @Override
    public void setEffect(Bundle bundle) {
        this.mFilterMonitor.setEffect(bundle);
        long curT = System.currentTimeMillis();
        Bundle tmpBundle = new Bundle(bundle);
        tmpBundle.putLong("time", curT);
        this.mTrEffectList.add(tmpBundle.toString());
    }

    @Override
    public void addFeature(String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        this.mFeatures.put(key, value);
        TTVideoEngineLog.d(TAG, "addFeature, key:" + key + ", value:" + value);
    }

    public static void addFeatureGlobal(String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        sFeatures.put(key, value);
        TTVideoEngineLog.d(TAG, "addFeatureGlobal, key:" + key + ", value:" + value);
    }

    private static int getHostabiBits() {
        int osBits;
        int appBits = VideoEventLoggerV2.getAppBits();
        if (appBits != (osBits = VideoEventLoggerV2.getOsBits())) {
            TTVideoEngineLog.i(TAG, "appBits:" + appBits + " != osBits:" + osBits);
            return -1;
        }
        return appBits;
    }

    private static int getAppBits() {
        return 64;
    }

    private static int getOsBits() {
        String arch = System.getProperty("os.arch");
        if (arch != null && arch.contains("64")) {
            return 64;
        }
        return 32;
    }

    @Override
    public void onAVBadInterlaced(long diff) {
        if (this.mEventOneEvent != null) {
            this.mEventOneEvent.onAVBadInterlaced();
        }
        if (this.mEventOneOutSync != null) {
            this.mEventOneOutSync.onAVBadInterlaced();
        }
        if (this.mEventOneNoRender != null) {
            this.mEventOneNoRender.onAVBadInterlaced();
        }
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("pts", "-1");
        map.put("type", "non");
        map.put("diff", Long.toString(diff));
        this.mAVBadInterlacedList.add(new JSONObject(map).toString());
    }

    @Override
    public void setPlayerViewSize(int width, int height) {
        this.mViewSizeMonitor.setSize(width, height);
    }

    @Override
    public void setVrDisplayDistance(float distc) {
        HashMap<String, Number> map = new HashMap<String, Number>(2);
        long curT = System.currentTimeMillis();
        map.put("distc", Float.valueOf(distc));
        map.put("t", curT);
        this.mVrDistanceList.add(new JSONObject(map).toString());
    }

    @Override
    public void setVrDisplayFrameRate(float fr) {
        this.mVrFrameRate = fr;
    }

    @Override
    public void setVrScreenRefreshRate(int r) {
        this.mVrScreenRefreshRate = r;
    }

    @Override
    public void setVrHeadMovementDelay(long dly) {
        this.mVrHeadMovementDelay = dly;
    }

    @Override
    public void setSurfaceSourceType(String type) {
        if (!TextUtils.isEmpty((CharSequence)type) && this.mSetSurfaceType == null) {
            this.mSetSurfaceType = type;
        }
    }

    @Override
    public void setSurfaceBegin() {
        if (this.mSetSurfaceTimeList.size() > 20) {
            return;
        }
        if (this.mSetSurfaceBeginT <= 0L) {
            this.mSetSurfaceBeginT = System.currentTimeMillis();
        }
    }

    @Override
    public void setSurfaceEnd() {
        if (this.mSetSurfaceBeginT > 0L && !TextUtils.isEmpty((CharSequence)this.mSetSurfaceType)) {
            long costT = System.currentTimeMillis() - this.mSetSurfaceBeginT;
            HashMap<String, Long> map = new HashMap<String, Long>(1);
            map.put(this.mSetSurfaceType, costT);
            this.mSetSurfaceTimeList.add(map.toString());
            this.mSetSurfaceBeginT = Integer.MIN_VALUE;
            this.mSetSurfaceType = null;
        }
    }

    @Override
    public void setPlayerSurface(String player_surface_code) {
        if (TextUtils.isEmpty((CharSequence)this.mPlayerSurfaceCode)) {
            this.mPlayerSurfaceCode = player_surface_code;
        }
    }

    @Override
    public void setSRPreloadInfo(Map<String, Object> preloadInfo) {
        this.mEvent.mSRPreloadInfo = preloadInfo;
    }

    @Override
    public void setSRStrategyInfo(SRStrategy srStrategy) {
        this.mEvent.mSRStrategyInfo.putAll(srStrategy.getStrategyInfo());
    }

    @Override
    public void saveEvent() {
        if (this.mEvent == null) {
            return;
        }
        if (this.mEvent.pt_new <= 0L && this.ps_t <= 0L) {
            return;
        }
        if (this.mLeave && this.mEvent.pt_new > 0L && this.mEvent.vt <= 0L) {
            if (this.mEvent.lt <= 0L) {
                this.mEvent.lt = System.currentTimeMillis();
            }
        } else {
            this.mEvent.et = System.currentTimeMillis();
        }
        this.mEventBase.updateVideoInfo(null);
        this.updateEventData();
        EngineThreadPool.addExecuteTask(() -> {
            VideoEventLoggerV2.updateTimeConsumingEventData(this.mContext, this.mEvent, this.mEventBase, this.mNetworkQualityAlgorithm);
            this.mEventSaver.save(this.mEvent, this.mEventBase);
        });
    }

    @Override
    public void uploadSavedEvent() {
        EngineThreadPool.addExecuteTask(() -> this.mEventSaver.uploadIfExits(this.mEventBase.isUploadLogEnabled));
    }

    @Override
    public void crosstalkHappen(int crosstalkCount, ArrayList infoList) {
        this.mEvent.mCrosstalkCount = crosstalkCount;
        this.mEvent.mCrosstalkInfoList = infoList;
        this._recordExitReason(-2009, true);
    }

    @Override
    public void onVideoInfoIdChanged(int id) {
        VideoInfo videoInfo;
        IVideoModel videoModel = this.mVideoModel;
        if (videoModel != null && (videoInfo = videoModel.getVideoInfoByInfoId(id)) != null) {
            int mediaType = videoInfo.getMediatype();
            String vType = videoInfo.getValueStr(6);
            if (mediaType == VideoRef.TYPE_AUDIO && ("dash".equals(vType) || "bash".equals(vType))) {
                this.mEventBase.mCurDashAudioInfoId = id;
            }
        }
    }

    @Override
    public void initContentReporterIfNeeded(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (sEnableContentDataReport && url.contains("trans_vdata_to_content=1")) {
            if (this.mContentDataReporter == null) {
                this.mContentDataReporter = new ContentDataReporter(this.mContext);
            }
            this.mUrlMatchCondition = true;
            this.mContentDataReporter.setInitialUrl(url);
        }
    }

    private void contentReporterStartTaskIfNeeded() {
        if (sEnableContentDataReport && this.mUrlMatchCondition) {
            this.mContentDataReporter.startTask(this.mEvent, this.mEventBase);
        }
    }

    private static class StatisticDataRunnable
    implements Runnable {
        private final WeakReference<VideoEventOnePlay> rEvent;
        private final WeakReference<VideoEventBase> rEventBase;

        public StatisticDataRunnable(VideoEventOnePlay event, VideoEventBase eventBase) {
            this.rEvent = new WeakReference<VideoEventOnePlay>(event);
            this.rEventBase = new WeakReference<VideoEventBase>(eventBase);
        }

        @Override
        public void run() {
            DeviceMonitorUtils.CPUInfo cpuInfo;
            VideoEventOnePlay event = (VideoEventOnePlay)this.rEvent.get();
            VideoEventBase eventBase = (VideoEventBase)this.rEventBase.get();
            if (event != null && eventBase != null && (cpuInfo = eventBase.getCurrentCPUInfo()) != null) {
                event.mCpuRateBegin = cpuInfo.cpuAppRate > 0.0 ? cpuInfo.cpuAppRate : (double)1.4E-45f;
                event.mCpuSpeedBegin = cpuInfo.cpuAppSpeed > 0.0 ? cpuInfo.cpuAppSpeed : (double)1.4E-45f;
            }
        }
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            VideoEventBase eventBase = VideoEventLoggerV2.this.mEventBase;
            VideoEventOnePlay onePlay = VideoEventLoggerV2.this.mEvent;
            NetworkPortraitData portraitData = PortraitNetworkScore.getInstance().getPortraitData();
            float netSpeed = -1.0f;
            int rttLevel = PortraitNetworkScore.getInstance().getNetworkRTTLevel();
            int rttMs = PortraitNetworkScore.getInstance().getNetworkRTTMS();
            int bitrate = eventBase.mCurrentConfigBitrate;
            int size = onePlay.mCatowerRttList.size();
            String netType = VideoEventBase.getNetType();
            String sigLevel = VideoEventBase.getSignalStrength();
            String curQuality = eventBase.mCurQuality;
            if (bitrate < 0) {
                bitrate = (int)VideoEventLoggerV2.this.mDataSource.getLogValueLong(75);
            }
            if (onePlay.mCatowerRttList.isEmpty()) {
                onePlay.mCatowerRttList.addAll(portraitData.getRttHistoryData(0));
            }
            if (onePlay.mCatowerRttMsList.isEmpty()) {
                onePlay.mCatowerRttMsList.addAll(portraitData.getRttMsHistoryData(0));
            }
            if (onePlay.mMdlMultiSpeedList.isEmpty()) {
                onePlay.mMdlMultiSpeedList.addAll(portraitData.getNetSpeedHistoryData(0));
            }
            if (size >= VideoEventLoggerV2.this.mNetLevelMaxCount) {
                onePlay.mCatowerRttList.remove(0);
            }
            onePlay.mCatowerRttList.add(rttLevel);
            size = onePlay.mCatowerRttMsList.size();
            if (size >= VideoEventLoggerV2.this.mNetLevelMaxCount) {
                onePlay.mCatowerRttMsList.remove(0);
            }
            onePlay.mCatowerRttMsList.add(rttMs);
            String string = VideoEventLoggerV2.TAG;
            synchronized (VideoEventLoggerV2.TAG) {
                float current;
                if (VideoEventLoggerV2.this.mMDLDownloadTime > 0L) {
                    netSpeed = (float)(VideoEventLoggerV2.this.mMDLDownloadSize * 8L) * 1000.0f / (float)VideoEventLoggerV2.this.mMDLDownloadTime;
                }
                VideoEventLoggerV2.this.mMDLDownloadTime = 0L;
                VideoEventLoggerV2.this.mMDLDownloadSize = 0L;
                // ** MonitorExit[var12_12] (shouldn't be in output)
                size = onePlay.mMdlMultiSpeedList.size();
                if (size >= VideoEventLoggerV2.this.mNetLevelMaxCount) {
                    onePlay.mMdlMultiSpeedList.remove(0);
                }
                onePlay.mMdlMultiSpeedList.add(Float.valueOf(netSpeed));
                portraitData.setNetSpeed(netSpeed);
                if (bitrate > 0) {
                    this.addIfChanged(onePlay.mBitrateList, onePlay.mNetQualityIndex, bitrate);
                }
                if (!TextUtils.isEmpty((CharSequence)curQuality)) {
                    this.addIfChanged(onePlay.mQualityList, onePlay.mNetQualityIndex, curQuality);
                }
                if (!TextUtils.isEmpty((CharSequence)netType)) {
                    this.addIfChanged(onePlay.mNetworkTypeList, onePlay.mNetQualityIndex, netType);
                }
                if (!TextUtils.isEmpty((CharSequence)sigLevel)) {
                    this.addIfChanged(onePlay.mSignalStrengthList, onePlay.mNetQualityIndex, sigLevel);
                }
                if ((size = onePlay.mCurrentList.size()) >= VideoEventLoggerV2.this.mNetLevelMaxCount) {
                    onePlay.mCurrentList.remove(0);
                }
                if ((current = VideoEventLoggerV2.this.mEventBase.getBatteryCurrent()) != -1.0f) {
                    onePlay.mCurrentList.add(Float.valueOf(current));
                }
                ++onePlay.mNetQualityIndex;
                TTVideoEngineLog.d(VideoEventLoggerV2.TAG, "netlevel rttLevel:" + rttLevel + ", rttMs:" + rttMs + ", netType:" + netType + ", sigLevel:" + sigLevel + ", bitrate:" + bitrate + ", quality:" + curQuality + ", speed:" + netSpeed);
                return;
            }
        }

        private <T> void addIfChanged(@NonNull LinkedHashMap<String, T> map, int index, @NonNull T value) {
            int size = map.size();
            if (size > 0) {
                String lastKey = (String)map.keySet().toArray()[size - 1];
                T lastValue = map.get(lastKey);
                if (!value.equals(lastValue)) {
                    map.put(Integer.toString(index), value);
                }
            } else {
                map.put(Integer.toString(index), value);
            }
        }
    }

    private static class AsyncGetLogDataRunnable
    implements Runnable {
        private final VideoEventOnePlay rEvent;
        private final Context rContext;
        private final Handler rHandler;
        VideoEventLoggerV2 rLogger;
        VideoEventBase rEventBase;
        PortraitNetworkScore.NetworkQualityAlgorithm rQualityAlg;
        EventSaver rEventSaver;

        public AsyncGetLogDataRunnable(Context context, VideoEventOnePlay event, VideoEventLoggerV2 logger, VideoEventBase base, PortraitNetworkScore.NetworkQualityAlgorithm alg, EventSaver saver) {
            this.rEvent = event;
            this.rContext = context;
            this.rLogger = logger;
            this.rEventBase = base;
            this.rHandler = new Handler(Looper.getMainLooper());
            this.rQualityAlg = alg;
            this.rEventSaver = saver;
        }

        @Override
        public void run() {
            TTVideoEngineLog.i(VideoEventLoggerV2.TAG, "AyncGetLogDataRunnable enter");
            if (this.rEvent == null) {
                TTVideoEngineLog.e(VideoEventLoggerV2.TAG, "rEvent is null, return.");
                return;
            }
            VideoEventLoggerV2.updateTimeConsumingEventData(this.rContext, this.rEvent, this.rEventBase, this.rQualityAlg);
            JSONObject jsonEvent = this.rEvent.toJsonObject(this.rEventBase);
            boolean isUpload = this.rEventBase.isUploadLogEnabled;
            this.rEventSaver.remove(this.rEvent.mSessionID);
            this.rHandler.post(() -> VideoEventManager.instance.addEvent(isUpload, jsonEvent));
        }
    }

    class FeatureConfigs {
        private int mEnableBufferDirectly = 0;
        private int mFirstBufEndMs = 0;
        private int mEnableVolumeBalance = 0;
        private int mAEType = -1;
        private int mEnableEngineLooper = 0;
        private int mEnableAutoRange = 0;
        private int mEnableHwDropNonRef = 0;
        private int mEnableHttps = 0;
        private int mEnableFallbackApi = 0;
        private int mEnableAsyncPosition = 0;
        private int mEnableLoadControl = 0;
        private int mRenderType = Integer.MIN_VALUE;
        private int mImageScaleType = 0;
        private int mAudioRenderType = Integer.MIN_VALUE;
        private int mSkipFindStreamInfo = 0;
        private int mEnableAsyncPrepare = 0;
        private int mCodecFrcLevel = 0;
        private int mEnableLazySeek = 0;
        private int mKeepFormatThreadAlive = 0;
        private int mHDRType = 0;
        private int mEnableABRStartup = 0;
        private int mEnableThreadPriority = 0;
        private int mEnableSmoothClock = 0;
        private int mDisableSplitVoice = 0;
        private int mEnableNativeYV12 = 0;
        private int mEnableStrategyCenter = 0;
        private int mEnableOutletDropLimit = -1;
        private int mEnableGearStrategy = 0;
        private int mEnableSRStrategy = 0;

        FeatureConfigs() {
        }
    }
}

