/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.model.BareVideoInfo;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.SubInfo;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.model.VideoStyle;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class BareVideoModel
implements IVideoModel {
    private static final String TAG = "TTVideoEngine.BareVideoModel";
    private String mVid;
    private long mDuration;
    private float mLoudness;
    private float mPeak;
    private List<VideoInfo> mInfos;
    private int mCategory = 0;
    private boolean mAdaptive;
    private String mBid = "";
    private String mDynamicType;
    private String mBashString = "";

    private BareVideoModel() {
    }

    @Override
    public boolean hasData() {
        return this.mInfos != null && !this.mInfos.isEmpty();
    }

    @Override
    public List<VideoInfo> getVideoInfoList() {
        return this.mInfos;
    }

    @Override
    public List<SubInfo> getSubInfoList() {
        return null;
    }

    @Override
    public IVideoModel.Source getSource() {
        return IVideoModel.Source.BARE;
    }

    @Override
    @NonNull
    public Set<IVideoModel.Format> getFormats() {
        HashSet<IVideoModel.Format> formats = new HashSet<IVideoModel.Format>();
        if (this.mInfos != null) {
            for (VideoInfo info : this.mInfos) {
                String format;
                if (info == null || (format = info.getValueStr(6)) == null) continue;
                if (format.equals("mp3")) {
                    formats.add(IVideoModel.Format.MP3);
                    continue;
                }
                if (format.equals("dash")) {
                    formats.add(IVideoModel.Format.DASH);
                    continue;
                }
                if (format.equals("hls")) {
                    formats.add(IVideoModel.Format.HLS);
                    continue;
                }
                if (format.equals("mp4")) {
                    formats.add(IVideoModel.Format.MP4);
                    continue;
                }
                formats.add(IVideoModel.Format.MP4);
            }
        }
        return formats;
    }

    @Override
    public VideoInfo getVideoInfo(Resolution resolution) {
        return this.getVideoInfo(resolution, null);
    }

    @Override
    public boolean hasFormat(IVideoModel.Format format) {
        return this.getFormats().contains((Object)format);
    }

    @Override
    public VideoInfo getVideoInfo(Map<Integer, String> otherDimensionalityMap) {
        VideoInfo videoInfo = null;
        for (VideoInfo tmpInfo : this.mInfos) {
            if (tmpInfo == null) continue;
            if (otherDimensionalityMap == null || otherDimensionalityMap.isEmpty()) {
                videoInfo = tmpInfo;
                break;
            }
            boolean isFound = true;
            for (Map.Entry<Integer, String> entry : otherDimensionalityMap.entrySet()) {
                int key = entry.getKey();
                String value = entry.getValue();
                if (TextUtils.isEmpty((CharSequence)value) || value.equals(tmpInfo.getValueStr(key))) continue;
                isFound = false;
                break;
            }
            if (!isFound) continue;
            videoInfo = tmpInfo;
            break;
        }
        return videoInfo;
    }

    @Override
    @Nullable
    public VideoInfo getVideoInfo(Resolution resolution, Map<Integer, String> otherDimensionalityMap) {
        return this.getVideoInfo(resolution, this.getVideoRefInt(7), otherDimensionalityMap);
    }

    @Override
    @Nullable
    public VideoInfo getVideoInfo(Resolution resolution, int type, Map<Integer, String> otherDimensionalityMap) {
        if (this.mInfos == null) {
            return null;
        }
        VideoInfo videoInfo = null;
        for (VideoInfo tmpInfo : this.mInfos) {
            if (tmpInfo == null || resolution != tmpInfo.getResolution() || type != tmpInfo.getMediatype()) continue;
            if (otherDimensionalityMap == null || otherDimensionalityMap.isEmpty()) {
                videoInfo = tmpInfo;
                break;
            }
            boolean isFound = true;
            for (Map.Entry<Integer, String> entry : otherDimensionalityMap.entrySet()) {
                int key = entry.getKey();
                String value = entry.getValue();
                if (TextUtils.isEmpty((CharSequence)value) || value.equals(tmpInfo.getValueStr(key))) continue;
                isFound = false;
                break;
            }
            if (!isFound) continue;
            videoInfo = tmpInfo;
            break;
        }
        return videoInfo;
    }

    @Override
    public VideoInfo getVideoInfo(Resolution resolution, boolean downgrade) {
        return this.getVideoInfo(resolution, this.getVideoRefInt(7), null, downgrade);
    }

    @Override
    public VideoInfo getVideoInfo(Resolution resolution, Map<Integer, String> otherDimensionalityMap, boolean downgrade) {
        return this.getVideoInfo(resolution, this.getVideoRefInt(7), otherDimensionalityMap, downgrade);
    }

    @Override
    public VideoInfo getVideoInfo(Resolution resolution, int type, boolean downgrade) {
        return this.getVideoInfo(resolution, type, null, downgrade);
    }

    @Override
    public VideoInfo getVideoInfo(Resolution resolution, int type, Map<Integer, String> otherDimensionalityMap, boolean downgrade) {
        Resolution[] temResolutions;
        int originIndex;
        int i;
        VideoInfo info = this.getVideoInfo(resolution, type, otherDimensionalityMap);
        if (!downgrade) {
            return info;
        }
        String[] temQualityInfos = TTVideoEngine.getAllQualityInfos();
        if (temQualityInfos.length > 0 && otherDimensionalityMap != null && otherDimensionalityMap.containsKey(32)) {
            int temIndex = temQualityInfos.length - 1;
            block0: while (info == null) {
                String qualityValue = otherDimensionalityMap.get(32);
                if (qualityValue == null) continue;
                for (i = 0; i < temQualityInfos.length; ++i) {
                    if (!temQualityInfos[i].equals(qualityValue)) continue;
                    temIndex = i;
                    break;
                }
                originIndex = temIndex;
                while (info == null) {
                    String temQualityInfo = temQualityInfos[temIndex];
                    otherDimensionalityMap.put(32, temQualityInfo);
                    info = this.getVideoInfo(resolution, type, otherDimensionalityMap);
                    if (info != null) {
                        return info;
                    }
                    if ((temIndex = (temIndex + temQualityInfos.length - 1) % temQualityInfos.length) != originIndex) continue;
                    continue block0;
                }
            }
        }
        if ((temResolutions = Resolution.getAllResolutions()).length <= 0) {
            return info;
        }
        int index = temResolutions.length - 1;
        if (resolution != null) {
            for (i = 0; i < temResolutions.length; ++i) {
                Resolution tem = temResolutions[i];
                if (tem.getIndex() != resolution.getIndex()) continue;
                index = i;
                break;
            }
        }
        originIndex = index;
        while (info == null) {
            Resolution temResolution = temResolutions[index];
            info = this.getVideoInfo(temResolution, type, null);
            if (info != null) {
                resolution = temResolution;
                break;
            }
            if ((index = (index + temResolutions.length - 1) % temResolutions.length) != originIndex) continue;
            break;
        }
        return info;
    }

    @Override
    public String[] allVideoURLs(Resolution resolution) {
        return this.allVideoURLs(resolution, null);
    }

    @Override
    public String[] allVideoURLs(Resolution resolution, Map<Integer, String> otherDimensionalityMap) {
        VideoInfo info = this.getVideoInfo(resolution, otherDimensionalityMap);
        if (info == null) {
            return new String[0];
        }
        return info.getValueStrArr(16);
    }

    @Override
    public String getSpadea() {
        String val = null;
        for (VideoInfo info : this.mInfos) {
            String spadea = info.getValueStr(5);
            if (TextUtils.isEmpty((CharSequence)spadea)) continue;
            val = spadea;
            break;
        }
        return val;
    }

    @Override
    public String[] getCodecs() {
        HashSet<String> codecList = new HashSet<String>();
        if (this.mInfos != null) {
            for (VideoInfo info : this.mInfos) {
                String infoCodecType = info.getValueStr(8);
                if (TextUtils.isEmpty((CharSequence)infoCodecType)) continue;
                codecList.add(infoCodecType);
            }
        }
        return codecList.toArray(new String[0]);
    }

    @Override
    public String getVType() {
        return "mp4";
    }

    @Override
    public String getDynamicType() {
        return this.mDynamicType;
    }

    @Override
    public Resolution[] getSupportResolutions() {
        HashSet<Resolution> resolutionSet = new HashSet<Resolution>();
        if (this.mInfos != null) {
            for (VideoInfo info : this.mInfos) {
                resolutionSet.add(info.getResolution());
            }
        }
        return resolutionSet.toArray(new Resolution[0]);
    }

    @Override
    public int[] getSupportSubtitleLangs() {
        return null;
    }

    @Override
    public String[] getSupportQualityInfos() {
        HashSet<String> qualities = new HashSet<String>();
        for (VideoInfo info : this.mInfos) {
            String qualityDesc = info.getValueStr(32);
            if (TextUtils.isEmpty((CharSequence)qualityDesc)) continue;
            qualities.add(qualityDesc);
        }
        return qualities.toArray(new String[0]);
    }

    @Override
    public JSONObject getDnsInfo() {
        return null;
    }

    @Override
    public int getVideoRefInt(int key) {
        int val = 0;
        switch (key) {
            case 3: {
                val = (int)this.mDuration;
                break;
            }
            case 7: {
                val = VideoRef.TYPE_VIDEO;
                break;
            }
            case 232: {
                val = this.mCategory;
            }
        }
        return val;
    }

    @Override
    public String getVideoRefStr(int key) {
        String val = null;
        switch (key) {
            case 2: {
                val = this.mVid;
                break;
            }
            case 246: {
                val = this.mBid;
                break;
            }
            case 8: {
                val = this.mBashString;
                break;
            }
        }
        return val;
    }

    @Override
    public boolean getVideoRefBool(int key) {
        boolean value = false;
        block0 : switch (key) {
            case 222: {
                value = this.mAdaptive;
                break;
            }
            case 208: {
                if (this.mInfos == null) break;
                for (VideoInfo info : this.mInfos) {
                    if (!info.getValueStr(6).equals("hls")) continue;
                    value = true;
                    break block0;
                }
                break;
            }
        }
        return value;
    }

    @Override
    public long getVideoRefLong(int key) {
        return 0L;
    }

    @Override
    public float getVideoRefFloat(int key) {
        float val = 0.0f;
        switch (key) {
            case 224: {
                val = this.mLoudness;
                break;
            }
            case 225: {
                val = this.mPeak;
            }
        }
        return val;
    }

    @Override
    public void setUpResolution(HashMap<String, Resolution> resolutionMap) {
    }

    @Override
    public String resolutionToString(Resolution resolution) {
        return resolution.toString(VideoRef.TYPE_VIDEO);
    }

    @Override
    public boolean isSupportBash() {
        String dynamicType;
        if (TextUtils.isEmpty((CharSequence)this.getVideoRefStr(8))) {
            return false;
        }
        return this.hasFormat(IVideoModel.Format.DASH) ? !TextUtils.isEmpty((CharSequence)(dynamicType = this.getDynamicType())) && dynamicType.equals("segment_base") : this.hasFormat(IVideoModel.Format.MP4) && this.getVideoRefBool(222) && TextUtils.isEmpty((CharSequence)this.getSpadea());
    }

    @Override
    public boolean isSupportHLSSeamlessSwitch() {
        if (TextUtils.isEmpty((CharSequence)this.getVideoRefStr(8))) {
            return false;
        }
        return this.hasFormat(IVideoModel.Format.HLS) && this.getVideoRefBool(222);
    }

    @Override
    public String toMediaInfoJsonString() {
        JSONObject ret = this.getMediaInfo();
        if (ret != null) {
            return ret.toString();
        }
        return null;
    }

    @Override
    public JSONObject getMediaInfo() {
        String format = this.hasFormat(IVideoModel.Format.MP3) ? "mp3" : (this.hasFormat(IVideoModel.Format.DASH) ? "dash" : (this.hasFormat(IVideoModel.Format.HLS) ? "hls" : (this.hasFormat(IVideoModel.Format.MP4) ? "mp4" : "")));
        String videoId = this.getVideoRefStr(2);
        long duration = this.mDuration;
        List<VideoInfo> videoInfos = this.getVideoInfoList();
        try {
            if (videoInfos != null) {
                HashMap<String, Object> modelMap = new HashMap<String, Object>();
                ArrayList<Map<String, Object>> infoMaps = new ArrayList<Map<String, Object>>();
                for (VideoInfo info : videoInfos) {
                    infoMaps.add(info.toMediaInfo());
                }
                modelMap.put("format", format);
                modelMap.put("vid", videoId);
                modelMap.put("bid", this.mBid);
                modelMap.put("category", this.getVideoRefInt(232));
                modelMap.put("duration", duration);
                modelMap.put("infos", infoMaps);
                return new JSONObject(modelMap);
            }
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        return null;
    }

    @Override
    public int fromMediaInfoJsonString(String jsonString) {
        try {
            JSONObject jObject = new JSONObject(jsonString);
            return this.fromMediaInfoJsonObject(jObject);
        }
        catch (Exception e) {
            TTVideoEngineLog.i(TAG, "[GearStrategy]fromMediaInfoJsonString exception=" + e);
            return -1;
        }
    }

    @Override
    public int fromMediaInfoJsonObject(JSONObject jsonObject) {
        try {
            this.mVid = jsonObject.optString("vid");
            this.mBid = jsonObject.optString("bid");
            if (TextUtils.isEmpty((CharSequence)this.mBid)) {
                this.mBid = this.mVid;
            }
            this.mCategory = jsonObject.optInt("category");
            this.mDuration = jsonObject.optLong("duration");
            JSONArray jInfos = jsonObject.getJSONArray("infos");
            if (jInfos != null) {
                for (int i = 0; i < jInfos.length(); ++i) {
                    BareVideoInfo info = new BareVideoInfo.Builder().build();
                    info.fromMediaInfoJsonObject(jInfos.getJSONObject(i));
                    if (this.mInfos == null) {
                        this.mInfos = new ArrayList<VideoInfo>();
                    }
                    this.mInfos.add(info);
                }
            }
            return 0;
        }
        catch (Exception e) {
            TTVideoEngineLog.i(TAG, "[GearStrategy]fromMediaInfoJsonObject exception=" + e);
            return -1;
        }
    }

    @Override
    public List<Integer> getSupportInfoId(int mediaType) {
        return null;
    }

    @Override
    public VideoInfo getVideoInfoByInfoId(int infoId) {
        return null;
    }

    @Override
    public List<Integer> getSupportedTTSAudioInfo() {
        return null;
    }

    @Override
    public List<Integer> getOriginalAudioInfo() {
        return null;
    }

    @Override
    public VideoStyle getVideoStyle() {
        return null;
    }

    public String toBashString() {
        JSONObject jsonObject = this.toBashJsonObject();
        return jsonObject != null ? jsonObject.toString() : "";
    }

    @Nullable
    public JSONObject toBashJsonObject() {
        try {
            List<VideoInfo> infoList = this.getVideoInfoList();
            if (infoList == null || infoList.size() <= 0) {
                return null;
            }
            JSONArray videoJsonArray = new JSONArray();
            JSONArray audioJsonArray = new JSONArray();
            for (VideoInfo info : infoList) {
                JSONObject infoJsonObject = null;
                if (info == null || (infoJsonObject = info.toBashJsonObject()) == null) continue;
                if (info.getMediatype() == VideoRef.TYPE_VIDEO) {
                    videoJsonArray.put((Object)infoJsonObject);
                    continue;
                }
                if (info.getMediatype() != VideoRef.TYPE_AUDIO) continue;
                audioJsonArray.put((Object)infoJsonObject);
            }
            if (videoJsonArray.length() > 0 || audioJsonArray.length() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("dynamic_video_list", (Object)videoJsonArray);
                jsonObject.put("dynamic_audio_list", (Object)audioJsonArray);
                return jsonObject;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static class Builder {
        private String mVid = null;
        private long mDuration = 0L;
        private boolean mAdaptive = false;
        private String mDynamicType = null;
        private float mLoudness = 0.0f;
        private float mPeak = 0.0f;
        private int mCategory = 0;
        private String mFirstSubVid = null;
        private int mSubListIndex = -1;
        private List<VideoInfo> mInfos = null;
        private String mBid = "";

        public Builder vid(String vid) {
            this.mVid = vid;
            if (TextUtils.isEmpty((CharSequence)this.mBid)) {
                this.mBid = vid;
            }
            return this;
        }

        public Builder bid(String bid) {
            this.mBid = bid;
            return this;
        }

        public Builder adaptive(boolean adaptive) {
            this.mAdaptive = adaptive;
            return this;
        }

        public Builder dynamicType(String dynamicType) {
            this.mDynamicType = dynamicType;
            return this;
        }

        public Builder loudness(float loudness) {
            this.mLoudness = loudness;
            return this;
        }

        public Builder peak(float peak) {
            this.mPeak = peak;
            return this;
        }

        public Builder duration(long duration) {
            this.mDuration = duration;
            return this;
        }

        public Builder category(int category) {
            this.mCategory = category;
            return this;
        }

        public Builder firstSubVideoId(String firstSubVideoId) {
            this.mFirstSubVid = firstSubVideoId;
            return this;
        }

        public Builder firstSubVideoId(String firstSubVideoId, int index) {
            this.mFirstSubVid = firstSubVideoId;
            this.mSubListIndex = index;
            return this;
        }

        public Builder addVideoInfo(VideoInfo info) {
            if (this.mInfos == null) {
                this.mInfos = new ArrayList<VideoInfo>();
            }
            this.mInfos.add(info);
            return this;
        }

        public Builder setVideoInfos(List<? extends VideoInfo> videoInfos) {
            if (this.mInfos == null) {
                this.mInfos = new ArrayList<VideoInfo>();
            }
            this.mInfos.clear();
            this.mInfos.addAll(videoInfos);
            return this;
        }

        public BareVideoModel build() {
            BareVideoModel model = new BareVideoModel();
            model.mVid = this.mVid;
            model.mBid = this.mBid;
            model.mDuration = this.mDuration;
            model.mAdaptive = this.mAdaptive;
            model.mDynamicType = this.mDynamicType;
            model.mLoudness = this.mLoudness;
            model.mPeak = this.mPeak;
            model.mCategory = this.mCategory;
            if (this.mInfos == null) {
                this.mInfos = new ArrayList<VideoInfo>();
            }
            model.mInfos = this.mInfos;
            model.mBashString = model.toBashString();
            return model;
        }
    }
}

