/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.model;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.ss.ttvideoengine.net.TTHTTPNetwork;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.json.JSONObject;

public class IntertrustDrmHelper {
    private static final String TAG = "IntertrustDrmHelper";
    public static final int DRM_RESULT_OK = 0;
    public static final int DRM_RESULT_FAIL = -1;
    public static final int DRM_RESULT_LIB_UNLOAD = -1000;
    public static final int DRM_RESULT_TOKEN_TEMPLATE_INVALID = -1001;
    public static final int DRM_RESULT_PLUGIN_UNLOAD = -1002;
    public static final int DRM_RESULT_ROOT_DEVICE = -1003;
    public static final int DRM_ERROR_INTERNAL = -600000;
    public static final int DRM_ERROR_TOKEN_PROCESS = -600001;
    private static final String INTERTRUST_DRM_PATH = "com.ss.ttm.drm.intertrust.IntertrustDrmProxy";
    private static final String INTERTRUST_DRM_LISTENER_PATH = "com.ss.ttm.drm.intertrust.IntertrustDrmProxy$IntertrustDrmProxyListener";
    private static final String INTERTRUST_DRM_NETWORK_LISTENER_PATH = "com.ss.ttm.drm.intertrust.IntertrustDrmProxy$IntertrustDrmProxyNetworkClient";
    public static final int MSG_IS_SUCCESS = 0;
    public static final int MSG_IS_ERROR = 1;
    public static final int URL_TYPE_SINGLE = 0;
    public static final int URL_TYPE_HLS = 1;
    public static final int URL_TYPE_DASH = 2;
    private Class<?> mDrmClass = null;
    private Object mInstance = null;
    private Object mIntertrustCallback = null;
    private Object mDrmNetworkCallback = null;
    private TTVNetClient mNetworkSession = new TTHTTPNetwork();
    private IntertrustDrmHelperListener mListener = null;
    private Handler mHandler = null;

    public void setListener(IntertrustDrmHelperListener listener) {
        this.mListener = listener;
    }

    public int init(Context context, int closedCheck) {
        TTVideoEngineLog.d(TAG, "init enter");
        Object ret = null;
        try {
            this.mDrmClass = Class.forName(INTERTRUST_DRM_PATH);
            this.mInstance = this.mDrmClass.newInstance();
            Class<?> drmListenerClass = Class.forName(INTERTRUST_DRM_LISTENER_PATH);
            MyIntertrustListener intertrustListener = new MyIntertrustListener();
            this.mIntertrustCallback = Proxy.newProxyInstance(IntertrustDrmHelper.class.getClassLoader(), new Class[]{drmListenerClass}, (InvocationHandler)intertrustListener);
            Method setListenerMethod = this.mDrmClass.getDeclaredMethod("setListener", drmListenerClass);
            setListenerMethod.invoke(this.mInstance, this.mIntertrustCallback);
            Class<?> drmNetListenerClass = Class.forName(INTERTRUST_DRM_NETWORK_LISTENER_PATH);
            MyNetworkListener networkListener = new MyNetworkListener();
            this.mDrmNetworkCallback = Proxy.newProxyInstance(IntertrustDrmHelper.class.getClassLoader(), new Class[]{drmNetListenerClass}, (InvocationHandler)networkListener);
            Method setNetworkMethod = this.mDrmClass.getDeclaredMethod("setNetworkClient", drmNetListenerClass);
            setNetworkMethod.invoke(this.mInstance, this.mDrmNetworkCallback);
            if (closedCheck == 0) {
                Method initMethod = this.mDrmClass.getDeclaredMethod("init", Context.class);
                ret = initMethod.invoke(this.mInstance, context);
            } else {
                Method initMethod = this.mDrmClass.getDeclaredMethod("init", Context.class, Integer.TYPE);
                ret = initMethod.invoke(this.mInstance, context, closedCheck);
            }
        }
        catch (ClassNotFoundException e) {
            TTVideoEngineLog.e(TAG, "class not found:" + e.getLocalizedMessage());
            return -1002;
        }
        catch (InstantiationException e) {
            TTVideoEngineLog.e(TAG, "instance failed+" + e.getLocalizedMessage());
            return -1;
        }
        catch (IllegalAccessException e) {
            TTVideoEngineLog.e(TAG, "illegal access exception:" + e.getLocalizedMessage());
            return -1;
        }
        catch (NoSuchMethodException e) {
            TTVideoEngineLog.e(TAG, "method not found:" + e.getLocalizedMessage());
            return -1;
        }
        catch (InvocationTargetException e) {
            TTVideoEngineLog.e(TAG, "invoke failed:" + e.getLocalizedMessage());
            return -1;
        }
        this.mHandler = new MyHandler(this, TTHelper.getLooper());
        return (Integer)ret;
    }

    public void release() {
        TTVideoEngineLog.d(TAG, "release enter");
        if (this.mInstance == null) {
            return;
        }
        try {
            if (this.mDrmClass == null) {
                this.mDrmClass = Class.forName(INTERTRUST_DRM_PATH);
            }
            Method releaseMethod = this.mDrmClass.getDeclaredMethod("release", new Class[0]);
            releaseMethod.invoke(this.mInstance, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            TTVideoEngineLog.e(TAG, "class not found:" + e.getLocalizedMessage());
            return;
        }
        catch (NoSuchMethodException e) {
            TTVideoEngineLog.e(TAG, "method not found:" + e.getLocalizedMessage());
            return;
        }
        catch (IllegalAccessException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return;
        }
        catch (InvocationTargetException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return;
        }
        this.mInstance = null;
    }

    public int start() {
        TTVideoEngineLog.d(TAG, "start enter");
        if (this.mInstance == null) {
            return -1;
        }
        Object ret = null;
        try {
            if (this.mDrmClass == null) {
                this.mDrmClass = Class.forName(INTERTRUST_DRM_PATH);
            }
            Method startMethod = this.mDrmClass.getDeclaredMethod("start", new Class[0]);
            ret = startMethod.invoke(this.mInstance, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            TTVideoEngineLog.e(TAG, "class not found:" + e.getLocalizedMessage());
            return -1;
        }
        catch (NoSuchMethodException e) {
            TTVideoEngineLog.e(TAG, "method not found:" + e.getLocalizedMessage());
            return -1;
        }
        catch (IllegalAccessException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return -1;
        }
        catch (InvocationTargetException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return -1;
        }
        return (Integer)ret;
    }

    public int stop() {
        TTVideoEngineLog.d(TAG, "stop enter");
        if (this.mInstance == null) {
            return -1;
        }
        Object ret = null;
        try {
            if (this.mDrmClass == null) {
                this.mDrmClass = Class.forName(INTERTRUST_DRM_PATH);
            }
            Method stopMethod = this.mDrmClass.getDeclaredMethod("stop", new Class[0]);
            ret = stopMethod.invoke(this.mInstance, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            TTVideoEngineLog.e(TAG, "class not found:" + e.getLocalizedMessage());
            return -1;
        }
        catch (NoSuchMethodException e) {
            TTVideoEngineLog.e(TAG, "method not found:" + e.getLocalizedMessage());
            return -1;
        }
        catch (IllegalAccessException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return -1;
        }
        catch (InvocationTargetException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return -1;
        }
        return (Integer)ret;
    }

    public void setTokenUrlTemplate(String tokenUrlTemplate) {
        TTVideoEngineLog.d(TAG, "setTokenUrlTemplate enter");
        if (this.mInstance == null) {
            return;
        }
        try {
            if (this.mDrmClass == null) {
                this.mDrmClass = Class.forName(INTERTRUST_DRM_PATH);
            }
            Method method = this.mDrmClass.getDeclaredMethod("setTokenUrlTemplate", String.class);
            method.invoke(this.mInstance, tokenUrlTemplate);
        }
        catch (ClassNotFoundException e) {
            TTVideoEngineLog.e(TAG, "class not found:" + e.getLocalizedMessage());
            return;
        }
        catch (NoSuchMethodException e) {
            TTVideoEngineLog.e(TAG, "method not found:" + e.getLocalizedMessage());
            return;
        }
        catch (IllegalAccessException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return;
        }
        catch (InvocationTargetException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return;
        }
    }

    public int processToken(int aid, String vid, String kid) {
        TTVideoEngineLog.d(TAG, "processToken enter");
        if (this.mInstance == null) {
            return -1;
        }
        Object ret = null;
        try {
            if (this.mDrmClass == null) {
                this.mDrmClass = Class.forName(INTERTRUST_DRM_PATH);
            }
            Method method = this.mDrmClass.getDeclaredMethod("processToken", Integer.TYPE, String.class, String.class);
            ret = method.invoke(this.mInstance, aid, vid, kid);
        }
        catch (ClassNotFoundException e) {
            TTVideoEngineLog.e(TAG, "class not found:" + e.getLocalizedMessage());
            return -1;
        }
        catch (NoSuchMethodException e) {
            TTVideoEngineLog.e(TAG, "method not found:" + e.getLocalizedMessage());
            return -1;
        }
        catch (IllegalAccessException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return -1;
        }
        catch (InvocationTargetException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return -1;
        }
        return (Integer)ret;
    }

    public String makeUrl(String srcUrl, int type) {
        TTVideoEngineLog.d(TAG, "makeUrl enter");
        if (this.mInstance == null) {
            return null;
        }
        Object ret = null;
        try {
            if (this.mDrmClass == null) {
                this.mDrmClass = Class.forName(INTERTRUST_DRM_PATH);
            }
            Method method = this.mDrmClass.getDeclaredMethod("makeUrl", String.class, Integer.TYPE);
            ret = method.invoke(this.mInstance, srcUrl, type);
        }
        catch (ClassNotFoundException e) {
            TTVideoEngineLog.e(TAG, "class not found:" + e.getLocalizedMessage());
            return null;
        }
        catch (NoSuchMethodException e) {
            TTVideoEngineLog.e(TAG, "method not found:" + e.getLocalizedMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return null;
        }
        catch (InvocationTargetException e) {
            TTVideoEngineLog.e(TAG, "method invoke failied:" + e.getLocalizedMessage());
            return null;
        }
        return (String)ret;
    }

    private void _notifyError(Error error) {
        Message message = this.mHandler.obtainMessage(1, (Object)error);
        this.mHandler.sendMessage(message);
    }

    private void _notifySuccess() {
        Message message = this.mHandler.obtainMessage(0);
        this.mHandler.sendMessage(message);
    }

    public static interface IntertrustDrmHelperListener {
        public void onTokenProcessed(Error var1);

        public void onError(Error var1);
    }

    private class MyHandler
    extends Handler {
        private WeakReference<IntertrustDrmHelper> mHelper;

        public MyHandler(IntertrustDrmHelper drmProxy, Looper looper) {
            super(looper);
            this.mHelper = new WeakReference<IntertrustDrmHelper>(drmProxy);
        }

        public void handleMessage(Message msg) {
            IntertrustDrmHelper drmProxy = (IntertrustDrmHelper)this.mHelper.get();
            if (drmProxy == null) {
                return;
            }
            IntertrustDrmHelperListener listener = drmProxy.mListener;
            if (listener == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    Error error = (Error)msg.obj;
                    listener.onError(error);
                    break;
                }
                case 0: {
                    listener.onTokenProcessed(null);
                }
            }
        }
    }

    class myNetClientListener
    implements TTVNetClient.RawCompletionListener {
        myNetClientListener() {
        }

        @Override
        public void onCompletion(String rawStr, Error error) {
            if (error != null) {
                String description = error.description;
                TTVideoEngineLog.e(IntertrustDrmHelper.TAG, "get token return error code: " + error.code + ", internal:" + error.internalCode + ", description:" + error.description);
                if (!description.contains("Canceled")) {
                    IntertrustDrmHelper.this._notifyError(error);
                }
                return;
            }
            if (IntertrustDrmHelper.this.mInstance == null) {
                return;
            }
            try {
                if (IntertrustDrmHelper.this.mDrmClass == null) {
                    IntertrustDrmHelper.this.mDrmClass = Class.forName(IntertrustDrmHelper.INTERTRUST_DRM_PATH);
                }
                Method method = IntertrustDrmHelper.this.mDrmClass.getDeclaredMethod("processTokenComplete", String.class);
                method.invoke(IntertrustDrmHelper.this.mInstance, rawStr);
            }
            catch (ClassNotFoundException e) {
                TTVideoEngineLog.e(IntertrustDrmHelper.TAG, "class not found:" + e.getLocalizedMessage());
                return;
            }
            catch (NoSuchMethodException e) {
                TTVideoEngineLog.e(IntertrustDrmHelper.TAG, "method not found:" + e.getLocalizedMessage());
                return;
            }
            catch (IllegalAccessException e) {
                TTVideoEngineLog.e(IntertrustDrmHelper.TAG, "method invoke failied:" + e.getLocalizedMessage());
                return;
            }
            catch (InvocationTargetException e) {
                TTVideoEngineLog.e(IntertrustDrmHelper.TAG, "method invoke failied:" + e.getLocalizedMessage());
                return;
            }
        }
    }

    private class MyIntertrustListener
    implements InvocationHandler {
        private MyIntertrustListener() {
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            TTVideoEngineLog.d(IntertrustDrmHelper.TAG, "intertrust listener invoke");
            String methodName = method.getName();
            if (methodName.equals("onTokenProcessed")) {
                IntertrustDrmHelper.this._notifySuccess();
            } else if (methodName.equals("onError")) {
                int errCode = objects[0] != null ? (Integer)objects[0] : -1;
                int internalCode = objects[1] != null ? (Integer)objects[1] : -1;
                String errStr = objects[2] != null ? objects[2].toString() : "";
                int err = errCode;
                if (errCode == -600000) {
                    err = -9935;
                } else if (errCode == -600001) {
                    err = -9934;
                }
                IntertrustDrmHelper.this._notifyError(new Error("kTTVideoErrorDomainIntertrustDRM", err, internalCode, errStr));
            } else {
                TTVideoEngineLog.w(IntertrustDrmHelper.TAG, "invalid method name:" + methodName);
            }
            return null;
        }
    }

    private class MyNetworkListener
    implements InvocationHandler {
        private MyNetworkListener() {
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            TTVideoEngineLog.d(IntertrustDrmHelper.TAG, "network listener invoke");
            String methodName = method.getName();
            if (methodName.equals("startTask")) {
                String url = objects[0] != null ? objects[0].toString() : "";
                Map headers = objects[1] != null ? (Map)objects[1] : null;
                JSONObject jsonbody = objects[2] != null ? (JSONObject)objects[2] : null;
                IntertrustDrmHelper.this.mNetworkSession.startTask(url, (Map<String, String>)headers, jsonbody, 0, new myNetClientListener());
            } else if (methodName.equals("cancel")) {
                IntertrustDrmHelper.this.mNetworkSession.cancel();
            } else {
                TTVideoEngineLog.w(IntertrustDrmHelper.TAG, "invalid method name:" + methodName);
            }
            return null;
        }
    }
}

