/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.model;

import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import org.json.JSONArray;
import org.json.JSONObject;

public class MediaBitrateFitterInfo {
    public static final String KEY_FITTER_FUNC_PARAMS = "func_params";
    public static final String KEY_FITTER_HEADER_SIZE = "header_size";
    public static final String KEY_FITTER_DURATION = "duration";
    public static final String KEY_FITTER_FUNC_TYPE = "func_method";
    private static final String TAG = "FitterInfo";
    private float[] mFunctionParams = null;
    private int mHeaderSize;
    private int mDuration;
    private int mFunctionType = 0;

    public void extractFields(JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        try {
            if (jsonObject.has(KEY_FITTER_FUNC_PARAMS)) {
                JSONArray functionParamArray = jsonObject.getJSONArray(KEY_FITTER_FUNC_PARAMS);
                if (functionParamArray.length() <= 0) {
                    return;
                }
                this.mFunctionParams = new float[functionParamArray.length()];
                for (int i = 0; i < functionParamArray.length(); ++i) {
                    this.mFunctionParams[i] = (float)functionParamArray.optDouble(i);
                }
            }
            this.mHeaderSize = jsonObject.optInt(KEY_FITTER_HEADER_SIZE);
            this.mDuration = jsonObject.optInt(KEY_FITTER_DURATION);
            this.mFunctionType = jsonObject.optInt(KEY_FITTER_FUNC_TYPE);
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
    }

    public float[] getFunctionParams() {
        return this.mFunctionParams;
    }

    public int getHeaderSize() {
        return this.mHeaderSize;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public int getFunctionType() {
        return this.mFunctionType;
    }

    public int calculateSizeBySecond(float second) {
        if (this.mFunctionParams == null) {
            TTVideoEngineLog.e(TAG, "fitter params empty");
            return 0;
        }
        if (second > (float)this.getDuration() || second <= 0.0f) {
            TTVideoEngineLog.e(TAG, String.format("preload second:%f, fitter duration:%d", Float.valueOf(second), this.getDuration()));
            return 0;
        }
        if (this.mFunctionType == 0) {
            return this.calculateSize(second);
        }
        if (this.mFunctionType == 1) {
            return this.calculateSizeByFun2(second);
        }
        return this.calculateSize(second);
    }

    private int calculateSize(float second) {
        float[] bitrateFitterParams = this.getFunctionParams();
        int headerSize = this.getHeaderSize();
        double fitting_size = 0.0;
        if (bitrateFitterParams.length > 50) {
            TTVideoEngineLog.e(TAG, "bitrateFitterParams num: " + bitrateFitterParams.length);
            return 0;
        }
        for (int i = 0; i < bitrateFitterParams.length; ++i) {
            double temp = 1.0;
            for (int j = 0; j < bitrateFitterParams.length - i - 1; ++j) {
                temp *= (double)second;
            }
            fitting_size += (temp *= (double)bitrateFitterParams[i]);
        }
        double result = fitting_size * (double)second * 1024.0 / 8.0;
        return (int)result;
    }

    private int calculateSizeByFun2(float second) {
        float[] bitrateFitterParams = this.getFunctionParams();
        if (bitrateFitterParams.length != 3) {
            return 0;
        }
        double p1 = bitrateFitterParams[0];
        double p0 = bitrateFitterParams[1];
        double n = bitrateFitterParams[2];
        double bitrate = p1 / Math.pow(second, n) + p0;
        double result_size = bitrate * (double)second * 1024.0 / 8.0;
        return (int)result_size;
    }
}

