/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.net;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.AppInfo;
import com.ss.ttvideoengine.net.NetUtils;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelSelect {
    private static final String TAG = "ChannelSelect";
    private static final String SP_NAME = "engine_channel_select_v2";
    private static final String KEY_CHANNEL_ARRAY = "channel_array";
    private static final String KEY_NET_TYPE = "netType";
    private static final int COST_ERROR_VALUE_MS = 30000;
    private static final int REUSE_HOST_COST_WEIGHT_MILLIS = 80;
    private static final long REUSE_HOST_LIFE_TIME_MILLIS = 300000L;
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ChannelSelect sInstance;
    private Context mContext;
    private final Map<String, Channel> mChannelMap = new LinkedHashMap<String, Channel>();
    private Channel mChannelSelected;
    private SharedPreferences mSP;
    private int mNetType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChannelSelect getInstance() {
        if (sInstance != null) return sInstance;
        Class<ChannelSelect> clazz = ChannelSelect.class;
        synchronized (ChannelSelect.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ChannelSelect();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private ChannelSelect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Context context) {
        if (context == null) {
            return;
        }
        Class<ChannelSelect> clazz = ChannelSelect.class;
        synchronized (ChannelSelect.class) {
            if (this.mContext != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.mContext = context.getApplicationContext();
            this.mSP = context.getSharedPreferences(SP_NAME, 0);
            this.mNetType = NetUtils.getNetType(context);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static String channelKey() {
        if (TextUtils.isEmpty((CharSequence)AppInfo.mRegion)) {
            return KEY_CHANNEL_ARRAY;
        }
        return "channel_array_" + AppInfo.mRegion;
    }

    private void resetHostChannelMapLocked() {
        if (TTHelper.isEmpty(this.mChannelMap)) {
            return;
        }
        for (Map.Entry<String, Channel> entry : this.mChannelMap.entrySet()) {
            entry.getValue().reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHostList(int apiVersion, JSONArray hostArray) {
        if (TTHelper.isEmpty(hostArray)) {
            return;
        }
        Class<ChannelSelect> clazz = ChannelSelect.class;
        synchronized (ChannelSelect.class) {
            Channel chanenl;
            this.mChannelMap.clear();
            for (int i = 0; i < hostArray.length(); ++i) {
                String hostStr = hostArray.optString(i);
                this.mChannelMap.put(hostStr, new Channel(apiVersion, hostStr));
            }
            if (this.mChannelSelected != null && (chanenl = this.mChannelMap.get(this.mChannelSelected.mHost)) == null) {
                this.mChannelSelected = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String selectNext(int apiVersion, String curHost) {
        Class<ChannelSelect> clazz = ChannelSelect.class;
        synchronized (ChannelSelect.class) {
            if (this.mContext == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            int net = NetUtils.getNetType(this.mContext);
            if (net != this.mNetType) {
                TTVideoEngineLog.d(TAG, "network type change:" + net);
                this.resetHostChannelMapLocked();
                this.mNetType = net;
            }
            String host = null;
            List channels = this.groupByApiVersionLocked(apiVersion);
            if (this.mChannelSelected == null) {
                this.mChannelSelected = (Channel)channels.get(0);
            }
            if (curHost == null) {
                host = this.mChannelSelected.mHost;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return host;
            }
            if (((Channel)channels.get(channels.size() - 1)).mHost.equals(curHost)) {
                host = ((Channel)channels.get(0)).mHost;
            }
            if (host == null) {
                for (int index = 0; index < channels.size() - 1; ++index) {
                    Channel channel = (Channel)channels.get(index);
                    if (!channel.mHost.equals(curHost)) continue;
                    host = ((Channel)channels.get(index + 1)).mHost;
                    break;
                }
            }
            if (host == null) {
                host = this.mChannelSelected.mHost;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelSelected(int apiVersion, String host) {
        Class<ChannelSelect> clazz = ChannelSelect.class;
        synchronized (ChannelSelect.class) {
            if (host == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (this.mChannelSelected == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (host.equals(this.mChannelSelected.mHost)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            List channels = this.groupByApiVersionLocked(apiVersion);
            for (Channel channel : channels) {
                if (!channel.mHost.equals(host)) continue;
                this.mChannelSelected = channel;
                break;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List groupByApiVersionLocked(int apiVersion) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        Class<ChannelSelect> clazz = ChannelSelect.class;
        synchronized (ChannelSelect.class) {
            for (Map.Entry<String, Channel> entry : this.mChannelMap.entrySet()) {
                Channel channel = entry.getValue();
                if (channel == null || channel.mApiVersion != apiVersion) continue;
                channels.add(entry.getValue());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return channels;
        }
    }

    private static class Channel {
        private final int mApiVersion;
        private final String mHost;
        private long mNetCost;
        private long mLastUpdateTime;

        Channel(int apiVersion, String hostStr) {
            this.mApiVersion = apiVersion;
            this.mHost = hostStr;
            this.mNetCost = 0L;
            this.mLastUpdateTime = 0L;
        }

        @Nullable
        static Channel parse(@Nullable JSONObject object) {
            if (object == null) {
                return null;
            }
            int apiVersion = object.optInt("apiVersion");
            String host = object.optString("host");
            if (apiVersion >= 0 && !TextUtils.isEmpty((CharSequence)host)) {
                Channel channel = new Channel(apiVersion, host);
                channel.mNetCost = object.optLong("netCost", 0L);
                return channel;
            }
            return null;
        }

        @Nullable
        static JSONObject toJson(@Nullable Channel channel) {
            if (channel == null) {
                return null;
            }
            if (TextUtils.isEmpty((CharSequence)channel.mHost)) {
                return null;
            }
            JSONObject object = new JSONObject();
            try {
                object.put("host", (Object)channel.mHost);
                object.put("apiVersion", channel.mApiVersion);
                object.put("netCost", channel.mNetCost);
                return object;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }

        void setHostCost(long costInMS, long updateTime) {
            if (costInMS <= 0L) {
                return;
            }
            this.mNetCost = costInMS;
            this.mLastUpdateTime = updateTime;
        }

        void reset() {
            this.mNetCost = 0L;
            this.mLastUpdateTime = 0L;
        }
    }
}

