/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.net;

import android.os.Build;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TLSSocketFactory
extends SSLSocketFactory {
    private static final String[] TLS_ALL = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
    private static final String[] TLS_POP_13 = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
    final SSLSocketFactory base;

    public TLSSocketFactory(SSLSocketFactory base) {
        this.base = base;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.base.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.base.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.patch(this.base.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.patch(this.base.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.patch(this.base.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.patch(this.base.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.patch(this.base.createSocket(address, port, localAddress, localPort));
    }

    private Socket patch(Socket s) {
        if (s instanceof SSLSocket) {
            if (Build.VERSION.SDK_INT >= 29) {
                ((SSLSocket)s).setEnabledProtocols(TLS_ALL);
            } else {
                ((SSLSocket)s).setEnabledProtocols(TLS_POP_13);
            }
        }
        return s;
    }
}

