/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.selector.shift;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import com.ss.ttvideoengine.model.IVideoInfo;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.selector.SelectedInfo;
import com.ss.ttvideoengine.selector.Selector;
import com.ss.ttvideoengine.selector.shift.BitrateInfo;
import com.ss.ttvideoengine.selector.shift.BitrateNotMatchException;
import com.ss.ttvideoengine.selector.shift.IAutoBitrateSet;
import com.ss.ttvideoengine.selector.shift.IBandwidthSet;
import com.ss.ttvideoengine.selector.shift.IGearConfig;
import com.ss.ttvideoengine.selector.shift.IGearSet;
import com.ss.ttvideoengine.selector.shift.Shift;
import com.ss.ttvideoengine.selector.shift.SpeedShiftConfig;
import com.ss.ttvideoengine.selector.strategy.GearStrategyContext;
import com.ss.ttvideoengine.selector.strategy.IGearStrategyListener;
import com.ss.ttvideoengine.strategrycenter.StrategyHelper;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpeedShiftSelector
implements Selector {
    public static final int PARAMS_NETWORK_SPEED = 1;
    protected final IGearConfig gearConfig;
    protected List<? extends IGearSet> gearSets;
    protected List<? extends IBandwidthSet> bandwidthSets;
    protected IAutoBitrateSet autoBitrateSet;
    private Shift[] mShifts;

    public SpeedShiftSelector(SpeedShiftConfig config) {
        if (config != null) {
            this.gearConfig = config.getIGearConfig();
            this.gearSets = config.getIGearSets();
            this.bandwidthSets = config.getIBandwidthSets();
            this.autoBitrateSet = config.getIAutoBitrateSet();
        } else {
            this.gearConfig = null;
        }
        this.initShifts(this.gearSets);
    }

    protected <T extends IVideoInfo> List<T> filter(List<T> bitRates) {
        ArrayList<IVideoInfo> result = new ArrayList<IVideoInfo>();
        if (this.gearConfig == null || bitRates.isEmpty()) {
            return result;
        }
        Pair<Double, Double> bitrateInterval = this.gearConfig.getBitrateInterval();
        Set<String> gearGroup = this.gearConfig.getGearGroup();
        boolean useBitrateInterval = bitrateInterval != null && this.gearConfig.getDefaultBitrate() > 0.0;
        for (IVideoInfo br : bitRates) {
            if (useBitrateInterval) {
                int bitRate = br.getValueInt(3);
                if (!((double)bitRate >= (Double)bitrateInterval.first) || !((double)bitRate <= (Double)bitrateInterval.second)) continue;
                result.add(br);
                continue;
            }
            if (gearGroup == null || !gearGroup.contains(br.getValueStr(7))) continue;
            result.add(br);
        }
        if (result.isEmpty()) {
            if (useBitrateInterval) {
                IVideoInfo closestValue = null;
                for (IVideoInfo br : bitRates) {
                    if (closestValue == null) {
                        closestValue = br;
                        continue;
                    }
                    if (!(Math.abs((double)br.getValueInt(3) - this.gearConfig.getDefaultBitrate()) < Math.abs((double)closestValue.getValueInt(3) - this.gearConfig.getDefaultBitrate()))) continue;
                    closestValue = br;
                }
                result.add(closestValue);
            } else {
                result.add((IVideoInfo)bitRates.get(0));
            }
        }
        return result;
    }

    protected <T extends IVideoInfo> T getDefaultBitrate(List<T> bitRates) throws BitrateNotMatchException {
        IVideoInfo result = null;
        String defaultGearName = this.gearConfig.getDefaultGearName();
        double defaultBitrate = this.gearConfig.getDefaultBitrate();
        if (defaultBitrate <= 0.0) {
            for (IVideoInfo br : bitRates) {
                if (!TextUtils.equals((CharSequence)br.getValueStr(7), (CharSequence)defaultGearName)) continue;
                return (T)br;
            }
        } else {
            double minDiff = Double.MAX_VALUE;
            for (IVideoInfo br : bitRates) {
                double abs = Math.abs((double)br.getValueInt(3) - defaultBitrate);
                if (!(minDiff > abs)) continue;
                minDiff = abs;
                result = br;
            }
            return (T)result;
        }
        throw new BitrateNotMatchException(4, "defaultGearName = " + defaultGearName + " bitrates = " + bitRates.toString());
    }

    @Nullable
    private <T extends IVideoInfo> T findBitRate(BitrateInfo bitrateInfo, List<T> bitRates) throws BitrateNotMatchException {
        if (bitrateInfo == null) {
            if (this.gearConfig != null) {
                return this.getDefaultBitrate(bitRates);
            }
            throw new BitrateNotMatchException(6, "gear config is null");
        }
        if ((bitRates = this.filter(bitRates)) == null || bitRates.isEmpty()) {
            throw new BitrateNotMatchException(5, "Intersection bitrate list is empty.");
        }
        T result = bitrateInfo.maxBitrate ? this.findMaxBitrate(bitrateInfo.bitrate, bitRates) : this.findNearestBitrate(bitrateInfo.bitrate, bitRates);
        return result;
    }

    @Nullable
    private <T extends IVideoInfo> T findMaxBitrate(double bitrate, List<T> bitRates) {
        IVideoInfo result = null;
        if (bitRates != null) {
            for (IVideoInfo br : bitRates) {
                if (result != null) {
                    if ((double)result.getValueInt(3) > bitrate) {
                        result = br.getValueInt(3) < result.getValueInt(3) ? br : result;
                        continue;
                    }
                    if (!(bitrate >= (double)br.getValueInt(3)) || br.getValueInt(3) < result.getValueInt(3)) continue;
                    result = br;
                    continue;
                }
                result = br;
            }
        }
        return (T)result;
    }

    @Nullable
    private <T extends IVideoInfo> T findNearestBitrate(double bitrate, List<T> bitRates) {
        IVideoInfo result = null;
        if (bitRates != null) {
            for (IVideoInfo br : bitRates) {
                if (result == null) {
                    result = br;
                    continue;
                }
                if (!(Math.abs((double)br.getValueInt(3) - bitrate) < Math.abs((double)result.getValueInt(3) - bitrate))) continue;
                result = br;
            }
        }
        return (T)result;
    }

    private void initShifts(List<? extends IGearSet> gearSets) {
        if (gearSets != null && !gearSets.isEmpty()) {
            this.mShifts = new Shift[gearSets.size()];
            for (int i = 0; i < gearSets.size(); ++i) {
                Shift shiftTemp;
                IGearSet gsTemp = gearSets.get(i);
                this.mShifts[i] = shiftTemp = new Shift(gsTemp.getBitRate(), (double)gsTemp.getNetworkLower() * 8000.0, (double)gsTemp.getNetworkUpper() * 8000.0);
            }
        }
    }

    private BitrateInfo calculateBitrateInfoByGearSet(double speed) {
        if (speed <= 0.0 || this.mShifts == null) {
            return null;
        }
        double minDistance = Double.MAX_VALUE;
        Shift tempShift = null;
        for (Shift shift : this.mShifts) {
            double tempDistance = Math.abs(shift.getMedianThreshold() - speed);
            if (!(tempDistance < minDistance)) continue;
            minDistance = tempDistance;
            tempShift = shift;
        }
        if (tempShift != null) {
            return new BitrateInfo(tempShift.mRate, false);
        }
        return null;
    }

    private BitrateInfo calculateBitrateInfoByBandwidthSet(double speed) {
        if (speed <= 0.0 || this.bandwidthSets == null || this.bandwidthSets.size() == 0) {
            return null;
        }
        IBandwidthSet result = null;
        for (IBandwidthSet iBandwidthSet : this.bandwidthSets) {
            if (iBandwidthSet == null || !(speed <= iBandwidthSet.getSpeed())) continue;
            result = iBandwidthSet;
            break;
        }
        if (result == null) {
            result = this.bandwidthSets.get(this.bandwidthSets.size() - 1);
        }
        if (result == null) {
            return null;
        }
        return new BitrateInfo(result.getBitrate(), true);
    }

    private BitrateInfo calculateBitrateInfoByAutoBitrateSet(double speed) {
        if (speed <= 0.0 || this.autoBitrateSet == null) {
            return null;
        }
        double bitrate = this.autoBitrateSet.getFirstParam() * speed * speed * speed + this.autoBitrateSet.getSecondParam() * speed * speed + this.autoBitrateSet.getThirdParam() * speed + this.autoBitrateSet.getFourthParam();
        bitrate = Math.max(bitrate, this.autoBitrateSet.getMinBitrate());
        return new BitrateInfo(bitrate, true);
    }

    private SelectedInfo select(List<? extends IVideoInfo> bitRates, Map<Integer, Object> params) {
        Object arg;
        boolean hasBitRate;
        boolean bl = hasBitRate = bitRates != null && !bitRates.isEmpty();
        if (!hasBitRate) {
            Error error = new Error("kTTVideoSelector", -7999, "bitrate list is empty...");
            return new SelectedInfo(error);
        }
        double speed = -1.0;
        if (params != null && (arg = params.get(1)) != null) {
            try {
                speed = (Double)arg;
            }
            catch (ClassCastException e) {
                TTVideoEngineLog.e("Selector", e.getMessage());
            }
        }
        BitrateInfo bitrateInfo = this.autoBitrateSet != null ? this.calculateBitrateInfoByAutoBitrateSet(speed) : (this.bandwidthSets != null ? this.calculateBitrateInfoByBandwidthSet(speed) : this.calculateBitrateInfoByGearSet(speed));
        Error err = null;
        IVideoInfo info = null;
        try {
            info = this.findBitRate(bitrateInfo, bitRates);
        }
        catch (BitrateNotMatchException e) {
            err = new Error("kTTVideoSelector", -7998, e.getMessage());
        }
        if (info == null) {
            info = bitRates.get(0);
        }
        SelectedInfo selectedInfo = new SelectedInfo(info, err);
        if (bitrateInfo != null) {
            selectedInfo.setDoubleValue(0, bitrateInfo.bitrate);
        }
        return selectedInfo;
    }

    @Override
    @NonNull
    public SelectedInfo select(@Nullable IVideoModel videoModel, @Nullable Map<Integer, Object> params) {
        if (videoModel == null) {
            Error error = new Error("kTTVideoSelector", -7999, "null video model");
            return new SelectedInfo(error);
        }
        if (StrategyHelper.helper().moduleSwitch(804) != 0) {
            TTVideoEngineLog.i("Selector", "[GearStrategy] SpeedShiftSelector native select enabled");
            HashMap<String, String> nativeParams = new HashMap<String, String>();
            GearStrategyContext strategyContext = new GearStrategyContext(null);
            strategyContext.setVideoModel(videoModel);
            strategyContext.setGearStrategyListener(new IGearStrategyListener(){

                @Override
                public void onBeforeSelect(IVideoModel videoModel, Map<String, String> params, int selectType, Object userData) {
                }

                @Override
                public void onAfterSelect(IVideoModel videoModel, Map<String, String> result, int selectType, Object userData) {
                    ((Map)userData).putAll(result);
                }
            });
            strategyContext.setUserData(nativeParams);
            Map<String, Integer> result = StrategyHelper.helper().selectResolution(videoModel, 1, nativeParams, strategyContext);
            String errDesc = (String)nativeParams.get("error_desc");
            if (errDesc != null && !errDesc.isEmpty()) {
                int errCode = 0;
                try {
                    errCode = Integer.parseInt((String)nativeParams.get("error_code"));
                }
                catch (Exception e) {
                    errCode = 0;
                }
                Error error = new Error("kTTVideoSelector", errCode, errDesc);
                return new SelectedInfo(error);
            }
            Error err = null;
            VideoInfo info = null;
            double calcBitrate = 0.0;
            if (result != null) {
                int videoBitrate = result.get("video");
                try {
                    calcBitrate = Double.parseDouble((String)nativeParams.get("video_calc_bitrarte"));
                }
                catch (Exception e) {
                    calcBitrate = 0.0;
                }
                List<VideoInfo> videoInfos = videoModel.getVideoInfoList();
                if (videoBitrate > 0 && videoInfos != null) {
                    HashMap videoInfoParams = new HashMap();
                    for (VideoInfo videoInfo : videoInfos) {
                        long resolutionBitRate;
                        if (videoInfo == null || videoInfo.getMediatype() == VideoRef.TYPE_AUDIO || videoInfo.getResolution() == null || (resolutionBitRate = (long)videoInfo.getValueInt(3)) != (long)videoBitrate) continue;
                        info = videoInfo;
                        break;
                    }
                }
                if (info == null) {
                    err = new Error("kTTVideoSelector", -7999, "null video info fit bitrate");
                }
            } else {
                err = new Error("kTTVideoSelector", -7997, "native select result null");
            }
            SelectedInfo selectedInfo = new SelectedInfo(info, err);
            if (calcBitrate > 0.0) {
                selectedInfo.setDoubleValue(0, calcBitrate);
            }
            return selectedInfo;
        }
        TTVideoEngineLog.i("Selector", "[GearStrategy] SpeedShiftSelector native select disabled");
        return this.select(videoModel.getVideoInfoList(), params);
    }

    public static class Params {
        private double mSpeed;

        public Params speed(double speed) {
            this.mSpeed = speed;
            return this;
        }

        public Map<Integer, Object> build() {
            HashMap<Integer, Object> params = new HashMap<Integer, Object>();
            params.put(1, this.mSpeed);
            return params;
        }
    }
}

