/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.source;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.source.Source;
import com.ss.ttvideoengine.strategy.source.StrategySource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class DirectUrlSource
implements StrategySource {
    public static final int KEY_LITE_EDITION = 1;
    private static final int KEY_PRO_EDITION = 2;
    @NonNull
    private final String vid;
    private final List<UrlItem> urlItems = new ArrayList<UrlItem>();
    private final int codecStrategy;
    private final boolean smartUrlEnabled;
    private final int smartUrlVersion;

    private DirectUrlSource(Builder builder) {
        this.vid = builder.vid == null ? UUID.randomUUID().toString() : builder.vid;
        this.urlItems.addAll(builder.items);
        this.codecStrategy = builder.codecStrategy;
        this.smartUrlEnabled = builder.smartUrlEnabled;
        this.smartUrlVersion = builder.smartUrlVersion;
    }

    @NonNull
    public List<UrlItem> allItems() {
        return Collections.unmodifiableList(this.urlItems);
    }

    @Nullable
    public UrlItem firstItem() {
        return this.urlItems.isEmpty() ? null : this.urlItems.get(0);
    }

    @Nullable
    public UrlItem findItemByEncodeType(String encodeType) {
        for (UrlItem urlItem : this.urlItems) {
            if (!TextUtils.equals((CharSequence)urlItem.encodeType, (CharSequence)encodeType)) continue;
            return urlItem;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.urlItems.isEmpty();
    }

    @Override
    public Source.Type type() {
        return Source.Type.DIRECT_URL_SOURCE;
    }

    @Override
    @NonNull
    public String vid() {
        return this.vid;
    }

    @Override
    public int codecStrategy() {
        return this.codecStrategy;
    }

    public boolean isSmartUrlEnabled() {
        return this.smartUrlEnabled;
    }

    public int smartUrlVersion() {
        return this.smartUrlVersion;
    }

    public boolean isSmartUrlValid() {
        return this.smartUrlEnabled && (this.smartUrlVersion == 2 || this.smartUrlVersion == 1);
    }

    public String toString() {
        return "DirectUrlSource{vid='" + this.vid + '\'' + ", urlItems=" + this.urlItems + ", codecStrategy=" + this.codecStrategy + ", smartUrlEnabled=" + this.smartUrlEnabled + ", smartUrlVersion=" + this.smartUrlVersion + '}';
    }

    public static class Builder {
        private final List<UrlItem> items = new ArrayList<UrlItem>();
        @Nullable
        private String vid;
        private int codecStrategy;
        private boolean smartUrlEnabled;
        private int smartUrlVersion = 1;

        public Builder setVid(@Nullable String vid) {
            this.vid = vid;
            return this;
        }

        public Builder addItem(@NonNull UrlItem urlItem) {
            if (urlItem == null) {
                throw new NullPointerException("urlItem = null");
            }
            this.items.add(urlItem);
            return this;
        }

        public Builder setCodecStrategy(int codecStrategy) {
            this.codecStrategy = codecStrategy;
            return this;
        }

        public Builder setSmartUrlEnabled(boolean enabled) {
            this.smartUrlEnabled = enabled;
            return this;
        }

        public Builder setSmartUrlVersion(int smartUrlVersion) {
            this.smartUrlVersion = smartUrlVersion;
            return this;
        }

        public DirectUrlSource build() {
            if (this.items.isEmpty()) {
                throw new IllegalArgumentException("items is empty");
            }
            return new DirectUrlSource(this);
        }
    }

    public static class UrlItem {
        @NonNull
        private final String[] urls;
        private final long urlExpiredTime;
        @Nullable
        private final String cacheKey;
        @Nullable
        private final String playAuth;
        @Nullable
        private final String encodeType;

        private UrlItem(Builder builder) {
            Objects.nonNull(builder.urls);
            this.urls = builder.urls;
            this.urlExpiredTime = builder.urlExpiredTime;
            this.cacheKey = builder.cacheKey;
            this.playAuth = builder.playAuth;
            this.encodeType = builder.encodeType;
        }

        @NonNull
        public String getUrl() {
            return this.urls[0];
        }

        public String[] getUrls() {
            return this.urls;
        }

        public long getUrlExpiredTime() {
            return this.urlExpiredTime;
        }

        @Nullable
        public String getCacheKey() {
            return this.cacheKey;
        }

        @Nullable
        public String getPlayAuth() {
            return this.playAuth;
        }

        @Nullable
        public String getEncodeType() {
            return this.encodeType;
        }

        public String toString() {
            return "UrlItem{urls='" + Arrays.toString(this.urls) + '\'' + ", cacheKey='" + this.cacheKey + '\'' + ", playAuth='" + this.playAuth + '\'' + ", encodeType='" + this.encodeType + '\'' + '}';
        }

        public static class Builder {
            private String[] urls;
            private long urlExpiredTime;
            @Nullable
            private String cacheKey;
            @Nullable
            private String playAuth;
            @Nullable
            private String encodeType;

            public Builder() {
            }

            public Builder(UrlItem urlItem) {
                this.urls = urlItem.urls;
                this.urlExpiredTime = urlItem.urlExpiredTime;
                this.cacheKey = urlItem.cacheKey;
                this.playAuth = urlItem.playAuth;
                this.encodeType = urlItem.encodeType;
            }

            public Builder setUrl(@NonNull String url) {
                if (url == null) {
                    throw new NullPointerException("url = null");
                }
                this.urls = new String[]{url};
                return this;
            }

            public Builder setUrls(@NonNull String[] urls) {
                Builder.checkUrls(urls);
                this.urls = urls;
                return this;
            }

            private static void checkUrls(String[] urls) {
                if (urls == null) {
                    throw new NullPointerException("urls = null");
                }
                if (urls.length == 0) {
                    throw new IllegalArgumentException("urls is empty");
                }
                if (TextUtils.isEmpty((CharSequence)urls[0])) {
                    throw new IllegalArgumentException("urls[0] = null");
                }
            }

            Builder setUrlExpiredTime(long expiredTime) {
                this.urlExpiredTime = expiredTime;
                return this;
            }

            public Builder setCacheKey(@Nullable String cacheKey) {
                this.cacheKey = cacheKey;
                return this;
            }

            public Builder setPlayAuth(@Nullable String playAuth) {
                this.playAuth = playAuth;
                return this;
            }

            public Builder setEncodeType(@Nullable String encodeType) {
                this.encodeType = encodeType;
                return this;
            }

            public UrlItem build() {
                Builder.checkUrls(this.urls);
                return new UrlItem(this);
            }
        }
    }
}

